/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.content.processor;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASArray;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASNumber;
import com.adobe.internal.pdftoolkit.pdf.content.Instruction;
import com.adobe.internal.pdftoolkit.pdf.content.OperandStack;
import com.adobe.internal.pdftoolkit.pdf.content.processor.ContentOperator;
import com.adobe.internal.pdftoolkit.pdf.content.processor.IOperatorHandler;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFDashPattern;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFLineCap;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFLineJoin;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFRenderingIntent;

class GeneralGStateOperator
extends ContentOperator {
    static final int w = 1;
    static final int J = 2;
    static final int j = 3;
    static final int M = 4;
    static final int d = 5;
    static final int ri = 6;
    static final int i = 7;
    static final int gs = 8;

    GeneralGStateOperator(int type, ASName name) {
        super(type, name);
    }

    @Override
    public void process(Instruction instruction, IOperatorHandler opHandlers) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        OperandStack opStack = instruction.getReadonlyOperands();
        switch (this.getType()) {
            case 1: {
                double lineWidth = opStack.popNumber().doubleValue();
                opHandlers.w(lineWidth, instruction);
                break;
            }
            case 2: {
                PDFLineCap lineCap;
                try {
                    lineCap = PDFLineCap.getInstance(opStack.popNumber().intValue());
                }
                catch (PDFInvalidParameterException e) {
                    throw new PDFInvalidDocumentException(e);
                }
                opHandlers.J(lineCap, instruction);
                break;
            }
            case 3: {
                PDFLineJoin lineJoin;
                try {
                    lineJoin = PDFLineJoin.getInstance(opStack.popNumber().intValue());
                }
                catch (PDFInvalidParameterException e) {
                    throw new PDFInvalidDocumentException(e);
                }
                opHandlers.j(lineJoin, instruction);
                break;
            }
            case 4: {
                double miterLimit = opStack.popNumber().doubleValue();
                opHandlers.M(miterLimit, instruction);
                break;
            }
            case 5: {
                int phase = opStack.popNumber().intValue();
                ASArray array = opStack.popArray();
                int arraySize = array.size();
                double[] pattern = new double[arraySize];
                for (int idx = 0; idx < arraySize; ++idx) {
                    pattern[idx] = ((ASNumber)array.get(idx)).doubleValue();
                }
                PDFDashPattern dashPattern = new PDFDashPattern(pattern, phase);
                opHandlers.d(dashPattern, instruction);
                break;
            }
            case 6: {
                PDFRenderingIntent intent = PDFRenderingIntent.getIntentForValue(opStack.popName());
                opHandlers.ri(intent, instruction);
                break;
            }
            case 7: {
                double flatness = opStack.popNumber().doubleValue();
                opHandlers.i(flatness, instruction);
                break;
            }
            case 8: {
                ASName extGStateName = opStack.popName();
                opHandlers.gs(extGStateName, instruction);
            }
        }
    }
}

