/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.content;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFUnableToCompleteOperationException;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.listener.DocumentListener;
import com.adobe.internal.pdftoolkit.pdf.document.listener.DocumentListenerProperties;
import com.adobe.internal.pdftoolkit.pdf.document.listener.DocumentMessage;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObject;
import java.util.HashSet;
import java.util.Stack;

public class XObjectsCycleDetector
implements DocumentListener {
    private Stack<Integer> xobjects = new Stack();
    private HashSet<Integer> objectNumSet = new HashSet();

    private XObjectsCycleDetector() {
    }

    public static XObjectsCycleDetector getInstance(PDFDocument document) {
        DocumentListener existingListener = document.getListenerRegistry().getListener(XObjectsCycleDetector.class);
        if (existingListener == null) {
            XObjectsCycleDetector cycleDetector = new XObjectsCycleDetector();
            document.getListenerRegistry().registerListener(XObjectsCycleDetector.class, cycleDetector);
            return cycleDetector;
        }
        return (XObjectsCycleDetector)existingListener;
    }

    public boolean cycleDetected(PDFXObject current) {
        if (this.xobjects.isEmpty()) {
            return false;
        }
        return this.objectNumSet.contains(current.getCosObject().getObjNum());
    }

    public void push(PDFXObject current) {
        Integer num = current.getCosObject().getObjNum();
        this.xobjects.push(num);
        this.objectNumSet.add(num);
    }

    public void pop() {
        Integer num = this.xobjects.pop();
        this.objectNumSet.remove(num);
    }

    @Override
    public DocumentListenerProperties getProperties() {
        return null;
    }

    @Override
    public void message(DocumentMessage message) throws PDFUnableToCompleteOperationException {
    }
}

