/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.content;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidContentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.content.Content;
import com.adobe.internal.pdftoolkit.pdf.content.ContentParser;
import com.adobe.internal.pdftoolkit.pdf.content.Instruction;
import com.adobe.internal.pdftoolkit.pdf.document.PDFResources;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

public class ContentReader {
    private ContentParser parser;
    private Instruction nextInstr;

    private ContentReader(Content content) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosDictionary csMap = null;
        PDFResources pdfResources = content.getResources();
        if (pdfResources != null) {
            csMap = pdfResources.getDictionaryDictionaryValue(ASName.k_ColorSpace);
        }
        this.parser = new ContentParser(content.getContents(), csMap);
    }

    private ContentReader(Content content, HashSet<ASName> operators) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosDictionary csMap = null;
        PDFResources pdfResources = content.getResources();
        if (pdfResources != null) {
            csMap = pdfResources.getDictionaryDictionaryValue(ASName.k_ColorSpace);
        }
        this.parser = new ContentParser(content.getContents(), csMap, operators);
    }

    private ContentReader(ContentParser parser) {
        this.parser = parser;
    }

    public static ContentReader newInstance(Content content) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return new ContentReader(content);
    }

    public static ContentReader newInstance(Content content, HashSet<ASName> operators) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        operators.add(ASName.k_ID);
        return new ContentReader(content, operators);
    }

    public boolean hasNext() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.nextInstr != null) {
            return true;
        }
        try {
            this.nextInstr = this.parser.nextInstruction();
            return this.nextInstr != null;
        }
        catch (PDFParseException e) {
            throw new PDFInvalidContentException(e);
        }
    }

    public Instruction next() {
        Instruction returnInstr = this.nextInstr;
        this.nextInstr = null;
        return returnInstr;
    }

    public Instruction next(ASName scanOperator) throws PDFInvalidContentException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        while (this.hasNext()) {
            Instruction instruction = this.next();
            if (instruction.getOperator() != scanOperator) continue;
            return instruction;
        }
        return null;
    }

    public Instruction next(Set scanOperators) throws PDFInvalidContentException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        while (this.hasNext()) {
            Instruction instruction = this.next();
            if (!scanOperators.contains(instruction.getOperator())) continue;
            return instruction;
        }
        return null;
    }

    public ContentReader slice() throws PDFIOException {
        return new ContentReader(this.parser.slice());
    }

    public void close() throws IOException {
        this.parser.close();
    }

    public boolean available() throws IOException {
        return this.parser.available();
    }
}

