/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.graphicsDOM;

import com.adobe.internal.pdftoolkit.graphicsDOM.ContentItem;
import com.adobe.internal.pdftoolkit.graphicsDOM.DocumentContext;
import com.adobe.internal.pdftoolkit.graphicsDOM.LineCap;
import com.adobe.internal.pdftoolkit.graphicsDOM.LineJoint;
import com.adobe.internal.pdftoolkit.graphicsDOM.ShadingPattern;
import com.adobe.internal.pdftoolkit.graphicsDOM.TextState;
import com.adobe.internal.pdftoolkit.graphicsDOM.TilingPattern;
import java.awt.geom.Area;
import java.util.Arrays;
import java.util.Map;

public abstract class GraphicsState {
    private LineCap lineCap = LineCap.ROUND;
    private LineJoint lineJoin;
    private double lineWidth = 1.0;
    private double[] fillColorValues;
    private double[] strokeColorValues;
    private Area clipPath = null;
    private double miterLimit = 10.0;
    private boolean strokeAdjustment = false;
    private Map<String, TilingPattern<? extends GraphicsState, ? extends TextState, ? extends ContentItem<? extends GraphicsState>>> loadedTilingPatterns = null;
    private String fillTilingPatternName = null;
    private String strokeTilingPatternName = null;
    private double strokeAlpha = 1.0;
    private double nonStrokeAlpha = 1.0;
    private double smoothness = 0.0;
    private int dashPhase = 0;
    private double[] dashArray = new double[0];
    private int overPrintMode = 0;
    private double flatnessTolerance = 0.0;
    private double fillAlphaOpacity = 1.0;
    private boolean alphaSourceFlag = false;
    private boolean textKnockoutFlag = true;
    private RenderingIntent renderingIntent;
    private Map<String, ShadingPattern<? extends GraphicsState, ? extends TextState, ? extends ContentItem<? extends GraphicsState>>> loadedShadingPatterns = null;
    private String fillShadingPatternName = null;
    private String strokeShadingPatternName = null;
    private BlendingMode blendingMode = BlendingMode.NORMAL;
    private int backdropColor;
    private ContentItem cachedSoftMask = null;
    private boolean overPrint = false;

    public boolean equals(Object obj) {
        if (!(obj instanceof GraphicsState)) {
            return false;
        }
        GraphicsState gState = (GraphicsState)obj;
        return this.getLineCap() == gState.getLineCap() && this.getLineJoin() == gState.getLineJoin() && this.getLineWidth() == gState.getLineWidth() && Arrays.equals(this.getFillColorValues(), gState.getFillColorValues()) && Arrays.equals(this.getStrokeColorValues(), gState.getStrokeColorValues()) && this.clipPathEquals(gState) && this.getMiterLimit() == gState.getMiterLimit() && this.getStrokeAdjustment() == gState.getStrokeAdjustment() && this.stringEquals(this.getFillTilingPatternName(), gState.getFillTilingPatternName()) && this.stringEquals(this.getStrokeTilingPatternName(), gState.getStrokeTilingPatternName()) && this.getStrokeAlpha() == gState.getStrokeAlpha() && this.getNonStrokeAlpha() == gState.getNonStrokeAlpha() && this.getSmoothness() == gState.getSmoothness() && this.getDashPhase() == gState.getDashPhase() && Arrays.equals(this.getDashArray(), gState.getDashArray()) && this.getOverPrintMode() == gState.getOverPrintMode() && this.getFlatnessTolerance() == gState.getFlatnessTolerance() && this.getFillAlphaOpacity() == gState.getFillAlphaOpacity() && this.getalphaSourceFlag() == gState.getalphaSourceFlag() && this.getTextKnockoutFlag() == gState.getTextKnockoutFlag() && this.getRenderingIntent() == gState.getRenderingIntent() && this.getBlendingMode() == gState.getBlendingMode() && this.stringEquals(this.getFillShadingPatternName(), gState.getFillShadingPatternName()) && this.stringEquals(this.getStrokeShadingPatternName(), gState.getStrokeShadingPatternName());
    }

    private boolean clipPathEquals(GraphicsState gState) {
        if (this.getClipPath() == null && gState.getClipPath() == null) {
            return true;
        }
        if (this.getClipPath() == null || gState.getClipPath() == null) {
            return false;
        }
        return this.getClipPath().equals(gState.getClipPath());
    }

    private boolean stringEquals(String str1, String str2) {
        if (str1 == null && str2 == null) {
            return true;
        }
        if (str1 == null || str2 == null) {
            return false;
        }
        return str1.equals(str2);
    }

    public double getSmoothness() {
        return this.smoothness;
    }

    public void setSmoothness(double smoothness) {
        this.smoothness = smoothness;
    }

    public double getStrokeAlpha() {
        return this.strokeAlpha;
    }

    public void setStrokeAlpha(double alpha) {
        this.strokeAlpha = alpha;
    }

    public double getNonStrokeAlpha() {
        return this.nonStrokeAlpha;
    }

    public void setNonStrokeAlpha(double alpha) {
        this.nonStrokeAlpha = alpha;
    }

    public boolean getStrokeAdjustment() {
        return this.strokeAdjustment;
    }

    public void setStrokeAdjustment(boolean strokeAdjustment) {
        this.strokeAdjustment = strokeAdjustment;
    }

    public double getMiterLimit() {
        return this.miterLimit;
    }

    public void setMiterLimit(double miterLimit) {
        this.miterLimit = miterLimit;
    }

    public Area getClipPath() {
        return this.clipPath;
    }

    public void setClipPath(Area clipPath) {
        this.clipPath = clipPath;
    }

    public LineCap getLineCap() {
        return this.lineCap;
    }

    public void setLineCap(LineCap lineCap) {
        this.lineCap = lineCap;
    }

    public LineJoint getLineJoin() {
        return this.lineJoin;
    }

    public void setLineJoin(LineJoint lineJoin) {
        this.lineJoin = lineJoin;
    }

    public double getLineWidth() {
        return this.lineWidth;
    }

    public void setLineWidth(double lineWidth) {
        this.lineWidth = lineWidth;
    }

    public double[] getFillColorValues() {
        return this.fillColorValues;
    }

    public void setFillColorValues(double[] fillColorValues) {
        this.fillColorValues = fillColorValues;
    }

    public double[] getStrokeColorValues() {
        return this.strokeColorValues;
    }

    public void setStrokeColorValues(double[] strokeColorValues) {
        this.strokeColorValues = strokeColorValues;
    }

    public String getFillTilingPatternName() {
        return this.fillTilingPatternName;
    }

    public void setFillTilingPatternName(String tilingPatternName) {
        this.fillTilingPatternName = tilingPatternName;
    }

    public String getStrokeTilingPatternName() {
        return this.strokeTilingPatternName;
    }

    public void setStrokeTilingPatternName(String tilingPatternName) {
        this.strokeTilingPatternName = tilingPatternName;
    }

    public Map<String, TilingPattern<? extends GraphicsState, ? extends TextState, ? extends ContentItem<? extends GraphicsState>>> getLoadedTilingPatterns() {
        return this.loadedTilingPatterns;
    }

    public void setLoadedTilingPatterns(Map<String, TilingPattern<? extends GraphicsState, ? extends TextState, ? extends ContentItem<? extends GraphicsState>>> loadedTilingPatterns) {
        this.loadedTilingPatterns = loadedTilingPatterns;
    }

    public double[] getDashArray() {
        return this.dashArray;
    }

    public void setDashArray(double[] dashArray) {
        this.dashArray = dashArray;
    }

    public int getDashPhase() {
        return this.dashPhase;
    }

    public void setDashPhase(int dashPhase) {
        this.dashPhase = dashPhase;
    }

    public int getOverPrintMode() {
        return this.overPrintMode;
    }

    public void setOverPrintMode(int overPrintMode) {
        this.overPrintMode = overPrintMode;
    }

    public double getFlatnessTolerance() {
        return this.flatnessTolerance;
    }

    public void setFlatnessTolerance(double flatnessTolerance) {
        this.flatnessTolerance = flatnessTolerance;
    }

    public double getFillAlphaOpacity() {
        return this.fillAlphaOpacity;
    }

    public void setFillAlphaOpacity(double fillAlphaOpacity) {
        this.fillAlphaOpacity = fillAlphaOpacity;
    }

    public boolean getalphaSourceFlag() {
        return this.alphaSourceFlag;
    }

    public void setAlphaSourceFlag(boolean alphaSourceFlag) {
        this.alphaSourceFlag = alphaSourceFlag;
    }

    public boolean getTextKnockoutFlag() {
        return this.textKnockoutFlag;
    }

    public void setTextKnockoutFlag(boolean textKnockoutFlag) {
        this.textKnockoutFlag = textKnockoutFlag;
    }

    public RenderingIntent getRenderingIntent() {
        return this.renderingIntent;
    }

    public void setRenderingIntent(RenderingIntent renderingIntent) {
        this.renderingIntent = renderingIntent;
    }

    public abstract <W extends DocumentContext> void writeToDisplayArea(W var1);

    public void setLoadedShadingPatterns(Map<String, ShadingPattern<? extends GraphicsState, ? extends TextState, ? extends ContentItem<? extends GraphicsState>>> loadedShadingPatterns) {
        this.loadedShadingPatterns = loadedShadingPatterns;
    }

    public String getFillShadingPatternName() {
        return this.fillShadingPatternName;
    }

    public void setFillShadingPatternName(String fillShadingPatternName) {
        this.fillShadingPatternName = fillShadingPatternName;
    }

    public Map<String, ShadingPattern<? extends GraphicsState, ? extends TextState, ? extends ContentItem<? extends GraphicsState>>> getLoadedShadingPatterns() {
        return this.loadedShadingPatterns;
    }

    public String getStrokeShadingPatternName() {
        return this.strokeShadingPatternName;
    }

    public void setStrokeShadingPatternName(String strokeShadingPatternName) {
        this.strokeShadingPatternName = strokeShadingPatternName;
    }

    public BlendingMode getBlendingMode() {
        return this.blendingMode;
    }

    public void setBlendingMode(BlendingMode blendingMode) {
        this.blendingMode = blendingMode;
    }

    public int getBackdropColor() {
        return this.backdropColor;
    }

    public void setBackdropColor(int backdropColor) {
        this.backdropColor = backdropColor;
    }

    public abstract void setGraphicsStateSoftMask(ContentItem var1);

    public abstract ContentItem getGraphicsStateSoftMask();

    public ContentItem getCachedSoftMask() {
        return this.cachedSoftMask;
    }

    public void setCachedSoftMask(ContentItem cachedSoftMask) {
        this.cachedSoftMask = cachedSoftMask;
    }

    public boolean getOverPrint() {
        return this.overPrint;
    }

    public void setOverPrint(boolean overPrint) {
        this.overPrint = overPrint;
    }

    public static enum RenderingIntent {
        ABSOLUTE_COLORIMETRIC,
        RELATIVE_COLORIMETRIC,
        SATURATION,
        PERCEPTUAL;

    }

    public static enum BlendingMode {
        NORMAL,
        MULTIPLY,
        SCREEN,
        DARKEN,
        LIGHTEN,
        DIFFERENCE,
        EXCLUSION,
        COLORDODGE,
        COLORBURN,
        HARDLIGHT,
        SOFTLIGHT,
        OVERLAY,
        LUMINOSITY,
        COLOR,
        SATURATION,
        HUE,
        OVERPRINTSrc,
        OVERPRINTDst;

    }
}

