/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.graphicsDOM;

import com.adobe.fontengine.font.FontLoadingException;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.InvalidGlyphException;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFRuntimeException;
import com.adobe.internal.pdftoolkit.core.types.ASMatrix;
import com.adobe.internal.pdftoolkit.graphicsDOM.AbstractContentItem;
import com.adobe.internal.pdftoolkit.graphicsDOM.ContentType;
import com.adobe.internal.pdftoolkit.graphicsDOM.DocumentContext;
import com.adobe.internal.pdftoolkit.graphicsDOM.Glyph;
import com.adobe.internal.pdftoolkit.graphicsDOM.GraphicsState;
import com.adobe.internal.pdftoolkit.graphicsDOM.PrimitiveContentItem;
import com.adobe.internal.pdftoolkit.graphicsDOM.TextState;
import com.adobe.internal.pdftoolkit.graphicsDOM.Type3Glyph;
import com.adobe.internal.pdftoolkit.graphicsDOM.utils.GraphicsUtils;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;
import java.util.List;

public abstract class ContentTextItem<T extends TextState, G extends GraphicsState>
extends AbstractContentItem<G>
implements PrimitiveContentItem<G> {
    private List<Glyph> text;
    private T textState;
    private Rectangle2D boundingBox = null;

    public ContentTextItem(G graphicsState, T textState, int id) {
        super(graphicsState, id);
        this.setTState(textState);
    }

    public T getTState() {
        return this.textState;
    }

    public void setTState(T tState) {
        this.textState = tState;
    }

    public List<Glyph> getText() {
        return this.text;
    }

    public void setText(List<Glyph> text) {
        this.text = text;
    }

    @Override
    public void writeToDisplayArea(DocumentContext context) {
        super.writeToDisplayArea(context);
        if (this.getTState() != null) {
            ((TextState)this.getTState()).writeToDisplayArea(context);
        }
    }

    public boolean isFontType3() {
        return this.text != null && !this.text.isEmpty() && this.text.get(0) instanceof Type3Glyph;
    }

    @Override
    public ContentType getType() {
        return ContentType.Text;
    }

    @Override
    public Rectangle2D getBoundingBox(DocumentContext context) {
        if (this.boundingBox != null) {
            return this.boundingBox;
        }
        Iterator<Glyph> itr = this.text.iterator();
        Glyph glyph = null;
        GeneralPath outline = null;
        Rectangle2D currentGlyphBoundingBox = null;
        Rectangle2D completeBoundingBox = null;
        while (itr.hasNext()) {
            try {
                glyph = itr.next();
                if (this.isFontType3()) {
                    currentGlyphBoundingBox = ((Type3Glyph)glyph).getBoundingBox(context);
                } else {
                    outline = glyph.getGlyphOutline();
                    if (outline == null) {
                        outline = context.getCachedGlyphOutline(glyph.getGID(), ((TextState)this.getTState()).getFontName());
                        if (outline == null) {
                            outline = GraphicsUtils.getGlyphsOulines(glyph.getGID(), ((TextState)this.getTState()).getFontMap().get(((TextState)this.getTState()).getFontName()));
                            context.cacheGlyphOutline(outline, glyph.getGID(), ((TextState)this.getTState()).getFontName());
                        }
                        outline = GraphicsUtils.getTransformedGlyphsOutlines(outline, glyph.getGID(), new ASMatrix(((TextState)this.getTState()).getMatrix()), ((TextState)this.getTState()).getFontSize(), ((TextState)this.getTState()).getTextRise(), glyph, null);
                        glyph.setGlyphOutline(outline);
                    }
                    currentGlyphBoundingBox = outline.getBounds2D();
                }
                if (currentGlyphBoundingBox == null || currentGlyphBoundingBox.getWidth() == 0.0 || currentGlyphBoundingBox.getHeight() == 0.0) continue;
                completeBoundingBox = completeBoundingBox == null ? currentGlyphBoundingBox : completeBoundingBox.createUnion(currentGlyphBoundingBox);
            }
            catch (InvalidGlyphException invalidGlyphException) {
            }
            catch (FontLoadingException e) {
                throw new PDFRuntimeException("Exception while calculating bounding box of text.", e);
            }
            catch (InvalidFontException e) {
                throw new PDFRuntimeException("Exception while calculating bounding box of text.", e);
            }
            catch (UnsupportedFontException e) {
                throw new PDFRuntimeException("Exception while calculating bounding box of text.", e);
            }
        }
        this.boundingBox = completeBoundingBox != null ? completeBoundingBox : currentGlyphBoundingBox;
        return this.boundingBox;
    }
}

