/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.graphicsDOM;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFRuntimeException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASMatrix;
import com.adobe.internal.pdftoolkit.core.types.ASRectangle;
import com.adobe.internal.pdftoolkit.graphicsDOM.AbstractContentItem;
import com.adobe.internal.pdftoolkit.graphicsDOM.ContentType;
import com.adobe.internal.pdftoolkit.graphicsDOM.DocumentContext;
import com.adobe.internal.pdftoolkit.graphicsDOM.GraphicsState;
import com.adobe.internal.pdftoolkit.graphicsDOM.PathPainting;
import com.adobe.internal.pdftoolkit.graphicsDOM.PrimitiveContentItem;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;

public abstract class ContentPathItem<G extends GraphicsState>
extends AbstractContentItem<G>
implements PrimitiveContentItem<G> {
    private GeneralPath genPath;
    private PathPainting pathPaintType;
    private ASMatrix transformationMatrix = null;
    private Rectangle2D boundingBox = null;
    private boolean isShadingPresent = false;

    public ContentPathItem(G graphicsState, int id) {
        super(graphicsState, id);
    }

    public GeneralPath getPath() {
        return this.genPath;
    }

    public PathPainting getPathPaintingType() {
        return this.pathPaintType;
    }

    public void setPath(GeneralPath genPath, PathPainting pathPaintType) {
        this.genPath = genPath;
        this.pathPaintType = pathPaintType;
        this.boundingBox = null;
    }

    @Override
    public ContentType getType() {
        return ContentType.Path;
    }

    public void setTransformationMatrix(ASMatrix matrix) {
        this.transformationMatrix = matrix;
    }

    public ASMatrix getTransformationMatrix() {
        return this.transformationMatrix;
    }

    @Override
    public Rectangle2D getBoundingBox(DocumentContext context) {
        if (this.boundingBox != null) {
            return this.boundingBox;
        }
        Rectangle2D rect = this.genPath.getBounds2D();
        double lineWidth = ((GraphicsState)this.getGState()).getLineWidth();
        double miterLimit = ((GraphicsState)this.getGState()).getMiterLimit();
        lineWidth = this.getPathPaintingType().isStroke() && lineWidth > 0.0 ? (miterLimit > 1.0 ? lineWidth * miterLimit / 4.0 : lineWidth / 2.0 * Math.sqrt(2.0)) : 0.25;
        ASRectangle newRect = new ASRectangle(rect.getMinX() - lineWidth, rect.getMinY() - lineWidth, rect.getMaxX() + lineWidth, rect.getMaxY() + lineWidth);
        try {
            newRect = newRect.transform(this.transformationMatrix).normalized();
        }
        catch (PDFInvalidDocumentException e) {
            throw new PDFRuntimeException(e);
        }
        catch (PDFIOException e) {
            throw new PDFRuntimeException(e);
        }
        catch (PDFSecurityException e) {
            throw new PDFRuntimeException(e);
        }
        rect.setRect(newRect.left(), newRect.bottom(), newRect.width(), newRect.height());
        this.boundingBox = rect;
        return this.boundingBox;
    }

    public boolean getIsShadingPresent() {
        return this.isShadingPresent;
    }

    public void setIsShadingPresent(boolean isShadingPresent) {
        this.isShadingPresent = isShadingPresent;
    }
}

