/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.core.util;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFUnableToCompleteOperationException;
import com.adobe.internal.pdftoolkit.core.types.ASDictionary;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.util.CourierBoldOblique_FDCreator;
import com.adobe.internal.pdftoolkit.core.util.CourierBold_FDCreator;
import com.adobe.internal.pdftoolkit.core.util.CourierOblique_FDCreator;
import com.adobe.internal.pdftoolkit.core.util.Courier_FDCreator;
import com.adobe.internal.pdftoolkit.core.util.FDCreator;
import com.adobe.internal.pdftoolkit.core.util.HelveticaBoldOblique_FDCreator;
import com.adobe.internal.pdftoolkit.core.util.HelveticaBold_FDCreator;
import com.adobe.internal.pdftoolkit.core.util.HelveticaOblique_FDCreator;
import com.adobe.internal.pdftoolkit.core.util.Helvetica_FDCreator;
import com.adobe.internal.pdftoolkit.core.util.Symbol_FDCreator;
import com.adobe.internal.pdftoolkit.core.util.TimesBoldItalic_FDCreator;
import com.adobe.internal.pdftoolkit.core.util.TimesBold_FDCreator;
import com.adobe.internal.pdftoolkit.core.util.TimesItalic_FDCreator;
import com.adobe.internal.pdftoolkit.core.util.TimesRoman_FDCreator;
import com.adobe.internal.pdftoolkit.core.util.ZapfDingbats_FDCreator;
import java.util.HashMap;

public class PDFStandardFontDescriptors {
    private static HashMap creators = new HashMap();
    private static ASDictionary descriptors = new ASDictionary();

    private PDFStandardFontDescriptors() {
    }

    public static ASDictionary get(ASName name) throws PDFInvalidParameterException {
        try {
            ASDictionary dict = descriptors.getDictionary(name);
            if (dict == null) {
                throw new PDFInvalidParameterException("Font name does not correspond to a standard 14 font.");
            }
            return dict;
        }
        catch (PDFUnableToCompleteOperationException e) {
            throw new PDFInvalidParameterException("Font name does not correspond to a standard 14 font.", e);
        }
    }

    private static ASDictionary create(ASName name) {
        return ((FDCreator)creators.get(name)).create(name);
    }

    static {
        creators.put(ASName.k_Helvetica, new Helvetica_FDCreator());
        creators.put(ASName.k_Helvetica_Oblique, new HelveticaOblique_FDCreator());
        creators.put(ASName.k_Helvetica_Bold, new HelveticaBold_FDCreator());
        creators.put(ASName.k_Helvetica_BoldOblique, new HelveticaBoldOblique_FDCreator());
        creators.put(ASName.k_Times_Roman, new TimesRoman_FDCreator());
        creators.put(ASName.k_Times_Italic, new TimesItalic_FDCreator());
        creators.put(ASName.k_Times_Bold, new TimesBold_FDCreator());
        creators.put(ASName.k_Times_BoldItalic, new TimesBoldItalic_FDCreator());
        creators.put(ASName.k_Courier, new Courier_FDCreator());
        creators.put(ASName.k_Courier_Oblique, new CourierOblique_FDCreator());
        creators.put(ASName.k_Courier_Bold, new CourierBold_FDCreator());
        creators.put(ASName.k_Courier_BoldOblique, new CourierBoldOblique_FDCreator());
        creators.put(ASName.k_Symbol, new Symbol_FDCreator());
        creators.put(ASName.k_ZapfDingbats, new ZapfDingbats_FDCreator());
        descriptors.put(ASName.k_Helvetica, PDFStandardFontDescriptors.create(ASName.k_Helvetica));
        descriptors.put(ASName.k_Helvetica_Oblique, PDFStandardFontDescriptors.create(ASName.k_Helvetica_Oblique));
        descriptors.put(ASName.k_Helvetica_Bold, PDFStandardFontDescriptors.create(ASName.k_Helvetica_Bold));
        descriptors.put(ASName.k_Helvetica_BoldOblique, PDFStandardFontDescriptors.create(ASName.k_Helvetica_BoldOblique));
        descriptors.put(ASName.k_Times_Roman, PDFStandardFontDescriptors.create(ASName.k_Times_Roman));
        descriptors.put(ASName.k_Times_Italic, PDFStandardFontDescriptors.create(ASName.k_Times_Italic));
        descriptors.put(ASName.k_Times_Bold, PDFStandardFontDescriptors.create(ASName.k_Times_Bold));
        descriptors.put(ASName.k_Times_BoldItalic, PDFStandardFontDescriptors.create(ASName.k_Times_BoldItalic));
        descriptors.put(ASName.k_Courier, PDFStandardFontDescriptors.create(ASName.k_Courier));
        descriptors.put(ASName.k_Courier_Oblique, PDFStandardFontDescriptors.create(ASName.k_Courier_Oblique));
        descriptors.put(ASName.k_Courier_Bold, PDFStandardFontDescriptors.create(ASName.k_Courier_Bold));
        descriptors.put(ASName.k_Courier_BoldOblique, PDFStandardFontDescriptors.create(ASName.k_Courier_BoldOblique));
        descriptors.put(ASName.k_Symbol, PDFStandardFontDescriptors.create(ASName.k_Symbol));
        descriptors.put(ASName.k_ZapfDingbats, PDFStandardFontDescriptors.create(ASName.k_ZapfDingbats));
    }
}

