/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.core.types;

import com.adobe.internal.io.stream.OutputByteStream;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.types.ASString;
import com.adobe.internal.pdftoolkit.core.util.ByteOps;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

public class ASHexString
extends ASString {
    public ASHexString(byte[] bytes) {
        super(bytes);
    }

    public ASHexString(int[] numbers, int bytesToUse, int bytesToPad) throws PDFInvalidParameterException {
        super(ASHexString.convertIntegersToBytes(numbers, 0, numbers.length - 1, bytesToUse, bytesToPad));
    }

    public ASHexString(int[] numbers, int startIndex, int endIndex, int bytesToUse, int bytesToPad) throws PDFInvalidParameterException {
        super(ASHexString.convertIntegersToBytes(numbers, startIndex, endIndex, bytesToUse, bytesToPad));
    }

    public byte[] getHex() {
        return ByteOps.getHex(this.getBytes());
    }

    public void write(OutputStream outputStream) throws PDFIOException {
        try {
            outputStream.write(60);
            outputStream.write(this.getHex());
            outputStream.write(62);
        }
        catch (IOException e) {
            throw new PDFIOException(e);
        }
    }

    @Override
    public void write(OutputByteStream outputStream) throws PDFIOException {
        try {
            outputStream.write(60);
            outputStream.write(this.getHex());
            outputStream.write(62);
        }
        catch (IOException e) {
            throw new PDFIOException(e);
        }
    }

    @Override
    public String asString() {
        byte[] hex = this.getBytes();
        try {
            boolean isUnicode = hex.length >= 2 && hex[0] == -2 && hex[1] == -1;
            return new String(hex, isUnicode ? "UTF-16" : "ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("US-ASCII encoding not supported.", e);
        }
    }

    @Override
    public String toString() {
        return this.asString();
    }
}

