/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.core.filter;

import com.adobe.internal.pdftoolkit.core.filter.FilterParams;
import com.adobe.internal.pdftoolkit.core.filter.FlateEncode;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class FlateOutputStream
extends FilterOutputStream {
    FlateEncode fl;

    public FlateOutputStream(OutputStream out, FilterParams p) {
        super(out);
        this.fl = new FlateEncode(out);
        int compression = -1;
        int strategy = 0;
        int windowBits = 12;
        int memLevel = 5;
        if (p != null) {
            if (p.containsKey("CompressionLevel")) {
                compression = (Integer)p.get("CompressionLevel");
            }
            if (p.containsKey("CompressionStrategy")) {
                strategy = (Integer)p.get("CompressionStrategy");
            }
            if (p.containsKey("WindowBits")) {
                windowBits = (Integer)p.get("WindowBits");
            }
            if (p.containsKey("MemoryLevel")) {
                memLevel = (Integer)p.get("MemoryLevel");
            }
        }
        this.fl.DeflateInit2(compression, windowBits, memLevel, strategy);
    }

    public FlateOutputStream(OutputStream out) {
        this(out, null);
    }

    @Override
    public void write(int b) throws IOException {
        this.fl.write(b & 0xFF);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        int maxWrite = b.length - off;
        if (maxWrite > len) {
            maxWrite = len;
        }
        while (maxWrite-- > 0) {
            this.write(b[off++]);
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void close() throws IOException {
        this.fl.write(-2);
        this.fl.write(-1);
        super.close();
    }

    public long getTotalOut() {
        return this.fl.getTotalOut();
    }
}

