/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.core.filter;

import com.adobe.internal.pdftoolkit.core.filter.FlateTree;
import java.io.IOException;
import java.io.OutputStream;

class FlateEncode {
    static final int Z_DEFLATED = 8;
    static final int Z_NO_COMPRESSION = 0;
    static final int Z_BEST_SPEED = 1;
    static final int Z_BEST_COMPRESSION = 9;
    static final int Z_DEFAULT_COMPRESSION = -1;
    static final int Z_FILTERED = 1;
    static final int Z_HUFFMAN_ONLY = 2;
    static final int Z_DEFAULT_STRATEGY = 0;
    static final int MAX_MEM_LEVEL = 9;
    static final int DEF_MEM_LEVEL = 5;
    static final int MAX_WBITS = 15;
    static final int DEF_WBITS = 12;
    static final int Z_EOF = -1;
    static final int Z_PARTIAL_FLUSH = -2;
    private static final int STORED_BLOCK = 0;
    private static final int STATIC_TREES = 1;
    private static final int DYN_TREES = 2;
    private static final int MIN_MATCH = 3;
    private static final int MAX_MATCH = 258;
    private static final int TOO_FAR = 4096;
    private static final int MIN_LOOKAHEAD = 262;
    private static final int LENGTH_CODES = 29;
    private static final int LITERALS = 256;
    private static final int L_CODES = 286;
    private static final int D_CODES = 30;
    private static final int BL_CODES = 19;
    private static final int MAX_BITS = 15;
    private static final int INIT_STATE = 42;
    private static final int BUSY_STATE = 113;
    private static final int FINISH_STATE = 666;
    private static final int MAX_BL_BITS = 7;
    private static final int END_BLOCK = 256;
    private static final int REP_3_6 = 16;
    private static final int REPZ_3_10 = 17;
    private static final int REPZ_11_138 = 18;
    private static final int[] extra_lbits = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4, 4, 5, 5, 5, 5, 0};
    private static final int[] extra_dbits = new int[]{0, 0, 0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13};
    private static final int[] extra_blbits = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 3, 7};
    private static final int[] bl_order = new int[]{16, 17, 18, 0, 8, 7, 9, 6, 10, 5, 11, 4, 12, 3, 13, 2, 14, 1, 15};
    private static final int ACRO_BUFSIZE = 4096;
    private long acroLastAvailOut = -1L;
    private boolean acroRoundByteCountUp = false;
    private boolean acroEarlyEOF = false;
    FlateTree static_ltree = new FlateTree(null, 288, 286, 15, extra_lbits, 257);
    FlateTree static_dtree;
    int[] dist_code;
    int[] length_code;
    int[] base_length;
    int[] base_dist;
    FlateTree dyn_ltree;
    FlateTree dyn_dtree;
    FlateTree bl_tree;
    short[] l_buf;
    short[] d_buf;
    int lit_bufsize;
    int last_lit;
    int matches;
    int last_eob_len;
    int level;
    int strategy;
    int status;
    private int rawBits;
    private int rawBitsLeft;
    private OutputStream out;
    private long totalOut;
    int noheader;
    int w_size;
    int w_bits;
    int w_mask;
    int max_dist;
    byte[] window;
    int window_size;
    short[] prev;
    short[] head;
    int ins_h;
    int hash_size;
    int hash_bits;
    int hash_mask;
    int hash_shift;
    int block_start;
    int match_length;
    int prev_match;
    boolean match_available;
    int strstart;
    int match_start;
    int lookahead;
    int prev_length;
    int max_chain_length;
    int max_lazy_match;
    int good_match;
    int nice_match;
    private static final int Adler_BASE = 65521;
    private int adler_s1;
    private int adler_s2;

    public FlateEncode(OutputStream out) {
        int n;
        int code;
        this.static_ltree.InitStaticLTree();
        this.static_dtree = new FlateTree(null, 30, 30, 15, extra_dbits, 0);
        this.static_dtree.InitStaticDTree();
        this.dyn_ltree = new FlateTree(this.static_ltree, 573, 286, 15, extra_lbits, 257);
        this.dyn_dtree = new FlateTree(this.static_dtree, 61, 30, 15, extra_dbits, 0);
        this.bl_tree = new FlateTree(null, 39, 19, 7, extra_blbits, 0);
        this.dyn_ltree.InitTree();
        this.dyn_dtree.InitTree();
        this.bl_tree.InitTree();
        this.dist_code = new int[512];
        this.length_code = new int[256];
        this.base_length = new int[29];
        this.base_dist = new int[30];
        int length = 0;
        for (code = 0; code < 28; ++code) {
            this.base_length[code] = length;
            for (n = 0; n < 1 << extra_lbits[code]; ++n) {
                this.length_code[length++] = code;
            }
        }
        this.length_code[length - 1] = code;
        int dist = 0;
        for (code = 0; code < 16; ++code) {
            this.base_dist[code] = dist;
            for (n = 0; n < 1 << extra_dbits[code]; ++n) {
                this.dist_code[dist++] = code;
            }
        }
        dist >>>= 7;
        while (code < 30) {
            this.base_dist[code] = dist << 7;
            for (n = 0; n < 1 << extra_dbits[code] - 7; ++n) {
                this.dist_code[256 + dist++] = code;
            }
            ++code;
        }
        this.out = out;
        this.rawBitsLeft = 0;
        this.rawBits = 0;
        this.last_eob_len = 8;
        this.level = -1;
        this.status = 0;
    }

    private void sendBits(int b, int n) throws IOException {
        this.rawBits += (b & (1 << n) - 1) << this.rawBitsLeft;
        this.rawBitsLeft += n;
        while (this.rawBitsLeft >= 8) {
            this.out.write(this.rawBits & 0xFF);
            this.rawBits >>>= 8;
            this.rawBitsLeft -= 8;
            ++this.totalOut;
            this.acroRoundByteCountUp = false;
        }
    }

    private void sendCode(int cv, FlateTree tree) throws IOException {
        this.sendBits(tree.code[cv], tree.len[cv]);
    }

    private void putByte(int b) throws IOException {
        this.sendBits(b, 8);
    }

    private void putShort(int b) throws IOException {
        this.sendBits(b, 16);
    }

    private void flushToByte() throws IOException {
        if ((this.rawBitsLeft & 7) != 0) {
            this.sendBits(0, 8 - (this.rawBitsLeft & 7));
            this.acroRoundByteCountUp = true;
        }
    }

    private void putShortMSB(int b) throws IOException {
        this.flushToByte();
        this.sendBits(b >>> 8, 8);
        this.sendBits(b, 8);
    }

    private void scan_tree(FlateTree tree) {
        int prevlen = -1;
        tree.len[tree.max_code + 1] = -1;
        int count = 0;
        int max_count = 7;
        int min_count = 4;
        int nextlen = tree.len[0];
        if (nextlen == 0) {
            max_count = 138;
            min_count = 3;
        }
        for (int n = 0; n <= tree.max_code; ++n) {
            int curlen = nextlen;
            nextlen = tree.len[n + 1];
            if (++count < max_count && curlen == nextlen) continue;
            if (count < min_count) {
                int n2 = curlen;
                this.bl_tree.freq[n2] = this.bl_tree.freq[n2] + count;
            } else if (curlen != 0) {
                if (curlen != prevlen) {
                    int n3 = curlen;
                    this.bl_tree.freq[n3] = this.bl_tree.freq[n3] + 1;
                }
                this.bl_tree.freq[16] = this.bl_tree.freq[16] + 1;
            } else if (count <= 10) {
                this.bl_tree.freq[17] = this.bl_tree.freq[17] + 1;
            } else {
                this.bl_tree.freq[18] = this.bl_tree.freq[18] + 1;
            }
            count = 0;
            prevlen = curlen;
            if (nextlen == 0) {
                max_count = 138;
                min_count = 3;
                continue;
            }
            if (curlen == nextlen) {
                max_count = 6;
                min_count = 3;
                continue;
            }
            max_count = 7;
            min_count = 4;
        }
    }

    private void send_tree(FlateTree tree) throws IOException {
        int prevlen = -1;
        int count = 0;
        int max_count = 7;
        int min_count = 4;
        int nextlen = tree.len[0];
        if (nextlen == 0) {
            max_count = 138;
            min_count = 3;
        }
        for (int n = 0; n <= tree.max_code; ++n) {
            int curlen = nextlen;
            nextlen = tree.len[n + 1];
            if (++count < max_count && curlen == nextlen) continue;
            if (count < min_count) {
                do {
                    this.sendCode(curlen, this.bl_tree);
                } while (--count > 0);
            } else if (curlen != 0) {
                if (curlen != prevlen) {
                    this.sendCode(curlen, this.bl_tree);
                    --count;
                }
                this.sendCode(16, this.bl_tree);
                this.sendBits(count - 3, 2);
            } else if (count <= 10) {
                this.sendCode(17, this.bl_tree);
                this.sendBits(count - 3, 3);
            } else {
                this.sendCode(18, this.bl_tree);
                this.sendBits(count - 11, 7);
            }
            count = 0;
            prevlen = curlen;
            if (nextlen == 0) {
                max_count = 138;
                min_count = 3;
                continue;
            }
            if (curlen == nextlen) {
                max_count = 6;
                min_count = 3;
                continue;
            }
            max_count = 7;
            min_count = 4;
        }
    }

    private void send_all_trees(int blcodes) throws IOException {
        this.sendBits(this.dyn_ltree.max_code + 1 - 257, 5);
        this.sendBits(this.dyn_dtree.max_code + 1 - 1, 5);
        this.sendBits(blcodes + 1 - 4, 4);
        for (int rank = 0; rank <= blcodes; ++rank) {
            this.sendBits(this.bl_tree.len[bl_order[rank]], 3);
        }
        this.send_tree(this.dyn_ltree);
        this.send_tree(this.dyn_dtree);
    }

    private int build_bl_tree() {
        int max_blindex;
        this.scan_tree(this.dyn_ltree);
        this.scan_tree(this.dyn_dtree);
        this.bl_tree.build_tree();
        for (max_blindex = 18; max_blindex >= 3 && this.bl_tree.len[bl_order[max_blindex]] == 0; --max_blindex) {
        }
        this.bl_tree.opt_len += 3 * (max_blindex + 1) + 5 + 5 + 4;
        return max_blindex;
    }

    private void copy_block(byte[] buf, int buf_start, int len, boolean header) throws IOException {
        this.flushToByte();
        this.last_eob_len = 8;
        if (header) {
            this.putShort(len);
            this.putShort(~len);
        }
        for (int i = 0; i < len; ++i) {
            this.putByte(buf[buf_start + i]);
        }
    }

    private void tr_stored_block(byte[] buf, int buf_start, int stored_len, boolean eof) throws IOException {
        this.sendBits(0 + (eof ? 1 : 0), 3);
        this.copy_block(buf, buf_start, stored_len, true);
    }

    private void tr_flush_block(boolean eof) throws IOException {
        int static_lenb;
        int opt_lenb;
        int max_blindex = 0;
        int stored_len = this.strstart - this.block_start;
        long beforeCount = this.getAcroTotalOut();
        if (this.level > 0) {
            this.dyn_ltree.build_tree();
            this.dyn_dtree.build_tree();
            max_blindex = this.build_bl_tree();
            int opt_len = this.dyn_ltree.opt_len + this.dyn_dtree.opt_len + this.bl_tree.opt_len;
            int static_len = this.static_ltree.opt_len + this.static_dtree.opt_len;
            opt_lenb = opt_len + 3 + 7 >>> 3;
            static_lenb = static_len + 3 + 7 >>> 3;
            if (static_lenb <= opt_lenb) {
                opt_lenb = static_lenb;
            }
        } else {
            opt_lenb = static_lenb = stored_len + 5;
        }
        if (stored_len + 4 <= opt_lenb && this.block_start >= 0) {
            this.tr_stored_block(this.window, this.block_start, stored_len, eof);
        } else if (static_lenb == opt_lenb) {
            this.sendBits(2 + (eof ? 1 : 0), 3);
            this.compress_block(this.static_ltree, this.static_dtree);
        } else {
            this.sendBits(4 + (eof ? 1 : 0), 3);
            this.send_all_trees(max_blindex);
            this.compress_block(this.dyn_ltree, this.dyn_dtree);
        }
        this.dyn_ltree.InitTree();
        this.dyn_dtree.InitTree();
        this.bl_tree.InitTree();
        this.block_start = this.strstart;
        this.last_lit = 0;
        if (eof) {
            this.flushToByte();
        }
        this.getAcroAvailOut(beforeCount);
    }

    private int d_code(int dist) {
        return dist < 256 ? this.dist_code[dist] : this.dist_code[256 + (dist >>> 7)];
    }

    private boolean tr_tally(int dist, int lc) {
        if (dist == 0) {
            lc &= 0xFF;
        }
        this.d_buf[this.last_lit] = (short)dist;
        this.l_buf[this.last_lit++] = (short)lc;
        if (dist == 0) {
            int n = lc;
            this.dyn_ltree.freq[n] = this.dyn_ltree.freq[n] + 1;
        } else {
            ++this.matches;
            int n = this.length_code[lc] + 256 + 1;
            this.dyn_ltree.freq[n] = this.dyn_ltree.freq[n] + 1;
            int n2 = this.d_code(--dist);
            this.dyn_dtree.freq[n2] = this.dyn_dtree.freq[n2] + 1;
        }
        if (this.level > 2 && (this.last_lit & 0xFFF) == 0) {
            int out_length = this.last_lit * 8;
            int in_length = this.strstart - this.block_start;
            for (int dcode = 0; dcode < 30; ++dcode) {
                out_length += this.dyn_dtree.freq[dcode] * (5 + extra_dbits[dcode]);
            }
            if (this.matches < this.last_lit / 2 && (out_length >>>= 3) < in_length / 2) {
                return true;
            }
        }
        return this.last_lit == this.lit_bufsize - 1;
    }

    private void compress_block(FlateTree ltree, FlateTree dtree) throws IOException {
        int lx = 0;
        if (this.last_lit != 0) {
            do {
                int dist = this.d_buf[lx];
                int lc = this.l_buf[lx++];
                if (dist == 0) {
                    this.sendCode(lc, ltree);
                    continue;
                }
                int code = this.length_code[lc];
                this.sendCode(code + 256 + 1, ltree);
                int extra = extra_lbits[code];
                if (extra != 0) {
                    this.sendBits(lc -= this.base_length[code], extra);
                }
                code = this.d_code(--dist);
                this.sendCode(code, dtree);
                extra = extra_dbits[code];
                if (extra == 0) continue;
                this.sendBits(dist -= this.base_dist[code], extra);
            } while (lx < this.last_lit);
        }
        this.sendCode(256, ltree);
        this.last_eob_len = ltree.len[256];
    }

    private void Adler32(int b) {
        this.adler_s1 += b & 0xFF;
        if (this.adler_s1 >= 65521) {
            this.adler_s1 -= 65521;
        }
        this.adler_s2 += this.adler_s1;
        if (this.adler_s2 >= 65521) {
            this.adler_s2 -= 65521;
        }
    }

    private void UPDATE_HASH(int c) {
        this.ins_h = (this.ins_h << this.hash_shift ^ c & 0xFF) & this.hash_mask;
    }

    private int INSERT_STRING() {
        this.UPDATE_HASH(this.window[this.strstart + 3 - 1]);
        short s = this.head[this.ins_h];
        this.prev[this.strstart & this.w_mask] = s;
        short hash_head = s;
        this.head[this.ins_h] = (short)this.strstart;
        return hash_head & 0xFFFF;
    }

    private void CLEAR_HASH() {
        int i = this.head.length;
        while (i-- > 0) {
            this.head[i] = 0;
        }
    }

    void DeflateInit(int compression_level) {
        this.DeflateInit2(compression_level, 12, 5, 0);
    }

    void DeflateInit2(int compression_level, int windowBits, int memLevel, int strategy) {
        if (this.level != -1) {
            return;
        }
        this.level = compression_level;
        if (this.level == -1 || this.level < 0 || this.level > 9) {
            this.level = 6;
        }
        if (memLevel < 1 || memLevel > 9) {
            memLevel = 5;
        }
        this.noheader = 0;
        if (windowBits < 0) {
            this.noheader = 1;
            windowBits = -windowBits;
        }
        if (windowBits < 8) {
            windowBits = 8;
        } else if (windowBits > 15) {
            windowBits = 12;
        }
        if (strategy < 0 || strategy > 2) {
            strategy = 0;
        }
        this.strategy = strategy;
        this.w_bits = windowBits;
        this.w_size = 1 << this.w_bits;
        this.w_mask = this.w_size - 1;
        this.max_dist = this.w_size - 262;
        this.hash_bits = memLevel + 7;
        this.hash_size = 1 << this.hash_bits;
        this.hash_mask = this.hash_size - 1;
        this.hash_shift = (this.hash_bits + 3 - 1) / 3;
        this.window = new byte[2 * this.w_size];
        this.prev = new short[this.w_size];
        this.head = new short[this.hash_size];
        this.lit_bufsize = 1 << memLevel + 6;
        this.l_buf = new short[this.lit_bufsize];
        this.d_buf = new short[this.lit_bufsize];
        this.deflateReset();
    }

    void deflateReset() {
        if (this.noheader < 0) {
            this.noheader = 0;
        }
        this.status = this.noheader != 0 ? 113 : 42;
        this.lm_init();
    }

    private void lm_init() {
        this.window_size = 2 * this.w_size;
        this.CLEAR_HASH();
        switch (this.level) {
            case 0: {
                this.good_match = 0;
                this.max_lazy_match = 0;
                this.nice_match = 0;
                this.max_chain_length = 0;
                break;
            }
            case 1: {
                this.good_match = 4;
                this.max_lazy_match = 4;
                this.nice_match = 8;
                this.max_chain_length = 4;
                break;
            }
            case 2: {
                this.good_match = 4;
                this.max_lazy_match = 5;
                this.nice_match = 16;
                this.max_chain_length = 8;
                break;
            }
            case 3: {
                this.good_match = 4;
                this.max_lazy_match = 6;
                this.nice_match = 32;
                this.max_chain_length = 32;
                break;
            }
            case 4: {
                this.good_match = 4;
                this.max_lazy_match = 4;
                this.nice_match = 16;
                this.max_chain_length = 16;
                break;
            }
            case 5: {
                this.good_match = 8;
                this.max_lazy_match = 16;
                this.nice_match = 32;
                this.max_chain_length = 32;
                break;
            }
            default: {
                this.good_match = 8;
                this.max_lazy_match = 16;
                this.nice_match = 128;
                this.max_chain_length = 128;
                break;
            }
            case 7: {
                this.good_match = 8;
                this.max_lazy_match = 32;
                this.nice_match = 128;
                this.max_chain_length = 256;
                break;
            }
            case 8: {
                this.good_match = 32;
                this.max_lazy_match = 128;
                this.nice_match = 258;
                this.max_chain_length = 1024;
                break;
            }
            case 9: {
                this.good_match = 32;
                this.max_lazy_match = 258;
                this.nice_match = 258;
                this.max_chain_length = 4096;
            }
        }
        this.strstart = 0;
        this.block_start = 0;
        this.lookahead = 0;
        this.prev_length = 2;
        this.match_length = 2;
        this.match_available = false;
        this.ins_h = 0;
    }

    private int longest_match(int cur_match) {
        int chain_length = this.max_chain_length;
        int scan = this.strstart;
        int best_len = this.prev_length;
        int nice_match = this.nice_match;
        int limit = this.strstart > this.max_dist ? this.strstart - this.max_dist : 0;
        int strend = this.strstart + 258;
        byte scan_end1 = this.window[scan + best_len - 1];
        byte scan_end = this.window[scan + best_len];
        if (this.prev_length >= this.good_match) {
            chain_length >>= 2;
        }
        if (nice_match > this.lookahead) {
            nice_match = this.lookahead;
        }
        do {
            int match;
            if (this.window[(match = cur_match) + best_len] != scan_end || this.window[match + best_len - 1] != scan_end1 || this.window[match] != this.window[scan] || this.window[++match] != this.window[scan + 1]) continue;
            scan += 2;
            ++match;
            while (this.window[++scan] == this.window[++match] && scan < strend) {
            }
            int len = scan - this.strstart;
            scan = this.strstart;
            if (len <= best_len) continue;
            this.match_start = cur_match;
            best_len = len;
            if (len >= nice_match) break;
            scan_end1 = this.window[scan + best_len - 1];
            scan_end = this.window[scan + best_len];
        } while ((cur_match = this.prev[cur_match & this.w_mask]) > limit && --chain_length != 0);
        return best_len <= this.lookahead ? best_len : this.lookahead;
    }

    private void fill_window(int ch) {
        if (this.strstart >= this.w_size + this.max_dist) {
            int p;
            int n;
            System.arraycopy(this.window, this.w_size, this.window, 0, this.w_size);
            this.match_start -= this.w_size;
            this.strstart -= this.w_size;
            this.block_start -= this.w_size;
            for (n = 0; n < this.hash_size; ++n) {
                p = (this.head[n] & 0xFFFF) - this.w_size;
                this.head[n] = (short)(p >= 0 ? p : 0);
            }
            for (n = 0; n < this.w_size; ++n) {
                p = (this.prev[n] & 0xFFFF) - this.w_size;
                this.prev[n] = (short)(p >= 0 ? p : 0);
            }
        }
        this.window[this.strstart + this.lookahead++] = (byte)ch;
    }

    private void deflate_stored(int ch) throws IOException {
        boolean flush;
        boolean bl = flush = ch < 0;
        if (!flush) {
            this.window[this.strstart++] = (byte)ch;
            if (this.strstart < this.window_size && this.strstart - this.block_start < 65535) {
                return;
            }
        }
        if (this.strstart - this.block_start > 0) {
            this.tr_flush_block(ch == -1);
            this.block_start = 0;
            this.strstart = 0;
        }
    }

    private void deflate_fast(int ch) throws IOException {
        boolean flush = ch < 0;
        int hash_head = 0;
        if (!flush) {
            this.fill_window(ch);
            if (this.lookahead < 262) {
                return;
            }
        }
        if (this.lookahead > 0) {
            do {
                boolean bflush;
                if (this.lookahead >= 3) {
                    this.ins_h = this.window[this.strstart];
                    this.UPDATE_HASH(this.window[this.strstart + 1]);
                    hash_head = this.INSERT_STRING();
                }
                if (hash_head != 0 && this.strstart - hash_head <= this.max_dist && this.strategy != 2) {
                    this.match_length = this.longest_match(hash_head);
                }
                if (this.match_length >= 3) {
                    bflush = this.tr_tally(this.strstart - this.match_start, this.match_length - 3);
                    this.lookahead -= this.match_length;
                    if (this.match_length <= this.max_lazy_match && this.lookahead >= 3) {
                        --this.match_length;
                        do {
                            ++this.strstart;
                            this.INSERT_STRING();
                        } while (--this.match_length != 0);
                        ++this.strstart;
                    } else {
                        this.strstart += this.match_length;
                        this.match_length = 0;
                        this.ins_h = this.window[this.strstart];
                        this.UPDATE_HASH(this.window[this.strstart + 1]);
                    }
                } else {
                    bflush = this.tr_tally(0, this.window[this.strstart]);
                    --this.lookahead;
                    ++this.strstart;
                }
                if (!bflush) continue;
                this.tr_flush_block(false);
            } while (flush && this.lookahead > 0);
        }
        if (flush) {
            boolean eof;
            boolean bl = eof = ch == -1;
            if (ch == -2 && this.acroLastAvailOut == 0L) {
                eof = true;
                this.acroEarlyEOF = true;
            }
            this.tr_flush_block(eof);
        } else {
            this.acroLastAvailOut = -1L;
        }
    }

    private void deflate_slow(int ch) throws IOException {
        boolean flush = ch < 0;
        boolean bflush = false;
        int hash_head = 0;
        if (!flush) {
            this.fill_window(ch);
            if (this.lookahead < 262) {
                return;
            }
        }
        if (this.lookahead > 0) {
            do {
                if (this.lookahead >= 3) {
                    this.ins_h = this.window[this.strstart];
                    this.UPDATE_HASH(this.window[this.strstart + 1]);
                    hash_head = this.INSERT_STRING();
                }
                this.prev_length = this.match_length;
                this.prev_match = this.match_start;
                this.match_length = 2;
                if (hash_head != 0 && this.prev_length < this.max_lazy_match && this.strstart - hash_head <= this.max_dist) {
                    if (this.strategy != 2) {
                        this.match_length = this.longest_match(hash_head);
                    }
                    if (this.match_length <= 5 && (this.strategy == 1 || this.match_length == 3 && this.strstart - this.match_start > 4096)) {
                        this.match_length = 2;
                    }
                }
                if (this.prev_length >= 3 && this.match_length <= this.prev_length) {
                    int max_insert = this.strstart + this.lookahead - 3;
                    bflush = this.tr_tally(this.strstart - 1 - this.prev_match, this.prev_length - 3);
                    this.lookahead -= this.prev_length - 1;
                    this.prev_length -= 2;
                    do {
                        if (++this.strstart > max_insert) continue;
                        this.INSERT_STRING();
                    } while (--this.prev_length != 0);
                    this.match_available = false;
                    this.match_length = 2;
                    ++this.strstart;
                    if (!bflush) continue;
                    this.tr_flush_block(false);
                    continue;
                }
                if (this.match_available) {
                    bflush = this.tr_tally(0, this.window[this.strstart - 1]);
                    if (bflush) {
                        this.tr_flush_block(false);
                    }
                    ++this.strstart;
                    --this.lookahead;
                    continue;
                }
                this.match_available = true;
                ++this.strstart;
                --this.lookahead;
            } while (flush && this.lookahead > 0);
        }
        if (flush) {
            boolean eof;
            if (this.match_available) {
                this.tr_tally(0, this.window[this.strstart - 1]);
                this.match_available = false;
            }
            boolean bl = eof = ch == -1;
            if (ch == -2 && this.acroLastAvailOut == 0L) {
                eof = true;
                this.acroEarlyEOF = true;
            }
            this.tr_flush_block(eof);
        } else {
            this.acroLastAvailOut = -1L;
        }
    }

    void write(int ch) throws IOException {
        if (ch >= 0) {
            if (this.level == -1) {
                this.DeflateInit(-1);
            }
            if (this.status == 42) {
                int header = 8 + (this.w_bits - 8 << 4) << 8;
                int level_flags = this.level - 1 >> 1;
                if (level_flags < 0 || level_flags > 3) {
                    level_flags = 3;
                }
                header |= level_flags << 6;
                header += 31 - header % 31;
                this.status = 113;
                this.putShortMSB(header);
                this.adler_s1 = 1;
                this.adler_s2 = 0;
            }
            this.Adler32(ch);
            if (this.level == 0) {
                this.deflate_stored(ch & 0xFF);
            } else if (this.level <= 3) {
                this.deflate_fast(ch & 0xFF);
            } else {
                this.deflate_slow(ch & 0xFF);
            }
        } else if (this.status != 666) {
            if (!this.acroEarlyEOF) {
                if (this.level == 0) {
                    this.deflate_stored(ch);
                } else if (this.level <= 3) {
                    this.deflate_fast(ch);
                } else {
                    this.deflate_slow(ch);
                }
            }
            if (ch == -1) {
                this.status = 666;
                this.putShortMSB(this.adler_s2);
                this.putShortMSB(this.adler_s1);
            } else if (this.acroLastAvailOut != 0L && !this.acroEarlyEOF) {
                this.sendBits(2, 3);
                this.sendCode(256, this.static_ltree);
                if (1 + this.last_eob_len + 10 - this.rawBitsLeft < 9) {
                    this.sendBits(2, 3);
                    this.sendCode(256, this.static_ltree);
                }
                this.last_eob_len = 7;
            }
        }
    }

    long getTotalOut() {
        return this.totalOut;
    }

    private long getAcroTotalOut() {
        long total = this.totalOut;
        if (total == 2L || this.acroRoundByteCountUp) {
            return total;
        }
        if (total != 0L && (total & 1L) == 0L && this.rawBitsLeft == 0) {
            return total - 2L;
        }
        return total & 0xFFFFFFFFFFFFFFFEL;
    }

    private long getAcroAvailOut(long countBefore) {
        long countAfter = this.getAcroTotalOut();
        long availOut = countAfter != 0L && countAfter % 4096L == 0L ? 0L : (countAfter % 4096L < countBefore % 4096L ? 0L : 4096L - countAfter % 4096L);
        this.acroLastAvailOut = availOut;
        return availOut;
    }
}

