/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.core.filter;

import com.adobe.internal.pdftoolkit.core.filter.Base64FilterException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class Base64Engine {
    private static final byte ED = 64;
    private static final byte IL = 65;
    private static byte[] base64DecodeTable;
    private static byte[] base64EncodeTable;
    private static char[] bitsToChar;
    private static final byte[] charToBits;

    public static int decode(byte[] input, int inOffset, int length, byte[] output, int outOffset) {
        int maxout = 0;
        int count = 0;
        if (output != null) {
            maxout = output.length - outOffset;
        }
        if (length > input.length - inOffset) {
            length = input.length - inOffset;
        }
        while (length > 0) {
            int k = 0;
            int val = 0;
            while (k < 4 && length-- > 0) {
                byte cval;
                if ((cval = base64DecodeTable[input[inOffset++] & 0x7F]) < 64) {
                    val = (val << 6) + cval;
                    ++k;
                    continue;
                }
                if (cval != 64 || k == 0) continue;
                length = 0;
                break;
            }
            switch (k) {
                case 1: {
                    val <<= 6;
                }
                case 2: {
                    val <<= 6;
                }
                case 3: {
                    val <<= 6;
                }
            }
            if (k >= 1) {
                ++count;
                if (maxout-- > 0) {
                    output[outOffset++] = (byte)(val >> 16);
                }
            }
            if (k >= 3) {
                ++count;
                if (maxout-- > 0) {
                    output[outOffset++] = (byte)(val >> 8);
                }
            }
            if (k != 4) continue;
            ++count;
            if (maxout-- <= 0) continue;
            output[outOffset++] = (byte)val;
        }
        return count;
    }

    public static int encode(byte[] input, int inOffset, int length, byte[] output, int outOffset) {
        int val;
        int maxout = 0;
        int count = 0;
        if (output != null) {
            maxout = output.length - outOffset;
        }
        if (length > input.length - inOffset) {
            length = input.length - inOffset;
        }
        int inline = 0;
        while (length >= 3) {
            if (inline == 76) {
                if (maxout-- > 0) {
                    output[outOffset++] = 13;
                }
                if (maxout-- > 0) {
                    output[outOffset++] = 10;
                }
                count += 2;
                inline = 0;
            }
            val = (input[inOffset++] & 0xFF) << 16;
            val += (input[inOffset++] & 0xFF) << 8;
            val += input[inOffset++] & 0xFF;
            if (maxout-- > 0) {
                output[outOffset++] = base64EncodeTable[val >>> 18];
            }
            if (maxout-- > 0) {
                output[outOffset++] = base64EncodeTable[val >>> 12 & 0x3F];
            }
            if (maxout-- > 0) {
                output[outOffset++] = base64EncodeTable[val >>> 6 & 0x3F];
            }
            if (maxout-- > 0) {
                output[outOffset++] = base64EncodeTable[val & 0x3F];
            }
            length -= 3;
            count += 4;
            inline += 4;
        }
        if (length > 0) {
            if (inline == 76) {
                if (maxout-- > 0) {
                    output[outOffset++] = 13;
                }
                if (maxout-- > 0) {
                    output[outOffset++] = 10;
                }
                count += 2;
            }
            val = (input[inOffset++] & 0xFF) << 16;
            if (length > 1) {
                val += (input[inOffset] & 0xFF) << 8;
            }
            if (maxout-- > 0) {
                output[outOffset++] = base64EncodeTable[val >>> 18];
            }
            if (maxout-- > 0) {
                output[outOffset++] = base64EncodeTable[val >>> 12 & 0x3F];
            }
            if (maxout-- > 0) {
                output[outOffset++] = length > 1 ? base64EncodeTable[val >>> 6 & 0x3F] : 61;
            }
            if (maxout-- > 0) {
                output[outOffset++] = 61;
            }
            count += 4;
        }
        return count;
    }

    public static char[] encode(byte[] input, int inOffset, int length) {
        int val;
        char[] output = new char[(length * 8 + 23) / 24 * 4];
        int outOffset = 0;
        while (length >= 3) {
            val = (input[inOffset++] & 0xFF) << 16;
            val |= (input[inOffset++] & 0xFF) << 8;
            output[outOffset++] = bitsToChar[(val |= input[inOffset++] & 0xFF) >>> 18 & 0x3F];
            output[outOffset++] = bitsToChar[val >>> 12 & 0x3F];
            output[outOffset++] = bitsToChar[val >>> 6 & 0x3F];
            output[outOffset++] = bitsToChar[val & 0x3F];
            length -= 3;
        }
        if (length > 0) {
            val = (input[inOffset++] & 0xFF) << 16;
            if (length > 1) {
                val |= (input[inOffset] & 0xFF) << 8;
            }
            output[outOffset++] = bitsToChar[val >>> 18 & 0x3F];
            output[outOffset++] = bitsToChar[val >>> 12 & 0x3F];
            output[outOffset++] = length > 1 ? bitsToChar[val >>> 6 & 0x3F] : 61;
            output[outOffset++] = 61;
        }
        return output;
    }

    public static byte[] decode(String s) {
        int inLen = s.length();
        if (inLen % 4 != 0) {
            return null;
        }
        int outLen = 3 * inLen / 4;
        if (inLen > 0 && s.charAt(inLen - 1) == '=') {
            --inLen;
            --outLen;
        }
        if (inLen > 0 && s.charAt(inLen - 1) == '=') {
            --inLen;
            --outLen;
        }
        byte[] bytes = new byte[outLen];
        int b = 0;
        int i = 0;
        while (i < inLen) {
            char c;
            if ((c = s.charAt(i++)) > charToBits.length) {
                return null;
            }
            byte d0 = charToBits[c];
            if ((c = s.charAt(i++)) > charToBits.length) {
                return null;
            }
            byte d1 = charToBits[c];
            int d2 = 0;
            if (i < inLen) {
                if ((c = s.charAt(i++)) > charToBits.length) {
                    return null;
                }
                d2 = charToBits[c];
            }
            int d3 = 0;
            if (i < inLen) {
                if ((c = s.charAt(i++)) > charToBits.length) {
                    return null;
                }
                d3 = charToBits[c];
            }
            if (d0 < 0 || d1 < 0 || d2 < 0 || d3 < 0) {
                return null;
            }
            bytes[b++] = (byte)((d0 & 0x3F) << 2 | (d1 & 0x30) >> 4);
            if (b >= outLen) continue;
            bytes[b++] = (byte)((d1 & 0xF) << 4 | (d2 & 0x3C) >> 2);
            if (b >= outLen) continue;
            bytes[b++] = (byte)((d2 & 3) << 6 | d3 & 0x3F);
        }
        return bytes;
    }

    static {
        int i;
        base64DecodeTable = new byte[128];
        base64EncodeTable = new byte[64];
        for (i = 0; i < 128; ++i) {
            Base64Engine.base64DecodeTable[i] = 65;
        }
        for (i = 0; i < 26; ++i) {
            Base64Engine.base64DecodeTable[65 + i] = (byte)i;
            Base64Engine.base64EncodeTable[i] = (byte)(65 + i);
            Base64Engine.base64DecodeTable[97 + i] = (byte)(i + 26);
            Base64Engine.base64EncodeTable[i + 26] = (byte)(97 + i);
        }
        for (i = 0; i < 10; ++i) {
            Base64Engine.base64DecodeTable[48 + i] = (byte)(i + 52);
            Base64Engine.base64EncodeTable[i + 52] = (byte)(48 + i);
        }
        Base64Engine.base64DecodeTable[43] = 62;
        Base64Engine.base64EncodeTable[62] = 43;
        Base64Engine.base64DecodeTable[47] = 63;
        Base64Engine.base64EncodeTable[63] = 47;
        Base64Engine.base64DecodeTable[61] = 64;
        bitsToChar = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
        charToBits = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 62, -1, -1, -1, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1, -1, -1, -1, -1, -1, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, -1, -1, -1, -1, -1};
    }

    public static class InputEncodeStream
    extends InputStream {
        private InputStream mIn;
        byte[] mInbuf;
        byte[] mOutbuf;
        int mOutNdx;
        int mOnLine;
        boolean mSendLF;

        public InputEncodeStream(InputStream source) {
            this.mIn = source;
            this.mInbuf = new byte[3];
            this.mOutbuf = new byte[4];
            this.mOnLine = 0;
            this.mOutNdx = 4;
            this.mSendLF = false;
        }

        @Override
        public int read() throws IOException {
            if (this.mSendLF) {
                this.mSendLF = false;
                return 10;
            }
            if (this.mOnLine == 76) {
                this.mSendLF = true;
                this.mOnLine = 0;
                return 13;
            }
            if (this.mOutNdx >= 4) {
                int mInMax = this.mIn.read(this.mInbuf, 0, 3);
                if (mInMax == -1) {
                    return -1;
                }
                Base64Engine.encode(this.mInbuf, 0, mInMax, this.mOutbuf, 0);
                this.mOutNdx = 0;
            }
            ++this.mOnLine;
            return this.mOutbuf[this.mOutNdx++];
        }
    }

    public static class EncodedOutputStream
    extends OutputStream {
        private OutputStream mOut;
        byte[] mInbuf;
        byte[] mOutbuf;
        int mInNdx;
        int mOnLine;

        public EncodedOutputStream(OutputStream destination) {
            this.mOut = destination;
            this.mInbuf = new byte[3];
            this.mOutbuf = new byte[4];
            this.mOnLine = 0;
            this.mInNdx = 0;
        }

        @Override
        public void close() throws IOException {
            this.flush();
            this.mOut.close();
        }

        @Override
        public void flush() throws IOException {
            if (this.mInNdx > 0) {
                int outLen = Base64Engine.encode(this.mInbuf, 0, this.mInNdx, this.mOutbuf, 0);
                this.mOut.write(this.mOutbuf, 0, outLen);
                this.mOut.write(10);
                this.mOnLine = 0;
                this.mInNdx = 0;
            }
        }

        @Override
        public void write(int b) throws IOException {
            this.mInbuf[this.mInNdx++] = (byte)b;
            if (this.mInNdx >= 3) {
                int outLen = Base64Engine.encode(this.mInbuf, 0, this.mInNdx, this.mOutbuf, 0);
                this.mOut.write(this.mOutbuf, 0, outLen);
                this.mOnLine += outLen;
                this.mInNdx = 0;
                if (this.mOnLine >= 76) {
                    this.mOut.write(10);
                    this.mOnLine = 0;
                }
            }
        }
    }

    public static class OutputDecodeStream
    extends OutputStream {
        private byte[] mInbuf = new byte[4];
        private byte[] mOutbuf = new byte[3];
        private int mInNdx = 0;
        private OutputStream mOut;

        public OutputDecodeStream(OutputStream dest) {
            this.mOut = dest;
        }

        @Override
        public void write(int b) throws IOException {
            if (b < 0) {
                throw new Base64FilterException("invalid Base64 character");
            }
            if (base64DecodeTable[b & 0x7F] == 65) {
                return;
            }
            this.mInbuf[this.mInNdx++] = (byte)(b & 0x7F);
            if (this.mInNdx >= 4) {
                int outLen = Base64Engine.decode(this.mInbuf, 0, 4, this.mOutbuf, 0);
                this.mOut.write(this.mOutbuf, 0, outLen);
                this.mInNdx = 0;
            }
        }

        @Override
        public void close() throws IOException {
            if (this.mInNdx != 0) {
                throw new Base64FilterException("Incomplete Base64 data stream");
            }
        }
    }
}

