/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.core.encryption;

import com.adobe.internal.pdftoolkit.core.cos.CosDocument;
import com.adobe.internal.pdftoolkit.core.encryption.PBSHStandard;
import com.adobe.internal.pdftoolkit.core.encryption.StandardCipherSecurityManager;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFCosParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityConfigurationException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.securityframework.SecurityHandler;
import com.adobe.internal.pdftoolkit.core.securityframework.SecurityManager;
import com.adobe.internal.pdftoolkit.core.securityframework.impl.SecurityKeyPasswordInterface;
import com.adobe.internal.pdftoolkit.core.securityframework.impl.SecurityProvidersImpl;

public class SecurityKeyPasswordImpl
implements SecurityKeyPasswordInterface {
    private CosDocument mDoc;
    private SecurityManager mSecMgr;

    public SecurityKeyPasswordImpl() {
    }

    private SecurityKeyPasswordImpl(CosDocument pdfDoc, byte[] password, SecurityProvidersImpl providers) throws PDFSecurityConfigurationException {
        this.mSecMgr = StandardCipherSecurityManager.newInstance(password, providers);
        this.mDoc = pdfDoc;
    }

    @Override
    public SecurityKeyPasswordInterface makeSecurityKey(CosDocument pdfDoc, byte[] password, SecurityProvidersImpl providers) throws PDFSecurityException {
        return new SecurityKeyPasswordImpl(pdfDoc, password, providers);
    }

    @Override
    public SecurityManager getSecurityManager() {
        return this.mSecMgr;
    }

    @Override
    public byte[] getOwnerPassword() throws PDFParseException, PDFSecurityException {
        SecurityHandler secHandler;
        try {
            secHandler = this.mDoc.getEncryption().getDefaultDecryptionHandler();
        }
        catch (PDFCosParseException e) {
            throw new PDFParseException(e);
        }
        if (secHandler != null && secHandler instanceof PBSHStandard) {
            return ((PBSHStandard)secHandler).getOwnerPassword();
        }
        return null;
    }

    @Override
    public byte[] getUserPassword() throws PDFParseException, PDFSecurityException {
        SecurityHandler secHandler;
        try {
            secHandler = this.mDoc.getEncryption().getDefaultDecryptionHandler();
        }
        catch (PDFCosParseException e) {
            throw new PDFParseException(e);
        }
        if (secHandler != null && secHandler instanceof PBSHStandard) {
            return ((PBSHStandard)secHandler).getUserPassword();
        }
        return null;
    }
}

