/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.core.encryption;

import com.adobe.internal.io.stream.InputByteStream;
import com.adobe.internal.io.stream.OutputByteStream;
import com.adobe.internal.pdftoolkit.core.encryption.JCEEncryptionHandlerState;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityConfigurationException;
import com.adobe.internal.pdftoolkit.core.securityframework.EncryptionHandler;
import com.adobe.internal.pdftoolkit.core.securityframework.EncryptionHandlerState;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;

public abstract class JCECipherEncryptionHandler
implements EncryptionHandler {
    protected static final int BUF_LEN = 65536;
    protected byte[] mEncryptKey;
    protected String mAlgorithm;
    protected Cipher mCipher;
    protected byte[] mAddition = null;
    protected MessageDigest mDigest;
    protected boolean mInternal = false;

    public JCECipherEncryptionHandler(String algorithm, byte[] encryptionKey, MessageDigest md5Digest, Provider encryptProvider) throws PDFSecurityConfigurationException {
        if (encryptProvider == null) {
            this.initializeDefaultCipher(algorithm);
        } else {
            try {
                this.mCipher = Cipher.getInstance(algorithm, encryptProvider);
            }
            catch (Exception e) {
                this.initializeDefaultCipher(algorithm);
            }
        }
        this.mAlgorithm = algorithm;
        this.mEncryptKey = encryptionKey;
        this.mDigest = md5Digest;
    }

    void initializeDefaultCipher(String algorithm) throws PDFSecurityConfigurationException {
        try {
            this.mCipher = Cipher.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new PDFSecurityConfigurationException(algorithm + " encryption handler not available.", ex);
        }
        catch (NoSuchPaddingException ex) {
            throw new PDFSecurityConfigurationException(algorithm + " encryption handler not available.", ex);
        }
    }

    protected abstract byte[] initCipher(Cipher var1, byte[] var2, int var3, byte[] var4, int var5) throws PDFSecurityConfigurationException;

    protected byte[] perform(byte[] content, byte[] addKey, int mode) throws PDFSecurityConfigurationException {
        byte[] key = this.mInternal ? addKey : this.calculateCompleteKey(addKey);
        byte[] newContent = this.initCipher(this.mCipher, content, content.length, key, mode);
        byte[] encrypted = null;
        try {
            encrypted = this.mCipher.doFinal(newContent);
        }
        catch (IllegalStateException e) {
            throw new PDFSecurityConfigurationException("Error in " + this.mAlgorithm + " encryption handler.", e);
        }
        catch (IllegalBlockSizeException e) {
            throw new PDFSecurityConfigurationException("Error in " + this.mAlgorithm + " encryption handler.", e);
        }
        catch (BadPaddingException e) {
            throw new PDFSecurityConfigurationException("Error in " + this.mAlgorithm + " encryption handler.", e);
        }
        return encrypted;
    }

    Cipher getCipher() {
        return this.mCipher;
    }

    protected byte[] calculateCompleteKey(byte[] additionKey) {
        byte[] baseKey = this.getBaseEncryptionKey();
        if (additionKey == null) {
            return baseKey;
        }
        int baseLen = baseKey == null ? 0 : baseKey.length;
        byte[] key = new byte[baseLen + additionKey.length];
        if (baseLen > 0) {
            System.arraycopy(baseKey, 0, key, 0, baseKey.length);
        }
        System.arraycopy(additionKey, 0, key, baseLen, additionKey.length);
        this.mDigest.update(key);
        if (this.mAddition != null) {
            this.mDigest.update(this.mAddition);
        }
        byte[] encryptedKey = this.mDigest.digest();
        int len = StrictMath.min(baseLen + additionKey.length, 16);
        byte[] finalKey = new byte[len];
        System.arraycopy(encryptedKey, 0, finalKey, 0, len);
        return finalKey;
    }

    @Override
    public byte[] encrypt(byte[] content, byte[] key) throws PDFSecurityConfigurationException {
        return this.perform(content, key, 1);
    }

    @Override
    public byte[] decrypt(byte[] content, byte[] key) throws PDFSecurityConfigurationException {
        return this.perform(content, key, 2);
    }

    protected void perform(InputByteStream content, OutputByteStream output, byte[] addKey, int mode) throws IOException, PDFSecurityConfigurationException {
        byte[] buffer = new byte[65536];
        byte[] key = this.mInternal ? addKey : this.calculateCompleteKey(addKey);
        try {
            int len = content.read(buffer);
            byte[] newContent = this.initCipher(this.mCipher, buffer, len, key, mode);
            len = newContent.length;
            while (true) {
                byte[] encrypted;
                if ((encrypted = this.mCipher.update(newContent, 0, len)) != null) {
                    output.write(encrypted);
                }
                if (content.bytesAvailable() <= 0L) break;
                len = content.read(buffer);
                newContent = buffer;
            }
            int finalLen = this.mCipher.doFinal(buffer, 0);
            if (finalLen > 0) {
                output.write(buffer, 0, finalLen);
            }
        }
        catch (IllegalBlockSizeException e) {
            throw new PDFSecurityConfigurationException("Error in " + this.mAlgorithm + " encryption handler.", e);
        }
        catch (ShortBufferException e) {
            throw new PDFSecurityConfigurationException("Error in " + this.mAlgorithm + " encryption handler.", e);
        }
        catch (BadPaddingException e) {
            throw new PDFSecurityConfigurationException("Error in " + this.mAlgorithm + " encryption handler.", e);
        }
    }

    @Override
    public void encrypt(InputByteStream src, OutputByteStream dest, byte[] key) throws PDFSecurityConfigurationException, PDFIOException {
        try {
            this.perform(src, dest, key, 1);
        }
        catch (IOException e) {
            throw new PDFIOException(e);
        }
    }

    @Override
    public void decrypt(InputByteStream src, OutputByteStream dest, byte[] key) throws PDFSecurityConfigurationException, PDFIOException {
        try {
            this.perform(src, dest, key, 2);
        }
        catch (IOException e) {
            throw new PDFIOException(e);
        }
    }

    public byte[] getBaseEncryptionKey() {
        return this.mEncryptKey;
    }

    @Override
    public EncryptionHandlerState createEncryptionHandlerState() throws PDFSecurityConfigurationException {
        return new JCEEncryptionHandlerState(this);
    }
}

