/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.core.credentials;

import com.adobe.internal.pdftoolkit.core.credentials.Credentials;
import com.adobe.internal.pdftoolkit.core.credentials.PrivateKeyHolder;
import com.adobe.internal.pdftoolkit.core.credentials.impl.ByteArrayKeyHolder;
import com.adobe.internal.pdftoolkit.core.credentials.impl.JCECredentials;
import com.adobe.internal.pdftoolkit.core.credentials.impl.JCEKeyHolder;
import com.adobe.internal.pdftoolkit.core.credentials.impl.utils.CertUtils;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import java.io.IOException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;

public class CredentialFactory {
    private CredentialFactory() {
    }

    public static CredentialFactory newInstance() {
        return new CredentialFactory();
    }

    public Credentials createCredentials(PrivateKeyHolder privateKeyHolder, X509Certificate cert, Certificate[] certChain) throws PDFInvalidParameterException {
        try {
            privateKeyHolder = CredentialFactory.computeJCEPrivateKey(privateKeyHolder);
            return new JCECredentials(privateKeyHolder, cert, certChain);
        }
        catch (NoSuchAlgorithmException e) {
            throw new PDFInvalidParameterException("Could not create the private key using the data in the private key holder", e);
        }
        catch (InvalidKeySpecException e) {
            throw new PDFInvalidParameterException("Invalid key specification in the private key holder", e);
        }
    }

    public Credentials createCredentials(PrivateKey privateKey, X509Certificate cert, Certificate[] certChain) throws PDFInvalidParameterException {
        return new JCECredentials(privateKey, cert, certChain);
    }

    public Credentials createCredentials(byte[] derEncodedPrivateKey, byte[] derEncodedCert, byte[][] derEncodedCertChain) throws PDFInvalidParameterException {
        try {
            X509Certificate jceCert = (X509Certificate)CertUtils.importCertificate(derEncodedCert);
            Certificate[] jceCertChain = CertUtils.importCertificateChain(derEncodedCertChain);
            PrivateKeyHolder privateKeyHolder = CertUtils.createJCEPrivateKeyHolder(derEncodedPrivateKey, "RSA");
            return new JCECredentials(privateKeyHolder, jceCert, jceCertChain);
        }
        catch (CertificateException e) {
            throw new PDFInvalidParameterException("Certificate Exception when importing JCE keys and certs - ", e);
        }
        catch (IOException e) {
            throw new PDFInvalidParameterException("IO Exception when importing JCE keys and certs - ", e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new PDFInvalidParameterException("Exception when importing JCE keys and certs - ", e);
        }
        catch (InvalidKeySpecException e) {
            throw new PDFInvalidParameterException("Invalid key Exception when importing JCE keys and certs - ", e);
        }
    }

    public Credentials createCredentials(PrivateKeyHolder privateKeyHolder, byte[] derEncodedCert, byte[][] derEncodedCertChain) throws PDFInvalidParameterException {
        if (privateKeyHolder instanceof JCEKeyHolder) {
            return new JCECredentials(privateKeyHolder, derEncodedCert, derEncodedCertChain);
        }
        try {
            privateKeyHolder = CredentialFactory.computeJCEPrivateKey(privateKeyHolder);
            X509Certificate jceCert = (X509Certificate)CertUtils.importCertificate(derEncodedCert);
            Certificate[] jceCertChain = CertUtils.importCertificateChain(derEncodedCertChain);
            JCECredentials credentials = new JCECredentials(privateKeyHolder, jceCert, jceCertChain);
            return credentials;
        }
        catch (CertificateException e) {
            throw new PDFInvalidParameterException("Certificate Exception when importing JCE keys and certs - ", e);
        }
        catch (IOException e) {
            throw new PDFInvalidParameterException("IO Exception when importing JCE keys and certs - ", e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new PDFInvalidParameterException("Exception when importing JCE keys and certs - ", e);
        }
        catch (InvalidKeySpecException e) {
            throw new PDFInvalidParameterException("Invalid key Exception when importing JCE keys and certs - ", e);
        }
    }

    public Credentials createEncryptionCredentials(byte[] derEncodedCert, byte[][] derEncodedCertChain) throws PDFInvalidParameterException {
        try {
            X509Certificate jceCert = (X509Certificate)CertUtils.importCertificate(derEncodedCert);
            Certificate[] jceCertChain = CertUtils.importCertificateChain(derEncodedCertChain);
            PrivateKey privateKey = null;
            return new JCECredentials(privateKey, jceCert, jceCertChain);
        }
        catch (CertificateException e) {
            throw new PDFInvalidParameterException("Certificate Exception when importing JCE keys and certs - ", e);
        }
        catch (IOException e) {
            throw new PDFInvalidParameterException("IO Exception when importing JCE keys and certs - ", e);
        }
    }

    public synchronized Credentials createCredentials(KeyStore keyStore, String alias, char[] password) throws PDFInvalidParameterException {
        Certificate[] certChain;
        Certificate cert;
        Key key;
        try {
            key = keyStore.getKey(alias, password);
        }
        catch (NoSuchAlgorithmException e) {
            throw new PDFInvalidParameterException("could not retrieve the key from the key store", e);
        }
        catch (UnrecoverableKeyException e) {
            throw new PDFInvalidParameterException("could not retrieve the key from the key store", e);
        }
        catch (KeyStoreException e) {
            throw new PDFInvalidParameterException("could not retrieve the key from the key store", e);
        }
        if (!(key instanceof PrivateKey)) {
            throw new PDFInvalidParameterException("key store did not contain a private key");
        }
        PrivateKey privateKey = (PrivateKey)key;
        try {
            cert = keyStore.getCertificate(alias);
        }
        catch (KeyStoreException e) {
            throw new PDFInvalidParameterException("could not retrieve the certificate from the key store", e);
        }
        if (!(cert instanceof X509Certificate)) {
            throw new PDFInvalidParameterException("key store did not contain an X509 certificate.");
        }
        try {
            certChain = keyStore.getCertificateChain(alias);
        }
        catch (KeyStoreException e) {
            throw new PDFInvalidParameterException("could not retrieve the certificate chain from the key store", e);
        }
        return new JCECredentials(privateKey, (X509Certificate)cert, certChain);
    }

    public static PrivateKeyHolder computeJCEPrivateKey(PrivateKeyHolder privateKeyHolder) throws NoSuchAlgorithmException, InvalidKeySpecException, PDFInvalidParameterException {
        if (privateKeyHolder instanceof JCEKeyHolder) {
            return privateKeyHolder;
        }
        if (privateKeyHolder instanceof ByteArrayKeyHolder) {
            return CertUtils.createJCEPrivateKeyHolder(((ByteArrayKeyHolder)privateKeyHolder).getDerEncodedKey(), ((ByteArrayKeyHolder)privateKeyHolder).getAlgorithm());
        }
        throw new PDFInvalidParameterException("The PrivateKeyHolder did not contain any valid private keys");
    }

    public static String getJCEProviderName(PrivateKeyHolder privateKeyHolder) {
        if (privateKeyHolder instanceof JCEKeyHolder) {
            return ((JCEKeyHolder)privateKeyHolder).getProviderName();
        }
        return null;
    }
}

