/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.core.cos;

import com.adobe.internal.io.stream.InputByteStream;
import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosDocument;
import com.adobe.internal.pdftoolkit.core.cos.CosLinearization;
import com.adobe.internal.pdftoolkit.core.cos.CosList;
import com.adobe.internal.pdftoolkit.core.cos.CosName;
import com.adobe.internal.pdftoolkit.core.cos.CosNumeric;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.cos.CosObjectID;
import com.adobe.internal.pdftoolkit.core.cos.CosObjectInfo;
import com.adobe.internal.pdftoolkit.core.cos.CosObjectRef;
import com.adobe.internal.pdftoolkit.core.cos.CosObjectStream;
import com.adobe.internal.pdftoolkit.core.cos.CosParseBuf;
import com.adobe.internal.pdftoolkit.core.cos.CosStream;
import com.adobe.internal.pdftoolkit.core.cos.CosToken;
import com.adobe.internal.pdftoolkit.core.cos.REPAIRTYPE;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFCosParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASNumber;
import com.adobe.internal.pdftoolkit.core.types.ASObject;
import com.adobe.internal.pdftoolkit.core.types.ASString;
import com.adobe.internal.pdftoolkit.core.util.ByteOps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;

class XRefTable {
    static final int tTable = 0;
    static final int tStream = 1;
    static final int tHybrid = 2;
    private static final int mMaxChunk = 262144;
    private static final int EOF_CHECK_THRESHOLD = 1024;
    private int mXrefType;
    private InputByteStream mFileBuf;
    private InputByteStream mBuf;
    private CosDocument mDoc;
    private ArrayList mXRefSubSections;
    private CosDictionary mTrailer;
    private ArrayList mTrailerList;
    private long[] mRevisions;
    private boolean mNoPreload;
    private boolean mIsFDF;
    private int highestObjectNumInXRefEntries = 0;
    private TableXRefSubSection mainXrefSubSection = null;
    private boolean isXrefIntialized;

    XRefTable(CosDocument doc, InputByteStream buf, boolean noPreload, boolean isFDF) {
        this.mFileBuf = buf;
        this.mBuf = buf;
        this.mDoc = doc;
        this.mNoPreload = noPreload;
        this.mIsFDF = isFDF;
    }

    void loadMainInfos() throws PDFCosParseException, IOException, PDFSecurityException, PDFIOException {
        if (this.mIsFDF) {
            this.rebuild();
        } else {
            this.mXRefSubSections = new ArrayList();
            this.mTrailerList = new ArrayList();
            ArrayList eofList = new ArrayList();
            long nextXRefOffset = this.getLastXRefSectionPosition();
            this.mBuf.seek(nextXRefOffset);
            byte b = CosToken.skipWhitespace(this.mBuf);
            this.mBuf.unget();
            if (nextXRefOffset == 0L) {
                throw new PDFCosParseException("could not find xref section");
            }
            if (b == 120) {
                this.mXrefType = 0;
                this.parseTableXrefChain(nextXRefOffset, eofList);
            } else if (ByteOps.isDigit(b)) {
                this.mXrefType = 1;
                this.parseStreamXrefChain(nextXRefOffset, eofList);
            } else {
                throw new PDFCosParseException("could not find xref section");
            }
            this.setRevisions(eofList);
            if (this.mDoc.getRepairTypes().contains((Object)REPAIRTYPE.xrefRepair) && this.mainXrefSubSection != null) {
                this.mainXrefSubSection.mEnd -= this.mainXrefSubSection.mBegin;
                this.mainXrefSubSection.mBegin = 0;
            }
            if (!this.mTrailer.containsKey(ASName.k_Size)) {
                XRefSubSection lastSection = (XRefSubSection)this.mXRefSubSections.get(0);
                this.mTrailer.put(ASName.k_Size, lastSection.mEnd);
            }
        }
        this.isXrefIntialized = true;
    }

    void rebuild() throws PDFCosParseException, IOException, PDFSecurityException, PDFIOException {
        this.mXRefSubSections = new ArrayList();
        this.mTrailerList = new ArrayList();
        this.mRevisions = null;
        ArrayList<CosObject> tempTrailerList = new ArrayList<CosObject>();
        ArrayList<Long> tempEOFList = new ArrayList<Long>();
        this.mBuf.seek(0L);
        boolean first = true;
        boolean isLinearized = false;
        int catalogObjNum = 0;
        while (true) {
            CosToken.skipWhitespace(this.mBuf);
            this.mBuf.unget();
            long objPos = this.mBuf.getPosition();
            ASObject asObj = CosToken.readPrimitive(this.mBuf);
            if (asObj == null) break;
            if (asObj instanceof ASNumber) {
                CosObject cosType;
                CosObject cosObj = this.scanIndirectObj((ASNumber)asObj, objPos);
                if (first && cosObj != null) {
                    first = false;
                    if (cosObj instanceof CosDictionary) {
                        isLinearized = ((CosDictionary)cosObj).containsKey(ASName.k_Linearized);
                    }
                }
                if (!(cosObj instanceof CosDictionary) || !((cosType = ((CosDictionary)cosObj).get(ASName.k_Type)) instanceof CosName) || ((CosName)cosType).nameValue() != ASName.k_Catalog) continue;
                catalogObjNum = ((ASNumber)asObj).intValue();
                continue;
            }
            if (!(asObj instanceof ASString)) continue;
            String str = asObj.toString();
            if ("startxref".equals(str)) {
                long nextEOF = 0L;
                try {
                    nextEOF = this.findNextEOF();
                    this.mBuf.seek(nextEOF);
                }
                catch (PDFCosParseException e) {
                    nextEOF = this.mBuf.getPosition();
                }
                tempEOFList.add(nextEOF);
                continue;
            }
            if (!"trailer".equals(str)) continue;
            long savePos = this.mBuf.getPosition();
            try {
                CosObject trailerDict = CosToken.readObject(this.mDoc, this.mBuf, null);
                if (!(trailerDict instanceof CosDictionary)) {
                    throw new PDFCosParseException("Invalid trailer dictionary");
                }
                tempTrailerList.add(trailerDict);
            }
            catch (PDFCosParseException e) {
                this.mBuf.seek(savePos);
            }
        }
        if (tempTrailerList.isEmpty() && catalogObjNum > 0) {
            CosDictionary trailer = this.mDoc.createDirectCosDictionary();
            trailer.put(ASName.k_Root, new CosObjectRef(this.mDoc, this.mDoc.getIndexedInfo(catalogObjNum)));
            trailer.put(ASName.k_Size, this.mDoc.createCosNumeric(this.mDoc.getNumObjectsInternal()));
            trailer.put(ASName.k_ID, this.mDoc.createUpdateDocID(true));
            tempTrailerList.add(trailer);
        }
        while (!tempTrailerList.isEmpty()) {
            this.mTrailerList.add(tempTrailerList.remove(tempTrailerList.size() - 1));
        }
        if (isLinearized && this.mTrailerList.size() > 1) {
            Object x = this.mTrailerList.get(this.mTrailerList.size() - 1);
            this.mTrailerList.set(this.mTrailerList.size() - 1, this.mTrailerList.get(this.mTrailerList.size() - 2));
            this.mTrailerList.set(this.mTrailerList.size() - 2, x);
        }
        if (!this.mTrailerList.isEmpty()) {
            this.mTrailer = (CosDictionary)this.mTrailerList.get(0);
            if (catalogObjNum > 0) {
                this.mTrailer.put(ASName.k_Root, new CosObjectRef(this.mDoc, this.mDoc.getIndexedInfo(catalogObjNum)));
            }
            this.mTrailer.put(ASName.k_Size, this.mDoc.getNumObjectsInternal());
        }
        ArrayList eofList = new ArrayList();
        while (!tempEOFList.isEmpty()) {
            eofList.add(tempEOFList.remove(tempEOFList.size() - 1));
        }
        if (isLinearized && eofList.size() > 1) {
            Object x = eofList.get(eofList.size() - 1);
            eofList.set(eofList.size() - 1, eofList.get(eofList.size() - 2));
            eofList.set(eofList.size() - 2, x);
        }
        if (this.mTrailer == null && !this.mIsFDF) {
            throw new PDFCosParseException("Rebuilt document still has no trailer");
        }
        this.setRevisions(eofList);
    }

    CosObject scanIndirectObj(ASNumber asObjNum, long objPos) throws PDFCosParseException, IOException, PDFSecurityException, PDFIOException {
        long savePos = this.mBuf.getPosition();
        ASObject asObjGen = CosToken.readPrimitive(this.mBuf);
        ASObject asObjTag = CosToken.readPrimitive(this.mBuf);
        if (asObjGen instanceof ASNumber && asObjTag instanceof ASString) {
            Number nmObjNum = asObjNum.numberValue();
            Number nmObjGen = ((ASNumber)asObjGen).numberValue();
            String objTag = ((ASString)asObjTag).toString();
            if ((nmObjNum instanceof Integer || nmObjNum instanceof Long) && (nmObjGen instanceof Integer || nmObjGen instanceof Long)) {
                int objNum = nmObjNum.intValue();
                int objGen = nmObjGen.intValue();
                if (objNum > 0 && objGen >= 0 && objGen < 65535 && "obj".equals(objTag)) {
                    CosObject cosObj = null;
                    try {
                        cosObj = CosToken.readIndirectObject(this.mDoc, this.mBuf, null);
                    }
                    catch (PDFCosParseException pDFCosParseException) {
                        // empty catch block
                    }
                    if (cosObj != null) {
                        CosObjectInfo info = new CosObjectInfo(this.mDoc, objNum, objGen);
                        info.setPosInternal(objPos);
                        info.markAddressed();
                        this.mDoc.putRebuiltInfo(objNum, info);
                        if (cosObj instanceof CosStream) {
                            CosObject lenObj = ((CosStream)cosObj).get(ASName.k_Length);
                            if (lenObj instanceof CosNumeric) {
                                int stmLen = ((CosNumeric)lenObj).intValue();
                                long saveStmPos = this.mBuf.getPosition();
                                this.mBuf.seek(saveStmPos + (long)stmLen);
                                ASObject asTokenObj = CosToken.readPrimitive(this.mBuf);
                                if (asTokenObj instanceof ASString && asTokenObj.toString().equals("endstream")) {
                                    return cosObj;
                                }
                                this.mBuf.seek(saveStmPos);
                                do {
                                    CosToken.skipWhitespace(this.mBuf);
                                    this.mBuf.unget();
                                    asTokenObj = CosToken.readPrimitive(this.mBuf);
                                    if (asTokenObj != null) continue;
                                    return cosObj;
                                } while (!(asTokenObj instanceof ASString) || !asTokenObj.toString().equals("endstream"));
                                return cosObj;
                            }
                        } else {
                            this.mBuf.unget();
                        }
                        return cosObj;
                    }
                }
            }
        }
        this.mBuf.seek(savePos);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void rebuildLate() throws PDFCosParseException, IOException, PDFSecurityException, PDFIOException {
        this.mBuf.seek(0L);
        while (true) {
            CosToken.skipWhitespace(this.mBuf);
            this.mBuf.unget();
            long objPos = this.mBuf.getPosition();
            ASObject asObj = CosToken.readPrimitive(this.mBuf);
            if (asObj == null) return;
            if (!(asObj instanceof ASNumber)) continue;
            long savePos = this.mBuf.getPosition();
            try {
                this.scanIndirectObj((ASNumber)asObj, objPos);
                continue;
            }
            catch (PDFCosParseException e) {
                if (this.mDoc.getOptions().skipCorruptObjects()) continue;
                throw e;
            }
            finally {
                if (this.mBuf.getPosition() >= objPos) continue;
                this.mBuf.seek(savePos);
                continue;
            }
            break;
        }
    }

    XRefTable(CosDocument doc) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        this.mDoc = doc;
        this.mXRefSubSections = new ArrayList();
        this.mTrailer = this.mDoc.createCosDictionary(0);
    }

    void close() throws IOException {
        try {
            this.closeStreams();
        }
        finally {
            this.closeXRefSubSections();
        }
    }

    private void closeStreams() throws IOException {
        try {
            if (this.mBuf != null && this.mBuf != this.mFileBuf) {
                this.mBuf.close();
                this.mBuf = null;
            }
        }
        finally {
            if (this.mFileBuf != null) {
                this.mFileBuf.close();
                this.mFileBuf = null;
            }
        }
    }

    private void closeXRefSubSections() throws IOException {
        IOException ioEx = null;
        for (XRefSubSection subSection : this.mXRefSubSections) {
            try {
                if (subSection == null) continue;
                subSection.close();
            }
            catch (IOException e) {
                ioEx = e;
            }
        }
        if (ioEx != null) {
            throw ioEx;
        }
        this.mXRefSubSections.clear();
    }

    private long find(InputByteStream byteStream, char[] key) throws IOException {
        long location = -1L;
        while (byteStream.bytesAvailable() > 0L) {
            char c = (char)byteStream.read();
            if (key[0] != c) continue;
            location = byteStream.getPosition() - 1L;
            for (int i = 1; i < key.length; ++i) {
                c = (char)byteStream.read();
                if (key[i] == c) continue;
                location = -1L;
                break;
            }
            if (location == -1L) continue;
            return location;
        }
        return location;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseTableXrefChain(long nextXRefOffset, ArrayList eofList) throws PDFCosParseException, IOException, PDFSecurityException, PDFIOException {
        do {
            CosNumeric prev;
            this.mBuf.seek(nextXRefOffset);
            int nextXrefSubSectionIndex = this.mXRefSubSections.size();
            byte b = this.readTableXRefTable();
            if (this.mXRefSubSections.size() > nextXrefSubSectionIndex) {
                this.mainXrefSubSection = (TableXRefSubSection)this.mXRefSubSections.get(nextXrefSubSectionIndex);
            }
            CosDictionary trailer = this.readTrailer(b);
            this.mTrailerList.add(trailer);
            if (this.mTrailer == null) {
                this.mTrailer = trailer;
            }
            if ((prev = (CosNumeric)trailer.get(ASName.k_Prev)) != null) {
                long prevValue = prev.longValue();
                if (prevValue == nextXRefOffset) {
                    throw new PDFCosParseException("Fatal XRef chain loop at position " + Long.toString(prevValue));
                }
                nextXRefOffset = prevValue;
                CosNumeric xref = (CosNumeric)trailer.get(ASName.k_XRefStm);
                if (xref != null) {
                    long pos = this.mBuf.getPosition();
                    try {
                        this.readStreamXRefTable(xref.longValue());
                    }
                    finally {
                        this.mBuf.seek(pos);
                        this.mainXrefSubSection = null;
                    }
                    this.mXrefType = 2;
                }
            } else {
                nextXRefOffset = 0L;
            }
            if (eofList == null || this.mBuf.getPosition() <= nextXRefOffset) continue;
            eofList.add(this.findNextEOF());
        } while (nextXRefOffset != 0L);
        int size = this.mXRefSubSections.size();
        boolean objectNumberZeroFound = true;
        if (size > 0) {
            objectNumberZeroFound = false;
            for (int i = 0; i < this.mXRefSubSections.size(); ++i) {
                XRefSubSection sub = (XRefSubSection)this.mXRefSubSections.get(i);
                if (!(sub instanceof TableXRefSubSection) || ((TableXRefSubSection)sub).mBegin != 0) continue;
                objectNumberZeroFound = true;
            }
        }
        if (!objectNumberZeroFound) {
            throw new PDFCosParseException("Object number 0 is not present in any of the Xref subsections.");
        }
    }

    private byte readTableXRefTable() throws PDFCosParseException, IOException {
        try {
            byte b = 0;
            CosToken.skipWhitespace(this.mBuf);
            this.mBuf.unget();
            if (!CosToken.readLine(this.mBuf, false).startsWith("xref")) {
                throw new PDFCosParseException("Expected 'xref' : " + Long.toString(this.mBuf.getPosition()));
            }
            b = CosToken.skipWhitespace(this.mBuf);
            while (ByteOps.isDigit(b)) {
                this.mXRefSubSections.add(new TableXRefSubSection(b));
                b = CosToken.skipWhitespace(this.mBuf);
            }
            return b;
        }
        catch (IOException e) {
            throw new PDFCosParseException(e);
        }
    }

    private void parseStreamXrefChain(long nextXRefOffset, ArrayList eofList) throws PDFCosParseException, IOException, PDFSecurityException, PDFIOException {
        do {
            CosNumeric prev;
            this.mBuf.seek(nextXRefOffset);
            CosStream xrefStm = this.readStreamXRefTable(nextXRefOffset);
            this.mTrailerList.add(xrefStm);
            if (this.mTrailer == null) {
                this.mTrailer = xrefStm;
            }
            if ((prev = (CosNumeric)xrefStm.get(ASName.k_Prev)) != null) {
                long prevValue = prev.longValue();
                if (prevValue == nextXRefOffset) {
                    throw new PDFCosParseException("Fatal XRef chain loop at position " + Long.toString(prevValue));
                }
                nextXRefOffset = prevValue;
            } else {
                nextXRefOffset = 0L;
            }
            if (eofList == null || this.mBuf.getPosition() <= nextXRefOffset) continue;
            eofList.add(this.findNextEOF());
        } while (nextXRefOffset != 0L);
    }

    private CosStream readStreamXRefTable(long nextXRefOffset) throws PDFCosParseException, IOException, PDFSecurityException, PDFIOException {
        this.mBuf.seek(nextXRefOffset);
        CosParseBuf pBuf = new CosParseBuf(this.mBuf, 128);
        int[] xStmID = CosToken.readObjID(this.mDoc, pBuf, CosToken.skipWhitespace(pBuf));
        CosObjectInfo xStmInfo = this.mDoc.getIndexedInfo(xStmID[0]);
        if (xStmInfo != null) {
            xStmInfo.setObjNum(xStmID[0]);
            xStmInfo.setObjGen(xStmID[1]);
        } else {
            xStmInfo = this.mDoc.getObjectInfo(xStmID[0], xStmID[1]);
        }
        CosObject xStmObj = CosToken.readIndirectObject(this.mDoc, pBuf, xStmInfo);
        pBuf.close();
        xStmInfo.setPosInternal(nextXRefOffset);
        xStmInfo.markLoaded();
        this.mDoc.putIndexedInfo(xStmID[0], null);
        if (!(xStmObj instanceof CosStream)) {
            throw new PDFCosParseException("Expected CosStream : " + Long.toString(nextXRefOffset));
        }
        CosStream xStm = (CosStream)xStmObj;
        InputByteStream xStmData = xStm.getStreamDecoded();
        CosObject xTypeObj = xStm.get(ASName.k_Type);
        if (xTypeObj == null || !(xTypeObj instanceof CosName) || !((CosName)xTypeObj).nameValue().equals(ASName.k_XRef)) {
            throw new PDFCosParseException("Expected CosName: " + Long.toString(nextXRefOffset));
        }
        CosObject indexObj = xStm.get(ASName.k_Index);
        CosObject wObj = xStm.get(ASName.k_W);
        if (!(wObj instanceof CosArray) || ((CosArray)wObj).size() != 3) {
            throw new PDFCosParseException("UExpected CosArray : " + Long.toString(nextXRefOffset));
        }
        CosArray wArray = (CosArray)wObj;
        int[] w = new int[3];
        int totalW = 0;
        for (int i = 0; i < 3; ++i) {
            w[i] = ((CosNumeric)wArray.get(i)).intValue();
            totalW += w[i];
        }
        int[] intArray = null;
        if (indexObj == null) {
            intArray = new int[]{0, ((CosNumeric)xStm.get(ASName.k_Size)).intValue()};
        } else {
            if (!(indexObj instanceof CosArray)) {
                throw new PDFCosParseException("Expected CosArray : " + Long.toString(nextXRefOffset));
            }
            CosArray indexArray = (CosArray)indexObj;
            intArray = new int[indexArray.size()];
            for (int i = 0; i < indexArray.size(); ++i) {
                intArray[i] = ((CosNumeric)indexArray.get(i)).intValue();
            }
        }
        long streamOffset = 0L;
        for (int i = 0; i < intArray.length; i += 2) {
            int first = intArray[i];
            int count = intArray[i + 1];
            while (count > 0) {
                int subCount = count;
                if (count * totalW > 262144) {
                    subCount = 262144 / totalW;
                }
                this.mXRefSubSections.add(new StreamXRefSubSection(first, subCount, xStm, xStmData, streamOffset, w, totalW));
                first += subCount;
                count -= subCount;
                streamOffset += (long)(subCount * totalW);
            }
        }
        xStmData.close();
        return xStm;
    }

    CosDictionary getTrailer() {
        return this.mTrailer;
    }

    CosDictionary[] getTrailerList() {
        if (this.mTrailerList.isEmpty()) {
            return null;
        }
        CosDictionary[] list = new CosDictionary[this.mTrailerList.size()];
        for (int i = 0; i < this.mTrailerList.size(); ++i) {
            list[i] = (CosDictionary)this.mTrailerList.get(this.mTrailerList.size() - i - 1);
        }
        return list;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    CosObject getIndirectObject(CosObjectInfo info) throws PDFCosParseException, IOException, PDFSecurityException, PDFIOException {
        CosObject result = null;
        if (info == null) return result;
        if (!info.isAddressed()) {
            info = this.getInfo(info);
        }
        if (info == null) {
            return result;
        }
        if (info.isFree()) return result;
        if (info.isCompressed()) {
            CosObject stmObject;
            int objNum = info.getObjNum();
            CosObjectInfo stmInfo = info.getStreamInfo();
            CosLinearization cosLin = this.mDoc.getLinearization();
            if (cosLin != null && cosLin.getOldToOldObjStmMap() != null) {
                objNum = cosLin.mapNewToOldObjNum(objNum);
                stmObject = cosLin.mapOldToOldObjStm(stmInfo.getObjNum());
            } else {
                stmObject = this.mDoc.getIndirectObject(stmInfo);
            }
            if (!(stmObject instanceof CosObjectStream)) throw new PDFCosParseException("Expected cosobject stream.");
            InputByteStream stm = ((CosObjectStream)stmObject).getBytesForObject(objNum);
            info.setNextObjPos(Long.MAX_VALUE);
            result = CosToken.readObject(this.mDoc, stm, info);
        } else {
            long pos = info.getPos();
            if (pos == 0L) {
                throw new PDFCosParseException("The position 0 for an object is not valid.");
            }
            if (pos >= this.mFileBuf.length()) {
                throw new PDFCosParseException("The position of (obj " + info.getObjNum() + " 0) lies outside the file boundary");
            }
            this.mFileBuf.seek(pos);
            CosParseBuf pBuf = new CosParseBuf(this.mFileBuf, 128);
            CosToken.skipObjID(this.mDoc, pBuf, CosToken.skipWhitespace(pBuf));
            result = CosToken.readIndirectObject(this.mDoc, pBuf, info);
            pBuf.close();
        }
        info.markLoaded();
        return result;
    }

    CosObjectInfo getInfo(int objNum) throws PDFCosParseException, IOException, PDFSecurityException {
        for (XRefSubSection xref : this.mXRefSubSections) {
            int begin = xref.getBegin();
            if (begin > objNum || objNum >= xref.getEnd() || !xref.getXRefUsed(objNum - begin)) continue;
            CosObjectInfo info = new CosObjectInfo(this.mDoc, objNum, xref.getXRefGeneration(objNum - begin));
            return xref.getInfo(objNum - begin, info);
        }
        return null;
    }

    private CosObjectInfo getInfo(CosObjectInfo info) throws PDFCosParseException, IOException, PDFSecurityException {
        int id = info.getObjNum();
        int generation = info.getObjGen();
        Iterator iter = this.mXRefSubSections.iterator();
        CosObjectInfo rslt = null;
        while (iter.hasNext() && rslt == null) {
            XRefSubSection xref = (XRefSubSection)iter.next();
            int begin = xref.getBegin();
            if (begin > id || id >= xref.getEnd()) continue;
            if (xref.getXRefGeneration(id - begin) == generation && xref.getXRefUsed(id - begin)) {
                rslt = xref.getInfo(id - begin, info);
            }
            return rslt;
        }
        return rslt;
    }

    void loadUpdateInfos() throws PDFCosParseException, IOException, PDFSecurityException {
        for (XRefSubSection xref : this.mXRefSubSections) {
            int begin;
            if (this.mNoPreload && this.mRevisions != null && this.getXRefSectionPos(xref) < this.mRevisions[0]) break;
            for (int id = begin = xref.getBegin(); id < xref.getEnd(); ++id) {
                int gen;
                CosObjectInfo info;
                if (id == 0 || (info = this.mDoc.getObjectInfo(id, gen = xref.getXRefUsed(id - begin) ? xref.getXRefGeneration(id - begin) : 65535)) != null && (info.isAddressed() || info.isLoaded() || info.isDirty())) continue;
                xref.getInfo(id - begin, info);
            }
        }
    }

    void resetXRef(InputByteStream stm) throws PDFCosParseException, IOException, PDFSecurityException, PDFIOException {
        this.mFileBuf = stm;
        this.mBuf = stm;
        this.mXRefSubSections.clear();
        ArrayList eofList = new ArrayList();
        this.mTrailerList = new ArrayList();
        long nextXRefOffset = this.getLastXRefSectionPosition();
        this.mBuf.seek(nextXRefOffset);
        byte b = CosToken.skipWhitespace(this.mBuf);
        this.mBuf.unget();
        if (b == 120) {
            this.mXrefType = 0;
            this.parseTableXrefChain(nextXRefOffset, eofList);
        } else if (ByteOps.isDigit(b)) {
            this.mXrefType = 1;
            this.parseStreamXrefChain(nextXRefOffset, eofList);
        } else {
            throw new PDFCosParseException("could not find xref section");
        }
        this.setRevisions(eofList);
    }

    private long findNextEOF() throws PDFCosParseException, IOException {
        char[] key_eof = new char[]{'%', '%', 'E', 'O', 'F'};
        long eofPos = this.find(this.mBuf, key_eof);
        if (eofPos < 0L) {
            throw new PDFCosParseException("Could not find EOF");
        }
        int nextByte = 0;
        while (!this.mBuf.eof() && nextByte != 10 && nextByte != 13) {
            nextByte = (byte)this.mBuf.read();
        }
        if (this.mBuf.eof()) {
            return this.mBuf.length();
        }
        nextByte = (byte)this.mBuf.read();
        if (this.mBuf.eof()) {
            return this.mBuf.length();
        }
        eofPos = this.mBuf.getPosition();
        if (nextByte != 10 && nextByte != 13) {
            --eofPos;
        }
        return eofPos;
    }

    long getObjEOF(CosObjectInfo objInfo) {
        if (objInfo == null || this.mRevisions == null) {
            return 0L;
        }
        if (objInfo.isCompressed()) {
            objInfo = objInfo.getStreamInfo();
        }
        long objPos = objInfo.getPos();
        for (int i = 0; i < this.mRevisions.length; ++i) {
            if (objPos >= this.mRevisions[i]) continue;
            return this.mRevisions[i];
        }
        return 0L;
    }

    long getRevisionEOF(int revision) {
        if (this.mRevisions == null || revision < 0 || revision >= this.mRevisions.length) {
            return 0L;
        }
        return this.mRevisions[revision];
    }

    int getObjRevision(CosObjectInfo objInfo) {
        if (objInfo == null || this.mRevisions == null) {
            return -1;
        }
        if (objInfo.isCompressed()) {
            objInfo = objInfo.getStreamInfo();
        }
        long objPos = objInfo.getPos();
        for (int i = 0; i < this.mRevisions.length; ++i) {
            if (objPos >= this.mRevisions[i]) continue;
            return i;
        }
        return -1;
    }

    int getNumRevisions() {
        if (this.mRevisions == null) {
            return 0;
        }
        return this.mRevisions.length;
    }

    void getChangedObjects(long eof, CosList modList) throws PDFCosParseException, IOException, PDFSecurityException {
        for (XRefSubSection subSec : this.mXRefSubSections) {
            if (this.getXRefSectionPos(subSec) < eof) {
                return;
            }
            int first = subSec.getBegin();
            int end = subSec.getEnd();
            int subSecSize = end - first;
            for (int index = 0; index < subSecSize; ++index) {
                int objNum = first + index;
                CosObjectID id = (CosObjectID)modList.get(objNum);
                if (id != null) continue;
                id = subSec.getXRefUsed(index) ? new CosObjectID(objNum, subSec.getXRefGeneration(index)) : new CosObjectID(objNum, -1);
                modList.add(objNum, id);
            }
        }
    }

    private long getXRefSectionPos(XRefSubSection sec) throws PDFCosParseException, IOException, PDFSecurityException {
        if (sec instanceof TableXRefSubSection) {
            return ((TableXRefSubSection)sec).mXRefPos;
        }
        CosStream xrefStm = ((StreamXRefSubSection)sec).mXStm;
        CosObjectInfo info = xrefStm.getInfo();
        if (!info.isFree() && !info.isCompressed()) {
            return info.getPos();
        }
        return 0L;
    }

    private void setRevisions(ArrayList eofList) {
        for (int i = 0; i < eofList.size() - 1; ++i) {
            if ((Long)eofList.get(i) > (Long)eofList.get(i + 1)) continue;
            eofList.remove(i);
        }
        if (!eofList.isEmpty()) {
            int size = eofList.size();
            this.mRevisions = new long[size];
            for (int i = 0; i < size; ++i) {
                this.mRevisions[i] = (Long)eofList.get(size - i - 1);
            }
        } else {
            this.mRevisions = null;
        }
    }

    private CosDictionary readTrailer(byte b) throws PDFCosParseException, IOException, PDFSecurityException, PDFIOException {
        CosParseBuf pBuf = new CosParseBuf(this.mBuf, 128);
        if (b != 116 || pBuf.read() != 114 || pBuf.read() != 97 || pBuf.read() != 105 || pBuf.read() != 108 || pBuf.read() != 101 || pBuf.read() != 114) {
            throw new PDFCosParseException("Expected 'trailer' : " + Long.toString(pBuf.getPosition() - 1L));
        }
        CosObject trailerDict = CosToken.readObject(this.mDoc, pBuf, null);
        pBuf.close();
        if (!(trailerDict instanceof CosDictionary)) {
            throw new PDFCosParseException("Invalid trailer dictionary");
        }
        return (CosDictionary)trailerDict;
    }

    long getLastXRefSectionPosition() throws PDFCosParseException, IOException {
        byte b;
        long pos = this.getEOFPosition();
        do {
            this.mBuf.seek(--pos);
        } while (!ByteOps.isDigit(b = (byte)this.mBuf.read()));
        long rslt = 0L;
        long multiplier = 1L;
        do {
            rslt += (long)((char)b - 48) * multiplier;
            multiplier *= 10L;
            this.mBuf.seek(--pos);
        } while (ByteOps.isDigit(b = (byte)this.mBuf.read()));
        return rslt;
    }

    private long getEOFPosition() throws PDFCosParseException, IOException {
        long length = this.mBuf.length();
        int bufferSize = length >= 1024L ? 1024 : (int)length;
        int curPos = 0;
        int bufPos = bufferSize;
        long garbageLength = 0L;
        byte[] buffer = new byte[bufferSize];
        this.mBuf.seek(length - (long)bufferSize);
        this.mBuf.read(buffer, 0, bufferSize);
        bufPos = bufferSize;
        while (bufPos >= 4) {
            curPos = bufPos--;
            if (buffer[bufPos] == 70 && buffer[--bufPos] == 79 && buffer[--bufPos] == 69 && buffer[--bufPos] == 37 && buffer[--bufPos] == 37) {
                this.mDoc.setGarbageLength(garbageLength);
                return length - (long)(bufferSize - bufPos);
            }
            if (garbageLength == 0L && curPos - bufPos == 1 && ByteOps.isWhitespace(buffer[bufPos])) continue;
            garbageLength += (long)(curPos - bufPos);
        }
        throw new PDFCosParseException("could not find %%EOF");
    }

    void setupTrailerEncryption() throws PDFCosParseException, PDFIOException, PDFSecurityException {
        if (this.mTrailerList != null) {
            for (int i = 0; i < this.mTrailerList.size(); ++i) {
                CosDictionary trailer = (CosDictionary)this.mTrailerList.get(i);
                if (trailer == null) continue;
                boolean oldDecrypt = this.mDoc.getEncryption().setEncryptionState(false);
                if (trailer.containsKey(ASName.k_ID)) {
                    CosArray idArray = trailer.getCosArray(ASName.k_ID);
                    idArray.setEncryptionState(false);
                }
                if (trailer.containsKey(ASName.k_Encrypt)) {
                    CosDictionary encryptDict = trailer.getCosDictionary(ASName.k_Encrypt);
                    encryptDict.setEncryptionState(false);
                }
                this.mDoc.getEncryption().setEncryptionState(oldDecrypt);
            }
        }
    }

    private static long readInt(InputByteStream buf, byte b) throws PDFCosParseException, IOException {
        int sign = 1;
        if (b == 43) {
            sign = 1;
            b = (byte)buf.read();
        }
        if (!ByteOps.isDigit(b)) {
            throw new PDFCosParseException("Expected digit : " + Long.toString(buf.getPosition() - 1L));
        }
        long rslt = 0L;
        while (ByteOps.isDigit(b)) {
            rslt *= 10L;
            rslt += (long)(b - 48);
            b = (byte)buf.read();
        }
        buf.unget();
        return rslt *= (long)sign;
    }

    int getType() {
        return this.mXrefType;
    }

    boolean isNew() {
        boolean result = false;
        if (this.mXRefSubSections.isEmpty()) {
            result = true;
        }
        return result;
    }

    int getNumObjectsDefinedInXRefEntries() {
        return this.highestObjectNumInXRefEntries + 1;
    }

    boolean isXrefIntialized() {
        return this.isXrefIntialized;
    }

    private class StreamXRefSubSection
    extends XRefSubSection {
        long mXrefPos;
        int[] mW;
        int mTotalW;
        int mW0plus1;
        CosStream mXStm;
        byte[] mXRefData;

        StreamXRefSubSection(int first, int count, CosStream cosStm, InputByteStream stm, long streamOffset, int[] w, int totalW) throws PDFCosParseException, IOException, PDFSecurityException {
            this.mBegin = first;
            this.mEnd = first + count;
            XRefTable.this.highestObjectNumInXRefEntries = XRefTable.this.highestObjectNumInXRefEntries > this.mEnd ? XRefTable.this.highestObjectNumInXRefEntries : this.mEnd;
            this.mXrefPos = streamOffset;
            this.mW = w;
            this.mTotalW = totalW;
            this.mW0plus1 = w[0] + w[1];
            this.mXStm = cosStm;
            this.mXRefData = new byte[count * totalW];
            stm.seek(this.mXrefPos);
            stm.read(this.mXRefData, 0, count * totalW);
        }

        @Override
        void close() {
            this.mXRefData = null;
        }

        @Override
        final int getXRefGeneration(int index) throws PDFCosParseException, IOException, PDFSecurityException {
            int result = 0;
            if (this.mW[2] != 0) {
                int entryBase = index * this.mTotalW;
                if (this.getXrefEntryType(index) == 1) {
                    for (int i = entryBase + this.mW0plus1; i < entryBase + this.mTotalW; ++i) {
                        result <<= 8;
                        result |= this.mXRefData[i] & 0xFF;
                    }
                }
            }
            return result;
        }

        @Override
        CosObjectInfo getInfo(int index, CosObjectInfo info) throws PDFCosParseException, IOException, PDFSecurityException {
            if (info != null && info.isAssigned()) {
                int entryBase = index * this.mTotalW;
                int type = this.getXrefEntryType(index);
                if (type == 0) {
                    info.markFree();
                } else if (type == 1) {
                    long position = 0L;
                    for (int i = entryBase + this.mW[0]; i < entryBase + this.mW0plus1; ++i) {
                        position <<= 8;
                        position |= (long)(this.mXRefData[i] & 0xFF);
                    }
                    info.setPos(position);
                    info.markAddressed();
                } else if (type == 2) {
                    int stmNumber = 0;
                    for (int i = entryBase + this.mW[0]; i < entryBase + this.mW0plus1; ++i) {
                        stmNumber <<= 8;
                        stmNumber |= this.mXRefData[i] & 0xFF;
                    }
                    int objNdx = 0;
                    for (int i = entryBase + this.mW0plus1; i < entryBase + this.mTotalW; ++i) {
                        objNdx <<= 8;
                        objNdx |= this.mXRefData[i] & 0xFF;
                    }
                    CosObjectInfo stmInfo = XRefTable.this.mDoc.getObjectInfo(stmNumber, 0);
                    info.setStreamInfo(stmInfo);
                    info.setStreamNdx(objNdx);
                    info.markAddressed();
                } else {
                    throw new PDFCosParseException("Undefined XRef stream entry type");
                }
            }
            return info;
        }

        private int getXrefEntryType(int index) {
            if (this.mW[0] == 0) {
                return 1;
            }
            int entryBase = index * this.mTotalW;
            int type = 0;
            for (int i = entryBase; i < entryBase + this.mW[0]; ++i) {
                type <<= 8;
                type |= this.mXRefData[i] & 0xFF;
            }
            return type;
        }

        @Override
        final boolean getXRefUsed(int index) throws PDFCosParseException, PDFSecurityException {
            return this.getXrefEntryType(index) != 0;
        }
    }

    private class TableXRefSubSection
    extends XRefSubSection {
        private static final int ENTRY_SIZE = 20;
        private static final int ENTRY_POSITION_OFFSET = 0;
        private static final int ENTRY_GENERATION_OFFSET = 11;
        private static final int ENTRY_IN_USE_OFFSET = 17;
        private long mXRefPos;
        private long mCurIndex;
        private byte[] mCurEntry;

        TableXRefSubSection(byte b) throws PDFCosParseException, IOException {
            this.mCurIndex = -1L;
            this.mCurEntry = new byte[20];
            this.mBegin = (int)XRefTable.readInt(XRefTable.this.mBuf, b);
            b = CosToken.skipWhitespace(XRefTable.this.mBuf);
            this.mEnd = this.mBegin + (int)XRefTable.readInt(XRefTable.this.mBuf, b);
            CosToken.skipWhitespace(XRefTable.this.mBuf);
            XRefTable.this.highestObjectNumInXRefEntries = XRefTable.this.highestObjectNumInXRefEntries > this.mEnd ? XRefTable.this.highestObjectNumInXRefEntries : this.mEnd;
            this.mXRefPos = XRefTable.this.mBuf.getPosition() - 1L;
            XRefTable.this.mBuf.seek(this.mXRefPos + (long)(20 * (this.mEnd - this.mBegin)));
        }

        @Override
        CosObjectInfo getInfo(int index, CosObjectInfo info) throws PDFCosParseException, IOException {
            if (info != null && info.isAssigned()) {
                if (this.getXRefUsed(index)) {
                    if ((long)index != this.mCurIndex) {
                        XRefTable.this.mBuf.seek(this.mXRefPos + 20L * (long)index + 0L);
                        XRefTable.this.mBuf.read(this.mCurEntry, 0, 20);
                        byte b = this.mCurEntry[17];
                        if (b != 110 && b != 102) {
                            throw new PDFCosParseException("Bad xref table entry");
                        }
                        this.mCurIndex = index;
                    }
                    long pos = 0L;
                    for (int i = 0; i < 10; ++i) {
                        pos *= 10L;
                        pos += (long)(this.mCurEntry[i] - 48);
                    }
                    info.setPos(pos);
                    info.markAddressed();
                } else {
                    info.markFree();
                }
            }
            return info;
        }

        @Override
        final int getXRefGeneration(int index) throws PDFCosParseException, IOException {
            if ((long)index != this.mCurIndex) {
                XRefTable.this.mBuf.seek(this.mXRefPos + 20L * (long)index + 0L);
                XRefTable.this.mBuf.read(this.mCurEntry, 0, 20);
                byte b = this.mCurEntry[17];
                if (b != 110 && b != 102) {
                    throw new PDFCosParseException("Bad xref table entry");
                }
                this.mCurIndex = index;
            }
            int generation = 0;
            for (int i = 11; i < 16; ++i) {
                generation *= 10;
                generation += this.mCurEntry[i] - 48;
            }
            return generation;
        }

        @Override
        final boolean getXRefUsed(int index) throws PDFCosParseException, IOException {
            if ((long)index != this.mCurIndex) {
                XRefTable.this.mBuf.seek(this.mXRefPos + 20L * (long)index + 0L);
                XRefTable.this.mBuf.read(this.mCurEntry, 0, 20);
                byte b = this.mCurEntry[17];
                if (b != 110 && b != 102) {
                    throw new PDFCosParseException("Bad xref table entry");
                }
                this.mCurIndex = index;
            }
            return this.mCurEntry[17] == 110;
        }

        public String toString() {
            return "TableXRefSubSection (base=" + this.mBegin + " end=" + this.mEnd + ")";
        }

        @Override
        void close() throws IOException {
        }
    }

    private abstract class XRefSubSection {
        int mBegin;
        int mEnd;

        private XRefSubSection() {
        }

        abstract void close() throws IOException;

        final int getBegin() {
            return this.mBegin;
        }

        final int getEnd() {
            return this.mEnd;
        }

        abstract CosObjectInfo getInfo(int var1, CosObjectInfo var2) throws PDFCosParseException, IOException, PDFSecurityException;

        abstract int getXRefGeneration(int var1) throws PDFCosParseException, IOException, PDFSecurityException;

        abstract boolean getXRefUsed(int var1) throws PDFCosParseException, IOException, PDFSecurityException;
    }
}

