/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.core.cos;

import com.adobe.internal.io.stream.InputByteStream;
import com.adobe.internal.pdftoolkit.core.cos.ByteArrayUtility;
import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosBoolean;
import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosDocument;
import com.adobe.internal.pdftoolkit.core.cos.CosLinearization;
import com.adobe.internal.pdftoolkit.core.cos.CosName;
import com.adobe.internal.pdftoolkit.core.cos.CosNull;
import com.adobe.internal.pdftoolkit.core.cos.CosNumeric;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.cos.CosObjectInfo;
import com.adobe.internal.pdftoolkit.core.cos.CosObjectRef;
import com.adobe.internal.pdftoolkit.core.cos.CosObjectStream;
import com.adobe.internal.pdftoolkit.core.cos.CosStream;
import com.adobe.internal.pdftoolkit.core.cos.CosString;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFCosParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASObject;
import com.adobe.internal.pdftoolkit.core.types.ASString;
import com.adobe.internal.pdftoolkit.core.util.BooleanHolder;
import com.adobe.internal.pdftoolkit.core.util.ByteOps;
import com.adobe.internal.pdftoolkit.core.util.ParseOps;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public final class CosToken {
    static final long DEFAULT_NEXT_OBJ_POS = Long.MAX_VALUE;
    private static final int INITIAL_NAME_BUFFER_SIZE = 1024;
    private static ThreadLocal<SoftReference<byte[]>> tlBuffer = new ThreadLocal<SoftReference<byte[]>>(){

        @Override
        protected synchronized SoftReference<byte[]> initialValue() {
            return new SoftReference<byte[]>(new byte[1024]);
        }
    };
    public static final BigDecimal MIN_FLOAT_APPROACHING_TO_ZERO = BigDecimal.valueOf(1.175E-38);
    public static final BigDecimal MAX_REAL = BigDecimal.valueOf(3.4028234663852886E38);

    private CosToken() {
    }

    static int[] readObjID(CosDocument doc, InputByteStream buf, byte b) throws PDFCosParseException, IOException {
        int[] values = new int[]{CosToken.readNumber(buf, b).intValue(), CosToken.readNumber(buf, CosToken.skipWhitespace(buf)).intValue()};
        if (CosToken.skipWhitespace(buf) != 111 || buf.read() != 98 || buf.read() != 106) {
            throw new PDFCosParseException("Expected 'obj' : " + Long.toString(buf.getPosition() - 1L));
        }
        return values;
    }

    static void skipObjID(CosDocument doc, InputByteStream buf, byte b) throws PDFCosParseException, IOException {
        while (buf.read() != 111) {
        }
        if (buf.read() != 98 || buf.read() != 106) {
            throw new PDFCosParseException("Expected 'obj' : " + Long.toString(buf.getPosition() - 1L));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static CosObject readIndirectObject(CosDocument doc, InputByteStream buf, CosObjectInfo info) throws PDFCosParseException, IOException, PDFSecurityException, PDFIOException {
        CosObject retVal = null;
        try {
            long nextObjPos = info != null && info.getNextObjPos() != Long.MAX_VALUE ? buf.getPosition() + (info.getNextObjPos() - info.getPos()) : Long.MAX_VALUE;
            retVal = CosToken.readObject(doc, buf, CosToken.skipWhitespace(buf), info, null, true, nextObjPos);
        }
        finally {
            if (retVal == null && info != null) {
                info.clearObject();
            }
        }
        return retVal;
    }

    static CosObject readObject(CosDocument doc, InputByteStream buf, CosObjectInfo info) throws PDFCosParseException, IOException, PDFSecurityException, PDFIOException {
        long nextObjPos = info != null && info.getNextObjPos() != Long.MAX_VALUE ? buf.getPosition() + (info.getNextObjPos() - info.getPos()) : Long.MAX_VALUE;
        return CosToken.readObject(doc, buf, CosToken.skipWhitespace(buf), info, null, false, nextObjPos);
    }

    static void skipObject(CosDocument doc, InputByteStream buf) throws PDFCosParseException, IOException, PDFSecurityException, PDFIOException {
        CosToken.skipObject(doc, buf, CosToken.skipWhitespace(buf));
    }

    private static ArrayList readArray(CosDocument doc, InputByteStream buf, long nextObjPos) throws PDFCosParseException, PDFSecurityException, IOException, PDFIOException {
        return CosToken.readObjectList(doc, buf, (byte)93, nextObjPos);
    }

    private static void skipArray(CosDocument doc, InputByteStream buf) throws PDFCosParseException, PDFSecurityException, IOException, PDFIOException {
        CosToken.skipObjectList(doc, buf, (byte)93);
    }

    private static Map readDictionary(CosDocument doc, InputByteStream buf, long nextObjPos) throws PDFCosParseException, IOException, IOException, PDFSecurityException, PDFIOException {
        ArrayList<CosObject> content = CosToken.readObjectList(doc, buf, (byte)62, nextObjPos);
        if (content == null) {
            return null;
        }
        byte b = (byte)buf.read();
        if (b != 62) {
            throw new PDFCosParseException("Expected '>' but got '" + b + "'.");
        }
        LinkedHashMap<ASName, CosObject> rslt = new LinkedHashMap<ASName, CosObject>();
        Iterator<CosObject> contentIter = content.iterator();
        while (contentIter.hasNext()) {
            CosObject cosName = contentIter.next();
            if (cosName instanceof CosName) {
                ASName key = ((CosName)cosName).nameValue();
                CosObject value = contentIter.next();
                if (value instanceof CosNull) continue;
                rslt.put(key, value);
                continue;
            }
            rslt.put(null, cosName);
        }
        return rslt;
    }

    private static void skipDictionary(CosDocument doc, InputByteStream buf) throws PDFCosParseException, IOException, IOException, PDFSecurityException, PDFIOException {
        CosToken.skipObjectList(doc, buf, (byte)62);
        buf.read();
    }

    private static byte readHexDigit(InputByteStream buf) throws PDFCosParseException, IOException {
        return CosToken.toHexDigit((byte)buf.read());
    }

    private static byte[] readHexString(InputByteStream buf, boolean[] oddBall) throws PDFCosParseException, IOException {
        int bufSize = 16;
        int digitPosition = 0;
        byte[] bytes = new byte[bufSize];
        byte b = (byte)buf.read();
        while (b != -1) {
            while (b != -1 && ByteOps.isWhitespace(b)) {
                b = (byte)buf.read();
            }
            if (b == 62 || b == -1) break;
            byte h = CosToken.toHexDigit(b);
            b = (byte)buf.read();
            while (b != -1 && ByteOps.isWhitespace(b)) {
                b = (byte)buf.read();
            }
            byte l = 0;
            if (b != 62 && b != -1) {
                l = CosToken.toHexDigit(b);
            }
            if (digitPosition >= bufSize) {
                int newBufSize = 4096;
                if (newBufSize <= bufSize) {
                    newBufSize = bufSize * 2;
                }
                byte[] newBytes = new byte[newBufSize];
                System.arraycopy(bytes, 0, newBytes, 0, bufSize);
                bytes = newBytes;
                bufSize = newBufSize;
            }
            bytes[digitPosition++] = (byte)(h * 16 + l);
            if (b == 62 || b == -1) {
                oddBall[0] = true;
                break;
            }
            b = (byte)buf.read();
        }
        if (digitPosition < bytes.length) {
            byte[] copyBytes = new byte[digitPosition];
            System.arraycopy(bytes, 0, copyBytes, 0, digitPosition);
            bytes = copyBytes;
        }
        return bytes;
    }

    private static void skipHexString(InputByteStream buf) throws PDFCosParseException, IOException {
        byte b = (byte)buf.read();
        while (b != -1) {
            while (ByteOps.isWhitespace(b)) {
                b = (byte)buf.read();
            }
            if (b == 62 || (b = (byte)buf.read()) == 62) break;
            b = (byte)buf.read();
        }
    }

    public static byte toHexDigit(byte b) throws PDFCosParseException {
        int rslt = 0;
        if (b >= 48 && b <= 57) {
            rslt = b - 48;
        } else if (b >= 65 && b <= 70) {
            rslt = b - 65 + 10;
        } else if (b >= 97 && b <= 102) {
            rslt = b - 97 + 10;
        } else {
            throw new PDFCosParseException("Expected Hex Digit - instead got " + Byte.toString(b));
        }
        return (byte)rslt;
    }

    private static ASName readName(InputByteStream buf) throws PDFCosParseException, IOException {
        byte[] readBuffer = tlBuffer.get().get();
        if (readBuffer == null) {
            tlBuffer.remove();
            readBuffer = tlBuffer.get().get();
        }
        int end = 0;
        int cur = buf.read();
        while (cur != -1 && ByteOps.isRegular((byte)cur)) {
            if (end == readBuffer.length) {
                byte[] newBuffer = new byte[readBuffer.length * 2];
                System.arraycopy(readBuffer, 0, newBuffer, 0, readBuffer.length);
                readBuffer = newBuffer;
                tlBuffer.set(new SoftReference<byte[]>(readBuffer));
            }
            if (cur == 35) {
                int next = buf.read();
                buf.unget();
                if (ByteOps.isHexDigit((byte)next)) {
                    cur = CosToken.readHexDigit(buf) * 16 + CosToken.readHexDigit(buf);
                }
            }
            readBuffer[end++] = (byte)cur;
            cur = buf.read();
        }
        if (cur != -1) {
            buf.unget();
        }
        return ASName.getName(readBuffer, 0, end);
    }

    private static void skipName(InputByteStream buf) throws PDFCosParseException, IOException {
        int cur = buf.read();
        while (cur != -1 && ByteOps.isRegular((byte)cur)) {
            if (cur == 35) {
                int next = buf.read();
                buf.unget();
                if (ByteOps.isHexDigit((byte)next)) {
                    cur = CosToken.readHexDigit(buf) * 16 + CosToken.readHexDigit(buf);
                }
            }
            cur = buf.read();
        }
        if (cur != -1) {
            buf.unget();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static Number readNumber(InputByteStream buf, byte b) throws PDFCosParseException, IOException {
        void var10_26;
        block36: {
            int sign = 1;
            long left = 0L;
            long right = 0L;
            long divisor = 1L;
            boolean decimal = false;
            long initPos = buf.getPosition();
            byte initByte = b;
            long numberOfDigitsBeforeDecimal = 1L;
            if (b == 45) {
                sign = -1;
                numberOfDigitsBeforeDecimal = 0L;
                b = (byte)buf.read();
            } else if (b == 43) {
                sign = 1;
                numberOfDigitsBeforeDecimal = 0L;
                b = (byte)buf.read();
            } else if (b == 48) {
                numberOfDigitsBeforeDecimal = 0L;
                b = (byte)buf.read();
            }
            while (ByteOps.isDigit(b) && b == 48) {
                ++initPos;
                b = (byte)buf.read();
            }
            while (ByteOps.isDigit(b)) {
                left *= 10L;
                left += (long)(b - 48);
                b = (byte)buf.read();
            }
            if (b == 46) {
                long numberOfDigitsAfterDecimal;
                decimal = true;
                numberOfDigitsBeforeDecimal += buf.getPosition() - initPos - 1L;
                int dataLengthToParse = (int)(buf.getPosition() - initPos);
                b = (byte)buf.read();
                for (numberOfDigitsAfterDecimal = 0L; ByteOps.isDigit(b) && numberOfDigitsAfterDecimal < 16L; right += (long)(b - 48), divisor *= 10L, ++numberOfDigitsAfterDecimal) {
                    right *= 10L;
                    b = (byte)buf.read();
                }
                if (numberOfDigitsAfterDecimal == 16L) {
                    while (ByteOps.isDigit(b) && b == 48) {
                        ++numberOfDigitsAfterDecimal;
                        b = (byte)buf.read();
                    }
                    if (ByteOps.isDigit(b)) {
                        while (ByteOps.isDigit(b)) {
                            ++numberOfDigitsAfterDecimal;
                            b = (byte)buf.read();
                        }
                    } else {
                        numberOfDigitsAfterDecimal = 16L;
                    }
                }
                if (ByteOps.isRegular(b)) {
                    throw new PDFCosParseException("Unexpected character at position " + Long.toString(buf.getPosition() - 1L));
                }
                buf.unget();
                if (numberOfDigitsBeforeDecimal > 16L || numberOfDigitsAfterDecimal > 16L) {
                    InputByteStream slicedByteStream = null;
                    InputStream inputStream = null;
                    try {
                        dataLengthToParse = (int)((long)dataLengthToParse + numberOfDigitsAfterDecimal);
                        byte[] data = new byte[dataLengthToParse + 1];
                        slicedByteStream = buf.slice(initPos, dataLengthToParse);
                        inputStream = slicedByteStream.toInputStream();
                        inputStream.read(data, 1, dataLengthToParse);
                        data[0] = initByte;
                        BigDecimal bigNumber = new BigDecimal(new String(data));
                        if (bigNumber != null && (bigNumber.compareTo(MAX_REAL) == 1 || bigNumber.compareTo(MAX_REAL.negate()) == -1)) {
                            PDFCosParseException exceptionOccured = new PDFCosParseException("Number in document is out of the range \u00ef\u00bf\u00bd3.403 \u00ef\u00bf\u00bd 10^38");
                            exceptionOccured.addErrorType(PDFCosParseException.CosParseErrorType.NumberParseError);
                            throw exceptionOccured;
                        }
                        if (bigNumber != null && bigNumber.compareTo(MIN_FLOAT_APPROACHING_TO_ZERO) == -1 && bigNumber.compareTo(MIN_FLOAT_APPROACHING_TO_ZERO.negate()) == 1) {
                            Double d = new Double((double)sign * 0.0);
                            return d;
                        }
                        Double d = bigNumber.doubleValue();
                        return d;
                    }
                    finally {
                        try {
                            if (inputStream != null) {
                                inputStream.close();
                            }
                        }
                        finally {
                            if (slicedByteStream != null) {
                                slicedByteStream.close();
                            }
                        }
                    }
                }
            }
            if (!decimal) {
                if (sign == 1 && left <= Integer.MAX_VALUE || sign == -1 && left <= 0x80000000L) {
                    Integer n = (int)left * sign;
                    break block36;
                } else {
                    PDFCosParseException exceptionOccured = new PDFCosParseException("Number in document is either greater than 2,147,483,647 OR less than -2,147,483,648");
                    exceptionOccured.addErrorType(PDFCosParseException.CosParseErrorType.NumberParseError);
                    throw exceptionOccured;
                }
            }
            Double d = new Double(((double)left + (double)right / (double)divisor) * (double)sign);
        }
        if (ByteOps.isRegular(b)) {
            throw new PDFCosParseException("Unexpected character at position " + Long.toString(buf.getPosition() - 1L));
        }
        buf.unget();
        return var10_26;
    }

    static Number readNumber(byte[] buf, BooleanHolder wasRepaired) throws PDFCosParseException {
        return CosToken.readNumber(buf, false, wasRepaired);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Number readNumber(byte[] buf, boolean isExponent, BooleanHolder wasRepaired) throws PDFCosParseException {
        Number rslt;
        int b;
        int index;
        block28: {
            index = 0;
            if (index == buf.length) {
                throw new PDFCosParseException("Empty number string");
            }
            b = buf[index++];
            int sign = 1;
            long left = 0L;
            long right = 0L;
            long divisor = 1L;
            boolean decimal = false;
            long numberOfDigitsBeforeDecimal = 0L;
            if (b == 45) {
                sign = -1;
                if (index == buf.length) {
                    throw new PDFCosParseException("Non-numeric number string");
                }
                b = buf[index++];
            } else if (b == 43) {
                sign = 1;
                if (index == buf.length) {
                    throw new PDFCosParseException("Non-numeric number string");
                }
                b = buf[index++];
            }
            while (ByteOps.isDigit((byte)b) && b == 48) {
                if (index == buf.length) {
                    b = 32;
                    break;
                }
                b = buf[index++];
            }
            while (ByteOps.isDigit((byte)b)) {
                left *= 10L;
                left += (long)(b - 48);
                ++numberOfDigitsBeforeDecimal;
                if (index == buf.length) {
                    b = 32;
                    break;
                }
                b = buf[index++];
            }
            if (b == 46) {
                decimal = true;
                long numberOfDigitsAfterDecimal = 0L;
                b = 32;
                int indexOfLastTrailingZero = buf.length - 1;
                if (index < buf.length) {
                    b = buf[indexOfLastTrailingZero];
                    while (b == 0) {
                        b = buf[--indexOfLastTrailingZero];
                    }
                    while (ByteOps.isDigit((byte)b) && b == 48) {
                        b = buf[--indexOfLastTrailingZero];
                    }
                    b = buf[index++];
                    while (ByteOps.isDigit((byte)b)) {
                        right *= 10L;
                        right += (long)(b - 48);
                        divisor *= 10L;
                        ++numberOfDigitsAfterDecimal;
                        if (index > indexOfLastTrailingZero) {
                            b = 32;
                            break;
                        }
                        b = buf[index++];
                    }
                }
                if (numberOfDigitsAfterDecimal == 0L && numberOfDigitsBeforeDecimal == 0L && !ByteOps.isDigit((byte)b) && ByteOps.isRegular((byte)b)) {
                    throw new PDFCosParseException("Non-numeric number string");
                }
                if (numberOfDigitsBeforeDecimal > 16L || numberOfDigitsAfterDecimal > 16L) {
                    BigDecimal bigNumber = new BigDecimal(new String(buf).substring(0, indexOfLastTrailingZero));
                    if (bigNumber != null && (bigNumber.compareTo(MAX_REAL) == 1 || bigNumber.compareTo(MAX_REAL.negate()) == -1)) {
                        PDFCosParseException exceptionOccured = new PDFCosParseException("Number in document is out of the range \u00ef\u00bf\u00bd3.403 \u00ef\u00bf\u00bd 10^38");
                        exceptionOccured.addErrorType(PDFCosParseException.CosParseErrorType.NumberParseError);
                        throw exceptionOccured;
                    }
                    if (bigNumber != null && bigNumber.compareTo(MIN_FLOAT_APPROACHING_TO_ZERO) == -1 && bigNumber.compareTo(MIN_FLOAT_APPROACHING_TO_ZERO.negate()) == 1) {
                        return new Double((double)sign * 0.0);
                    }
                    return bigNumber.doubleValue();
                }
            }
            if (!decimal) {
                if (sign == 1 && left <= Integer.MAX_VALUE || sign == -1 && left <= 0x80000000L) {
                    rslt = (int)left * sign;
                    break block28;
                } else {
                    PDFCosParseException exceptionOccured = new PDFCosParseException("Number in document is either greater than 2,147,483,647 OR less than -2,147,483,648");
                    exceptionOccured.addErrorType(PDFCosParseException.CosParseErrorType.NumberParseError);
                    throw exceptionOccured;
                }
            }
            rslt = new Double(((double)left + (double)right / (double)divisor) * (double)sign);
        }
        if (!isExponent && b == 101 && wasRepaired != null) {
            byte[] bufCopy = new byte[buf.length - index];
            System.arraycopy(buf, index, bufCopy, 0, bufCopy.length);
            Number pow = null;
            try {
                pow = CosToken.readNumber(bufCopy, true, wasRepaired);
            }
            catch (Exception e) {
                throw new PDFCosParseException("Non-numeric number string");
            }
            rslt = rslt.doubleValue() * Math.pow(10.0, pow.doubleValue());
            double rsltDouble = rslt.doubleValue();
            if (rsltDouble != (double)rslt.intValue() ? rsltDouble > MAX_REAL.doubleValue() || rsltDouble < MAX_REAL.negate().doubleValue() : rsltDouble > 2.147483647E9 || rsltDouble < -2.147483648E9) {
                throw new PDFCosParseException("Non-numeric number string");
            }
            wasRepaired.setValue(true);
            b = buf[buf.length - 1];
        }
        if (!ByteOps.isDigit((byte)b) && ByteOps.isRegular((byte)b)) {
            throw new PDFCosParseException("Non-numeric number string");
        }
        return rslt;
    }

    static String readLine(InputByteStream buf, boolean breakOnSpace) throws IOException {
        StringBuilder rslt = new StringBuilder();
        int b = buf.read();
        while (!(b == 13 || b == 10 || breakOnSpace && b == 32)) {
            rslt.append((char)b);
            b = buf.read();
        }
        if (b == 13 && buf.read() != 10) {
            buf.unget();
        }
        return rslt.toString();
    }

    /*
     * Unable to fully structure code
     */
    public static byte skipWhitespace(InputByteStream buf) throws IOException, PDFCosParseException {
        block3: {
            block0: while (true) {
                if (ByteOps.isWhitespace(b = (byte)buf.read())) {
                    continue;
                }
                if (b != 37) break block3;
                do {
                    if (b != 13 && b != 10) ** break;
                    continue block0;
                } while ((b = (byte)buf.read()) != -1 || !buf.eof());
                break;
            }
            throw new PDFCosParseException("Read past EOF");
        }
        return b;
    }

    private static int readDigits(byte[] output, InputByteStream buf, byte b, int offset) throws IOException {
        do {
            output[offset++] = b;
            b = (byte)buf.read();
        } while (offset < output.length && (ByteOps.isDigit(b) || b == 43 || b == 45 || b == 46));
        if (b != -1) {
            buf.unget();
        }
        if (ByteOps.isDigit(b) || b == 43 || b == 45 || b == 46) {
            while (ByteOps.isDigit(b = (byte)buf.read()) || b == 43 || b == 45 || b == 46) {
            }
            if (b != -1) {
                buf.unget();
            }
        }
        return offset;
    }

    private static CosObject readObject(CosDocument doc, InputByteStream buf, byte b, CosObjectInfo info, ArrayList parseArray, boolean doStms, long nextObjPos) throws PDFCosParseException, IOException, PDFSecurityException, IOException, PDFIOException {
        CosObject rslt = null;
        if (ByteOps.isDigit(b) || b == 43 || b == 45 || b == 46) {
            byte[] rep = new byte[64];
            int pos = CosToken.readDigits(rep, buf, b, 0);
            b = (byte)buf.read();
            if (b == 101 && !buf.eof()) {
                b = (byte)buf.read();
                if (ByteOps.isDigit(b) || b == 43 || b == 45) {
                    rep[pos++] = 101;
                    CosToken.readDigits(rep, buf, b, pos);
                    b = (byte)buf.read();
                } else {
                    buf.unget();
                }
            }
            if (b != -1) {
                buf.unget();
            }
            rslt = new CosNumeric(doc, rep, info);
        } else if (b == 82) {
            if (parseArray != null) {
                int generation = ((CosNumeric)parseArray.remove(parseArray.size() - 1)).intValue();
                int objectNumber = ((CosNumeric)parseArray.remove(parseArray.size() - 1)).intValue();
                CosLinearization cosLin = doc.getLinearization();
                if (cosLin != null) {
                    objectNumber = cosLin.mapOldToNewObjNum(objectNumber);
                    generation = 0;
                }
                if (doc.isFDF() || !doc.getXRef().isXrefIntialized() || objectNumber < doc.getXRef().getNumObjectsDefinedInXRefEntries()) {
                    info = doc.getObjectInfo(objectNumber, generation);
                }
                if (info != null) {
                    rslt = doc.getObjectRef(info);
                }
                if (rslt == null) {
                    rslt = doc.createCosNull();
                }
            } else {
                rslt = doc.createCosNull();
            }
        } else if (b == 47) {
            ASName name = CosToken.readName(buf);
            rslt = new CosName(doc, name, info);
        } else if (b == 40) {
            byte[] str = ByteArrayUtility.readLiteral(doc, buf, nextObjPos);
            if (str == null) {
                return null;
            }
            rslt = new CosString(doc, str, 0, str.length, true, info);
        } else if (b == 60) {
            b = (byte)buf.read();
            if (b == 60) {
                Map map = CosToken.readDictionary(doc, buf, nextObjPos);
                if (map == null) {
                    rslt = doc.createCosNull();
                    if (info != null) {
                        rslt.setInfo(info);
                        doc.setRepairedValue(info.getObjNum(), rslt);
                    }
                    return rslt;
                }
                if (doStms && (b = CosToken.skipWhitespace(buf)) == 115) {
                    if (buf.read() != 116 || buf.read() != 114 || buf.read() != 101 || buf.read() != 97 || buf.read() != 109) {
                        throw new PDFCosParseException("Expected 'stream' at position " + Long.toString(buf.getPosition() - 1L));
                    }
                    b = (byte)buf.read();
                    while (b == 32) {
                        b = (byte)buf.read();
                    }
                    if (b == 13) {
                        b = (byte)buf.read();
                        if (b != 10) {
                            buf.unget();
                        }
                    } else if (b != 10) {
                        buf.unget();
                    }
                    boolean ostream = map.containsKey(ASName.k_Type) && ((CosName)map.get(ASName.k_Type)).nameValue() == ASName.k_ObjStm;
                    long pos = buf.getPosition();
                    rslt = ostream && info != null ? new CosObjectStream(doc, map, info, pos) : new CosStream(doc, map, info, pos);
                }
                if (rslt == null) {
                    rslt = new CosDictionary(doc, map, info);
                }
            } else {
                buf.unget();
                boolean[] oddBall = new boolean[1];
                byte[] str = CosToken.readHexString(buf, oddBall);
                rslt = new CosString(doc, str, 0, str.length, true, info, true, oddBall[0]);
            }
        } else if (b == 91) {
            ArrayList objectsList = CosToken.readArray(doc, buf, nextObjPos);
            if (objectsList == null) {
                rslt = doc.createCosNull();
                if (info != null) {
                    rslt.setInfo(info);
                    doc.setRepairedValue(info.getObjNum(), rslt);
                }
            } else {
                rslt = new CosArray(doc, objectsList, info);
            }
        } else if (b == 116) {
            rslt = new CosBoolean(doc, (boolean)CosToken.readTrue(buf), info);
        } else if (b == 102) {
            rslt = new CosBoolean(doc, (boolean)CosToken.readFalse(buf), info);
        } else if (b == 110) {
            CosToken.readNull(buf);
            rslt = doc.createCosNull();
        } else {
            throw new PDFCosParseException("Unexpected token at position " + Long.toString(buf.getPosition() - 1L));
        }
        return rslt;
    }

    public static void skipObject(CosDocument doc, InputByteStream buf, byte b) throws PDFCosParseException, IOException, PDFSecurityException, PDFIOException {
        if (ByteOps.isDigit(b) || b == 43 || b == 45 || b == 46) {
            while (ByteOps.isDigit(b = (byte)buf.read()) || b == 43 || b == 45 || b == 46) {
            }
            if (b != -1) {
                buf.unget();
            }
        } else if (b != 82) {
            if (b == 47) {
                CosToken.skipName(buf);
            } else if (b == 40) {
                ByteArrayUtility.skipLiteral(buf);
            } else if (b == 60) {
                b = (byte)buf.read();
                if (b == 60) {
                    long dictStartPos = buf.getPosition();
                    CosToken.skipDictionary(doc, buf);
                    b = CosToken.skipWhitespace(buf);
                    if (b == 115) {
                        if (buf.read() == 116 && buf.read() == 114 && buf.read() == 101 && buf.read() == 97 && buf.read() == 109) {
                            buf.seek(dictStartPos);
                            Map map = CosToken.readDictionary(doc, buf, Long.MAX_VALUE);
                            b = (byte)buf.read();
                            while (b == 32) {
                                b = (byte)buf.read();
                            }
                            if (b == 13) {
                                b = (byte)buf.read();
                                if (b != 10) {
                                    buf.unget();
                                }
                            } else if (b != 10) {
                                buf.unget();
                            }
                            long length = -1L;
                            CosObject obj = (CosObject)map.get(ASName.k_Length);
                            if (obj instanceof CosNumeric) {
                                length = ((CosNumeric)obj).longValue();
                            } else if (obj instanceof CosObjectRef && ((CosObjectRef)obj).getValueType() == 1) {
                                length = ((Number)((CosObjectRef)obj).getValue()).longValue();
                            }
                            if (length != -1L) {
                                buf.seek(buf.getPosition() + length);
                            }
                        }
                    } else {
                        buf.unget();
                    }
                } else {
                    buf.unget();
                    CosToken.skipHexString(buf);
                }
            } else if (b == 91) {
                CosToken.skipArray(doc, buf);
            } else if (b == 116) {
                CosToken.skipTrue(buf);
            } else if (b == 102) {
                CosToken.skipFalse(buf);
            } else if (b == 110) {
                CosToken.skipNull(buf);
            }
        }
    }

    private static ArrayList<CosObject> readObjectList(CosDocument doc, InputByteStream buf, byte delimiter, long nextObjPos) throws PDFCosParseException, IOException, PDFSecurityException, PDFIOException {
        ArrayList<CosObject> rslt = new ArrayList<CosObject>();
        byte b = CosToken.skipWhitespace(buf);
        while (b != delimiter && b != -1) {
            CosObject obj = CosToken.readObject(doc, buf, b, null, rslt, false, nextObjPos);
            if (obj == null) {
                return null;
            }
            rslt.add(obj);
            b = CosToken.skipWhitespace(buf);
        }
        return rslt;
    }

    private static void skipObjectList(CosDocument doc, InputByteStream buf, byte delimiter) throws PDFCosParseException, IOException, PDFSecurityException, PDFIOException {
        byte b = CosToken.skipWhitespace(buf);
        while (b != delimiter && b != -1) {
            CosToken.skipObject(doc, buf, b);
            b = CosToken.skipWhitespace(buf);
        }
    }

    private static Boolean readTrue(InputByteStream buf) throws PDFCosParseException, IOException {
        if (buf.read() != 114) {
            throw new PDFCosParseException("Expected 'true' - " + Long.toString(buf.getPosition() - 1L));
        }
        if (buf.read() != 117) {
            throw new PDFCosParseException("Expected 'true' - " + Long.toString(buf.getPosition() - 1L));
        }
        if (buf.read() != 101) {
            throw new PDFCosParseException("Expected 'true' - " + Long.toString(buf.getPosition() - 1L));
        }
        return Boolean.TRUE;
    }

    private static void skipTrue(InputByteStream buf) throws PDFCosParseException, IOException {
        buf.read();
        buf.read();
        buf.read();
    }

    private static void skipFalse(InputByteStream buf) throws PDFCosParseException, IOException {
        buf.read();
        buf.read();
        buf.read();
        buf.read();
    }

    private static void skipNull(InputByteStream buf) throws PDFCosParseException, IOException {
        buf.read();
        buf.read();
        buf.read();
    }

    private static Boolean readFalse(InputByteStream buf) throws PDFCosParseException, IOException {
        if (buf.read() != 97) {
            throw new PDFCosParseException("Expected 'false' - " + Long.toString(buf.getPosition() - 1L));
        }
        if (buf.read() != 108) {
            throw new PDFCosParseException("Expected 'false' - " + Long.toString(buf.getPosition() - 1L));
        }
        if (buf.read() != 115) {
            throw new PDFCosParseException("Expected 'false' - " + Long.toString(buf.getPosition() - 1L));
        }
        if (buf.read() != 101) {
            throw new PDFCosParseException("Expected 'false' - " + Long.toString(buf.getPosition() - 1L));
        }
        return Boolean.FALSE;
    }

    private static void readNull(InputByteStream buf) throws PDFCosParseException, IOException {
        if (buf.read() != 117) {
            throw new PDFCosParseException("Expected 'null' - " + Long.toString(buf.getPosition() - 1L));
        }
        if (buf.read() != 108) {
            throw new PDFCosParseException("Expected 'null' - " + Long.toString(buf.getPosition() - 1L));
        }
        if (buf.read() != 108) {
            throw new PDFCosParseException("Expected 'null' - " + Long.toString(buf.getPosition() - 1L));
        }
    }

    static ASObject readPrimitive(InputByteStream buf) throws IOException, PDFCosParseException {
        long savePos;
        byte b = CosToken.skipWhitespace(buf);
        if (buf.eof()) {
            return null;
        }
        if (ByteOps.isDigit(b) || b == 43 || b == 45 || b == 46) {
            savePos = buf.getPosition();
            try {
                return ParseOps.readNumber(b, buf);
            }
            catch (PDFParseException pDFParseException) {
                buf.seek(savePos);
            }
        }
        if (b == 47) {
            savePos = buf.getPosition();
            try {
                return ParseOps.readName(buf);
            }
            catch (PDFParseException pDFParseException) {
                buf.seek(savePos);
            }
        }
        if (ByteOps.isRegular(b)) {
            StringBuilder strBuf = new StringBuilder();
            strBuf.append((char)b);
            while (!buf.eof() && ByteOps.isRegular(b = (byte)buf.read())) {
                strBuf.append((char)b);
            }
            buf.unget();
            return new ASString(strBuf.toString());
        }
        if (b == 60) {
            b = (byte)buf.read();
            if (b == 60) {
                return new ASString("<<");
            }
            buf.unget();
        }
        if (b == 62) {
            b = (byte)buf.read();
            if (b == 62) {
                return new ASString(">>");
            }
            buf.unget();
        }
        byte[] bytes = new byte[]{b};
        return new ASString(bytes);
    }
}

