/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.core.cos;

import java.util.Iterator;

public final class CosList {
    private static final int BLOCK_BITS = 6;
    private static final int BLOCK_SIZE = 64;
    private static final int BLOCK_MASK = 63;
    private int mLevels = 1;
    private int mFirst = -1;
    private int mSize = 0;
    private int mCount = 0;
    private Object[] mObjects = new Object[64];
    private Object[] mCurNode = null;

    public void add(Object obj) {
        this.add(this.mSize, obj);
    }

    public void add(int index, Object obj) {
        if (index < 0) {
            return;
        }
        if (obj == null) {
            this.delete(index);
        } else {
            int curIndex;
            while (index >= 1 << 6 * this.mLevels) {
                Object[] block = new Object[64];
                block[0] = this.mObjects;
                this.mObjects = block;
                ++this.mLevels;
            }
            Object[] nodeBlock = this.mObjects;
            for (int curLevel = 0; curLevel < this.mLevels - 1; ++curLevel) {
                curIndex = index >> 6 * (this.mLevels - curLevel - 1) & 0x3F;
                if (nodeBlock[curIndex] == null) {
                    nodeBlock[curIndex] = new Object[64];
                }
                nodeBlock = (Object[])nodeBlock[curIndex];
            }
            curIndex = index & 0x3F;
            if (nodeBlock[curIndex] == null) {
                if (++this.mCount == 1) {
                    this.mFirst = index;
                    this.mSize = index + 1;
                } else if (index >= this.mSize) {
                    this.mSize = index + 1;
                } else if (index < this.mFirst) {
                    this.mFirst = index;
                }
            }
            nodeBlock[curIndex] = obj;
        }
    }

    public void addAll(CosList src) {
        Iterator<Object> iter = src.iterator();
        while (iter.hasNext()) {
            this.add(iter.next());
        }
    }

    public void delete(int index) {
        int curIndex;
        int curLevel;
        if (index < 0 || index >= 1 << 6 * this.mLevels) {
            return;
        }
        Object[] blockStack = new Object[this.mLevels];
        int[] indexStack = new int[this.mLevels];
        Object[] nodeBlock = this.mObjects;
        for (curLevel = 0; curLevel < this.mLevels - 1; ++curLevel) {
            blockStack[curLevel] = nodeBlock;
            indexStack[curLevel] = curIndex = index >> 6 * (this.mLevels - curLevel - 1) & 0x3F;
            if ((nodeBlock = (Object[])nodeBlock[curIndex]) != null) continue;
            return;
        }
        blockStack[curLevel] = nodeBlock;
        indexStack[curLevel] = curIndex = index & 0x3F;
        if (nodeBlock[curIndex] == null) {
            return;
        }
        if (--this.mCount == 0) {
            this.mLevels = 1;
            this.mFirst = -1;
            this.mSize = 0;
            this.mObjects = new Object[64];
            return;
        }
        for (curLevel = this.mLevels - 1; curLevel >= 0; --curLevel) {
            nodeBlock = (Object[])blockStack[curLevel];
            curIndex = indexStack[curLevel];
            nodeBlock[curIndex] = null;
            for (curIndex = 0; curIndex < 64 && nodeBlock[curIndex] == null; ++curIndex) {
            }
            if (curIndex != 64) break;
        }
        if (index == this.mFirst) {
            this.mFirst = this.findNext(index);
        } else if (index == this.mSize - 1) {
            this.mSize = this.findPrevious(index) + 1;
        }
        while (this.mSize <= 1 << 6 * (this.mLevels - 1) && this.mLevels > 1) {
            this.mObjects = (Object[])this.mObjects[0];
            --this.mLevels;
        }
    }

    public Object get(int index) {
        if (index < 0 || index >= 1 << 6 * this.mLevels) {
            return null;
        }
        Object[] nodeBlock = this.mObjects;
        for (int curLevel = 0; curLevel < this.mLevels - 1; ++curLevel) {
            int curIndex = index >> 6 * (this.mLevels - curLevel - 1) & 0x3F;
            if ((nodeBlock = (Object[])nodeBlock[curIndex]) != null) continue;
            return null;
        }
        return nodeBlock[index & 0x3F];
    }

    public int size() {
        return this.mSize;
    }

    public int count() {
        return this.mCount;
    }

    public boolean isEmpty() {
        return this.mSize == 0;
    }

    public boolean containsIndex(int index) {
        return this.get(index) != null;
    }

    public CosList copy() {
        CosList listCopy = new CosList();
        Iterator<Object> iter = this.iterator();
        while (iter.hasNext()) {
            listCopy.add(iter.next());
        }
        return listCopy;
    }

    public Object first() {
        return this.get(this.mFirst);
    }

    public Object last() {
        if (this.mSize == 0) {
            return null;
        }
        return this.get(this.mSize - 1);
    }

    public int findNext(int index) {
        if (++index >= this.mSize) {
            return -1;
        }
        if (index < this.mFirst) {
            index = this.mFirst;
        }
        int curLevel = 0;
        int curIndex = index >> 6 * (this.mLevels - 1);
        Object[] blockStack = new Object[this.mLevels - 1];
        int[] indexStack = new int[this.mLevels - 1];
        Object[] nodeBlock = this.mObjects;
        while (true) {
            if (curIndex == 64) {
                if (--curLevel < 0) {
                    return -1;
                }
                nodeBlock = (Object[])blockStack[curLevel];
                curIndex = indexStack[curLevel];
                ++curIndex;
                continue;
            }
            if (nodeBlock[curIndex] == null) {
                index = 0;
                ++curIndex;
                continue;
            }
            if (curLevel == this.mLevels - 1) {
                index = 0;
                for (curLevel = 0; curLevel < this.mLevels - 1; ++curLevel) {
                    index |= indexStack[curLevel];
                    index <<= 6;
                }
                this.mCurNode = nodeBlock;
                return index |= curIndex;
            }
            blockStack[curLevel] = nodeBlock;
            indexStack[curLevel] = curIndex;
            nodeBlock = (Object[])nodeBlock[curIndex];
            curIndex = index >> 6 * (this.mLevels - ++curLevel - 1) & 0x3F;
        }
    }

    public int findPrevious(int index) {
        if (--index < this.mFirst) {
            return -1;
        }
        if (index > this.mSize - 1) {
            index = this.mSize - 1;
        }
        int curLevel = 0;
        int curIndex = index >> 6 * (this.mLevels - 1);
        Object[] blockStack = new Object[this.mLevels - 1];
        int[] indexStack = new int[this.mLevels - 1];
        Object[] nodeBlock = this.mObjects;
        while (true) {
            if (curIndex == -1) {
                if (--curLevel < 0) {
                    return -1;
                }
                nodeBlock = (Object[])blockStack[curLevel];
                curIndex = indexStack[curLevel];
                --curIndex;
                continue;
            }
            if (nodeBlock[curIndex] == null) {
                index = -1;
                --curIndex;
                continue;
            }
            if (curLevel == this.mLevels - 1) {
                index = 0;
                for (curLevel = 0; curLevel < this.mLevels - 1; ++curLevel) {
                    index |= indexStack[curLevel];
                    index <<= 6;
                }
                return index |= curIndex;
            }
            blockStack[curLevel] = nodeBlock;
            indexStack[curLevel] = curIndex;
            nodeBlock = (Object[])nodeBlock[curIndex];
            curIndex = index >> 6 * (this.mLevels - ++curLevel - 1) & 0x3F;
        }
    }

    public Iterator<Object> iterator() {
        return new CosListIterator();
    }

    static /* synthetic */ Object[] access$002(CosList x0, Object[] x1) {
        x0.mCurNode = x1;
        return x1;
    }

    class CosListIterator
    implements Iterator {
        private int mCurIndex = -1;

        CosListIterator() {
            CosList.access$002(CosList.this, null);
        }

        @Override
        public boolean hasNext() {
            return this.mCurIndex < CosList.this.mSize - 1;
        }

        public Object next() {
            int nodeIndex;
            if (CosList.this.mCurNode != null && (nodeIndex = this.mCurIndex + 1 & 0x3F) != 0) {
                while (nodeIndex <= 63) {
                    if (CosList.this.mCurNode[nodeIndex] != null) {
                        this.mCurIndex = (this.mCurIndex & 0xFFFFFFC0) + nodeIndex;
                        return CosList.this.mCurNode[nodeIndex];
                    }
                    ++nodeIndex;
                }
            }
            this.mCurIndex = CosList.this.findNext(this.mCurIndex);
            if (this.mCurIndex < 0) {
                return null;
            }
            return CosList.this.mCurNode[this.mCurIndex & 0x3F];
        }

        @Override
        public void remove() {
            CosList.this.delete(this.mCurIndex);
            CosList.access$002(CosList.this, null);
        }
    }
}

