/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.core.cos;

import com.adobe.internal.io.ByteWriterFactory;
import com.adobe.internal.io.stream.OutputByteStream;
import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosContainer;
import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosDocument;
import com.adobe.internal.pdftoolkit.core.cos.CosList;
import com.adobe.internal.pdftoolkit.core.cos.CosListInt;
import com.adobe.internal.pdftoolkit.core.cos.CosName;
import com.adobe.internal.pdftoolkit.core.cos.CosNull;
import com.adobe.internal.pdftoolkit.core.cos.CosNumeric;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.cos.CosObjectInfo;
import com.adobe.internal.pdftoolkit.core.cos.CosObjectStream;
import com.adobe.internal.pdftoolkit.core.cos.CosStream;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFCosParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;

class CosLinearization {
    private static final int DEFAULT_WIDTH = 612;
    private static final int DEFAULT_HEIGHT = 792;
    private static final int OBJSTM_MAXNUMOBJS = 100;
    private static final int PROCESS_SINGLE = 0;
    private static final int PROCESS_SHALLOW = 1;
    private static final int PROCESS_DEEP = 2;
    private static final int PROCESS_SECONDARY = 3;
    private static final int PROCESS_TERTIARY = 4;
    private CosDocument mCosDoc;
    private CosDictionary mCatalog;
    private int mNumPages;
    private int mCurPageNum = -1;
    private boolean mCatalogEnable = false;
    private boolean mPageObjEnable = false;
    private boolean mStreamsEnable = false;
    private int mNumEmbFiles;
    private int mSpecialPageNum = -1;
    private CosDictionary mSpecialPageObj;
    private int mCurEnumTag;
    private boolean mUseBookmarks;
    private CosList mPageContents = new CosList();
    private CosList mPageThumbObjs = new CosList();
    private LinObjCol mCurPageCol;
    private LinObjCol mCurEmbFileCol;
    private CosList mMasterList = new CosList();
    private CosList mColArray = new CosList();
    private Object[] mStateStack = null;
    private int mStateStackPtr = 0;
    private int mXRefStyle;
    private CosListInt mNewToOldObjNumMap;
    private CosListInt mNewToOldObjGenMap;
    private CosList mOldToOldObjStmMap;
    private CosListInt mOldToNewObjNumMap;
    private CosList mLinArray;
    private CosList mPageArrays;
    private CosList mPageArraysSh;
    private CosList mSplPageDeferredArray;
    private CosList mEmbFileArrays;
    private CosList mThumbArray;
    private CosList mThumbArraySh;
    private CosList mAcroFormArray;
    private CosList mAcroFormArraySh;
    private CosList mStructureArray;
    private CosList mStructureArraySh;
    private CosList mRenditionArray;
    private CosList mRenditionArraySh;
    private CosList mMediaClipArray;
    private CosList mMediaClipArraySh;
    private CosList mOutlineArray;
    private CosList mThreadArray;
    private CosList mDestArray;
    private CosList mInfoDictArray;
    private CosList mPageLabelArray;
    private CosList mOtherArray;
    private CosList mMainSection;
    private CosList mMainSectionCompressed;
    private CosList mUpdateSection;
    private CosList mUpdateSectionCompressed;
    private CosList mSharedObjects;
    private CosList mObjectInfos;
    private CosStream mHintStm;
    private int mMainLastObjNum;
    private int mUpdateLastObjNum;
    private long mHintStmPos;
    private long mObjEndPos;
    private OutputByteStream mHintOutputStream;
    private int mNumSplPageSharedObjs;
    private int mNumSharedObjs;
    private int[] mSharedObjLengths;
    private CosListInt mSharedObjsNumMap;
    private CosList mSharedPageObjArrays;
    private int[] mPageNumPrivateObjs;
    private int[] mPagePrivateLen;
    private int[] mPageNumSharedObjs;
    private int mNumThumbPages;
    private CosObject[] mThumbPageObject;
    private int[] mThumbNumNoThumbs;
    private int[] mThumbNumObjects;
    private int[] mThumbTotalLen;
    private int[] mEmbFileFirstObjNum;
    private int[] mEmbFileNumObjs;
    private int[] mEmbFileLen;
    private int mLinObjInfoSN;

    CosLinearization(CosDocument doc) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        this.mCosDoc = doc;
        this.mColArray.add(new LinObjCol(0));
        this.mColArray.add(new CosList());
        this.mColArray.add(new CosList());
        this.mColArray.add(new LinObjCol(3));
        this.mColArray.add(new LinObjCol(4));
        this.mColArray.add(new LinObjCol(5));
        this.mColArray.add(new LinObjCol(6));
        this.mColArray.add(new LinObjCol(7));
        this.mColArray.add(new LinObjCol(8));
        this.mColArray.add(new LinObjCol(9));
        this.mColArray.add(new LinObjCol(10));
        this.mColArray.add(new LinObjCol(11));
        this.mColArray.add(new LinObjCol(12));
        this.mColArray.add(new LinObjCol(13));
        this.mCatalog = this.mCosDoc.getRoot();
        CosDictionary mInfoDict = this.mCosDoc.getInfo();
        CosDictionary mPageTree = this.mCatalog.getCosDictionary(ASName.k_Pages);
        this.mUseBookmarks = CosLinearization.safeGetName(this.mCatalog, ASName.k_PageMode) == ASName.k_UseOutlines;
        this.mStreamsEnable = true;
        this.processLinObjs();
        CosDictionary resObj = this.mCosDoc.createDirectCosDictionary();
        CosArray mbObj = this.mCosDoc.createCosArray();
        mbObj.addInt(0);
        mbObj.addInt(0);
        mbObj.addInt(612);
        mbObj.addInt(792);
        CosArray cbObj = mbObj;
        CosNumeric rotObj = this.mCosDoc.createCosNumeric(0);
        this.mCurPageNum = 0;
        this.processPageTreeNode(mPageTree, resObj, mbObj, cbObj, rotObj);
        this.mNumPages = this.mCurPageNum;
        this.mCurPageNum = -1;
        ++this.mCurEnumTag;
        this.processObj(CosLinearization.safeGetDict(this.mCatalog, ASName.k_AcroForm), 4, 3, false, false);
        ++this.mCurEnumTag;
        this.mStreamsEnable = false;
        this.processObj(CosLinearization.safeGetDict(this.mCatalog, ASName.k_StructTreeRoot), 5, 2, false, false);
        this.mStreamsEnable = true;
        CosDictionary namesObj = CosLinearization.safeGetDict(this.mCatalog, ASName.k_Names);
        if (namesObj != null) {
            ++this.mCurEnumTag;
            this.processObj(CosLinearization.safeGetDict(namesObj, ASName.k_Renditions), 6, 2, false, false);
            ++this.mCurEnumTag;
            this.processObj(CosLinearization.safeGetDict(namesObj, ASName.k_MediaClips), 7, 2, false, false);
        }
        if (!this.mUseBookmarks) {
            CosDictionary outlinesObj = CosLinearization.safeGetDict(this.mCatalog, ASName.k_Outlines);
            this.processObj(outlinesObj, 8, 2, false, false);
        }
        CosDictionary destsObj = null;
        if (namesObj != null) {
            destsObj = CosLinearization.safeGetDict(namesObj, ASName.k_Dests);
        }
        if (destsObj == null) {
            destsObj = CosLinearization.safeGetDict(this.mCatalog, ASName.k_Dests);
        }
        ++this.mCurEnumTag;
        this.processObj(destsObj, 10, 2, false, false);
        ++this.mCurEnumTag;
        this.processObj(namesObj, 13, 3, false, false);
        ++this.mCurEnumTag;
        this.processObj(mInfoDict, 11, 2, false, false);
        ++this.mCurEnumTag;
        this.processObj(CosLinearization.safeGetDict(this.mCatalog, ASName.k_PageLabels), 12, 2, false, false);
        ++this.mCurEnumTag;
        this.mPageObjEnable = true;
        this.mStreamsEnable = true;
        this.processCatalog(13);
        this.mPageObjEnable = false;
        this.mStreamsEnable = false;
    }

    private void processLinObjs() throws PDFCosParseException, PDFIOException, PDFSecurityException {
        ++this.mCurEnumTag;
        this.processCatalog(0);
        CosObject other = this.mCatalog.get(ASName.k_PageMode);
        this.processObj(other, 0, 2, false, false);
        other = this.mCatalog.get(ASName.k_OpenAction);
        this.processObj(other, 0, 2, false, false);
        other = this.mCatalog.get(ASName.k_AcroForm);
        this.processObj(other, 0, 0, false, false);
        other = this.mCatalog.get(ASName.k_Names);
        this.processObj(other, 0, 0, false, false);
        other = this.mCatalog.get(ASName.k_Threads);
        this.processObj(other, 0, 1, false, false);
        other = this.mCatalog.get(ASName.k_OCProperties);
        this.processObj(other, 0, 2, false, false);
        if (this.mUseBookmarks) {
            CosDictionary outlinesObj = CosLinearization.safeGetDict(this.mCatalog, ASName.k_Outlines);
            this.processObj(outlinesObj, 0, 2, false, false);
        }
    }

    private void processPageTreeNode(CosDictionary node, CosDictionary res, CosArray mb, CosArray cb, CosNumeric rot) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        ++this.mCurEnumTag;
        if (node.containsKey(ASName.k_Kids)) {
            CosNumeric number;
            CosArray array;
            CosDictionary dict = CosLinearization.safeGetDict(node, ASName.k_Resources);
            if (dict != null) {
                res = dict;
                node.remove(ASName.k_Resources);
            }
            if ((array = CosLinearization.safeGetArray(node, ASName.k_MediaBox)) != null) {
                mb = array;
                cb = array;
                node.remove(ASName.k_MediaBox);
            }
            if ((array = CosLinearization.safeGetArray(node, ASName.k_CropBox)) != null) {
                cb = array;
                node.remove(ASName.k_CropBox);
            }
            if ((number = CosLinearization.safeGetNumeric(node, ASName.k_Rotate)) != null) {
                rot = number;
                node.remove(ASName.k_Rotate);
            }
            this.processObj(node, 13, 1, false, false);
            CosArray kidsArray = node.getCosArray(ASName.k_Kids);
            Iterator<CosObject> iter = kidsArray.iterator();
            while (iter.hasNext()) {
                CosDictionary kid = (CosDictionary)iter.next();
                this.processPageTreeNode(kid, res, mb, cb, rot);
            }
        } else {
            if (!node.containsKey(ASName.k_Resources)) {
                node.put(ASName.k_Resources, res);
            }
            if (node.containsKey(ASName.k_MediaBox)) {
                cb = CosLinearization.safeGetArray(node, ASName.k_MediaBox);
            } else {
                node.put(ASName.k_MediaBox, mb);
            }
            if (!node.containsKey(ASName.k_CropBox)) {
                node.put(ASName.k_CropBox, cb);
            }
            if (!node.containsKey(ASName.k_Rotate)) {
                node.put(ASName.k_Rotate, rot);
            }
            this.processPageObj(node);
        }
    }

    private void processPageObj(CosDictionary pageObj) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        if (this.mCurPageNum == 0 && this.mSpecialPageObj == null) {
            this.mSpecialPageObj = pageObj;
        }
        if (pageObj == this.mSpecialPageObj) {
            this.mSpecialPageNum = this.mCurPageNum;
        }
        this.mCurPageCol = new LinObjCol(1);
        ((CosList)this.mColArray.get(1)).add(this.mCurPageCol);
        boolean forceShared = this.mSpecialPageNum == this.mCurPageNum;
        this.processObj(pageObj, 1, 0, forceShared, false);
        CosArray pageAnnots = CosLinearization.safeGetArray(pageObj, ASName.k_Annots);
        this.processObj(pageAnnots, 1, 1, forceShared, false);
        CosArray pageBeads = CosLinearization.safeGetArray(pageObj, ASName.k_B);
        this.processObj(pageBeads, 1, 1, forceShared, false);
        CosDictionary pageResObj = CosLinearization.safeGetDict(pageObj, ASName.k_Resources);
        this.processPageRes(pageResObj);
        CosObject pageContObj = pageObj.get(ASName.k_Contents);
        this.mPageContents.add(pageContObj);
        this.processObj(pageContObj, 1, 2, forceShared, false);
        this.processObj(pageAnnots, 1, 4, forceShared, false);
        CosDictionary thumbObj = CosLinearization.safeGetDict(pageObj, ASName.k_Thumb);
        this.mPageThumbObjs.add(thumbObj);
        if (thumbObj != null) {
            CosArray thumbCS = CosLinearization.safeGetArray(thumbObj, ASName.k_ColorSpace);
            this.processObj(thumbCS, 3, 2, true, false);
            this.processObj(thumbObj, 3, 2, false, false);
        }
        this.processObj(pageObj, 13, 3, false, false);
        this.mCurPageCol = null;
        ++this.mCurPageNum;
    }

    private void processPageRes(CosDictionary pageResObj) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        CosDictionary pageXObjects;
        if (pageResObj == null) {
            return;
        }
        boolean forceShared = this.mSpecialPageNum == this.mCurPageNum;
        CosDictionary pageCSs = CosLinearization.safeGetDict(pageResObj, ASName.k_ColorSpace);
        this.processObj(pageCSs, 1, 2, forceShared, false);
        CosDictionary pageFonts = CosLinearization.safeGetDict(pageResObj, ASName.k_Font);
        if (pageFonts != null) {
            Iterator<ASName> iter = pageFonts.keyIterator();
            while (iter.hasNext()) {
                int flags;
                CosDictionary fontDesc;
                ASName baseFont;
                ASName key = iter.next();
                CosDictionary font = CosLinearization.safeGetDict(pageFonts, key);
                if (font == null || (baseFont = CosLinearization.safeGetName(font, ASName.k_BaseFont)) == ASName.k_Symbol || baseFont == ASName.k_ZapfDingbats || (fontDesc = CosLinearization.safeGetDict(font, ASName.k_FontDescriptor)) != null && ((flags = CosLinearization.safeGetInt(fontDesc, ASName.k_Flags)) & 0x20) == 0) continue;
                this.processObj(font, 1, 2, forceShared, true);
            }
        }
        if ((pageXObjects = CosLinearization.safeGetDict(pageResObj, ASName.k_XObject)) != null) {
            Iterator<ASName> iter = pageXObjects.keyIterator();
            while (iter.hasNext()) {
                ASName subType;
                ASName key = iter.next();
                CosDictionary xObject = CosLinearization.safeGetDict(pageXObjects, key);
                if (xObject == null || (subType = CosLinearization.safeGetName(xObject, ASName.k_Subtype)) != ASName.k_Image) continue;
                this.processObj(xObject, 1, 2, forceShared, true);
            }
        }
        this.processObj(pageResObj, 1, 2, forceShared, false);
    }

    private void processCatalog(int colType) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        this.mCatalogEnable = true;
        this.processObj(this.mCatalog, colType, 0, false, false);
        if (colType != 0) {
            Iterator<ASName> iter = this.mCatalog.keyIterator();
            while (iter.hasNext()) {
                ASName key = iter.next();
                CosObject value = this.mCatalog.get(key);
                if (key == ASName.k_Threads) {
                    this.processThreadsArray(value);
                    continue;
                }
                this.processObj(value, colType, 2, false, false);
            }
        }
        this.mCatalogEnable = false;
    }

    private void processThreadsArray(CosObject threadsArray) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        if (threadsArray instanceof CosArray) {
            Iterator<CosObject> arrayIter = ((CosArray)threadsArray).iterator();
            while (arrayIter.hasNext()) {
                CosObject threadDict = arrayIter.next();
                if (!(threadDict instanceof CosDictionary)) continue;
                CosDictionary firstBead = CosLinearization.safeGetDict((CosDictionary)threadDict, ASName.k_F);
                if (firstBead != null) {
                    this.addObjToCol(firstBead, 9, false, false);
                    CosDictionary nextBead = CosLinearization.safeGetDict(firstBead, ASName.k_N);
                    while (nextBead != firstBead && nextBead != null) {
                        if (!nextBead.containsKey(ASName.k_T)) {
                            nextBead.put(ASName.k_T, threadDict);
                        }
                        this.addObjToCol(nextBead, 9, false, false);
                        nextBead = CosLinearization.safeGetDict(nextBead, ASName.k_N);
                    }
                }
                CosDictionary threadInfo = CosLinearization.safeGetDict((CosDictionary)threadDict, ASName.k_I);
                this.processObj(threadInfo, 9, 2, false, false);
            }
        }
    }

    private void processObj(CosObject obj, int colType, int level, boolean forceShared, boolean defer) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        if (this.mStateStack == null) {
            this.mStateStack = new Object[65536];
        }
        CosContainer container = null;
        Iterator containerIter = null;
        while (true) {
            block20: {
                int objNum;
                block21: {
                    CosObject length;
                    block22: {
                        CosDictionary efDict;
                        if (obj == null || obj instanceof CosNull) break block20;
                        if (!(obj instanceof CosDictionary)) break block21;
                        if (obj instanceof CosStream && !this.mStreamsEnable) break block20;
                        CosObject cosType = ((CosDictionary)obj).get(ASName.k_Type);
                        if (!(cosType instanceof CosName)) break block22;
                        ASName type = cosType.nameValue();
                        if (type == ASName.k_Catalog && !this.mCatalogEnable || type == ASName.k_Page && !this.mPageObjEnable && level != 0) break block20;
                        if ((type == ASName.k_Filespec || type == ASName.k_F) && (efDict = CosLinearization.safeGetDict((CosDictionary)obj, ASName.k_EF)) != null) {
                            Object[] saveStack = this.mStateStack;
                            int saveStackPtr = this.mStateStackPtr;
                            this.mStateStack = null;
                            this.mStateStackPtr = 0;
                            this.processEmbFile(efDict);
                            this.mStateStack = saveStack;
                            this.mStateStackPtr = saveStackPtr;
                        }
                    }
                    if ((length = ((CosDictionary)obj).get(ASName.k_Length)) instanceof CosNumeric && length.isIndirect()) {
                        Number value = ((CosNumeric)length).numberValue();
                        length = this.mCosDoc.createCosNumeric(value);
                        ((CosDictionary)obj).put(ASName.k_Length, length);
                    }
                }
                if (((objNum = obj.getObjNum()) == 0 || level == 3 || level == 4 || this.addObjToCol(obj, colType, forceShared, defer) != null) && level != 0 && obj instanceof CosContainer) {
                    if (containerIter != null) {
                        this.mStateStack[this.mStateStackPtr++] = container;
                        this.mStateStack[this.mStateStackPtr++] = containerIter;
                        this.mStateStack[this.mStateStackPtr++] = level;
                    }
                    if ((container = (CosContainer)obj) instanceof CosArray) {
                        containerIter = ((CosArray)container).iterator();
                    } else {
                        List<ASName> keys = ((CosDictionary)container).getKeys();
                        containerIter = keys.iterator();
                    }
                    if (level == 1) {
                        level = 0;
                    } else if (level == 4) {
                        level = 3;
                    } else if (level == 3) {
                        level = 2;
                    }
                }
            }
            if (containerIter == null) {
                return;
            }
            while (!containerIter.hasNext()) {
                if (this.mStateStackPtr == 0) {
                    return;
                }
                level = (Integer)this.mStateStack[--this.mStateStackPtr];
                containerIter = (Iterator)this.mStateStack[--this.mStateStackPtr];
                container = (CosContainer)this.mStateStack[--this.mStateStackPtr];
            }
            if (container instanceof CosArray) {
                obj = (CosObject)containerIter.next();
                continue;
            }
            ASName key = (ASName)containerIter.next();
            obj = null;
            if (key == ASName.k_Parent || key == ASName.k_SE) continue;
            obj = ((CosDictionary)container).get(key);
        }
    }

    private void processEmbFile(CosDictionary efDict) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        this.mCurEmbFileCol = new LinObjCol(2);
        this.processObj(CosLinearization.safeGetDict(efDict, ASName.k_F), 2, 2, false, false);
        this.processObj(CosLinearization.safeGetDict(efDict, ASName.k_DOS), 2, 2, false, false);
        this.processObj(CosLinearization.safeGetDict(efDict, ASName.k_Mac), 2, 2, false, false);
        this.processObj(CosLinearization.safeGetDict(efDict, ASName.k_Unix), 2, 2, false, false);
        if (this.mCurEmbFileCol.curSize() != 0) {
            ((CosList)this.mColArray.get(2)).add(this.mCurEmbFileCol);
            ++this.mNumEmbFiles;
        }
        this.mCurEmbFileCol = null;
    }

    private LinObjInfo addObjToCol(CosObject obj, int colType, boolean forceShared, boolean defer) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        int objNum = obj.getObjNum();
        if (objNum == 0) {
            return null;
        }
        LinObjInfo info = (LinObjInfo)this.mMasterList.get(objNum);
        if (info != null && info.getEnumTag() == this.mCurEnumTag) {
            return null;
        }
        LinObjCol col = colType == 1 ? this.mCurPageCol : (colType == 2 ? this.mCurEmbFileCol : (LinObjCol)this.mColArray.get(colType));
        boolean canShare = col.canShare();
        boolean canCollect = false;
        if (info == null) {
            if (!canShare) {
                forceShared = false;
            }
            info = new LinObjInfo(colType, canShare, obj.getInfo());
            if (forceShared) {
                info.makeShared();
            } else {
                defer = false;
            }
            if (defer) {
                info.makeDeferred();
            }
            this.mMasterList.add(objNum, info);
            canCollect = true;
        } else if (canShare && info.canShare()) {
            if (colType == 3) {
                if (info.getType() == 3) {
                    canCollect = true;
                }
            } else {
                canCollect = true;
            }
            if (canCollect) {
                info.makeShared();
            }
        }
        if (canCollect && !col.hasInfo(objNum)) {
            col.putInfo(objNum, info);
        }
        info.setEnumTag(this.mCurEnumTag);
        return info;
    }

    private static final int safeGetInt(CosDictionary dict, ASName key) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        CosObject obj = dict.get(key);
        if (obj instanceof CosNumeric) {
            return obj.intValue();
        }
        return 0;
    }

    private static final ASName safeGetName(CosDictionary dict, ASName key) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        CosObject obj = dict.get(key);
        if (obj instanceof CosName) {
            return obj.nameValue();
        }
        return null;
    }

    private static final CosNumeric safeGetNumeric(CosDictionary dict, ASName key) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        CosObject obj = dict.get(key);
        if (obj instanceof CosNumeric) {
            return (CosNumeric)obj;
        }
        return null;
    }

    private static final CosDictionary safeGetDict(CosDictionary dict, ASName key) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        CosObject obj = dict.get(key);
        if (obj instanceof CosDictionary) {
            return (CosDictionary)obj;
        }
        return null;
    }

    private static final CosArray safeGetArray(CosDictionary dict, ASName key) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        CosObject obj = dict.get(key);
        if (obj instanceof CosArray) {
            return (CosArray)obj;
        }
        return null;
    }

    CosList getMainSectionList() {
        return this.extractObjInfos(this.mMainSection);
    }

    CosList getMainSectionCompressedList() {
        return this.extractObjInfos(this.mMainSectionCompressed);
    }

    CosList getUpdateSectionList() {
        return this.extractObjInfos(this.mUpdateSection);
    }

    CosList getUpdateSectionCompressedList() {
        return this.extractObjInfos(this.mUpdateSectionCompressed);
    }

    int getNumPages() {
        return this.mNumPages;
    }

    CosDictionary getSpecialPageObj() {
        return this.mSpecialPageObj;
    }

    void setNewToOldObjNumMap(CosListInt map) {
        this.mNewToOldObjNumMap = map;
    }

    void setNewToOldObjGenMap(CosListInt map) {
        this.mNewToOldObjGenMap = map;
    }

    void setOldToOldObjStmMap(CosList map) {
        this.mOldToOldObjStmMap = map;
    }

    CosList getOldToOldObjStmMap() {
        return this.mOldToOldObjStmMap;
    }

    void setOldToNewObjNumMap(CosListInt map) {
        this.mOldToNewObjNumMap = map;
    }

    void buildLinearizationData(int xrefStyle) throws PDFCosParseException, PDFIOException, PDFSecurityException, IOException {
        this.mXRefStyle = xrefStyle;
        this.extractAndSortCollectionArrays();
        this.extractSharedObjects();
        this.buildLinearSections();
        this.mColArray = null;
    }

    private void extractAndSortCollectionArrays() {
        this.mLinArray = ((LinObjCol)this.mColArray.get(0)).getObjList();
        this.mPageArrays = new CosList();
        CosList pageCols = (CosList)this.mColArray.get(1);
        for (int i = 0; i < this.mNumPages; ++i) {
            CosList pageArray = ((LinObjCol)pageCols.get(i)).getObjList();
            this.mPageArrays.add(pageArray);
        }
        this.mEmbFileArrays = new CosList();
        CosList embFileCols = (CosList)this.mColArray.get(2);
        for (int i = 0; i < this.mNumEmbFiles; ++i) {
            CosList embFileArray = ((LinObjCol)embFileCols.get(i)).getObjList();
            this.mEmbFileArrays.add(embFileArray);
        }
        this.mThumbArray = ((LinObjCol)this.mColArray.get(3)).getObjList();
        this.mAcroFormArray = ((LinObjCol)this.mColArray.get(4)).getObjList();
        this.mStructureArray = ((LinObjCol)this.mColArray.get(5)).getObjList();
        this.mRenditionArray = ((LinObjCol)this.mColArray.get(6)).getObjList();
        this.mMediaClipArray = ((LinObjCol)this.mColArray.get(7)).getObjList();
        this.mOutlineArray = ((LinObjCol)this.mColArray.get(8)).getObjList();
        this.mThreadArray = ((LinObjCol)this.mColArray.get(9)).getObjList();
        this.mDestArray = ((LinObjCol)this.mColArray.get(10)).getObjList();
        this.mInfoDictArray = ((LinObjCol)this.mColArray.get(11)).getObjList();
        this.mPageLabelArray = ((LinObjCol)this.mColArray.get(12)).getObjList();
        this.mOtherArray = ((LinObjCol)this.mColArray.get(13)).getObjList();
    }

    private void extractSharedObjects() {
        Iterator<Object> iter;
        this.mPageArraysSh = new CosList();
        for (int i = 0; i < this.mNumPages; ++i) {
            LinObjInfo info;
            CosList pageArray = (CosList)this.mPageArrays.get(i);
            CosList pageArraySh = new CosList();
            iter = pageArray.iterator();
            while (iter.hasNext()) {
                info = (LinObjInfo)iter.next();
                if (!info.isShared()) continue;
                iter.remove();
                pageArraySh.add(info);
            }
            this.mPageArraysSh.add(pageArraySh);
            if (i != this.mSpecialPageNum) continue;
            this.mSplPageDeferredArray = new CosList();
            iter = pageArraySh.iterator();
            while (iter.hasNext()) {
                info = (LinObjInfo)iter.next();
                if (!info.isDeferred()) continue;
                iter.remove();
                this.mSplPageDeferredArray.add(info);
            }
        }
        this.mThumbArraySh = new CosList();
        iter = this.mThumbArray.iterator();
        while (iter.hasNext()) {
            LinObjInfo info = (LinObjInfo)iter.next();
            if (!info.isShared()) continue;
            iter.remove();
            this.mThumbArraySh.add(info);
        }
        this.mAcroFormArraySh = new CosList();
        iter = this.mAcroFormArray.iterator();
        while (iter.hasNext()) {
            LinObjInfo info = (LinObjInfo)iter.next();
            if (!info.isShared()) continue;
            iter.remove();
            this.mAcroFormArraySh.add(info);
        }
        this.mStructureArraySh = new CosList();
        iter = this.mStructureArray.iterator();
        while (iter.hasNext()) {
            LinObjInfo info = (LinObjInfo)iter.next();
            if (!info.isShared()) continue;
            iter.remove();
            this.mStructureArraySh.add(info);
        }
        this.mRenditionArraySh = new CosList();
        iter = this.mRenditionArray.iterator();
        while (iter.hasNext()) {
            LinObjInfo info = (LinObjInfo)iter.next();
            if (!info.isShared()) continue;
            iter.remove();
            this.mRenditionArraySh.add(info);
        }
        this.mMediaClipArraySh = new CosList();
        iter = this.mMediaClipArray.iterator();
        while (iter.hasNext()) {
            LinObjInfo info = (LinObjInfo)iter.next();
            if (!info.isShared()) continue;
            iter.remove();
            this.mMediaClipArraySh.add(info);
        }
    }

    private void buildLinearSections() throws PDFCosParseException, PDFIOException, PDFSecurityException, IOException {
        LinObjInfo info;
        this.mUpdateSection = new CosList();
        this.mUpdateSectionCompressed = new CosList();
        this.addToSection(this.mLinArray, 0, true);
        this.addToSection((CosList)this.mPageArrays.get(this.mSpecialPageNum), 1, true);
        this.addToSection((CosList)this.mPageArraysSh.get(this.mSpecialPageNum), 1, true);
        this.addToSection(this.mSplPageDeferredArray, 1, true);
        CosList mainShared = new CosList();
        CosList updateShared = new CosList();
        this.mSharedPageObjArrays = new CosList();
        CosList sharedSplPageObjs = new CosList();
        Iterator<Object> iter = ((CosList)this.mPageArraysSh.get(this.mSpecialPageNum)).iterator();
        while (iter.hasNext()) {
            info = (LinObjInfo)iter.next();
            updateShared.add(info.getSN(), info);
            sharedSplPageObjs.add(info.getSN(), info);
        }
        iter = this.mSplPageDeferredArray.iterator();
        while (iter.hasNext()) {
            info = (LinObjInfo)iter.next();
            updateShared.add(info.getSN(), info);
            sharedSplPageObjs.add(info.getSN(), info);
        }
        int curPage = 0;
        Iterator<Object> pageIter = this.mPageArraysSh.iterator();
        while (pageIter.hasNext()) {
            CosList pageArraySh = (CosList)pageIter.next();
            if (curPage++ == this.mSpecialPageNum) {
                this.mSharedPageObjArrays.add(sharedSplPageObjs);
                continue;
            }
            CosList sharedCurPageObjs = new CosList();
            iter = pageArraySh.iterator();
            while (iter.hasNext()) {
                LinObjInfo info2 = (LinObjInfo)iter.next();
                if (updateShared.get(info2.getSN()) == null) {
                    mainShared.add(info2.getSN(), info2);
                }
                sharedCurPageObjs.add(info2.getSN(), info2);
            }
            this.mSharedPageObjArrays.add(sharedCurPageObjs);
        }
        iter = this.mAcroFormArraySh.iterator();
        while (iter.hasNext()) {
            info = (LinObjInfo)iter.next();
            if (updateShared.get(info.getSN()) != null) continue;
            mainShared.add(info.getSN(), info);
        }
        iter = this.mStructureArraySh.iterator();
        while (iter.hasNext()) {
            info = (LinObjInfo)iter.next();
            if (updateShared.get(info.getSN()) != null) continue;
            mainShared.add(info.getSN(), info);
        }
        iter = this.mRenditionArraySh.iterator();
        while (iter.hasNext()) {
            info = (LinObjInfo)iter.next();
            if (updateShared.get(info.getSN()) != null) continue;
            mainShared.add(info.getSN(), info);
        }
        iter = this.mMediaClipArraySh.iterator();
        while (iter.hasNext()) {
            info = (LinObjInfo)iter.next();
            if (updateShared.get(info.getSN()) != null) continue;
            mainShared.add(info.getSN(), info);
        }
        this.mSharedObjects = mainShared;
        this.mMainSection = new CosList();
        this.mMainSectionCompressed = new CosList();
        curPage = 0;
        pageIter = this.mPageArrays.iterator();
        while (pageIter.hasNext()) {
            CosList pageArray = (CosList)pageIter.next();
            if (curPage++ == this.mSpecialPageNum) continue;
            this.addToSection(pageArray, 1, false);
        }
        this.addToSection(this.mSharedObjects, 13, false);
        this.addToSection(this.mThumbArray, 3, false);
        this.addToSection(this.mThumbArraySh, 3, false);
        this.addToSection(this.mOutlineArray, 8, false);
        this.addToSection(this.mThreadArray, 9, false);
        this.addToSection(this.mDestArray, 10, false);
        this.addToSection(this.mInfoDictArray, 11, false);
        this.addToSection(this.mPageLabelArray, 12, false);
        this.addToSection(this.mAcroFormArray, 4, false);
        this.addToSection(this.mStructureArray, 5, false);
        this.addToSection(this.mRenditionArray, 6, false);
        this.addToSection(this.mMediaClipArray, 7, false);
        Iterator<Object> embFileIter = this.mEmbFileArrays.iterator();
        while (embFileIter.hasNext()) {
            this.addToSection((CosList)embFileIter.next(), 2, false);
        }
        this.addToSection(this.mOtherArray, 13, false);
    }

    private void addToSection(CosList src, int colType, boolean toUpdateSection) throws PDFCosParseException, IOException, PDFSecurityException, PDFIOException {
        CosList destSectionCompressed;
        CosList destSection = toUpdateSection ? this.mUpdateSection : this.mMainSection;
        CosList cosList = destSectionCompressed = toUpdateSection ? this.mUpdateSectionCompressed : this.mMainSectionCompressed;
        if (this.mXRefStyle == 1) {
            this.addAllInfos(destSection, src);
        } else if (this.mXRefStyle == 2) {
            if (colType == 0) {
                this.addAllInfos(destSection, src);
            } else {
                CosList compSrc = new CosList();
                Iterator<Object> iter = src.iterator();
                while (iter.hasNext()) {
                    LinObjInfo linInfo = (LinObjInfo)iter.next();
                    CosObject cosObj = linInfo.getObjInfo().getObject();
                    if (cosObj instanceof CosStream) {
                        destSection.add(linInfo);
                        continue;
                    }
                    if (cosObj instanceof CosDictionary) {
                        ASName type = CosLinearization.safeGetName((CosDictionary)cosObj, ASName.k_Type);
                        if (colType == 1 && type == ASName.k_Page) {
                            destSection.add(linInfo);
                            continue;
                        }
                        if ((colType == 1 || colType == 13) && CosDocument.dictionariesNotToBeCompressed.contains(type)) {
                            destSection.add(linInfo);
                            continue;
                        }
                    }
                    compSrc.add(linInfo);
                }
                this.addAllInfos(destSectionCompressed, compSrc);
                this.buildObjStms(destSection, compSrc, colType);
            }
        } else if (this.mXRefStyle == 3) {
            if (colType == 5) {
                this.addAllInfos(destSectionCompressed, src);
                this.buildObjStms(destSection, src, colType);
            } else {
                this.addAllInfos(destSection, src);
            }
        }
    }

    private CosList extractObjInfos(CosList linInfoList) {
        CosList objInfoList = new CosList();
        if (linInfoList == this.mMainSection || linInfoList == this.mUpdateSection) {
            objInfoList.add(new CosObjectInfo());
        }
        Iterator<Object> iter = linInfoList.iterator();
        while (iter.hasNext()) {
            LinObjInfo linInfo = (LinObjInfo)iter.next();
            objInfoList.add(linInfo.getObjInfo());
        }
        return objInfoList;
    }

    private void buildObjStms(CosList dest, CosList src, int colType) throws PDFCosParseException, PDFIOException, PDFSecurityException, IOException {
        if (src.count() == 0) {
            return;
        }
        Iterator<Object> objIter = src.iterator();
        while (objIter.hasNext()) {
            int count = 0;
            CosObjectStream objStm = this.mCosDoc.createCosObjectStream();
            while (objIter.hasNext()) {
                LinObjInfo objLinInfo = (LinObjInfo)objIter.next();
                CosObject obj = objLinInfo.getObjInfo().getObject();
                objStm.addObjectToStream(obj);
                if (++count != 100) continue;
                break;
            }
            LinObjInfo objStmLinInfo = new LinObjInfo(colType, false, objStm.getInfo());
            dest.add(objStmLinInfo);
        }
    }

    void buildHintStream(CosList objectInfos, CosStream hintStm, int mainLastObjNum, int updateLastObjNum, long hintStmPos, long objEndPos) throws PDFCosParseException, PDFIOException, PDFSecurityException, IOException {
        this.mObjectInfos = objectInfos;
        this.mHintStm = hintStm;
        this.mMainLastObjNum = mainLastObjNum;
        this.mUpdateLastObjNum = updateLastObjNum;
        this.mHintStmPos = hintStmPos;
        this.mObjEndPos = objEndPos;
        this.mHintOutputStream = hintStm.getStreamManager().getOutputByteStreamClearDocument(ByteWriterFactory.Fixed.GROWABLE, -1L);
        this.convertLinInfos();
        CosList mSharedObjsArray = new CosList();
        this.addAllInfos(mSharedObjsArray, (CosList)this.mPageArraysSh.get(this.mSpecialPageNum));
        this.addAllInfos(mSharedObjsArray, this.mSplPageDeferredArray);
        this.mNumSplPageSharedObjs = mSharedObjsArray.count();
        this.addAllInfos(mSharedObjsArray, this.mSharedObjects);
        this.mNumSharedObjs = mSharedObjsArray.count();
        this.mSharedObjLengths = new int[this.mNumSharedObjs];
        int shObjNum = 0;
        this.mSharedObjsNumMap = new CosListInt();
        Iterator<Object> iter = mSharedObjsArray.iterator();
        while (iter.hasNext()) {
            CosObjectInfo info = (CosObjectInfo)iter.next();
            int objNum = info.getObjNum();
            this.mSharedObjLengths[shObjNum] = (int)(this.getNextObjPos(objNum) - this.getObjPos(objNum));
            this.mSharedObjsNumMap.add(objNum, shObjNum++);
        }
        this.mPageNumPrivateObjs = new int[this.mNumPages];
        this.mPagePrivateLen = new int[this.mNumPages];
        this.mPageNumSharedObjs = new int[this.mNumPages];
        for (int pgNum = 0; pgNum < this.mNumPages; ++pgNum) {
            CosList pgPrivObjsArray = (CosList)this.mPageArrays.get(pgNum);
            this.mPageNumPrivateObjs[pgNum] = pgPrivObjsArray.count();
            if (pgNum == this.mSpecialPageNum) {
                int n = pgNum;
                this.mPageNumPrivateObjs[n] = this.mPageNumPrivateObjs[n] + ((CosList)this.mPageArraysSh.get(pgNum)).count();
                int n2 = pgNum;
                this.mPageNumPrivateObjs[n2] = this.mPageNumPrivateObjs[n2] + this.mSplPageDeferredArray.count();
                int firstObjN = this.mSpecialPageObj.getObjNum();
                this.mPagePrivateLen[pgNum] = (int)(this.getObjPos(1) - this.getObjPos(firstObjN));
            } else if (this.mPageNumPrivateObjs[pgNum] != 0) {
                CosObjectInfo info = (CosObjectInfo)pgPrivObjsArray.first();
                int firstObjN = info.getObjNum();
                int lastObjN = firstObjN + this.mPageNumPrivateObjs[pgNum] - 1;
                this.mPagePrivateLen[pgNum] = (int)(this.getNextObjPos(lastObjN) - this.getObjPos(firstObjN));
            }
            CosList pgShObjsArray = (CosList)this.mSharedPageObjArrays.get(pgNum);
            this.mPageNumSharedObjs[pgNum] = pgShObjsArray.count();
        }
        this.generatePageHints();
        this.generateSharedObjHints();
        this.mNumThumbPages = 0;
        iter = this.mPageThumbObjs.iterator();
        while (iter.hasNext()) {
            if (iter.next() == null) continue;
            ++this.mNumThumbPages;
        }
        if (this.mNumThumbPages != 0 && !this.mThumbArray.isEmpty()) {
            long nextPos;
            this.mThumbPageObject = new CosObject[this.mNumThumbPages];
            this.mThumbNumNoThumbs = new int[this.mNumThumbPages];
            this.mThumbNumObjects = new int[this.mNumThumbPages];
            this.mThumbTotalLen = new int[this.mNumThumbPages];
            int objCtr = 0;
            int thumbCtr = 0;
            iter = this.mPageThumbObjs.iterator();
            while (iter.hasNext()) {
                CosObject thumbObj = (CosObject)iter.next();
                if (thumbObj != null) {
                    this.mThumbPageObject[thumbCtr] = thumbObj;
                    this.mThumbNumNoThumbs[thumbCtr++] = objCtr;
                    objCtr = 0;
                    continue;
                }
                ++objCtr;
            }
            objCtr = 0;
            thumbCtr = 0;
            iter = this.mThumbArray.iterator();
            while (iter.hasNext() && thumbCtr < this.mNumThumbPages) {
                CosObjectInfo info = (CosObjectInfo)iter.next();
                int thisObjNum = info.getObjNum();
                if (thisObjNum == this.mThumbPageObject[thumbCtr].getObjNum()) {
                    this.mThumbNumObjects[thumbCtr++] = objCtr;
                }
                ++objCtr;
            }
            long thisPos = this.getObjPos(this.mThumbPageObject[0].getObjNum());
            for (thumbCtr = 0; thumbCtr < this.mNumThumbPages - 1; ++thumbCtr) {
                this.mThumbNumObjects[thumbCtr] = this.mThumbNumObjects[thumbCtr + 1] - this.mThumbNumObjects[thumbCtr];
                nextPos = this.getObjPos(this.mThumbPageObject[thumbCtr + 1].getObjNum());
                this.mThumbTotalLen[thumbCtr] = (int)(nextPos - thisPos);
                thisPos = nextPos;
            }
            this.mThumbNumObjects[thumbCtr] = this.mThumbArray.count() - this.mThumbNumObjects[thumbCtr];
            CosObjectInfo info = (CosObjectInfo)this.mThumbArray.last();
            nextPos = this.getNextObjPos(info.getObjNum());
            this.mThumbTotalLen[thumbCtr] = (int)(nextPos - thisPos);
            this.generateThumbHints();
        }
        this.generateSimpleGenericHints(ASName.k_O, this.mOutlineArray);
        this.generateSimpleGenericHints(ASName.k_A, this.mThreadArray);
        this.generateExtendedGenericHints(ASName.k_V, this.mAcroFormArray, this.mAcroFormArraySh);
        this.generateSimpleGenericHints(ASName.k_E, this.mDestArray);
        this.generateSimpleGenericHints(ASName.k_L, this.mPageLabelArray);
        this.generateExtendedGenericHints(ASName.k_C, this.mStructureArray, this.mStructureArraySh);
        this.generateExtendedGenericHints(ASName.k_R, this.mRenditionArray, this.mRenditionArraySh);
        this.generateExtendedGenericHints(ASName.k_M, this.mMediaClipArray, this.mMediaClipArraySh);
        if (this.mNumEmbFiles != 0) {
            this.mEmbFileFirstObjNum = new int[this.mNumEmbFiles];
            this.mEmbFileNumObjs = new int[this.mNumEmbFiles];
            this.mEmbFileLen = new int[this.mNumEmbFiles];
            for (int embFileNum = 0; embFileNum < this.mNumEmbFiles; ++embFileNum) {
                int numEmbFileObjs;
                int firstObjNum;
                CosList embFileObjInfos = (CosList)this.mEmbFileArrays.get(embFileNum);
                CosObjectInfo info = (CosObjectInfo)embFileObjInfos.first();
                this.mEmbFileFirstObjNum[embFileNum] = firstObjNum = info.getObjNum();
                this.mEmbFileNumObjs[embFileNum] = numEmbFileObjs = embFileObjInfos.count();
                info = (CosObjectInfo)embFileObjInfos.last();
                int lastObjNum = info.getObjNum();
                this.mEmbFileLen[embFileNum] = (int)(this.getNextObjPos(lastObjNum) - this.getObjPos(firstObjNum));
            }
            this.generateEmbFileHints();
        }
        this.generateSimpleGenericHints(ASName.k_I, this.mInfoDictArray);
        hintStm.put(ASName.k_Filter, ASName.k_FlateDecode);
        hintStm.newDataDecoded(this.mHintOutputStream.closeAndConvert());
        this.mHintOutputStream = null;
    }

    private void generatePageHints() throws PDFCosParseException, PDFIOException, PDFSecurityException, IOException {
        int count;
        int minObjsPP = this.getMinIntVal(this.mPageNumPrivateObjs, this.mNumPages);
        this.putInt(minObjsPP);
        this.putInt((int)this.getObjPos(this.mSpecialPageObj.getObjNum()));
        int maxObjsPP = this.getMaxIntVal(this.mPageNumPrivateObjs, this.mNumPages);
        int fsObjsPP = this.getFieldSize(maxObjsPP - minObjsPP);
        this.putShort(fsObjsPP);
        int minPrivLen = this.getMinIntVal(this.mPagePrivateLen, this.mNumPages);
        this.putInt(minPrivLen);
        int maxPrivLen = this.getMaxIntVal(this.mPagePrivateLen, this.mNumPages);
        int fsPrivLen = this.getFieldSize(maxPrivLen - minPrivLen);
        this.putShort(fsPrivLen);
        this.putInt(0);
        this.putShort(0);
        this.putInt(0);
        this.putShort(fsPrivLen);
        int maxShObjsPP = this.getMaxIntVal(this.mPageNumSharedObjs, this.mNumPages);
        int fsShObjsPP = this.getFieldSize(maxShObjsPP);
        this.putShort(fsShObjsPP);
        int fsShObjNum = this.getFieldSize(this.mNumSharedObjs);
        this.putShort(fsShObjNum);
        this.putShort(4);
        this.putShort(8);
        this.putFields(this.mPageNumPrivateObjs, this.mNumPages, minObjsPP, fsObjsPP);
        this.putFields(this.mPagePrivateLen, this.mNumPages, minPrivLen, fsPrivLen);
        this.putFields(this.mPageNumSharedObjs, this.mNumPages, 0, fsShObjsPP);
        int totalShObjRefs = 0;
        for (count = 0; count < this.mNumPages; ++count) {
            totalShObjRefs += this.mPageNumSharedObjs[count];
        }
        int[] shObjRefs = new int[totalShObjRefs];
        int[] shObjDivs = new int[totalShObjRefs];
        count = 0;
        Iterator<Object> iter = this.mSharedPageObjArrays.iterator();
        while (iter.hasNext()) {
            CosList pgShObjsArray = (CosList)iter.next();
            Iterator<Object> subIter = pgShObjsArray.iterator();
            while (subIter.hasNext()) {
                CosObjectInfo info = (CosObjectInfo)subIter.next();
                shObjRefs[count] = this.mSharedObjsNumMap.get(info.getObjNum());
                int divValue = 0;
                shObjDivs[count++] = divValue;
            }
        }
        this.putFields(shObjRefs, totalShObjRefs, 0, fsShObjNum);
        this.putFields(shObjDivs, totalShObjRefs, 0, 4);
        this.putFields(this.mPagePrivateLen, this.mNumPages, minPrivLen, fsPrivLen);
    }

    private void generateSharedObjHints() throws PDFCosParseException, PDFIOException, PDFSecurityException, IOException {
        if (this.mNumSharedObjs == 0) {
            return;
        }
        int pos = (int)this.mHintOutputStream.getPosition();
        this.mHintStm.put(ASName.k_S, pos);
        int firstShObjNum = 0;
        int firstShobjPos = 0;
        if (this.mSharedObjects.count() != 0) {
            firstShObjNum = ((CosObjectInfo)this.mSharedObjects.first()).getObjNum();
            firstShobjPos = (int)this.getObjPos(firstShObjNum);
        }
        this.putInt(firstShObjNum);
        this.putInt(firstShobjPos);
        this.putInt(this.mNumSplPageSharedObjs);
        this.putInt(this.mNumSharedObjs);
        this.putShort(0);
        int minShObjLen = this.getMinIntVal(this.mSharedObjLengths, this.mNumSharedObjs);
        this.putInt(minShObjLen);
        int maxShObjLen = this.getMaxIntVal(this.mSharedObjLengths, this.mNumSharedObjs);
        int fsShObjLen = this.getFieldSize(maxShObjLen - minShObjLen);
        this.putShort(fsShObjLen);
        this.putFields(this.mSharedObjLengths, this.mNumSharedObjs, minShObjLen, fsShObjLen);
        int[] shObjSigs = new int[this.mNumSharedObjs];
        this.putFields(shObjSigs, this.mNumSharedObjs, 0, 1);
    }

    private void generateThumbHints() throws PDFCosParseException, PDFIOException, PDFSecurityException, IOException {
        if (this.mNumThumbPages == 0) {
            return;
        }
        int pos = (int)this.mHintOutputStream.getPosition();
        this.mHintStm.put(ASName.k_T, pos);
        int firstThumbObjNum = ((CosObjectInfo)this.mThumbArray.first()).getObjNum();
        this.putInt(firstThumbObjNum);
        this.putInt((int)this.getObjPos(firstThumbObjNum));
        this.putInt(this.mNumThumbPages);
        int maxNumPagesNoThumbs = this.getMaxIntVal(this.mThumbNumNoThumbs, this.mNumThumbPages);
        int fsNumPagesNoThumbs = this.getFieldSize(maxNumPagesNoThumbs);
        this.putShort(fsNumPagesNoThumbs);
        int minThumbLen = this.getMinIntVal(this.mThumbTotalLen, this.mNumThumbPages);
        this.putInt(minThumbLen);
        int maxThumbLen = this.getMaxIntVal(this.mThumbTotalLen, this.mNumThumbPages);
        int fsThumbLen = this.getFieldSize(maxThumbLen - minThumbLen);
        this.putShort(fsThumbLen);
        int minNumObjsInThumb = this.getMinIntVal(this.mThumbNumObjects, this.mNumThumbPages);
        this.putInt(minNumObjsInThumb);
        int maxNumObjsInThumb = this.getMaxIntVal(this.mThumbNumObjects, this.mNumThumbPages);
        int fsNumObjsInThumb = this.getFieldSize(maxNumObjsInThumb - minNumObjsInThumb);
        this.putShort(fsNumObjsInThumb);
        int numSharedThumbObjs = this.mThumbArraySh.count();
        int numFirstSharedThumbObj = 0;
        int posFirstSharedThumbObj = 0;
        int lenSharedThumbObjs = 0;
        if (numSharedThumbObjs != 0) {
            numFirstSharedThumbObj = ((CosObjectInfo)this.mThumbArraySh.first()).getObjNum();
            int numLastSharedThumbObj = ((CosObjectInfo)this.mThumbArraySh.last()).getObjNum();
            posFirstSharedThumbObj = (int)this.getObjPos(numFirstSharedThumbObj);
            lenSharedThumbObjs = (int)(this.getNextObjPos(numLastSharedThumbObj) - this.getObjPos(numFirstSharedThumbObj));
        }
        this.putInt(numFirstSharedThumbObj);
        this.putInt(posFirstSharedThumbObj);
        this.putInt(numSharedThumbObjs);
        this.putInt(lenSharedThumbObjs);
        this.putFields(this.mThumbNumNoThumbs, this.mNumThumbPages, 0, fsNumPagesNoThumbs);
        this.putFields(this.mThumbNumObjects, this.mNumThumbPages, minNumObjsInThumb, fsNumObjsInThumb);
        this.putFields(this.mThumbTotalLen, this.mNumThumbPages, minThumbLen, fsThumbLen);
    }

    private void generateEmbFileHints() throws PDFCosParseException, PDFIOException, PDFSecurityException, IOException {
        if (this.mNumEmbFiles == 0) {
            return;
        }
        int pos = (int)this.mHintOutputStream.getPosition();
        this.mHintStm.put(ASName.k_B, pos);
        this.putInt(this.mEmbFileFirstObjNum[0]);
        this.putInt((int)this.getObjPos(this.mEmbFileFirstObjNum[0]));
        this.putInt(this.mNumEmbFiles);
        int maxNumFirstObj = this.getMaxIntVal(this.mEmbFileFirstObjNum, this.mNumEmbFiles);
        int fsNumFirstObj = this.getFieldSize(maxNumFirstObj);
        this.putShort(fsNumFirstObj);
        int maxNumObjs = this.getMaxIntVal(this.mEmbFileNumObjs, this.mNumEmbFiles);
        int fsNumObjs = this.getFieldSize(maxNumObjs);
        this.putShort(fsNumObjs);
        int maxLen = this.getMaxIntVal(this.mEmbFileLen, this.mNumEmbFiles);
        int fsLen = this.getFieldSize(maxLen);
        this.putShort(fsLen);
        this.putShort(0);
        this.putFields(this.mEmbFileFirstObjNum, this.mNumEmbFiles, 0, fsNumFirstObj);
        this.putFields(this.mEmbFileNumObjs, this.mNumEmbFiles, 0, fsNumObjs);
        this.putFields(this.mEmbFileLen, this.mNumEmbFiles, 0, fsLen);
    }

    private void generateSimpleGenericHints(ASName key, CosList colObjInfos) throws PDFCosParseException, PDFIOException, PDFSecurityException, IOException {
        if (colObjInfos.isEmpty()) {
            return;
        }
        int pos = (int)this.mHintOutputStream.getPosition();
        this.mHintStm.put(key, pos);
        int firstObjNum = ((CosObjectInfo)colObjInfos.first()).getObjNum();
        this.putInt(firstObjNum);
        long firstObjPos = this.getObjPos(firstObjNum);
        this.putInt((int)firstObjPos);
        int objCount = colObjInfos.count();
        this.putInt(objCount);
        int lastObjNum = ((CosObjectInfo)colObjInfos.last()).getObjNum();
        long lastObjNextPos = this.getNextObjPos(lastObjNum);
        this.putInt((int)(lastObjNextPos - firstObjPos));
    }

    private void generateExtendedGenericHints(ASName key, CosList colObjInfos, CosList colObjInfosShared) throws PDFCosParseException, PDFIOException, PDFSecurityException, IOException {
        if (colObjInfos.isEmpty()) {
            return;
        }
        this.generateSimpleGenericHints(key, colObjInfos);
        int numShObjs = colObjInfosShared.count();
        this.putInt(numShObjs);
        int fsShObjs = this.getFieldSize(this.mNumSharedObjs);
        this.putShort(fsShObjs);
        int[] shObjRefs = new int[numShObjs];
        int count = 0;
        Iterator<Object> iter = colObjInfosShared.iterator();
        while (iter.hasNext()) {
            CosObjectInfo info = (CosObjectInfo)iter.next();
            shObjRefs[count++] = this.mSharedObjsNumMap.get(info.getObjNum());
        }
        this.putFields(shObjRefs, numShObjs, 0, fsShObjs);
    }

    private void convertLinInfos() {
        this.mLinArray = this.convertOneArray(this.mLinArray);
        CosList newArray = new CosList();
        Iterator<Object> iter = this.mPageArrays.iterator();
        while (iter.hasNext()) {
            newArray.add(this.convertOneArray((CosList)iter.next()));
        }
        this.mPageArrays = newArray;
        newArray = new CosList();
        iter = this.mPageArraysSh.iterator();
        while (iter.hasNext()) {
            newArray.add(this.convertOneArray((CosList)iter.next()));
        }
        this.mPageArraysSh = newArray;
        this.mSplPageDeferredArray = this.convertOneArray(this.mSplPageDeferredArray);
        newArray = new CosList();
        iter = this.mEmbFileArrays.iterator();
        while (iter.hasNext()) {
            newArray.add(this.convertOneArray((CosList)iter.next()));
        }
        this.mEmbFileArrays = newArray;
        this.mThumbArray = this.convertOneArray(this.mThumbArray);
        this.mThumbArraySh = this.convertOneArray(this.mThumbArraySh);
        this.mAcroFormArray = this.convertOneArray(this.mAcroFormArray);
        this.mAcroFormArraySh = this.convertOneArray(this.mAcroFormArraySh);
        this.mStructureArray = this.convertOneArray(this.mStructureArray);
        this.mStructureArraySh = this.convertOneArray(this.mStructureArraySh);
        this.mRenditionArray = this.convertOneArray(this.mRenditionArray);
        this.mRenditionArraySh = this.convertOneArray(this.mRenditionArraySh);
        this.mMediaClipArray = this.convertOneArray(this.mMediaClipArray);
        this.mMediaClipArraySh = this.convertOneArray(this.mMediaClipArraySh);
        this.mOutlineArray = this.convertOneArray(this.mOutlineArray);
        this.mThreadArray = this.convertOneArray(this.mThreadArray);
        this.mDestArray = this.convertOneArray(this.mDestArray);
        this.mInfoDictArray = this.convertOneArray(this.mInfoDictArray);
        this.mPageLabelArray = this.convertOneArray(this.mPageLabelArray);
        this.mOtherArray = this.convertOneArray(this.mOtherArray);
        this.mSharedObjects = this.convertOneArray(this.mSharedObjects);
        newArray = new CosList();
        iter = this.mSharedPageObjArrays.iterator();
        while (iter.hasNext()) {
            newArray.add(this.convertOneArray((CosList)iter.next()));
        }
        this.mSharedPageObjArrays = newArray;
    }

    private CosList convertOneArray(CosList array) {
        if (array.isEmpty()) {
            return array;
        }
        CosList newArray = new CosList();
        Iterator<Object> iter = array.iterator();
        while (iter.hasNext()) {
            LinObjInfo linInfo = (LinObjInfo)iter.next();
            CosObjectInfo objInfo = linInfo.getObjInfo();
            if (objInfo.isCompressed()) {
                objInfo = objInfo.getStreamInfo();
            }
            newArray.add(objInfo.getObjNum(), objInfo);
        }
        return newArray;
    }

    private final long getObjPos(int objNum) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        CosObjectInfo info = (CosObjectInfo)this.mObjectInfos.get(objNum);
        if (info.isCompressed()) {
            info = info.getStreamInfo();
        }
        return info.getPos() + this.mHintStmPos;
    }

    private final long getNextObjPos(int objNum) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        CosObjectInfo info = (CosObjectInfo)this.mObjectInfos.get(objNum);
        if (info.isCompressed()) {
            objNum = info.getStreamInfo().getObjNum();
        }
        if (objNum == this.mMainLastObjNum) {
            return this.mObjEndPos + this.mHintStmPos;
        }
        objNum = objNum == this.mUpdateLastObjNum ? 1 : ++objNum;
        return this.getObjPos(objNum);
    }

    private final int getMinIntVal(int[] values, int arrayLen) {
        if (arrayLen == 0) {
            return 0;
        }
        int minVal = Integer.MAX_VALUE;
        for (int i = 0; i < arrayLen; ++i) {
            if (values[i] >= minVal) continue;
            minVal = values[i];
        }
        return minVal;
    }

    private final int getMaxIntVal(int[] values, int arrayLen) {
        int maxVal = 0;
        for (int i = 0; i < arrayLen; ++i) {
            if (values[i] <= maxVal) continue;
            maxVal = values[i];
        }
        return maxVal;
    }

    private final int getFieldSize(int value) {
        int size = 32;
        for (int i = 0; i < 32; ++i) {
            if ((value & Integer.MIN_VALUE) != 0) {
                return size;
            }
            value <<= 1;
            --size;
        }
        return size;
    }

    private final void putInt(int value) throws PDFIOException, IOException {
        this.mHintOutputStream.write((byte)(value >> 24));
        this.mHintOutputStream.write((byte)(value >> 16));
        this.mHintOutputStream.write((byte)(value >> 8));
        this.mHintOutputStream.write((byte)value);
    }

    private final void putShort(int value) throws PDFIOException, IOException {
        this.mHintOutputStream.write((byte)(value >> 8));
        this.mHintOutputStream.write((byte)value);
    }

    private final void putFields(int[] values, int count, int minVal, int fieldSize) throws PDFIOException, IOException {
        int bitsFree = 8;
        int workByte = 0;
        for (int i = 0; i < count; ++i) {
            int bitsToDo = fieldSize;
            int curVal = values[i] - minVal;
            while (bitsToDo > 0) {
                if (bitsFree == 8) {
                    if (bitsToDo >= 8) {
                        this.mHintOutputStream.write((byte)(curVal >> (bitsToDo -= 8)));
                        continue;
                    }
                    workByte = (byte)(curVal << 8 - bitsToDo);
                    bitsFree -= bitsToDo;
                    bitsToDo = 0;
                    continue;
                }
                if (bitsFree > bitsToDo) {
                    workByte = (byte)(workByte | (byte)(curVal << bitsFree - bitsToDo & 255 >> 8 - bitsFree));
                    bitsFree -= bitsToDo;
                    bitsToDo = 0;
                    continue;
                }
                workByte = (byte)(workByte | (byte)(curVal >> bitsToDo - bitsFree & 255 >> 8 - bitsFree));
                this.mHintOutputStream.write(workByte);
                bitsToDo -= bitsFree;
                bitsFree = 8;
                workByte = 0;
            }
        }
        if (bitsFree < 8) {
            this.mHintOutputStream.write(workByte);
        }
    }

    private void addAllInfos(CosList dest, CosList src) {
        Iterator<Object> iter = src.iterator();
        while (iter.hasNext()) {
            dest.add(iter.next());
        }
    }

    int mapNewToOldObjNum(int objNum) {
        if (this.mNewToOldObjNumMap != null) {
            objNum = this.mNewToOldObjNumMap.get(objNum);
        }
        return objNum;
    }

    int mapNewToOldObjGen(int objNum) {
        int objGen = 0;
        if (this.mNewToOldObjGenMap != null) {
            objGen = this.mNewToOldObjGenMap.get(objNum);
        }
        return objGen;
    }

    int mapOldToNewObjNum(int objNum) {
        if (this.mOldToNewObjNumMap != null) {
            objNum = this.mOldToNewObjNumMap.get(objNum);
        }
        return objNum;
    }

    CosObject mapOldToOldObjStm(int objNum) {
        CosObject stmObj = null;
        if (this.mOldToOldObjStmMap != null) {
            stmObj = (CosObject)this.mOldToOldObjStmMap.get(objNum);
        }
        return stmObj;
    }

    final class LinObjInfo
    implements Comparable {
        private final int mFirstType;
        private final boolean mCanShare;
        private final CosObjectInfo mObjInfo;
        private final int mThisSN;
        private boolean mIsShared = false;
        private boolean mDefer = false;
        private int mEnumTag;
        private int mSharedObjNum;

        private LinObjInfo(int firstType, boolean canShare, CosObjectInfo info) throws PDFCosParseException, PDFIOException, PDFSecurityException {
            this.mFirstType = firstType;
            this.mCanShare = canShare;
            this.mObjInfo = info;
            this.mThisSN = ++CosLinearization.this.mLinObjInfoSN;
        }

        int getType() {
            return this.mFirstType;
        }

        boolean canShare() {
            return this.mCanShare;
        }

        CosObjectInfo getObjInfo() {
            return this.mObjInfo;
        }

        boolean isShared() {
            return this.mIsShared;
        }

        void makeShared() {
            if (this.mCanShare) {
                this.mIsShared = true;
            }
        }

        boolean isDeferred() {
            return this.mDefer;
        }

        void makeDeferred() {
            if (this.mIsShared) {
                this.mDefer = true;
            }
        }

        int getEnumTag() {
            return this.mEnumTag;
        }

        void setEnumTag(int enumTag) {
            this.mEnumTag = enumTag;
        }

        int getSN() {
            return this.mThisSN;
        }

        void setSharedObjNum(int sharedObjNum) {
            this.mSharedObjNum = sharedObjNum;
        }

        int getSharedObjNum() {
            return this.mSharedObjNum;
        }

        public int compareTo(Object obj) {
            return this.mThisSN - ((LinObjInfo)obj).getSN();
        }
    }

    private static final class LinObjCol {
        static final int COLTYPE_LINEARIZATION = 0;
        static final int COLTYPE_PAGE = 1;
        static final int COLTYPE_EMBFILE = 2;
        static final int COLTYPE_THUMB = 3;
        static final int COLTYPE_ACROFORM = 4;
        static final int COLTYPE_STRUCTURE = 5;
        static final int COLTYPE_RENDITION = 6;
        static final int COLTYPE_MEDIACLIP = 7;
        static final int COLTYPE_OUTLINE = 8;
        static final int COLTYPE_THREAD = 9;
        static final int COLTYPE_DEST = 10;
        static final int COLTYPE_INFODICT = 11;
        static final int COLTYPE_PAGELABEL = 12;
        static final int COLTYPE_OTHER = 13;
        final boolean[] colTypeCanShare = new boolean[]{false, true, false, true, true, true, true, true, false, false, false, false, false, false, false};
        private final int mColType;
        private CosList mColObjs;

        private LinObjCol(int colType) {
            this.mColType = colType;
            this.mColObjs = new CosList();
        }

        boolean canShare() {
            return this.colTypeCanShare[this.mColType];
        }

        boolean hasInfo(int n) {
            return this.mColObjs.get(n) != null;
        }

        void putInfo(int n, LinObjInfo info) {
            this.mColObjs.add(n, info);
        }

        int curSize() {
            return this.mColObjs.size();
        }

        CosList getObjList() {
            CosList retVal = new CosList();
            Iterator<Object> iter = this.mColObjs.iterator();
            while (iter.hasNext()) {
                LinObjInfo info = (LinObjInfo)iter.next();
                retVal.add(info.getSN(), info);
            }
            this.mColObjs = null;
            return retVal;
        }
    }
}

