/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.core.cos;

import com.adobe.internal.io.ByteWriterFactory;
import com.adobe.internal.io.stream.IO;
import com.adobe.internal.io.stream.InputByteStream;
import com.adobe.internal.io.stream.OutputByteStream;
import com.adobe.internal.io.stream.StreamManager;
import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosBoolean;
import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosDocument;
import com.adobe.internal.pdftoolkit.core.cos.CosName;
import com.adobe.internal.pdftoolkit.core.cos.CosNull;
import com.adobe.internal.pdftoolkit.core.cos.CosNumeric;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.cos.CosObjectRef;
import com.adobe.internal.pdftoolkit.core.cos.CosObjectRefAdapter;
import com.adobe.internal.pdftoolkit.core.cos.CosStream;
import com.adobe.internal.pdftoolkit.core.cos.CosString;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFCosParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class CosCloneMgr {
    private CosDocument mTarget;
    private HashMap<CosObjectRefAdapter, CosObjectRefAdapter> mClonedCosObjects;
    private HashSet<ASName> streamsToClone;

    public CosCloneMgr(CosDocument target) {
        this.mTarget = target;
        this.mClonedCosObjects = new HashMap();
        this.streamsToClone = new HashSet();
    }

    public CosCloneMgr(CosDocument target, HashSet<ASName> streamsToClone) {
        this(target);
        if (streamsToClone != null) {
            this.streamsToClone.addAll(streamsToClone);
        }
    }

    private CosObject cloneCosArray(CosArray cosObj) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        CosArray newCosArray = this.mTarget.createCosArray();
        if (cosObj.isIndirect()) {
            this.mClonedCosObjects.put(CosObjectRefAdapter.newInstance(cosObj), CosObjectRefAdapter.newInstance(newCosArray));
        }
        for (int i = 0; i < cosObj.size(); ++i) {
            newCosArray.add(this.clone(cosObj.get(i)));
        }
        return newCosArray;
    }

    private CosObject cloneCosDictionary(CosDictionary original, CosDictionary clone) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        if (original.isIndirect()) {
            this.mClonedCosObjects.put(CosObjectRefAdapter.newInstance(original), CosObjectRefAdapter.newInstance(clone));
        }
        Iterator<Map.Entry<ASName, CosObject>> iter = original.entrySet().iterator();
        CosDocument doc = original.getDocument();
        try {
            while (iter.hasNext()) {
                Map.Entry<ASName, CosObject> entry = iter.next();
                CosObject obj = entry.getValue();
                if (obj instanceof CosObjectRef) {
                    obj = doc.resolveReference((CosObjectRef)obj);
                }
                clone.put(entry.getKey(), this.clone(obj));
            }
        }
        catch (IOException e) {
            throw new PDFIOException(e);
        }
        return clone;
    }

    private CosObject cloneCosDictionary(CosDictionary cosObj) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        LinkedHashMap newMap = new LinkedHashMap(cosObj.size());
        CosDictionary newCosDictionary = this.mTarget.createCosDictionary(newMap);
        return this.cloneCosDictionary(cosObj, newCosDictionary);
    }

    private CosObject cloneCosStream(CosStream cosObj) throws PDFCosParseException, PDFIOException, IOException, PDFSecurityException {
        CosStream cloneStream = this.mTarget.createCosStream();
        cloneStream = (CosStream)this.cloneCosDictionary(cosObj, cloneStream);
        CosArray outputFilterList = cosObj.getOutputFiltersList();
        if (outputFilterList != null) {
            CosArray clonedOutputFilterList = (CosArray)this.cloneCosArray(outputFilterList);
            cloneStream.setOutputFiltersList(clonedOutputFilterList);
        }
        this.cloneStreamdata(cosObj, cloneStream);
        return cloneStream;
    }

    public CosObject clone(CosObject cosObj) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        if (cosObj instanceof CosBoolean) {
            return this.mTarget.createCosBoolean(cosObj.booleanValue());
        }
        if (cosObj instanceof CosName) {
            return this.mTarget.createCosName(cosObj.nameValue());
        }
        if (cosObj instanceof CosNull) {
            return this.mTarget.createCosNull();
        }
        if (cosObj instanceof CosNumeric) {
            return this.mTarget.createCosNumeric((CosNumeric)cosObj);
        }
        if (cosObj instanceof CosString) {
            CosString str = this.mTarget.createCosString(((CosString)cosObj).byteArrayValue());
            str.setWriteHex(((CosString)cosObj).getWriteHex());
            return str;
        }
        if (this.mClonedCosObjects.containsKey(CosObjectRefAdapter.newInstance(cosObj))) {
            return (CosObject)this.mClonedCosObjects.get(CosObjectRefAdapter.newInstance(cosObj)).getObject();
        }
        if (cosObj instanceof CosArray) {
            return this.cloneCosArray((CosArray)cosObj);
        }
        if (cosObj instanceof CosStream) {
            try {
                return this.cloneCosStream((CosStream)cosObj);
            }
            catch (IOException e) {
                throw new PDFIOException(e);
            }
        }
        if (cosObj instanceof CosDictionary) {
            return this.cloneCosDictionary((CosDictionary)cosObj);
        }
        return null;
    }

    public CosObject shallowClone(CosObject cosObj) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        try {
            return this.shallowClone(cosObj, false);
        }
        catch (IOException e) {
            throw new PDFIOException(e);
        }
    }

    private CosObject shallowClone(CosObject cosObj, boolean copyStream) throws PDFCosParseException, PDFIOException, PDFSecurityException, IOException {
        if (cosObj instanceof CosBoolean) {
            return this.mTarget.createCosBoolean(cosObj.booleanValue());
        }
        if (cosObj instanceof CosName) {
            return this.mTarget.createCosName(cosObj.nameValue());
        }
        if (cosObj instanceof CosNull) {
            return this.mTarget.createCosNull();
        }
        if (cosObj instanceof CosNumeric) {
            return this.mTarget.createCosNumeric((CosNumeric)cosObj);
        }
        if (cosObj instanceof CosString) {
            CosString str = this.mTarget.createCosString(((CosString)cosObj).byteArrayValue());
            str.setWriteHex(((CosString)cosObj).getWriteHex());
            return str;
        }
        if (cosObj instanceof CosObjectRef) {
            return this.shallowClone(this.mTarget.resolveReference((CosObjectRef)cosObj));
        }
        if (cosObj instanceof CosArray) {
            return this.shallowCloneCosArray((CosArray)cosObj);
        }
        if (cosObj instanceof CosStream) {
            if (copyStream) {
                try {
                    return this.shallowCloneCosStream((CosStream)cosObj);
                }
                catch (IOException e) {
                    throw new PDFIOException(e);
                }
            }
            return cosObj;
        }
        if (cosObj instanceof CosDictionary) {
            return this.shallowCloneCosDictionary((CosDictionary)cosObj);
        }
        return null;
    }

    private CosObject shallowCloneCosArray(CosArray cosObj) throws PDFCosParseException, PDFIOException, PDFSecurityException, IOException {
        CosArray newCosArray = this.mTarget.createCosArray();
        for (int i = 0; i < cosObj.size(); ++i) {
            newCosArray.add(this.shallowClone(cosObj.get(i)));
        }
        return newCosArray;
    }

    private CosObject shallowCloneCosDictionary(CosDictionary cosObj) throws PDFCosParseException, PDFIOException, PDFSecurityException, IOException {
        LinkedHashMap newMap = new LinkedHashMap(cosObj.size());
        CosDictionary newCosDictionary = this.mTarget.createCosDictionary(newMap);
        return this.shallowCloneCosDictionary(cosObj, newCosDictionary);
    }

    private CosObject shallowCloneCosDictionary(CosDictionary original, CosDictionary clone) throws PDFCosParseException, PDFIOException, PDFSecurityException, IOException {
        for (Map.Entry<ASName, CosObject> entry : original.entrySet()) {
            clone.put(entry.getKey(), this.shallowClone(entry.getValue(), this.streamsToClone != null && this.streamsToClone.contains(entry.getKey())));
        }
        return clone;
    }

    private CosObject shallowCloneCosStream(CosStream cosObj) throws PDFCosParseException, PDFIOException, IOException, PDFSecurityException {
        CosStream cloneStream = this.mTarget.createCosStream();
        cloneStream = (CosStream)this.shallowCloneCosDictionary(cosObj, cloneStream);
        this.cloneStreamdata(cosObj, cloneStream);
        return cloneStream;
    }

    private void cloneStreamdata(CosStream cosObj, CosStream cloneStream) throws PDFCosParseException, PDFIOException, PDFSecurityException, IOException {
        boolean encoded = cosObj.isEncoded();
        InputByteStream dataStream = null;
        dataStream = encoded ? cosObj.getStreamEncoded() : cosObj.getStreamDecoded();
        if (dataStream != null) {
            StreamManager streamManager = cloneStream.getStreamManager();
            OutputByteStream clonedData = streamManager.getOutputByteStreamEncryptedDocument(ByteWriterFactory.Fixed.FIXED, dataStream.length());
            IO.copy(dataStream, clonedData);
            if (encoded) {
                cloneStream.newDataEncoded(clonedData.closeAndConvert());
            } else {
                cloneStream.newDataDecoded(clonedData.closeAndConvert());
            }
            dataStream.close();
        }
    }

    public CosObject removeMapping(CosObject cosObj) {
        CosObjectRefAdapter object = this.mClonedCosObjects.remove(CosObjectRefAdapter.newInstance(cosObj));
        if (object == null) {
            return null;
        }
        return (CosObject)object.getObject();
    }
}

