/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.color;

import com.adobe.internal.pdftoolkit.color.DeviceCMYKtoRGBTables;
import java.awt.Color;
import java.util.List;

public class DeviceCMYKtoRGBColorConversion {
    public static Color convertDeviceCMYKtoRGB(int cyan, int magenta, int yellow, int black) {
        return DeviceCMYKtoRGBColorConversion.QUADLINEAR3(cyan, magenta, yellow, black);
    }

    private static Color QUADLINEAR3(int c, int m, int y, int k) {
        int w2;
        int v2;
        int u2;
        int w1;
        int v1;
        int u1;
        int kCMYKtoRGBSteps = 9;
        List<int[][][][]> table = DeviceCMYKtoRGBTables.getTables();
        int fq = (c *= 8) & Short.MAX_VALUE;
        int fr = (m *= 8) & Short.MAX_VALUE;
        int fs = (y *= 8) & Short.MAX_VALUE;
        int ft = (k *= 8) & Short.MAX_VALUE;
        int iq = c >> 15;
        int ir = m >> 15;
        int is = y >> 15;
        int it = k >> 15;
        int[][][][] data = table.get(iq);
        int u = data[ir][is][it][0];
        int v = data[ir][is][it][1];
        int w = data[ir][is][it][2];
        if (ft != 0) {
            u1 = data[ir][is][it + 1][0];
            v1 = data[ir][is][it + 1][1];
            w1 = data[ir][is][it + 1][2];
            u = DeviceCMYKtoRGBColorConversion.Linear15(ft, u, u1);
            v = DeviceCMYKtoRGBColorConversion.Linear15(ft, v, v1);
            w = DeviceCMYKtoRGBColorConversion.Linear15(ft, w, w1);
        }
        if (fs != 0) {
            u1 = data[ir][is + 1][it][0];
            v1 = data[ir][is + 1][it][1];
            w1 = data[ir][is + 1][it][2];
            if (ft != 0) {
                u2 = data[ir][is + 1][it + 1][0];
                v2 = data[ir][is + 1][it + 1][1];
                w2 = data[ir][is + 1][it + 1][2];
                u1 = DeviceCMYKtoRGBColorConversion.Linear15(ft, u1, u2);
                v1 = DeviceCMYKtoRGBColorConversion.Linear15(ft, v1, v2);
                w1 = DeviceCMYKtoRGBColorConversion.Linear15(ft, w1, w2);
            }
            u = DeviceCMYKtoRGBColorConversion.Linear15(fs, u, u1);
            v = DeviceCMYKtoRGBColorConversion.Linear15(fs, v, v1);
            w = DeviceCMYKtoRGBColorConversion.Linear15(fs, w, w1);
        }
        if (fr != 0) {
            u1 = data[ir + 1][is][it][0];
            v1 = data[ir + 1][is][it][1];
            w1 = data[ir + 1][is][it][2];
            if (ft != 0) {
                u2 = data[ir + 1][is][it + 1][0];
                v2 = data[ir + 1][is][it + 1][1];
                w2 = data[ir + 1][is][it + 1][2];
                u1 = DeviceCMYKtoRGBColorConversion.Linear15(ft, u1, u2);
                v1 = DeviceCMYKtoRGBColorConversion.Linear15(ft, v1, v2);
                w1 = DeviceCMYKtoRGBColorConversion.Linear15(ft, w1, w2);
            }
            if (fs != 0) {
                u2 = data[ir + 1][is + 1][it][0];
                v2 = data[ir + 1][is + 1][it][1];
                w2 = data[ir + 1][is + 1][it][2];
                if (ft != 0) {
                    int u3 = data[ir + 1][is + 1][it + 1][0];
                    int v3 = data[ir + 1][is + 1][it + 1][1];
                    int w3 = data[ir + 1][is + 1][it + 1][2];
                    u2 = DeviceCMYKtoRGBColorConversion.Linear15(ft, u2, u3);
                    v2 = DeviceCMYKtoRGBColorConversion.Linear15(ft, v2, v3);
                    w2 = DeviceCMYKtoRGBColorConversion.Linear15(ft, w2, w3);
                }
                u1 = DeviceCMYKtoRGBColorConversion.Linear15(fs, u1, u2);
                v1 = DeviceCMYKtoRGBColorConversion.Linear15(fs, v1, v2);
                w1 = DeviceCMYKtoRGBColorConversion.Linear15(fs, w1, w2);
            }
            u = DeviceCMYKtoRGBColorConversion.Linear15(fr, u, u1);
            v = DeviceCMYKtoRGBColorConversion.Linear15(fr, v, v1);
            w = DeviceCMYKtoRGBColorConversion.Linear15(fr, w, w1);
        }
        if (fq != 0) {
            int w3;
            int v3;
            int u3;
            int w22;
            int v22;
            int u22;
            int[][][][] data1 = table.get(iq + 1);
            int u12 = data1[ir][is][it][0];
            int v12 = data1[ir][is][it][1];
            int w12 = data1[ir][is][it][2];
            if (ft != 0) {
                u22 = data1[ir][is][it + 1][0];
                v22 = data1[ir][is][it + 1][1];
                w22 = data1[ir][is][it + 1][2];
                u12 = DeviceCMYKtoRGBColorConversion.Linear15(ft, u12, u22);
                v12 = DeviceCMYKtoRGBColorConversion.Linear15(ft, v12, v22);
                w12 = DeviceCMYKtoRGBColorConversion.Linear15(ft, w12, w22);
            }
            if (fs != 0) {
                u22 = data1[ir][is + 1][it][0];
                v22 = data1[ir][is + 1][it][1];
                w22 = data1[ir][is + 1][it][2];
                if (ft != 0) {
                    u3 = data1[ir][is + 1][it + 1][0];
                    v3 = data1[ir][is + 1][it + 1][1];
                    w3 = data1[ir][is + 1][it + 1][2];
                    u22 = DeviceCMYKtoRGBColorConversion.Linear15(ft, u22, u3);
                    v22 = DeviceCMYKtoRGBColorConversion.Linear15(ft, v22, v3);
                    w22 = DeviceCMYKtoRGBColorConversion.Linear15(ft, w22, w3);
                }
                u12 = DeviceCMYKtoRGBColorConversion.Linear15(fs, u12, u22);
                v12 = DeviceCMYKtoRGBColorConversion.Linear15(fs, v12, v22);
                w12 = DeviceCMYKtoRGBColorConversion.Linear15(fs, w12, w22);
            }
            if (fr != 0) {
                u22 = data1[ir + 1][is][it][0];
                v22 = data1[ir + 1][is][it][1];
                w22 = data1[ir + 1][is][it][2];
                if (ft != 0) {
                    u3 = data1[ir + 1][is][it + 1][0];
                    v3 = data1[ir + 1][is][it + 1][1];
                    w3 = data1[ir + 1][is][it + 1][2];
                    u22 = DeviceCMYKtoRGBColorConversion.Linear15(ft, u22, u3);
                    v22 = DeviceCMYKtoRGBColorConversion.Linear15(ft, v22, v3);
                    w22 = DeviceCMYKtoRGBColorConversion.Linear15(ft, w22, w3);
                }
                if (fs != 0) {
                    u3 = data1[ir + 1][is + 1][it][0];
                    v3 = data1[ir + 1][is + 1][it][1];
                    w3 = data1[ir + 1][is + 1][it][2];
                    if (ft != 0) {
                        int u4 = data1[ir + 1][is + 1][it + 1][0];
                        int v4 = data1[ir + 1][is + 1][it + 1][1];
                        int w4 = data1[ir + 1][is + 1][it + 1][2];
                        u3 = DeviceCMYKtoRGBColorConversion.Linear15(ft, u3, u4);
                        v3 = DeviceCMYKtoRGBColorConversion.Linear15(ft, v3, v4);
                        w3 = DeviceCMYKtoRGBColorConversion.Linear15(ft, w3, w4);
                    }
                    u22 = DeviceCMYKtoRGBColorConversion.Linear15(fs, u22, u3);
                    v22 = DeviceCMYKtoRGBColorConversion.Linear15(fs, v22, v3);
                    w22 = DeviceCMYKtoRGBColorConversion.Linear15(fs, w22, w3);
                }
                u12 = DeviceCMYKtoRGBColorConversion.Linear15(fr, u12, u22);
                v12 = DeviceCMYKtoRGBColorConversion.Linear15(fr, v12, v22);
                w12 = DeviceCMYKtoRGBColorConversion.Linear15(fr, w12, w22);
            }
            u = DeviceCMYKtoRGBColorConversion.Linear15(fq, u, u12);
            v = DeviceCMYKtoRGBColorConversion.Linear15(fq, v, v12);
            w = DeviceCMYKtoRGBColorConversion.Linear15(fq, w, w12);
        }
        return new Color(u, v, w);
    }

    private static int Linear15(int f, int a, int b) {
        return a + (f * (b - a) + 16384 >> 15);
    }
}

