/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.io;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class ExtendedDataInputStream
extends DataInputStream {
    public ExtendedDataInputStream(InputStream in) {
        super(in);
    }

    public long readUnsignedInt() throws IOException {
        long value = 0L;
        for (int i = 0; i < 4; ++i) {
            int b = this.read();
            if (b == -1) {
                throw new EOFException("Unexpected end of stream.");
            }
            value = (value << 8) + (long)(b & 0xFF);
        }
        return value;
    }

    public int readUnsigned3ByteInt() throws IOException {
        int value = 0;
        for (int i = 0; i < 3; ++i) {
            int b = this.read();
            if (b == -1) {
                throw new EOFException("Unexpected end of stream.");
            }
            value = (value << 8) + (b & 0xFF);
        }
        return value;
    }

    public void skipFully(long n) throws IOException {
        long totalBytesSkipped = 0L;
        while (n > 0L) {
            long bytesSkipped = super.skip(n);
            if (bytesSkipped == 0L) {
                throw new EOFException("Unable to skip.");
            }
            n -= bytesSkipped;
            totalBytesSkipped += bytesSkipped;
        }
    }
}

