/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.fontmanagement.fxg;

import com.adobe.agl.util.ULocale;
import com.adobe.fontengine.font.FontDescription;
import com.adobe.fontengine.fontmanagement.Platform;

public final class FXGFontDescription
extends FontDescription {
    static final long serialVersionUID = 1L;
    private final Platform platform;
    private final ULocale locale;
    private final String familyName;
    private final boolean isBold;
    private final boolean isItalic;

    public FXGFontDescription(Platform platform, ULocale locale, String familyName, boolean isBold, boolean isItalic) {
        if (platform == null || locale == null || familyName == null) {
            throw new NullPointerException("Platform, Locale, and Platform Name must not be null");
        }
        this.platform = platform;
        this.locale = locale;
        this.familyName = familyName;
        this.isBold = isBold;
        this.isItalic = isItalic;
    }

    public Platform getPlatform() {
        return this.platform;
    }

    public ULocale getLocale() {
        return this.locale;
    }

    public String getFamilyName() {
        return this.familyName;
    }

    public boolean isBold() {
        return this.isBold;
    }

    public boolean isItalic() {
        return this.isItalic;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.isBold ? 1231 : 1237);
        result = 31 * result + (this.isItalic ? 1231 : 1237);
        result = 31 * result + this.locale.hashCode();
        result = 31 * result + this.platform.hashCode();
        result = 31 * result + this.familyName.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FXGFontDescription)) {
            return false;
        }
        FXGFontDescription other = (FXGFontDescription)obj;
        if (this.isBold != other.isBold) {
            return false;
        }
        if (this.isItalic != other.isItalic) {
            return false;
        }
        if (this.locale == null ? other.locale != null : !this.locale.equals(other.locale)) {
            return false;
        }
        if (this.platform == null ? other.platform != null : !this.platform.equals(other.platform)) {
            return false;
        }
        return !(this.familyName == null ? other.familyName != null : !this.familyName.equals(other.familyName));
    }

    public String toString() {
        return new String("[" + this.platform + ", " + this.locale + "] - " + this.familyName + (this.isBold ? ", bold" : "") + (this.isItalic ? ", italic" : ""));
    }
}

