/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.fontmanagement;

import com.adobe.fontengine.font.Font;
import com.adobe.fontengine.font.FontImpl;
import com.adobe.fontengine.font.FontLoadingException;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.fontmanagement.CacheSupportInfo;
import com.adobe.fontengine.fontmanagement.URLFont;

public final class IntelligentResolver {
    public static Font choosePreferredFont(Font f1, Font f2, boolean preferFirst) throws UnsupportedFontException, InvalidFontException, FontLoadingException {
        String f2FontType;
        CacheSupportInfo f1Desc = ((FontImpl)f1).getCacheSupportInfo();
        CacheSupportInfo f2Desc = ((FontImpl)f2).getCacheSupportInfo();
        String f1FontType = f1Desc.getFontType();
        if (!f1FontType.equals(f2FontType = f2Desc.getFontType())) {
            if (f1FontType.equals("OpenTypeFont")) {
                return f1;
            }
            if (f2FontType.equals("OpenTypeFont")) {
                return f2;
            }
            if (f1FontType.equals("Type1Font")) {
                return f1;
            }
            return f2;
        }
        if (f1FontType.equals("OpenTypeFont")) {
            if (f1Desc.isCFF() && !f2Desc.isCFF()) {
                return f1;
            }
            if (!f1Desc.isCFF() && f2Desc.isCFF()) {
                return f2;
            }
        }
        if (f1Desc.getNumGlyphs() > f2Desc.getNumGlyphs()) {
            return f1;
        }
        if (f1Desc.getNumGlyphs() < f2Desc.getNumGlyphs()) {
            return f2;
        }
        if (f1.getClass() != f2.getClass()) {
            if (f1 instanceof URLFont) {
                return f1;
            }
            return f2;
        }
        return preferFirst ? f1 : f2;
    }
}

