/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.fontmanagement;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.List;

final class DirectoryWalker {
    private List fileList;
    private final boolean recurse;

    DirectoryWalker(File r, boolean recurse) {
        this.recurse = recurse;
        if (r.isDirectory()) {
            File[] list = r.listFiles(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return file.isFile() || file.isDirectory();
                }
            });
            this.fileList = new ArrayList(list.length);
            for (int i = 0; i < list.length; ++i) {
                this.fileList.add(list[i]);
            }
        } else {
            this.fileList = new ArrayList(1);
            this.fileList.add(r);
        }
    }

    File getNextFile() {
        File nextFile;
        do {
            if (this.fileList.isEmpty()) {
                return null;
            }
            nextFile = (File)this.fileList.remove(this.fileList.size() - 1);
            if (!this.recurse || !nextFile.isDirectory()) continue;
            File[] list = nextFile.listFiles();
            for (int i = 0; i < list.length; ++i) {
                this.fileList.add(list[i]);
            }
            return this.getNextFile();
        } while (nextFile.isDirectory());
        return nextFile;
    }
}

