/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font.type1;

import com.adobe.fontengine.font.FontInputStream;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.postscript.Reader;
import java.io.IOException;

final class BinaryEexecReader
implements Reader {
    private int lastRead;
    private int lastCipher;
    private int cipherR = 55665;

    BinaryEexecReader() {
    }

    @Override
    public int read(FontInputStream stream) throws IOException, InvalidFontException {
        this.lastRead = stream.read();
        if (this.lastRead == -1) {
            throw new InvalidFontException("unexpected end of file");
        }
        this.lastCipher = this.cipherR;
        int retVal = this.decryptByte((byte)this.lastRead);
        return retVal;
    }

    @Override
    public void unreadLast(FontInputStream stream) throws IOException {
        this.cipherR = this.lastCipher;
        stream.unread(this.lastRead);
    }

    public int decryptByte(byte inputByte) {
        byte dst = (byte)(inputByte ^ this.cipherR >> 8);
        this.cipherR = ((inputByte & 0xFF) + this.cipherR) * 52845 + 22719 & 0xFFFF;
        return dst & 0xFF;
    }

    int decryptBuffer(byte[] buffer, int numBytesToDecrypt) {
        int dest = 0;
        for (int i = 0; i < numBytesToDecrypt; ++i) {
            buffer[dest++] = (byte)this.decryptByte(buffer[i]);
        }
        return dest;
    }
}

