/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font.postscript;

import com.adobe.fontengine.font.FontInputStream;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.postscript.PlainReader;
import com.adobe.fontengine.font.postscript.Reader;
import com.adobe.fontengine.font.postscript.Token;
import com.adobe.fontengine.font.postscript.TokenType;
import java.io.IOException;

public final class Tokenizer {
    private FontInputStream fontInputStream;
    private Token token = new Token();
    private Reader reader;
    private static final int N = 1;
    private static final int W = 2;
    private static final int S = 4;
    private static final int D = 8;
    private static final int P = 16;
    private static final int G = 32;
    private static final int E = 64;
    private static final int[] lexicalClass = new int[]{2, 0, 0, 0, 0, 0, 0, 0, 0, 2, 3, 0, 2, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 4, 0, 0, 4, 4, 0, 32, 0, 32, 16, 4, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 0, 0, 4, 0, 4, 0, 0, 0, 0, 0, 0, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 4, 0, 0, 0, 0, 0, 0, 0, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    static final byte[] digit = new byte[]{99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 99, 99, 99, 99, 99, 99, 99, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 99, 99, 99, 99, 99, 99, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99};

    public static final boolean isWhite(int c) {
        return (lexicalClass[c] & 2) != 0;
    }

    public static final boolean isNewLine(int c) {
        return (lexicalClass[c] & 1) != 0;
    }

    public static final boolean isDelimiter(int c) {
        return (lexicalClass[c] & 6) != 0;
    }

    public static final boolean isSign(int c) {
        return (lexicalClass[c] & 0x20) != 0;
    }

    public static final boolean isExponent(int c) {
        return (lexicalClass[c] & 0x40) != 0;
    }

    public static final boolean isDigit(int c) {
        return digit[c] < 10;
    }

    public static final boolean isHex(int c) {
        return digit[c] < 16;
    }

    public static final boolean isRadix(int c, int b) {
        return digit[c] < b;
    }

    public static final byte digitValue(byte c) {
        return digit[c];
    }

    public Tokenizer(FontInputStream is) {
        this.fontInputStream = is;
        this.reader = new PlainReader();
    }

    private void addByte(byte newByte) {
        if (this.token.tokenLength < this.token.buff.length) {
            this.token.buff[this.token.tokenLength++] = newByte;
            return;
        }
        byte[] newBuffer = new byte[this.token.tokenLength + 256];
        System.arraycopy(this.token.buff, 0, newBuffer, 0, this.token.tokenLength);
        newBuffer[this.token.tokenLength++] = newByte;
        this.token.buff = newBuffer;
    }

    private void skipComment() throws IOException, InvalidFontException {
        int c;
        while (!Tokenizer.isNewLine(c = this.reader.read(this.fontInputStream))) {
        }
        this.reader.unreadLast(this.fontInputStream);
    }

    private void skipString() throws IOException, InvalidFontException {
        int cnt = 1;
        do {
            int c = this.reader.read(this.fontInputStream);
            switch (c) {
                case 92: {
                    this.addByte((byte)c);
                    c = this.reader.read(this.fontInputStream);
                    this.addByte((byte)c);
                    break;
                }
                case 40: {
                    this.addByte((byte)c);
                    ++cnt;
                    break;
                }
                case 41: {
                    --cnt;
                    this.addByte((byte)c);
                    break;
                }
                default: {
                    this.addByte((byte)c);
                }
            }
        } while (cnt > 0);
    }

    private void skipArray() throws IOException, InvalidFontException {
        int cnt = 1;
        do {
            int c = this.reader.read(this.fontInputStream);
            switch (c) {
                case 37: {
                    this.skipComment();
                    break;
                }
                case 40: {
                    this.addByte((byte)c);
                    this.skipString();
                    break;
                }
                case 91: {
                    this.addByte((byte)c);
                    ++cnt;
                    break;
                }
                case 93: {
                    this.addByte((byte)c);
                    --cnt;
                    break;
                }
                default: {
                    this.addByte((byte)c);
                }
            }
        } while (cnt > 0);
    }

    private void skipProcedure() throws IOException, InvalidFontException {
        int cnt = 1;
        do {
            int c = this.reader.read(this.fontInputStream);
            switch (c) {
                case 37: {
                    this.skipComment();
                    break;
                }
                case 40: {
                    this.addByte((byte)c);
                    this.skipString();
                    break;
                }
                case 123: {
                    this.addByte((byte)c);
                    ++cnt;
                    break;
                }
                case 125: {
                    this.addByte((byte)c);
                    --cnt;
                    break;
                }
                default: {
                    this.addByte((byte)c);
                }
            }
        } while (cnt > 0);
    }

    private void skipDictionary() throws IOException, InvalidFontException {
        block9: while (true) {
            int c = this.reader.read(this.fontInputStream);
            switch (c) {
                case 62: {
                    this.addByte((byte)c);
                    c = this.reader.read(this.fontInputStream);
                    switch (c) {
                        case 62: {
                            this.addByte((byte)c);
                            return;
                        }
                    }
                    this.reader.unreadLast(this.fontInputStream);
                    continue block9;
                }
                case 37: {
                    this.skipComment();
                    continue block9;
                }
                case 40: {
                    this.addByte((byte)c);
                    this.skipString();
                    continue block9;
                }
                case 60: {
                    this.addByte((byte)c);
                    this.skipAngle();
                    continue block9;
                }
            }
            this.addByte((byte)c);
        }
    }

    private TokenType skipAngle() throws IOException, InvalidFontException {
        int c = this.reader.read(this.fontInputStream);
        switch (c) {
            case 60: {
                this.addByte((byte)c);
                this.skipDictionary();
                return TokenType.kDICTIONARY;
            }
            case 126: {
                this.addByte((byte)c);
                while (true) {
                    c = this.reader.read(this.fontInputStream);
                    this.addByte((byte)c);
                    if (c == 126) {
                        c = this.reader.read(this.fontInputStream);
                        this.addByte((byte)c);
                        switch (c) {
                            case 62: {
                                return TokenType.kASCII85;
                            }
                        }
                        continue;
                    }
                    if (!(c >= 33 && c <= 117 || Tokenizer.isWhite(c) || c == 122)) break;
                }
                throw new InvalidFontException("invalid ascii85 string");
            }
        }
        this.addByte((byte)c);
        do {
            if (!Tokenizer.isHex(c) && !Tokenizer.isWhite(c)) {
                throw new InvalidFontException("invalid hex string");
            }
            c = this.reader.read(this.fontInputStream);
            this.addByte((byte)c);
        } while (c != 62);
        return TokenType.kHEXSTRING;
    }

    private TokenType skipNumber(int c) throws IOException, InvalidFontException {
        int state;
        boolean operatorFound = false;
        if (Tokenizer.isDigit(c)) {
            state = 1;
        } else if (Tokenizer.isSign(c)) {
            state = 2;
        } else if (c == 46) {
            state = 3;
        } else {
            state = 0;
            operatorFound = true;
        }
        while (!operatorFound) {
            c = this.reader.read(this.fontInputStream);
            if (Tokenizer.isDelimiter(c)) {
                switch (state) {
                    case 2: 
                    case 3: 
                    case 5: 
                    case 8: 
                    case 11: {
                        this.reader.unreadLast(this.fontInputStream);
                        return TokenType.kOPERATOR;
                    }
                    case 1: 
                    case 6: 
                    case 9: {
                        this.reader.unreadLast(this.fontInputStream);
                        return TokenType.kINTEGER;
                    }
                    case 4: 
                    case 7: 
                    case 10: {
                        this.reader.unreadLast(this.fontInputStream);
                        return TokenType.kREAL;
                    }
                }
            }
            this.addByte((byte)c);
            switch (state) {
                case 1: {
                    if (c == 46) {
                        state = 4;
                        break;
                    }
                    if (c == 35) {
                        state = 5;
                        break;
                    }
                    if (Tokenizer.isDigit(c)) break;
                    operatorFound = true;
                    break;
                }
                case 2: {
                    if (Tokenizer.isDigit(c)) {
                        state = 6;
                        break;
                    }
                    if (c == 46) {
                        state = 3;
                        break;
                    }
                    operatorFound = true;
                    break;
                }
                case 3: {
                    if (Tokenizer.isDigit(c)) {
                        state = 7;
                        break;
                    }
                    operatorFound = true;
                    break;
                }
                case 4: {
                    if (Tokenizer.isDigit(c)) {
                        state = 7;
                        break;
                    }
                    if (Tokenizer.isExponent(c)) {
                        state = 8;
                        break;
                    }
                    operatorFound = true;
                    break;
                }
                case 5: {
                    if (Tokenizer.isRadix(c, 36)) {
                        state = 9;
                        break;
                    }
                    operatorFound = true;
                    break;
                }
                case 6: {
                    if (c == 46) {
                        state = 7;
                        break;
                    }
                    if (Tokenizer.isDigit(c)) break;
                    operatorFound = true;
                    break;
                }
                case 7: {
                    if (Tokenizer.isExponent(c)) {
                        state = 8;
                        break;
                    }
                    if (Tokenizer.isDigit(c)) break;
                    operatorFound = true;
                    break;
                }
                case 8: {
                    if (Tokenizer.isDigit(c)) {
                        state = 10;
                        break;
                    }
                    if (Tokenizer.isSign(c)) {
                        state = 11;
                        break;
                    }
                    operatorFound = true;
                    break;
                }
                case 9: {
                    if (Tokenizer.isRadix(c, 36)) break;
                    operatorFound = true;
                    break;
                }
                case 10: {
                    if (Tokenizer.isDigit(c)) break;
                    operatorFound = true;
                    break;
                }
                case 11: {
                    if (Tokenizer.isDigit(c)) {
                        state = 10;
                        break;
                    }
                    operatorFound = true;
                }
            }
        }
        this.skipToDelimiter();
        return TokenType.kOPERATOR;
    }

    private void skipToDelimiter() throws IOException, InvalidFontException {
        int nextByte = this.reader.read(this.fontInputStream);
        while (nextByte != -1 && !Tokenizer.isDelimiter(nextByte)) {
            this.addByte((byte)nextByte);
            nextByte = this.reader.read(this.fontInputStream);
        }
        if (nextByte != -1) {
            this.reader.unreadLast(this.fontInputStream);
        }
    }

    private void gotoNextLine() throws InvalidFontException, IOException, IndexOutOfBoundsException {
        int nextByte = this.reader.read(this.fontInputStream);
        while (nextByte != -1) {
            if (Tokenizer.isNewLine(nextByte)) {
                return;
            }
            nextByte = this.reader.read(this.fontInputStream);
        }
    }

    public Token getNextPSToken() throws InvalidFontException, IOException, IndexOutOfBoundsException {
        this.token.tokenLength = 0;
        int nextByte = this.reader.read(this.fontInputStream);
        while (true) {
            if (!Tokenizer.isWhite(nextByte)) {
                if (nextByte != 37) break;
                this.skipComment();
            }
            nextByte = this.reader.read(this.fontInputStream);
        }
        this.addByte((byte)nextByte);
        switch (nextByte) {
            case 47: {
                nextByte = this.reader.read(this.fontInputStream);
                switch (nextByte) {
                    case -1: {
                        throw new InvalidFontException("unexpected end of token");
                    }
                    case 47: {
                        this.addByte((byte)nextByte);
                        this.token.tokenType = TokenType.kIMMEDIATE;
                        break;
                    }
                    default: {
                        this.token.tokenType = TokenType.kLITERAL;
                        this.reader.unreadLast(this.fontInputStream);
                    }
                }
                this.skipToDelimiter();
                break;
            }
            case 123: {
                this.skipProcedure();
                this.token.tokenType = TokenType.kPROCEDURE;
                break;
            }
            case 40: {
                this.skipString();
                this.token.tokenType = TokenType.kSTRING;
                break;
            }
            case 91: {
                this.skipArray();
                this.token.tokenType = TokenType.kARRAY;
                break;
            }
            case 60: {
                this.token.tokenType = this.skipAngle();
                break;
            }
            case 43: 
            case 45: 
            case 46: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                this.token.tokenType = this.skipNumber(nextByte);
                break;
            }
            default: {
                this.skipToDelimiter();
                this.token.tokenType = TokenType.kOPERATOR;
            }
        }
        return this.token;
    }

    public void findToken(byte[] tokenToFind) throws IOException, InvalidFontException {
        Token token;
        while (!(token = this.getNextPSToken()).matches(tokenToFind)) {
        }
    }

    public byte[] findOptionalTokensAtStartOfLine(byte[][] tokenToFind) throws IOException, InvalidFontException {
        block2: while (true) {
            Token token;
            this.gotoNextLine();
            try {
                token = this.getNextPSToken();
            }
            catch (InvalidFontException e) {
                return null;
            }
            if (token.isEOL()) {
                return null;
            }
            int i = 0;
            while (true) {
                if (i >= tokenToFind.length) continue block2;
                if (token.matches(tokenToFind[i])) {
                    return tokenToFind[i];
                }
                ++i;
            }
            break;
        }
    }

    public int read() throws IOException, InvalidFontException {
        return this.reader.read(this.fontInputStream);
    }

    public void setReader(Reader newReader) throws InvalidFontException {
        if (this.reader.getClass() == newReader.getClass()) {
            throw new InvalidFontException("eexec done twice?");
        }
        this.reader = newReader;
    }
}

