/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font.opentype;

import com.adobe.fontengine.font.FontByteArray;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.font.opentype.Gdef;
import com.adobe.fontengine.font.opentype.LayoutTable;
import com.adobe.fontengine.font.opentype.OTSelector;
import com.adobe.fontengine.font.opentype.Tag;
import com.adobe.fontengine.inlineformatting.AttributedRun;
import java.io.IOException;
import java.util.Arrays;

public abstract class LookupTable
extends LayoutTable {
    protected static final LookupResult lookupNotApplied = new LookupResult(false, 0, 0);
    static final int[] noMatch = new int[0];

    public LookupTable(FontByteArray buffer) throws IOException, InvalidFontException, UnsupportedFontException {
        super(buffer);
    }

    protected abstract int getScriptListOffset() throws InvalidFontException;

    protected abstract int getFeatureListOffset() throws InvalidFontException;

    protected abstract int getLookupListOffset() throws InvalidFontException;

    public int[][] resolveFeatureTag(int scriptTag, int langSysTag, int[] featureTags) throws InvalidFontException {
        int[][] result = new int[featureTags.length][];
        int scriptListOffset = this.getScriptListOffset();
        int scriptCount = this.data.getuint16(scriptListOffset);
        int resolvedScriptIndex = -1;
        for (int script = 0; script < scriptCount; ++script) {
            int thisScriptTag = this.data.getint32(scriptListOffset + 2 + 6 * script);
            if (scriptTag == thisScriptTag) {
                resolvedScriptIndex = script;
                break;
            }
            if (Tag.script_DFLT != thisScriptTag) continue;
            resolvedScriptIndex = script;
        }
        if (resolvedScriptIndex == -1) {
            for (int i = 0; i < result.length; ++i) {
                result[i] = new int[0];
            }
            return result;
        }
        int scriptOffset = this.data.getOffset(scriptListOffset, 2 + 6 * resolvedScriptIndex + 4);
        int langSysCount = this.data.getuint16(scriptOffset + 2);
        int resolvedLangSysOffset = this.data.getOffset(scriptOffset, 0);
        for (int lang = 0; lang < langSysCount; ++lang) {
            if ((long)langSysTag != this.data.getuint32(scriptOffset + 4 + 6 * lang)) continue;
            resolvedLangSysOffset = this.data.getOffset(scriptOffset, 4 + 6 * lang + 4);
            break;
        }
        if (resolvedLangSysOffset == 0) {
            for (int i = 0; i < result.length; ++i) {
                result[i] = new int[0];
            }
            return result;
        }
        int featureListOffset = this.getFeatureListOffset();
        for (int feature = 0; feature < featureTags.length; ++feature) {
            int resolvedFeatureIndex = -1;
            if (0 == featureTags[feature]) {
                int requiredFeatureIndex = this.data.getuint16(resolvedLangSysOffset + 2);
                resolvedFeatureIndex = requiredFeatureIndex == 65535 ? -1 : requiredFeatureIndex;
            } else {
                int featureCount = this.data.getuint16(resolvedLangSysOffset + 4);
                for (int f = 0; f < featureCount; ++f) {
                    int thisFeatureIndex = this.data.getuint16(resolvedLangSysOffset + 6 + 2 * f);
                    if ((long)featureTags[feature] != this.data.getuint32(featureListOffset + 2 + 6 * thisFeatureIndex)) continue;
                    resolvedFeatureIndex = thisFeatureIndex;
                }
            }
            if (resolvedFeatureIndex == -1) {
                result[feature] = new int[0];
                continue;
            }
            int featureOffset = featureListOffset + this.data.getuint16(featureListOffset + 2 + resolvedFeatureIndex * 6 + 4);
            int lookupCount = this.data.getuint16(featureOffset + 2);
            result[feature] = new int[lookupCount];
            for (int l = 0; l < lookupCount; ++l) {
                result[feature][l] = this.data.getuint16(featureOffset + 4 + l * 2);
            }
            Arrays.sort(result[feature]);
            int lookupListOffset = this.getLookupListOffset();
            for (int l = 0; l < lookupCount; ++l) {
                result[feature][l] = this.data.getOffset(lookupListOffset, 2 + 2 * result[feature][l]);
            }
        }
        return result;
    }

    public boolean featureIsPresent(int featureTag) throws InvalidFontException {
        int featureListOffset = this.getFeatureListOffset();
        int featureCount = this.data.getuint16(featureListOffset);
        for (int f = 0; f < featureCount; ++f) {
            if ((long)featureTag != this.data.getuint32(featureListOffset + 2 + 6 * f)) continue;
            return true;
        }
        return false;
    }

    public int applyLookups(int[] lookupOffsets, AttributedRun run, int start, int limit, OTSelector selector, Gdef gdef) throws InvalidFontException {
        for (int l = 0; l < lookupOffsets.length; ++l) {
            int lookupType = this.data.getuint16(lookupOffsets[l]);
            int lookupFlag = this.data.getuint16(lookupOffsets[l] + 2);
            int subtableCount = this.data.getuint16(lookupOffsets[l] + 4);
            int curGlyph = start;
            while (curGlyph < limit) {
                if (this.lookupFlagCovers(lookupFlag, gdef, run.elementAt(curGlyph))) {
                    ++curGlyph;
                    continue;
                }
                boolean doneAtThisPos = false;
                for (int st = 0; st < subtableCount && !doneAtThisPos; ++st) {
                    int stOffset = this.data.getOffset(lookupOffsets[l], 6 + 2 * st);
                    LookupResult result = this.applyLookupSubtable(lookupType, lookupFlag, stOffset, run, start, limit, curGlyph, selector, gdef);
                    if (!result.applied) continue;
                    curGlyph = result.nextToProcess;
                    limit += result.countAdjust;
                    doneAtThisPos = true;
                }
                if (doneAtThisPos) continue;
                ++curGlyph;
            }
        }
        return limit;
    }

    protected abstract LookupResult applyLookupSubtable(int var1, int var2, int var3, AttributedRun var4, int var5, int var6, int var7, OTSelector var8, Gdef var9) throws InvalidFontException;

    protected LookupResult applyContextualSubtable(int lookupFlag, int stOffset, AttributedRun run, int start, int limit, int curGlyph, OTSelector selector, Gdef gdef) throws InvalidFontException {
        int format = this.data.getuint16(stOffset);
        switch (format) {
            case 1: {
                return this.applyContextualSubtableFormat1(lookupFlag, stOffset, run, start, limit, curGlyph, selector, gdef);
            }
            case 2: {
                return this.applyContextualSubtableFormat2(lookupFlag, stOffset, run, start, limit, curGlyph, selector, gdef);
            }
            case 3: {
                return this.applyContextualSubtableFormat3(lookupFlag, stOffset, run, start, limit, curGlyph, selector, gdef);
            }
        }
        throw new InvalidFontException("Invalid contextual lookup subtable format (" + format + ")");
    }

    protected LookupResult applyContextualSubtableFormat1(int lookupFlag, int stOffset, AttributedRun run, int start, int limit, int curGlyph, OTSelector selector, Gdef gdef) throws InvalidFontException {
        int coverageOffset = this.data.getOffset(stOffset, 2);
        int inPos = curGlyph;
        int ci = this.getCoverageIndex(run.elementAt(inPos), coverageOffset);
        if (ci == -1) {
            return lookupNotApplied;
        }
        int ruleSetOffset = stOffset + this.data.getuint16(stOffset + 6 + ci * 2);
        int ruleCount = this.data.getuint16(ruleSetOffset);
        for (int s = 0; s < ruleCount; ++s) {
            int ruleOffset = this.data.getOffset(ruleSetOffset, 2 + 2 * s);
            int[] matchedPositions = this.matchOneRule(ruleOffset, lookupFlag, run, start, limit, inPos, selector, gdef);
            if (matchedPositions.length == 0 || !selector.isApplied(run, matchedPositions)) continue;
            int glyphCount = this.data.getuint16(ruleOffset);
            int applyCount = this.data.getuint16(ruleOffset + 2);
            int applyOffset = ruleOffset + 4 + 2 * (glyphCount - 1);
            return this.applySubLookups(applyCount, applyOffset, run, start, limit, matchedPositions, selector, gdef);
        }
        return lookupNotApplied;
    }

    protected LookupResult applyContextualSubtableFormat2(int lookupFlag, int stOffset, AttributedRun run, int start, int limit, int curGlyph, OTSelector selector, Gdef gdef) throws InvalidFontException {
        int coverageOffset = this.data.getOffset(stOffset, 2);
        int classDefOffset = this.data.getOffset(stOffset, 4);
        int inPos = curGlyph;
        if (-1 == this.getCoverageIndex(run.elementAt(inPos), coverageOffset)) {
            return lookupNotApplied;
        }
        int cl = this.getClassIndex(run.elementAt(inPos), classDefOffset);
        if (cl > this.data.getuint16(stOffset + 6) - 1) {
            return lookupNotApplied;
        }
        int classSetOffset = this.data.getOffset(stOffset, 8 + 2 * cl);
        if (classSetOffset == 0) {
            return lookupNotApplied;
        }
        int classRuleCnt = this.data.getuint16(classSetOffset);
        for (int i = 0; i < classRuleCnt; ++i) {
            int classRuleOffset = this.data.getOffset(classSetOffset, 2 + 2 * i);
            int glyphCount = this.data.getuint16(classRuleOffset);
            int[] matchedPositions = this.matchOneClassRule(classRuleOffset, classDefOffset, lookupFlag, run, start, limit, inPos, selector, gdef);
            if (matchedPositions.length == 0 || !selector.isApplied(run, matchedPositions)) continue;
            int applyCount = this.data.getuint16(classRuleOffset + 2);
            int applyOffset = classRuleOffset + 4 + 2 * (glyphCount - 1);
            return this.applySubLookups(applyCount, applyOffset, run, start, limit, matchedPositions, selector, gdef);
        }
        return lookupNotApplied;
    }

    protected LookupResult applyContextualSubtableFormat3(int lookupFlag, int stOffset, AttributedRun run, int start, int limit, int curGlyph, OTSelector selector, Gdef gdef) throws InvalidFontException {
        int glyphCount = this.data.getuint16(stOffset + 2);
        int inPos = curGlyph;
        int[] matchedPositions = new int[glyphCount];
        for (int i = 0; i < glyphCount; ++i) {
            if (i != 0) {
                while (inPos < limit && this.lookupFlagCovers(lookupFlag, gdef, run.elementAt(inPos))) {
                    ++inPos;
                }
            }
            if (inPos >= limit || -1 == this.getCoverageIndex(run.elementAt(inPos), this.data.getOffset(stOffset, 6 + 2 * i))) {
                return lookupNotApplied;
            }
            matchedPositions[i] = inPos++;
        }
        if (!selector.isApplied(run, matchedPositions)) {
            return lookupNotApplied;
        }
        int applyCount = this.data.getuint16(stOffset + 4);
        int applyOffset = stOffset + 6 + 2 * glyphCount;
        return this.applySubLookups(applyCount, applyOffset, run, start, limit, matchedPositions, selector, gdef);
    }

    int[] matchOneRule(int ruleOffset, int lookupFlag, AttributedRun run, int start, int limit, int inPos, OTSelector selector, Gdef gdef) throws InvalidFontException {
        int glyphCount = this.data.getuint16(ruleOffset);
        int[] matchedPositions = new int[glyphCount];
        matchedPositions[0] = inPos++;
        for (int i = 1; i < glyphCount; ++i) {
            while (inPos < limit && this.lookupFlagCovers(lookupFlag, gdef, run.elementAt(inPos))) {
                ++inPos;
            }
            if (inPos >= limit || run.elementAt(inPos) != this.data.getuint16(ruleOffset + 4 + 2 * (i - 1))) {
                return noMatch;
            }
            matchedPositions[i] = inPos++;
        }
        return matchedPositions;
    }

    int[] matchOneClassRule(int classRuleOffset, int classOffset, int lookupFlag, AttributedRun run, int start, int limit, int inPos, OTSelector selector, Gdef gdef) throws InvalidFontException {
        int glyphCount = this.data.getuint16(classRuleOffset);
        int[] matchedPositions = new int[glyphCount];
        matchedPositions[0] = inPos++;
        for (int g = 1; g < glyphCount; ++g) {
            while (inPos < limit && this.lookupFlagCovers(lookupFlag, gdef, run.elementAt(inPos))) {
                ++inPos;
            }
            if (inPos >= limit || this.getClassIndex(run.elementAt(inPos), classOffset) != this.data.getuint16(classRuleOffset + 4 + 2 * (g - 1))) {
                return noMatch;
            }
            matchedPositions[g] = inPos++;
        }
        return matchedPositions;
    }

    protected LookupResult applyChainingContextualSubtable(int lookupFlag, int stOffset, AttributedRun run, int start, int limit, int curGlyph, OTSelector selector, Gdef gdef) throws InvalidFontException {
        int format = this.data.getuint16(stOffset);
        switch (format) {
            case 1: {
                return this.applyChainingContextualSubtableFormat1(lookupFlag, stOffset, run, start, limit, curGlyph, selector, gdef);
            }
            case 2: {
                return this.applyChainingContextualSubtableFormat2(lookupFlag, stOffset, run, start, limit, curGlyph, selector, gdef);
            }
            case 3: {
                return this.applyChainingContextualSubtableFormat3(lookupFlag, stOffset, run, start, limit, curGlyph, selector, gdef);
            }
        }
        throw new InvalidFontException("Invalid ChainingContextualLookupSutable format (" + format + ")");
    }

    protected LookupResult applyChainingContextualSubtableFormat1(int lookupFlag, int stOffset, AttributedRun run, int start, int limit, int curGlyph, OTSelector selector, Gdef gdef) throws InvalidFontException {
        int coverageOffset = this.data.getOffset(stOffset, 2);
        int inPos = curGlyph;
        int ci = this.getCoverageIndex(run.elementAt(inPos), coverageOffset);
        if (ci == -1) {
            return lookupNotApplied;
        }
        int ruleSetOffset = this.data.getOffset(stOffset, 6 + 2 * ci);
        int ruleCount = this.data.getuint16(ruleSetOffset);
        for (int s = 0; s < ruleCount; ++s) {
            int ruleOffset = this.data.getOffset(ruleSetOffset, 2 + 2 * s);
            int[] matchedPositions = this.matchOneChainRule(ruleOffset, lookupFlag, run, start, limit, inPos, selector, gdef);
            if (matchedPositions.length == 0 || !selector.isApplied(run, matchedPositions)) continue;
            int backtrackGlyphCount = this.data.getuint16(ruleOffset);
            int inputGlyphCount = this.data.getuint16(ruleOffset + 2 + 2 * backtrackGlyphCount);
            int lookaheadGlyphCount = this.data.getuint16(ruleOffset + 4 + 2 * backtrackGlyphCount + 2 * (inputGlyphCount - 1));
            int applyCountOffset = ruleOffset + 6 + 2 * backtrackGlyphCount + 2 * (inputGlyphCount - 1) + 2 * lookaheadGlyphCount;
            int applyCount = this.data.getuint16(applyCountOffset);
            int applyOffset = applyCountOffset + 2;
            return this.applySubLookups(applyCount, applyOffset, run, start, limit, matchedPositions, selector, gdef);
        }
        return lookupNotApplied;
    }

    protected LookupResult applyChainingContextualSubtableFormat2(int lookupFlag, int stOffset, AttributedRun run, int start, int limit, int curGlyph, OTSelector selector, Gdef gdef) throws InvalidFontException {
        int coverageOffset = this.data.getOffset(stOffset, 2);
        int inPos = curGlyph;
        if (-1 == this.getCoverageIndex(run.elementAt(inPos), coverageOffset)) {
            return lookupNotApplied;
        }
        int backtrackClassDefOffset = this.data.getOffset(stOffset, 4);
        int inputClassDefOffset = this.data.getOffset(stOffset, 6);
        int lookaheadClassDefOffset = this.data.getOffset(stOffset, 8);
        int cl = this.getClassIndex(run.elementAt(inPos), inputClassDefOffset);
        if (cl > this.data.getuint16(stOffset + 10) - 1) {
            return lookupNotApplied;
        }
        int ruleSetOffset = this.data.getOffset(stOffset, 12 + 2 * cl);
        if (ruleSetOffset == 0) {
            return lookupNotApplied;
        }
        int ruleCount = this.data.getuint16(ruleSetOffset);
        for (int s = 0; s < ruleCount; ++s) {
            int ruleOffset = this.data.getOffset(ruleSetOffset, 2 + 2 * s);
            int[] matchedPositions = this.matchOneChainClassRule(ruleOffset, backtrackClassDefOffset, inputClassDefOffset, lookaheadClassDefOffset, lookupFlag, run, start, limit, inPos, selector, gdef);
            if (matchedPositions.length == 0 || !selector.isApplied(run, matchedPositions)) continue;
            int backtrackGlyphCount = this.data.getuint16(ruleOffset);
            int inputGlyphCount = this.data.getuint16(ruleOffset + 2 + 2 * backtrackGlyphCount);
            int lookaheadGlyphCount = this.data.getuint16(ruleOffset + 4 + 2 * backtrackGlyphCount + 2 * (inputGlyphCount - 1));
            int applyCountOffset = ruleOffset + 6 + 2 * backtrackGlyphCount + 2 * (inputGlyphCount - 1) + 2 * lookaheadGlyphCount;
            int applyCount = this.data.getuint16(applyCountOffset);
            int applyOffset = applyCountOffset + 2;
            return this.applySubLookups(applyCount, applyOffset, run, start, limit, matchedPositions, selector, gdef);
        }
        return lookupNotApplied;
    }

    protected LookupResult applyChainingContextualSubtableFormat3(int lookupFlag, int stOffset, AttributedRun run, int start, int limit, int curGlyph, OTSelector selector, Gdef gdef) throws InvalidFontException {
        int backtrackGlyphCount = this.data.getuint16(stOffset + 2);
        int inputGlyphCount = this.data.getuint16(stOffset + 4 + 2 * backtrackGlyphCount);
        int lookaheadGlyphCount = this.data.getuint16(stOffset + 6 + 2 * backtrackGlyphCount + 2 * inputGlyphCount);
        int backPos = curGlyph - 1;
        for (int b = 0; b < backtrackGlyphCount; ++b) {
            while (start <= backPos && this.lookupFlagCovers(lookupFlag, gdef, run.elementAt(backPos))) {
                --backPos;
            }
            if (backPos < start || -1 == this.getCoverageIndex(run.elementAt(backPos), this.data.getOffset(stOffset, 4 + 2 * b))) {
                return lookupNotApplied;
            }
            --backPos;
        }
        int[] matchedPositions = new int[inputGlyphCount];
        int inPos = curGlyph;
        for (int i = 0; i < inputGlyphCount; ++i) {
            if (i != 0) {
                while (inPos < limit && this.lookupFlagCovers(lookupFlag, gdef, run.elementAt(inPos))) {
                    ++inPos;
                }
            }
            if (limit <= inPos || -1 == this.getCoverageIndex(run.elementAt(inPos), this.data.getOffset(stOffset, 6 + 2 * backtrackGlyphCount + 2 * i))) {
                return lookupNotApplied;
            }
            matchedPositions[i] = inPos++;
        }
        if (!selector.isApplied(run, matchedPositions)) {
            return lookupNotApplied;
        }
        for (int l = 0; l < lookaheadGlyphCount; ++l) {
            while (inPos < limit && this.lookupFlagCovers(lookupFlag, gdef, run.elementAt(inPos))) {
                ++inPos;
            }
            if (limit <= inPos || -1 == this.getCoverageIndex(run.elementAt(inPos), this.data.getOffset(stOffset, 8 + 2 * backtrackGlyphCount + 2 * inputGlyphCount + 2 * l))) {
                return lookupNotApplied;
            }
            ++inPos;
        }
        int applyCountOffset = stOffset + 8 + 2 * backtrackGlyphCount + 2 * inputGlyphCount + 2 * lookaheadGlyphCount;
        int applyCount = this.data.getuint16(applyCountOffset);
        int applyOffset = applyCountOffset + 2;
        return this.applySubLookups(applyCount, applyOffset, run, start, limit, matchedPositions, selector, gdef);
    }

    int[] matchOneChainRule(int ruleOffset, int lookupFlag, AttributedRun run, int start, int limit, int inPos, OTSelector selector, Gdef gdef) throws InvalidFontException {
        int backtrackGlyphCount = this.data.getuint16(ruleOffset);
        int inputGlyphCount = this.data.getuint16(ruleOffset + 2 + 2 * backtrackGlyphCount);
        int lookaheadGlyphCount = this.data.getuint16(ruleOffset + 4 + 2 * backtrackGlyphCount + 2 * (inputGlyphCount - 1));
        int backPos = inPos - 1;
        for (int b = 0; b < backtrackGlyphCount; ++b) {
            while (start <= backPos && this.lookupFlagCovers(lookupFlag, gdef, run.elementAt(backPos))) {
                --backPos;
            }
            if (backPos < start || run.elementAt(backPos) != this.data.getuint16(ruleOffset + 2 + 2 * b)) {
                return noMatch;
            }
            --backPos;
        }
        int[] matchedPositions = new int[inputGlyphCount];
        matchedPositions[0] = inPos++;
        for (int i = 1; i < inputGlyphCount; ++i) {
            while (inPos < limit && this.lookupFlagCovers(lookupFlag, gdef, run.elementAt(inPos))) {
                ++inPos;
            }
            if (limit <= inPos || run.elementAt(inPos) != this.data.getuint16(ruleOffset + 4 + 2 * backtrackGlyphCount + 2 * (i - 1))) {
                return noMatch;
            }
            matchedPositions[i] = inPos++;
        }
        for (int l = 0; l < lookaheadGlyphCount; ++l) {
            while (inPos < limit && this.lookupFlagCovers(lookupFlag, gdef, run.elementAt(inPos))) {
                ++inPos;
            }
            if (limit <= inPos || run.elementAt(inPos) != this.data.getuint16(ruleOffset + 6 + 2 * backtrackGlyphCount + 2 * (inputGlyphCount - 1) + 2 * l)) {
                return noMatch;
            }
            ++inPos;
        }
        return matchedPositions;
    }

    int[] matchOneChainClassRule(int ruleOffset, int backtrackClassDefOffset, int inputClassDefOffset, int lookaheadClassDefOffset, int lookupFlag, AttributedRun run, int start, int limit, int inPos, OTSelector selector, Gdef gdef) throws InvalidFontException {
        int backtrackGlyphCount = this.data.getuint16(ruleOffset);
        int inputGlyphCount = this.data.getuint16(ruleOffset + 2 + 2 * backtrackGlyphCount);
        int lookaheadGlyphCount = this.data.getuint16(ruleOffset + 4 + 2 * backtrackGlyphCount + 2 * (inputGlyphCount - 1));
        int backPos = inPos - 1;
        for (int b = 0; b < backtrackGlyphCount; ++b) {
            while (start <= backPos && this.lookupFlagCovers(lookupFlag, gdef, run.elementAt(backPos))) {
                --backPos;
            }
            if (backPos < start || this.getClassIndex(run.elementAt(backPos), backtrackClassDefOffset) != this.data.getuint16(ruleOffset + 2 + 2 * b)) {
                return noMatch;
            }
            --backPos;
        }
        int[] matchedPositions = new int[inputGlyphCount];
        matchedPositions[0] = inPos++;
        for (int i = 1; i < inputGlyphCount; ++i) {
            while (inPos < limit && this.lookupFlagCovers(lookupFlag, gdef, run.elementAt(inPos))) {
                ++inPos;
            }
            if (limit <= inPos || this.getClassIndex(run.elementAt(inPos), inputClassDefOffset) != this.data.getuint16(ruleOffset + 4 + 2 * backtrackGlyphCount + 2 * (i - 1))) {
                return noMatch;
            }
            matchedPositions[i] = inPos++;
        }
        for (int l = 0; l < lookaheadGlyphCount; ++l) {
            while (inPos < limit && this.lookupFlagCovers(lookupFlag, gdef, run.elementAt(inPos))) {
                ++inPos;
            }
            if (limit <= inPos || this.getClassIndex(run.elementAt(inPos), lookaheadClassDefOffset) != this.data.getuint16(ruleOffset + 6 + 2 * backtrackGlyphCount + 2 * (inputGlyphCount - 1) + 2 * l)) {
                return noMatch;
            }
            ++inPos;
        }
        return matchedPositions;
    }

    protected LookupResult applyExtensionSubtable(int lookupFlag, int stOffset, AttributedRun run, int start, int limit, int curGlyph, OTSelector selector, Gdef gdef) throws InvalidFontException {
        int extensionLookupType = this.data.getuint16(stOffset + 2);
        int extensionOffset = stOffset + (int)this.data.getuint32(stOffset + 4);
        return this.applyLookupSubtable(extensionLookupType, lookupFlag, extensionOffset, run, start, limit, curGlyph, selector, gdef);
    }

    protected LookupResult applySubLookups(int count, int offset, AttributedRun run, int start, int limit, int[] matchedPositions, OTSelector selector, Gdef gdef) throws InvalidFontException {
        LookupResult result = new LookupResult(true, matchedPositions[matchedPositions.length - 1] + 1, 0);
        int lookupListOffset = this.getLookupListOffset();
        block0: for (int su = 0; su < count; ++su) {
            int sequenceIndex = this.data.getuint16(offset);
            int lookupIndex = this.data.getuint16(offset + 2);
            offset += 4;
            int curPos = matchedPositions[sequenceIndex];
            int lookupOffset = this.data.getOffset(lookupListOffset, 2 + 2 * lookupIndex);
            int lookupType = this.data.getuint16(lookupOffset);
            int lookupFlag = this.data.getuint16(lookupOffset + 2);
            int subtableCount = this.data.getuint16(lookupOffset + 4);
            if (this.lookupFlagCovers(lookupFlag, gdef, run.elementAt(curPos))) continue;
            for (int st = 0; st < subtableCount; ++st) {
                int stOffset = this.data.getOffset(lookupOffset, 6 + 2 * st);
                LookupResult r = this.applyLookupSubtable(lookupType, lookupFlag, stOffset, run, start, limit, curPos, selector, gdef);
                if (!r.applied) continue;
                result.nextToProcess += r.countAdjust;
                result.countAdjust += r.countAdjust;
                continue block0;
            }
        }
        return result;
    }

    protected static final class LookupResult {
        public boolean applied;
        public int nextToProcess;
        public int countAdjust;

        public LookupResult(boolean applied, int nextToProcess, int countAdjust) {
            this.applied = applied;
            this.nextToProcess = nextToProcess;
            this.countAdjust = countAdjust;
        }
    }
}

