/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font.opentype;

import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.Subset;
import com.adobe.fontengine.font.opentype.HmtxRaw;
import com.adobe.fontengine.font.opentype.OTByteArray;
import com.adobe.fontengine.font.opentype.Table;
import java.util.Map;

public final class Hmtx
extends Table {
    protected final int numberOfHMetrics;
    protected final HmtxRaw hmtx;

    protected Hmtx(HmtxRaw hmtx, int numberOfHMetrics) {
        this.hmtx = hmtx;
        this.numberOfHMetrics = numberOfHMetrics;
    }

    public int getLeftSideBearing(int glyphID) throws InvalidFontException {
        return this.hmtx.getLeftSideBearing(glyphID, this.numberOfHMetrics);
    }

    public int getHorizontalAdvance(int glyphID) throws InvalidFontException {
        return this.hmtx.getHorizontalAdvance(glyphID, this.numberOfHMetrics);
    }

    public void subsetAndStream(Subset subset, Map tables) throws InvalidFontException {
        OTByteArray.OTByteArrayBuilder newData = OTByteArray.getOTByteArrayBuilderInstance(subset.getNumGlyphs() * 4);
        int o = 0;
        for (int i = 0; i < subset.getNumGlyphs(); ++i) {
            int fullId = subset.getFullGid(i);
            newData.setuint16(o, this.getHorizontalAdvance(fullId));
            newData.setint16(o + 2, this.getLeftSideBearing(fullId));
            o += 4;
        }
        tables.put(new Integer(1752003704), newData);
    }

    public void stream(Map tables) {
        OTByteArray.OTByteArrayBuilder newData = this.hmtx.getDataAsByteArray();
        tables.put(new Integer(1752003704), newData);
    }
}

