/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font.opentype;

import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.InvalidGlyphException;
import com.adobe.fontengine.font.Matrix;
import com.adobe.fontengine.font.OrigFontType;
import com.adobe.fontengine.font.Rect;
import com.adobe.fontengine.font.Subset;
import com.adobe.fontengine.font.SubsetDefaultImpl;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.font.cff.AutoColor;
import com.adobe.fontengine.font.cff.CFFSubrize;
import com.adobe.fontengine.font.cff.CIDKeyedFont;
import com.adobe.fontengine.font.cff.CharStrings;
import com.adobe.fontengine.font.cff.Dict;
import com.adobe.fontengine.font.cff.NonOverlappingOutlineConsumer;
import com.adobe.fontengine.font.cff.Type2CStringGenerator;
import com.adobe.fontengine.font.opentype.GlyfRaw;
import com.adobe.fontengine.font.opentype.LocaRaw;
import com.adobe.fontengine.font.opentype.Name;
import com.adobe.fontengine.font.opentype.OTByteArray;
import com.adobe.fontengine.font.opentype.OpenTypeFont;
import com.adobe.fontengine.font.opentype.TTCompositeOutline;
import com.adobe.fontengine.font.opentype.TTOutline;
import com.adobe.fontengine.font.opentype.TTPoint;
import com.adobe.fontengine.font.opentype.TTSimpleOutline;
import com.adobe.fontengine.font.opentype.Table;
import com.adobe.fontengine.font.opentype.ZoneHint;
import com.adobe.fontengine.math.F16Dot16;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Map;

public final class Glyf
extends Table {
    protected final LocaRaw loca;
    protected final GlyfRaw glyf;
    protected final int indexToLocFormat;
    private static final int MAX_GLYF_SIZE_FOR_SUBRIZE = 614400;

    protected Glyf(GlyfRaw glyf, LocaRaw loca, int indexToLocFormat) {
        if (glyf == null) {
            glyf = new GlyfRaw();
        }
        this.glyf = glyf;
        this.loca = loca;
        this.indexToLocFormat = indexToLocFormat;
    }

    protected int getGlyphLocation(int gid) throws UnsupportedFontException, InvalidFontException {
        return this.loca.getGlyphLocation(gid, this.indexToLocFormat);
    }

    public Rect getGlyphBoundingBox(int gid) throws UnsupportedFontException, InvalidFontException {
        return this.glyf.getGlyphBoundingBox(this.getGlyphLocation(gid), this.getGlyphLocation(gid + 1));
    }

    public boolean isComposite(int gid) throws UnsupportedFontException, InvalidFontException {
        return this.glyf.isComposite(this.getGlyphLocation(gid), this.getGlyphLocation(gid + 1));
    }

    public void subsetAndStream(Subset subset, Map tables) throws UnsupportedFontException, InvalidFontException {
        OTByteArray.OTByteArrayBuilder locaData = OTByteArray.getOTByteArrayBuilderInstance((subset.getNumGlyphs() + 1) * 4);
        int newGlyfTableSize = 0;
        for (int i = 0; i < subset.getNumGlyphs(); ++i) {
            int fullGid = subset.getFullGid(i);
            long start = this.getGlyphLocation(fullGid);
            long limit = this.getGlyphLocation(fullGid + 1);
            if (limit < start) {
                throw new InvalidFontException("gid " + fullGid + " starts at " + start + " and ends at " + limit + "!");
            }
            newGlyfTableSize = (int)((long)newGlyfTableSize + (limit - start));
        }
        OTByteArray.OTByteArrayBuilder glyfData = OTByteArray.getOTByteArrayBuilderInstance(newGlyfTableSize);
        int position = 0;
        for (int i = 0; i < subset.getNumGlyphs(); ++i) {
            locaData.setuint32(i * 4, position);
            int fullGid = subset.getFullGid(i);
            long start = this.getGlyphLocation(fullGid);
            long limit = this.getGlyphLocation(fullGid + 1);
            if (limit - start > 0L) {
                glyfData.replace(position, this.glyf.data, (int)start, (int)(limit - start));
                this.fixComponentGlyphs(subset, (int)start, glyfData, position);
            }
            position = (int)((long)position + (limit - start));
        }
        locaData.setuint32(subset.getNumGlyphs() * 4, position);
        tables.put(new Integer(1819239265), locaData);
        tables.put(new Integer(1735162214), glyfData);
    }

    public void stream(Map tables) {
        OTByteArray.OTByteArrayBuilder newData = this.loca.getDataAsByteArray();
        tables.put(new Integer(1819239265), newData);
        newData = this.glyf.getDataAsByteArray();
        tables.put(new Integer(1735162214), newData);
    }

    public void pullComponentGlyphs(Subset subset, int gid) throws UnsupportedFontException, InvalidFontException {
        int limit;
        int start = this.getGlyphLocation(gid);
        if (start == (limit = this.getGlyphLocation(gid + 1))) {
            return;
        }
        if (this.glyf.data.getint16(start) != -1) {
            return;
        }
        start += 10;
        boolean moreComponents = true;
        while (moreComponents) {
            subset.getSubsetGid(this.glyf.data.getuint16(start + 2));
            int flags = this.glyf.data.getuint16(start);
            int blockSize = 4;
            blockSize = (flags & 1) != 0 ? (blockSize += 4) : (blockSize += 2);
            if ((flags & 8) != 0) {
                blockSize += 2;
            } else if ((flags & 0x40) != 0) {
                blockSize += 4;
            } else if ((flags & 0x80) != 0) {
                blockSize += 8;
            }
            start += blockSize;
            moreComponents = (flags & 0x20) != 0;
        }
    }

    void fixComponentGlyphs(Subset subset, int start, OTByteArray.OTByteArrayBuilder data, int offset) throws UnsupportedFontException, InvalidFontException {
        if (this.glyf.data == null || this.glyf.data.getint16(start) != -1) {
            return;
        }
        start += 10;
        offset += 10;
        boolean moreComponents = true;
        while (moreComponents) {
            data.setuint16(offset + 2, subset.getSubsetGid(this.glyf.data.getuint16(start + 2)));
            int flags = this.glyf.data.getuint16(start);
            int blockSize = 4;
            blockSize = (flags & 1) != 0 ? (blockSize += 4) : (blockSize += 2);
            if ((flags & 8) != 0) {
                blockSize += 2;
            } else if ((flags & 0x40) != 0) {
                blockSize += 4;
            } else if ((flags & 0x80) != 0) {
                blockSize += 8;
            }
            start += blockSize;
            offset += blockSize;
            moreComponents = (flags & 0x20) != 0;
        }
    }

    public TTOutline createTTOutline(OpenTypeFont font, int gid) throws UnsupportedFontException, InvalidFontException {
        int limit;
        int offset = this.getGlyphLocation(gid);
        if (offset == (limit = this.getGlyphLocation(gid + 1))) {
            return this.createTTSimpleOutline(font, gid, offset, limit);
        }
        int numberOfContours = this.glyf.data.getint16(offset);
        if (numberOfContours < 0) {
            return this.createTTCompositeOutline(font, gid, offset, limit);
        }
        if (numberOfContours == 0) {
            throw new UnsupportedFontException("createTTOutline, numberOfContours == 0");
        }
        return this.createTTSimpleOutline(font, gid, offset, limit);
    }

    TTCompositeOutline createTTCompositeOutline(OpenTypeFont font, int gid, int offset, int limit) throws UnsupportedFontException, InvalidFontException {
        ArrayList<TTCompositeOutline.TTComponent> components = new ArrayList<TTCompositeOutline.TTComponent>();
        int xMin = this.glyf.data.getint16(offset += 2);
        offset += 8;
        boolean moreComponents = true;
        boolean haveInstructions = false;
        while (moreComponents) {
            TTCompositeOutline.TTComponent component = new TTCompositeOutline.TTComponent();
            int flags = this.glyf.data.getuint16(offset);
            moreComponents = (flags & 0x20) != 0;
            haveInstructions = (flags & 0x100) != 0;
            int childGid = this.glyf.data.getuint16(offset += 2);
            offset += 2;
            component.outline = this.createTTOutline(font, childGid);
            component.alignByPosition = (flags & 2) != 0;
            component.roundXYToGrid = (flags & 4) != 0;
            component.useThisMetrics = (flags & 0x200) != 0;
            component.scaledOffsets = (flags & 0x800) != 0;
            boolean bl = component.unscaledOffset = (flags & 0x1000) != 0;
            if ((flags & 1) != 0) {
                component.argument1 = this.glyf.data.getint16(offset);
                component.argument2 = this.glyf.data.getint16(offset += 2);
                offset += 2;
            } else {
                component.argument1 = this.glyf.data.getint8(offset);
                component.argument2 = this.glyf.data.getint8(++offset);
                ++offset;
            }
            if ((flags & 8) != 0) {
                component.a = this.glyf.data.getuint16(offset);
                offset += 2;
                component.b = 0;
                component.c = 0;
                component.d = component.a;
            } else if ((flags & 0x40) != 0) {
                component.a = this.glyf.data.getuint16(offset);
                component.b = 0;
                component.c = 0;
                component.d = this.glyf.data.getuint16(offset += 2);
                offset += 2;
            } else if ((flags & 0x80) != 0) {
                component.a = this.glyf.data.getuint16(offset);
                component.b = this.glyf.data.getuint16(offset += 2);
                component.c = this.glyf.data.getuint16(offset += 2);
                component.d = this.glyf.data.getuint16(offset += 2);
                offset += 2;
            } else {
                component.a = 16384;
                component.b = 0;
                component.c = 0;
                component.d = 16384;
            }
            components.add(component);
        }
        int instructionsLength = 0;
        int instructionsOffset = 0;
        if (haveInstructions) {
            instructionsLength = this.glyf.data.getuint16(offset);
            instructionsOffset = offset += 2;
        }
        int l = xMin - font.hmtx.getLeftSideBearing(gid);
        int r = l + font.hmtx.getHorizontalAdvance(gid);
        int t = 0;
        int b = 0;
        if (font.os2 != null) {
            t = font.os2.getTypoAscender();
            b = font.os2.getTypoDescender();
        } else if (font.hhea != null) {
            t = font.hhea.getAscender();
            b = font.hhea.getDescender();
        }
        TTCompositeOutline ttOutline = new TTCompositeOutline(components, l, r, t, b, this.glyf.data, instructionsOffset, instructionsLength);
        return ttOutline;
    }

    TTSimpleOutline createTTSimpleOutline(OpenTypeFont font, int gid, int offset, int limit) throws UnsupportedFontException, InvalidFontException {
        TTSimpleOutline ttOutline = new TTSimpleOutline();
        if (offset == limit) {
            ttOutline.points = new TTPoint[4];
            ttOutline.contourEndPoints = new int[0];
            int numPoints = 0;
            int xMin = 0;
            int l = xMin - font.hmtx.getLeftSideBearing(gid);
            int r = l + font.hmtx.getHorizontalAdvance(gid);
            int t = 0;
            int b = 0;
            if (font.os2 != null) {
                t = font.os2.getTypoAscender();
                b = font.os2.getTypoDescender();
            } else if (font.hhea != null) {
                t = font.hhea.getAscender();
                b = font.hhea.getDescender();
            }
            ttOutline.points[numPoints + 0] = new TTPoint(l, 0, false);
            ttOutline.points[numPoints + 1] = new TTPoint(r, 0, false);
            ttOutline.points[numPoints + 2] = new TTPoint(0, t, false);
            ttOutline.points[numPoints + 3] = new TTPoint(0, b, false);
            return ttOutline;
        }
        int numberOfContours = this.glyf.data.getint16(offset);
        int xMin = this.glyf.data.getint16(offset += 2);
        offset += 8;
        if (numberOfContours < 0) {
            throw new UnsupportedFontException("composite glyph");
        }
        if (numberOfContours == 0) {
            throw new UnsupportedFontException();
        }
        ttOutline.contourEndPoints = new int[numberOfContours];
        for (int i = 0; i < numberOfContours; ++i) {
            ttOutline.contourEndPoints[i] = this.glyf.data.getuint16(offset);
            offset += 2;
        }
        int numPoints = ttOutline.contourEndPoints[numberOfContours - 1] + 1;
        int l = xMin - font.hmtx.getLeftSideBearing(gid);
        int r = l + font.hmtx.getHorizontalAdvance(gid);
        int t = 0;
        int b = 0;
        if (font.os2 != null) {
            t = font.os2.getTypoAscender();
            b = font.os2.getTypoDescender();
        } else if (font.hhea != null) {
            t = font.hhea.getAscender();
            b = font.hhea.getDescender();
        }
        ttOutline.points = new TTPoint[numPoints + 4];
        ttOutline.points[numPoints + 0] = new TTPoint(l, 0, false);
        ttOutline.points[numPoints + 1] = new TTPoint(r, 0, false);
        ttOutline.points[numPoints + 2] = new TTPoint(0, t, false);
        ttOutline.points[numPoints + 3] = new TTPoint(0, b, false);
        ttOutline.instructions = this.glyf.data;
        ttOutline.instructionsLength = this.glyf.data.getuint16(offset);
        ttOutline.instructionsOffset = offset += 2;
        int flagOffset = offset += ttOutline.instructionsLength;
        int xSize = 0;
        int curPoint = 0;
        while (curPoint < numPoints) {
            int flag;
            int numRepeats = ((flag = this.glyf.data.getuint8(offset++)) & 8) == 0 ? 0 : this.glyf.data.getuint8(offset++);
            for (int i = 0; i <= numRepeats; ++i) {
                if ((flag & 2) != 0) {
                    ++xSize;
                } else if ((flag & 0x10) == 0) {
                    xSize += 2;
                }
                ++curPoint;
            }
        }
        int xOffset = offset;
        int yOffset = xOffset + xSize;
        int x = 0;
        int y = 0;
        curPoint = 0;
        while (curPoint < numPoints) {
            int flag;
            int numRepeats = ((flag = this.glyf.data.getuint8(flagOffset++)) & 8) == 0 ? 0 : this.glyf.data.getuint8(flagOffset++);
            for (int i = 0; i <= numRepeats; ++i) {
                if ((flag & 2) != 0) {
                    x = (flag & 0x10) == 0 ? (x -= this.glyf.data.getuint8(xOffset)) : (x += this.glyf.data.getuint8(xOffset));
                    ++xOffset;
                } else if ((flag & 0x10) == 0) {
                    x += this.glyf.data.getint16(xOffset);
                    xOffset += 2;
                }
                if ((flag & 4) != 0) {
                    y = (flag & 0x20) == 0 ? (y -= this.glyf.data.getuint8(yOffset)) : (y += this.glyf.data.getuint8(yOffset));
                    ++yOffset;
                } else if ((flag & 0x20) == 0) {
                    y += this.glyf.data.getint16(yOffset);
                    yOffset += 2;
                }
                boolean onCurve = (flag & 1) != 0;
                try {
                    ttOutline.points[curPoint] = new TTPoint(x, y, onCurve);
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    throw new InvalidGlyphException(e);
                }
                ++curPoint;
            }
        }
        return ttOutline;
    }

    private String nameGet(String src) {
        if (src == null) {
            return null;
        }
        StringBuffer dst = new StringBuffer();
        block5: for (int i = 0; i < src.length(); ++i) {
            char c = src.charAt(i);
            switch (c) {
                case '\u00a9': {
                    dst.append("(C)");
                    continue block5;
                }
                case '\u00ae': {
                    dst.append("(R)");
                    continue block5;
                }
                case '\u2122': {
                    dst.append("(TM)");
                    continue block5;
                }
                default: {
                    if ((c & 0xFF00) != 0) {
                        dst.append('?');
                        continue block5;
                    }
                    dst.append(c);
                }
            }
        }
        return dst.toString();
    }

    private Dict createTopDict(OpenTypeFont otf, boolean cidFont) throws InvalidFontException, UnsupportedFontException, UnsupportedEncodingException {
        Double underThick;
        Double underPos;
        Double italicangle;
        Boolean fixedPitch;
        String weight;
        String familyname;
        String fullname;
        String copyright;
        String notice;
        String version;
        Name otfName;
        String registry = cidFont ? "Adobe" : null;
        String ordering = cidFont ? "Identity" : null;
        Matrix fontMatrix = cidFont ? null : new Matrix(1.0 / otf.getUnitsPerEmX(), 0.0, 0.0, 1.0 / otf.getUnitsPerEmY(), 0.0, 0.0);
        String postscript = "/OrigFontType /" + OrigFontType.kTRUETYPE + " def";
        String fontname = otf.getXDCFontDescription(null).getPostscriptName();
        if (fontname == null || fontname.length() == 0 || fontname.charAt(0) == '\u0000') {
            fontname = "unknown";
        }
        if ((otfName = otf.name) != null) {
            version = this.nameGet(otfName.selectName(5));
            notice = this.nameGet(otfName.selectName(7));
            copyright = this.nameGet(otfName.selectName(13));
            fullname = this.nameGet(otfName.selectName(4));
            familyname = this.nameGet(otfName.selectName(1));
            weight = this.nameGet(otfName.selectName(2));
        } else {
            weight = null;
            familyname = null;
            fullname = null;
            copyright = null;
            notice = null;
            version = null;
        }
        if (otf.post != null) {
            fixedPitch = new Boolean(otf.post.isFixedPitch());
            italicangle = new Double(F16Dot16.toDouble(-otf.post.getItalicAngle()));
            underPos = new Double(otf.post.getUnderlinePosition());
            underThick = new Double(otf.post.getUnderlineThickness());
        } else {
            fixedPitch = Boolean.FALSE;
            italicangle = new Double(0.0);
            underPos = new Double(-100.0);
            underThick = new Double(50.0);
        }
        Rect bbox = otf.head.getFontBBox();
        Integer paintType = null;
        Integer uniqueID = null;
        Double strokewidth = null;
        int[] xuid = null;
        Integer fsType = null;
        int[] bfBlend = null;
        String basefontname = null;
        return new Dict(registry, ordering, 0, version, notice, copyright, fullname, fontname, familyname, weight, fixedPitch, italicangle, underPos, underThick, paintType, uniqueID, bbox, strokewidth, xuid, postscript, fsType, bfBlend, basefontname, fontMatrix);
    }

    private Dict createPrivateDict(double nominalWidth, double defaultWidth, ZoneHint zoneHint) {
        double[] blueValues = null;
        double[] otherBlues = null;
        Double blueScale = null;
        Integer blueFuzz = null;
        Double blueShift = null;
        Double stdVW = null;
        Double stdHW = null;
        if (zoneHint != null) {
            blueValues = zoneHint.getBlueValues();
            if (blueValues != null) {
                otherBlues = zoneHint.getOtherBlues();
                blueScale = new Double(zoneHint.getBlueScale());
                blueFuzz = new Integer(zoneHint.getBlueFuzz());
                blueShift = new Double(zoneHint.getBlueShift());
            }
            stdHW = new Double(zoneHint.getStdHStem());
            stdVW = new Double(zoneHint.getStdVStem());
        }
        return new Dict(blueValues, otherBlues, null, null, blueScale, blueShift, blueFuzz, stdHW == 0.0 ? null : stdHW, stdVW == 0.0 ? null : stdVW, null, null, null, null, null, null, new Double(nominalWidth), new Double(defaultWidth));
    }

    public void streamForCFF(OpenTypeFont otf, Map tables, boolean removeOverlaps) throws UnsupportedFontException, InvalidFontException, IOException {
        this.subsetAndStreamForCFF(null, otf, tables, removeOverlaps);
    }

    private boolean checkSubrizeLimit(Subset subset, OpenTypeFont otf) throws InvalidFontException, UnsupportedFontException {
        if (this.glyf.data == null) {
            return false;
        }
        int glyfSize = this.glyf.data.getSize();
        if (glyfSize <= 614400) {
            return true;
        }
        if (subset == null) {
            return false;
        }
        return (double)glyfSize * (double)subset.getNumGlyphs() <= 614400.0 * (double)otf.getNumGlyphs();
    }

    public void subsetAndStreamForCFF(Subset subset, OpenTypeFont otf, Map tables, boolean removeOverlaps) throws UnsupportedFontException, InvalidFontException, IOException {
        String fontName;
        double width;
        int i;
        Type2CStringGenerator t2StringGenerator;
        ZoneHint zoneHint = null;
        AutoColor autoColor = null;
        boolean enableHinting = true;
        if (subset == null) {
            subset = new SubsetDefaultImpl(otf.getNumGlyphs(), false);
        }
        boolean enableSubrizer = this.checkSubrizeLimit(subset, otf);
        if (!removeOverlaps) {
            t2StringGenerator = new Type2CStringGenerator(subset.getNumGlyphs(), 1, enableSubrizer);
            for (i = 0; i < subset.getNumGlyphs(); ++i) {
                width = otf.getHorizontalAdvance(subset.getFullGid(i));
                t2StringGenerator.newGlyph(i, 0, width, 0.0);
                otf.getGlyphOutline(subset.getFullGid(i), t2StringGenerator, 2);
            }
        } else {
            NonOverlappingOutlineConsumer iSectOC;
            if (enableHinting) {
                zoneHint = new ZoneHint(otf);
            }
            t2StringGenerator = new Type2CStringGenerator(subset.getNumGlyphs(), 1, enableSubrizer);
            if (enableHinting) {
                autoColor = new AutoColor(t2StringGenerator, otf.getUnitsPerEmY(), 6, true, false, zoneHint.getTopZones(), zoneHint.getBottomZones());
                iSectOC = new NonOverlappingOutlineConsumer(autoColor, otf.getUnitsPerEmY());
            } else {
                iSectOC = new NonOverlappingOutlineConsumer(t2StringGenerator, otf.getUnitsPerEmY());
            }
            for (i = 0; i < subset.getNumGlyphs(); ++i) {
                width = otf.getHorizontalAdvance(subset.getFullGid(i));
                if (enableHinting) {
                    autoColor.newGlyph(i, width, 0);
                }
                t2StringGenerator.newGlyph(i, 0, width, 0.0);
                otf.getGlyphOutline(subset.getFullGid(i), iSectOC, 2);
            }
        }
        if ((fontName = otf.getXDCFontDescription(null).getPostscriptName()) == null || fontName.length() == 0 || fontName.charAt(0) == '\u0000') {
            fontName = "unknown";
        }
        double nominalWidth = t2StringGenerator.calculateNominalWidth(0);
        double defaultWidth = t2StringGenerator.calculateDefaultWidth(0);
        CharStrings charStrings = t2StringGenerator.getCharstringIndex();
        CharStrings lSubrStrings = null;
        CharStrings gSubrStrings = null;
        if (enableSubrizer) {
            CFFSubrize subrizer = new CFFSubrize();
            charStrings = subrizer.subrize(charStrings);
            lSubrStrings = subrizer.getLSubrs();
            gSubrStrings = subrizer.getGSubrs();
        }
        Dict topDict = this.createTopDict(otf, true);
        Dict privateDict = this.createPrivateDict(nominalWidth, defaultWidth, zoneHint);
        OTByteArray.OTByteArrayBuilder.OTByteArrayBuilderOutputStreamAdaptor stream = new OTByteArray.OTByteArrayBuilder.OTByteArrayBuilderOutputStreamAdaptor();
        Dict cidDict = new Dict(new Matrix(1.0 / otf.getUnitsPerEmX(), 0.0, 0.0, 1.0 / otf.getUnitsPerEmY(), 0.0, 0.0));
        CIDKeyedFont ckFont = new CIDKeyedFont(fontName, topDict, charStrings, subset.getNumGlyphs(), cidDict, privateDict, lSubrStrings, gSubrStrings);
        ckFont.subsetAndStream(subset, stream, false, null, false, false);
        tables.put(new Integer(1128678944), stream.getBuilder());
    }

    public static interface CoordFlags {
        public static final int ON_CURVE = 1;
        public static final int X_SHORT_VECTOR = 2;
        public static final int Y_SHORT_VECTOR = 4;
        public static final int REPEAT = 8;
        public static final int THIS_X_IS_SAME = 16;
        public static final int THIS_Y_IS_SAME = 32;
    }

    public static interface Flags {
        public static final int ARG_1_AND_2_ARE_WORDS = 1;
        public static final int ARGS_ARE_XY_VALUES = 2;
        public static final int ROUND_XY_TO_GRID = 4;
        public static final int WE_HAVE_A_SCALE = 8;
        public static final int MORE_COMPONENTS = 32;
        public static final int WE_HAVE_AN_X_AND_Y_SCALE = 64;
        public static final int WE_HAVE_A_TWO_BY_TWO = 128;
        public static final int WE_HAVE_INSTRUCTIONS = 256;
        public static final int USE_MY_METRICS = 512;
        public static final int OVERLAP_COMPOUND = 1024;
        public static final int SCALED_COMPONENT_OFFSET = 2048;
        public static final int UNSCALED_COMPONENT_OFFSET = 4096;
    }
}

