/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font.opentype;

import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.Subset;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.font.opentype.LayoutTable;
import com.adobe.fontengine.font.opentype.LayoutTableSubsetter;
import com.adobe.fontengine.font.opentype.LookupTableSubsetter;
import com.adobe.fontengine.font.opentype.OTByteArray;
import com.adobe.fontengine.font.opentype.SetGenerator;
import java.util.Arrays;
import java.util.Map;

class ChainingGenerator {
    private static final boolean warnAboutDroppedSublookups = false;

    ChainingGenerator() {
    }

    static LookupTableSubsetter.LookupSubtableGenerator newChainingInstance(LayoutTable origTable, OTByteArray.OTByteArrayBuilder builder, int origSTOffset, int newSTOffset, Subset subset, Map newCoverages, LookupTableSubsetter.LookupSubset lookupSubset, int origNumGlyphs) throws InvalidFontException {
        int format = origTable.data.getuint16(origSTOffset);
        switch (format) {
            case 1: {
                return ChainingFormat1Generator.newInstance(origSTOffset, newSTOffset, origTable, subset, builder, newCoverages, lookupSubset);
            }
            case 2: {
                return ChainingFormat2Generator.newInstance(origSTOffset, newSTOffset, origTable, subset, builder, lookupSubset, origNumGlyphs);
            }
            case 3: {
                return ChainingFormat3Generator.newInstance(origTable, builder, origSTOffset, newSTOffset, lookupSubset);
            }
        }
        throw new InvalidFontException("Invalid chaining contextual lookup format: " + format);
    }

    static void gatherCoveragesForSubtable(LayoutTable origTable, int stOffset, int lookupType, int lookupIndex, Integer subtableIndex, Map coverageMapToUse, Subset subset) throws InvalidFontException, UnsupportedFontException {
        int stFormat = origTable.data.getuint16(stOffset);
        switch (stFormat) {
            case 1: 
            case 2: {
                int coverageOffset = origTable.data.getOffset(stOffset, 2);
                LookupTableSubsetter.addToCoveragesMap(origTable, coverageOffset, coverageMapToUse, lookupIndex, subtableIndex, subset);
                break;
            }
            case 3: {
                int coverageOffset;
                int j;
                int coverageCount = origTable.data.getuint16(stOffset + 2);
                for (int j2 = 0; j2 < coverageCount; ++j2) {
                    int coverageOffset2 = origTable.data.getOffset(stOffset, 4 + 2 * j2);
                    LookupTableSubsetter.addToCoveragesMap(origTable, coverageOffset2, coverageMapToUse, lookupIndex, subtableIndex, subset);
                }
                int delta = 4 + 2 * coverageCount;
                coverageCount = origTable.data.getuint16(stOffset + delta);
                for (j = 0; j < coverageCount; ++j) {
                    coverageOffset = origTable.data.getOffset(stOffset, delta + 2 + 2 * j);
                    LookupTableSubsetter.addToCoveragesMap(origTable, coverageOffset, coverageMapToUse, lookupIndex, subtableIndex, subset);
                }
                delta += 2 + 2 * coverageCount;
                coverageCount = origTable.data.getuint16(stOffset + delta);
                for (j = 0; j < coverageCount; ++j) {
                    coverageOffset = origTable.data.getOffset(stOffset, delta + 2 + 2 * j);
                    LookupTableSubsetter.addToCoveragesMap(origTable, coverageOffset, coverageMapToUse, lookupIndex, subtableIndex, subset);
                }
                break;
            }
            default: {
                throw new InvalidFontException("Invalid contextual subtable format (" + stFormat + ")");
            }
        }
    }

    static void patchSubtableCoverage(LayoutTable origTable, OTByteArray.OTByteArrayBuilder builder, int origSTOffset, int newSTOffset, Map coverageInfo, int lookupType) throws InvalidFontException {
        int format = origTable.data.getuint16(origSTOffset);
        switch (format) {
            case 1: 
            case 2: {
                LookupTableSubsetter.patchCoverageAtOffset(origTable, builder, origSTOffset, newSTOffset, 2, coverageInfo);
                break;
            }
            case 3: {
                int i;
                int backTrackCount = origTable.data.getuint16(origSTOffset + 2);
                int inputCount = origTable.data.getuint16(origSTOffset + 4 + 2 * backTrackCount);
                int lookaheadCount = origTable.data.getuint16(origSTOffset + 6 + 2 * backTrackCount + 2 * inputCount);
                for (i = 0; i < backTrackCount; ++i) {
                    LookupTableSubsetter.patchCoverageAtOffset(origTable, builder, origSTOffset, newSTOffset, 4 + 2 * i, coverageInfo);
                }
                for (i = 0; i < inputCount; ++i) {
                    LookupTableSubsetter.patchCoverageAtOffset(origTable, builder, origSTOffset, newSTOffset, 6 + 2 * backTrackCount + 2 * i, coverageInfo);
                }
                for (i = 0; i < lookaheadCount; ++i) {
                    LookupTableSubsetter.patchCoverageAtOffset(origTable, builder, origSTOffset, newSTOffset, 8 + 2 * inputCount + 2 * backTrackCount + 2 * i, coverageInfo);
                }
                break;
            }
            default: {
                throw new InvalidFontException("Unrecognized lookup type 6 format: " + format);
            }
        }
    }

    private static class ChainingFormat3Generator
    implements LookupTableSubsetter.LookupSubtableGenerator {
        private final LayoutTable origTable;
        private final OTByteArray.OTByteArrayBuilder builder;
        private int origSTOffset;
        private int newSTOffset;
        private final LookupTableSubsetter.LookupSubset lookupSubset;

        private ChainingFormat3Generator(LayoutTable origTable, OTByteArray.OTByteArrayBuilder builder, int origSTOffset, int newSTOffset, LookupTableSubsetter.LookupSubset lookupSubset) {
            this.origTable = origTable;
            this.builder = builder;
            this.origSTOffset = origSTOffset;
            this.newSTOffset = newSTOffset;
            this.lookupSubset = lookupSubset;
        }

        static ChainingFormat3Generator newInstance(LayoutTable origTable, OTByteArray.OTByteArrayBuilder builder, int origSTOffset, int newSTOffset, LookupTableSubsetter.LookupSubset lookupSubset) {
            return new ChainingFormat3Generator(origTable, builder, origSTOffset, newSTOffset, lookupSubset);
        }

        @Override
        public int writeSubtable() throws InvalidFontException {
            int backTrackCount = this.origTable.data.getuint16(this.origSTOffset + 2);
            this.origSTOffset += 4 + 2 * backTrackCount;
            int inputCount = this.origTable.data.getuint16(this.origSTOffset);
            this.origSTOffset += 2 + 2 * inputCount;
            int lookaheadCount = this.origTable.data.getuint16(this.origSTOffset);
            this.origSTOffset += 2 + 2 * lookaheadCount;
            int substCount = this.origTable.data.getuint16(this.origSTOffset);
            this.origSTOffset += 2;
            int size = 10 + 2 * backTrackCount + 2 * inputCount + 2 * lookaheadCount;
            this.builder.ensureCapacity(this.newSTOffset + size);
            this.builder.setuint16(this.newSTOffset, 3);
            this.builder.setuint16(this.newSTOffset + 2, backTrackCount);
            this.newSTOffset += 4 + 2 * backTrackCount;
            this.builder.setuint16(this.newSTOffset, inputCount);
            this.newSTOffset += 2 + 2 * inputCount;
            this.builder.setuint16(this.newSTOffset, lookaheadCount);
            this.newSTOffset += 2 + 2 * lookaheadCount;
            int newSubstCount = 0;
            for (int i = 0; i < substCount; ++i) {
                int newValue = this.lookupSubset.getExistingSubsetGid(this.origTable.data.getuint16(this.origSTOffset + 4 * i + 2));
                if (newValue == -1) continue;
                this.builder.ensureCapacity(this.newSTOffset + (size += 4));
                this.builder.setuint16(this.newSTOffset + 2 + 4 * newSubstCount, this.origTable.data.getuint16(this.origSTOffset + 4 * i));
                this.builder.setuint16(this.newSTOffset + 2 + 4 * newSubstCount + 2, newValue);
                ++newSubstCount;
            }
            this.builder.setuint16(this.newSTOffset, newSubstCount);
            return size;
        }
    }

    private static class ChainingFormat2Generator
    extends SetGenerator
    implements LayoutTable.CoverageConsumer {
        private final LookupTableSubsetter.LookupSubset lookupSubset;
        private final LayoutTableSubsetter.ClassCoveredBySubset classCovered;
        private final int numGlyphs;
        private final int classCount;

        private ChainingFormat2Generator(LayoutTable origTable, Subset subset, OTByteArray.OTByteArrayBuilder newData, int newSTOffset, int origSTOffset, int classCount, LookupTableSubsetter.LookupSubset lookupSubset, int numGlyphs) throws InvalidFontException {
            super(origTable, subset, newData, newSTOffset, origSTOffset, classCount, 10, true, true);
            this.lookupSubset = lookupSubset;
            this.classCovered = new LayoutTableSubsetter.ClassCoveredBySubset(subset);
            this.numGlyphs = numGlyphs;
            this.classCount = classCount;
        }

        static ChainingFormat2Generator newInstance(int origSTOffset, int newSTOffset, LayoutTable origTable, Subset subset, OTByteArray.OTByteArrayBuilder newData, LookupTableSubsetter.LookupSubset lookupSubset, int numGlyphs) throws InvalidFontException {
            int classCount = origTable.data.getuint16(origSTOffset + 10);
            return new ChainingFormat2Generator(origTable, subset, newData, newSTOffset, origSTOffset, classCount, lookupSubset, numGlyphs);
        }

        @Override
        boolean[] computeMembersToKeep(int newRuleSetOffset, int origRuleSetOffset) throws InvalidFontException, UnsupportedFontException {
            int origRuleCount = this.origTable.data.getuint16(origRuleSetOffset);
            boolean[] keep = new boolean[origRuleCount];
            Arrays.fill(keep, true);
            block0: for (int i = 0; i < origRuleCount; ++i) {
                int j;
                int ruleOffset = this.origTable.data.getOffset(origRuleSetOffset, 2 + 2 * i);
                int delta = 2;
                int glyphCount = this.origTable.data.getuint16(ruleOffset);
                int origClassDefOffset = this.origTable.data.getOffset(this.origSTOffset, 4);
                for (j = 0; j < glyphCount; ++j) {
                    if (this.classCovered.classCoveredBySubset(this.origTable, origClassDefOffset, this.numGlyphs, this.origTable.data.getuint16(ruleOffset + delta + 2 * j))) continue;
                    keep[i] = false;
                    break;
                }
                delta += 2 * glyphCount;
                origClassDefOffset = this.origTable.data.getOffset(this.origSTOffset, 6);
                glyphCount = this.origTable.data.getuint16(ruleOffset + delta);
                delta += 2;
                for (j = 0; j < glyphCount - 1; ++j) {
                    if (this.classCovered.classCoveredBySubset(this.origTable, origClassDefOffset, this.numGlyphs, this.origTable.data.getuint16(ruleOffset + delta + 2 * j))) continue;
                    keep[i] = false;
                    break;
                }
                delta += 2 * (glyphCount - 1);
                origClassDefOffset = this.origTable.data.getOffset(this.origSTOffset, 8);
                glyphCount = this.origTable.data.getuint16(ruleOffset + delta);
                delta += 2;
                for (j = 0; j < glyphCount; ++j) {
                    if (this.classCovered.classCoveredBySubset(this.origTable, origClassDefOffset, this.numGlyphs, this.origTable.data.getuint16(ruleOffset + delta + 2 * j))) continue;
                    keep[i] = false;
                    continue block0;
                }
            }
            return keep;
        }

        @Override
        int writeMember(int newSubRuleOffset, int origSubRuleOffset) throws InvalidFontException, UnsupportedFontException {
            int i;
            int backtrackCount = this.origTable.data.getuint16(origSubRuleOffset);
            int inputCount = this.origTable.data.getuint16(origSubRuleOffset + 2 + 2 * backtrackCount);
            int lookahead = this.origTable.data.getuint16(origSubRuleOffset + 2 + 2 * backtrackCount + 2 + 2 * (inputCount - 1));
            int substCount = this.origTable.data.getuint16(origSubRuleOffset + 2 + 2 * backtrackCount + 2 + 2 * (inputCount - 1) + 2 + 2 * lookahead);
            int lSize = 2 + 2 * backtrackCount + 2 + 2 * (inputCount - 1) + 2 + 2 * lookahead + 2;
            this.builder.ensureCapacity(newSubRuleOffset + lSize);
            this.builder.setuint16(newSubRuleOffset, backtrackCount);
            int delta = 2;
            for (i = 0; i < backtrackCount; ++i) {
                this.builder.setuint16(newSubRuleOffset + delta, this.origTable.data.getuint16(origSubRuleOffset + delta));
                delta += 2;
            }
            this.builder.setuint16(newSubRuleOffset + delta, inputCount);
            delta += 2;
            for (i = 0; i < inputCount - 1; ++i) {
                this.builder.setuint16(newSubRuleOffset + delta, this.origTable.data.getuint16(origSubRuleOffset + delta));
                delta += 2;
            }
            this.builder.setuint16(newSubRuleOffset + delta, lookahead);
            delta += 2;
            for (i = 0; i < lookahead; ++i) {
                this.builder.setuint16(newSubRuleOffset + delta, this.origTable.data.getuint16(origSubRuleOffset + delta));
                delta += 2;
            }
            int substcountDelta = delta;
            int newSubstCount = 0;
            delta += 2;
            for (int i2 = 0; i2 < substCount; ++i2) {
                int newLookup = this.lookupSubset.getExistingSubsetGid(this.origTable.data.getuint16(origSubRuleOffset + delta + 2));
                if (newLookup != -1) {
                    this.builder.ensureCapacity(newSubRuleOffset + lSize + 4);
                    this.builder.setuint16(newSubRuleOffset + lSize, this.origTable.data.getuint16(origSubRuleOffset + delta));
                    this.builder.setuint16(newSubRuleOffset + lSize + 2, newLookup);
                    lSize += 4;
                    ++newSubstCount;
                }
                delta += 4;
            }
            this.builder.setuint16(newSubRuleOffset + substcountDelta, newSubstCount);
            return lSize;
        }

        void writeClassDef(int stOffsetDelta) throws InvalidFontException, UnsupportedFontException {
            LayoutTableSubsetter.ClassDefGenerator generator = LayoutTableSubsetter.ClassDefGenerator.newInstance(this.origTable, this.origTable.data.getOffset(this.origSTOffset, stOffsetDelta), this.subset, this.numGlyphs);
            this.builder.setuint16(this.newSTOffset + stOffsetDelta, this.subtableSize);
            OTByteArray array = generator.generateClass().toOTByteArray();
            this.subtableSize += this.writeByteArrayAtOffset(this.newSTOffset + this.subtableSize, array);
        }

        @Override
        int whichRuleSetIndexApplies(int gid, int coverageIndex) throws InvalidFontException {
            return this.origTable.getClassIndex(gid, this.origTable.data.getOffset(this.origSTOffset, 6));
        }

        @Override
        int getOrigRecordSize() {
            return 0;
        }

        @Override
        public int writeSubtable() throws InvalidFontException, UnsupportedFontException {
            int coverageOffset = this.origTable.data.getOffset(this.origSTOffset, 2);
            this.builder.ensureCapacity(this.newSTOffset + 12 + 2 * this.classCount);
            this.builder.setuint16(this.newSTOffset, 2);
            this.builder.setuint16(this.newSTOffset + 10, this.classCount);
            this.origTable.iterateCoverage(coverageOffset, this.subset, this);
            this.writeClassDef(4);
            this.writeClassDef(6);
            this.writeClassDef(8);
            return this.subtableSize;
        }
    }

    private static class ChainingFormat1Generator
    extends SetGenerator
    implements LayoutTable.CoverageConsumer {
        private final LookupTableSubsetter.LookupSubset lookupSubset;
        private final int ruleCount;

        private ChainingFormat1Generator(LayoutTable origTable, Subset subset, OTByteArray.OTByteArrayBuilder newData, int newSTOffset, int origSTOffset, int subRuleSetCount, LookupTableSubsetter.LookupSubset lookupSubset) throws InvalidFontException {
            super(origTable, subset, newData, newSTOffset, origSTOffset, subRuleSetCount, 4, false, true);
            this.lookupSubset = lookupSubset;
            this.ruleCount = subRuleSetCount;
        }

        static ChainingFormat1Generator newInstance(int origSTOffset, int newSTOffset, LayoutTable origTable, Subset subset, OTByteArray.OTByteArrayBuilder builder, Map newCoverages, LookupTableSubsetter.LookupSubset lookupSubset) throws InvalidFontException {
            int coverageOffset = origTable.data.getOffset(origSTOffset, 2);
            LookupTableSubsetter.NewCoverage newCoverage = (LookupTableSubsetter.NewCoverage)newCoverages.get(new Integer(coverageOffset));
            return new ChainingFormat1Generator(origTable, subset, builder, newSTOffset, origSTOffset, newCoverage.glyphCount, lookupSubset);
        }

        @Override
        boolean[] computeMembersToKeep(int newRuleSetOffset, int origRuleSetOffset) throws InvalidFontException, UnsupportedFontException {
            int origRuleCount = this.origTable.data.getuint16(origRuleSetOffset);
            boolean[] keep = new boolean[origRuleCount];
            Arrays.fill(keep, true);
            block0: for (int i = 0; i < origRuleCount; ++i) {
                int ruleOffset = this.origTable.data.getOffset(origRuleSetOffset, 2 + 2 * i);
                int backtrackCount = this.origTable.data.getuint16(ruleOffset);
                for (int j = 0; j < backtrackCount; ++j) {
                    if (this.subset.getExistingSubsetGid(this.origTable.data.getuint16(ruleOffset + 2 + 2 * j)) != -1) continue;
                    keep[i] = false;
                    break;
                }
                if (!keep[i]) continue;
                int inputCount = this.origTable.data.getuint16(ruleOffset + 2 + 2 * backtrackCount);
                for (int j = 0; j < inputCount - 1; ++j) {
                    if (this.subset.getExistingSubsetGid(this.origTable.data.getuint16(ruleOffset + 4 + 2 * backtrackCount + 2 * j)) != -1) continue;
                    keep[i] = false;
                    break;
                }
                if (!keep[i]) continue;
                int lookahead = this.origTable.data.getuint16(ruleOffset + 4 + 2 * (inputCount - 1) + 2 * backtrackCount);
                for (int j = 0; j < lookahead; ++j) {
                    if (this.subset.getExistingSubsetGid(this.origTable.data.getuint16(ruleOffset + 6 + 2 * (inputCount - 1) + 2 * backtrackCount + 2 * j)) != -1) continue;
                    keep[i] = false;
                    continue block0;
                }
            }
            return keep;
        }

        @Override
        int writeMember(int newSubRuleOffset, int origSubRuleOffset) throws InvalidFontException, UnsupportedFontException {
            int gid;
            int i;
            int backTrackCount = this.origTable.data.getuint16(origSubRuleOffset);
            int inputCount = this.origTable.data.getuint16(origSubRuleOffset + 2 + 2 * backTrackCount);
            int lookaheadCount = this.origTable.data.getuint16(origSubRuleOffset + 4 + 2 * backTrackCount + 2 * (inputCount - 1));
            int substCount = this.origTable.data.getuint16(origSubRuleOffset + 6 + 2 * backTrackCount + 2 * (inputCount - 1) + 2 * lookaheadCount);
            int lSize = 8 + 2 * backTrackCount + 2 * (inputCount - 1) + 2 * lookaheadCount;
            this.builder.ensureCapacity(newSubRuleOffset + lSize);
            this.builder.setuint16(newSubRuleOffset, backTrackCount);
            for (i = 0; i < backTrackCount; ++i) {
                gid = this.subset.getExistingSubsetGid(this.origTable.data.getuint16(origSubRuleOffset + 2 + 2 * i));
                if (gid == -1) {
                    throw new RuntimeException("Backtrack gid not in subset? Can't happen!");
                }
                this.builder.setuint16(newSubRuleOffset + 2 + 2 * i, gid);
            }
            origSubRuleOffset += 2 + 2 * backTrackCount;
            this.builder.setuint16(newSubRuleOffset += 2 + 2 * backTrackCount, inputCount);
            for (i = 0; i < inputCount - 1; ++i) {
                gid = this.subset.getExistingSubsetGid(this.origTable.data.getuint16(origSubRuleOffset + 2 + 2 * i));
                if (gid == -1) {
                    throw new RuntimeException("Input gid not in subset? Can't happen!");
                }
                this.builder.setuint16(newSubRuleOffset + 2 + 2 * i, gid);
            }
            origSubRuleOffset += 2 + 2 * (inputCount - 1);
            this.builder.setuint16(newSubRuleOffset += 2 + 2 * (inputCount - 1), lookaheadCount);
            for (i = 0; i < lookaheadCount; ++i) {
                gid = this.subset.getExistingSubsetGid(this.origTable.data.getuint16(origSubRuleOffset + 2 + 2 * i));
                if (gid == -1) {
                    throw new RuntimeException("Lookahead gid not in subset? Can't happen!");
                }
                this.builder.setuint16(newSubRuleOffset + 2 + 2 * i, gid);
            }
            newSubRuleOffset += 2 + 2 * lookaheadCount;
            origSubRuleOffset += 2 + 2 * lookaheadCount;
            int newSubstCount = 0;
            for (int i2 = 0; i2 < substCount; ++i2) {
                int lookup = this.lookupSubset.getExistingSubsetGid(this.origTable.data.getuint16(origSubRuleOffset + 2 + 4 * i2 + 2));
                if (lookup == -1) continue;
                this.builder.ensureCapacity(newSubRuleOffset + (lSize += 4));
                this.builder.setuint16(newSubRuleOffset + 2 + 4 * newSubstCount, this.origTable.data.getuint16(origSubRuleOffset + 2 + 4 * i2));
                this.builder.setuint16(newSubRuleOffset + 2 + 4 * newSubstCount + 2, lookup);
                ++newSubstCount;
            }
            this.builder.setuint16(newSubRuleOffset, newSubstCount);
            return lSize;
        }

        @Override
        int whichRuleSetIndexApplies(int gid, int coverageIndex) {
            return coverageIndex;
        }

        @Override
        int getOrigRecordSize() {
            return 0;
        }

        private void writeHeader(int newSTOffset, int glyphCount) {
            this.builder.ensureCapacity(newSTOffset + 6 + 2 * glyphCount);
            this.builder.setuint16(newSTOffset, 1);
            this.builder.setuint16(newSTOffset + 4, glyphCount);
        }

        @Override
        public int writeSubtable() throws InvalidFontException, UnsupportedFontException {
            int coverageOffset = this.origTable.data.getOffset(this.origSTOffset, 2);
            this.writeHeader(this.newSTOffset, this.ruleCount);
            this.origTable.iterateCoverage(coverageOffset, this.subset, this);
            return super.writeSubtable();
        }
    }
}

