/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font.opentype;

import com.adobe.fontengine.font.FontByteArray;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.Subset;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.font.opentype.OTByteArray;
import com.adobe.fontengine.font.opentype.Orientation;
import com.adobe.fontengine.font.opentype.Table;
import com.adobe.fontengine.font.opentype.Tag;
import java.io.IOException;
import java.util.Map;

public final class Base
extends Table {
    protected Base(FontByteArray buffer) throws IOException, InvalidFontException, UnsupportedFontException {
        super(buffer);
        int majorVersion = this.getTableMajorVersion();
        if (majorVersion != 1) {
            throw new UnsupportedFontException("'BASE' tables with major version " + majorVersion + "are not supported");
        }
    }

    public int getTableMajorVersion() throws InvalidFontException {
        return this.data.getuint16(0);
    }

    public int getTableMinorVersion() throws InvalidFontException {
        return this.data.getuint16(2);
    }

    public int getBaselinePosition(Orientation o, int scriptTag, int baselineTag) throws InvalidFontException {
        int axisTableOffset = this.data.getOffset(0, o == Orientation.HORIZONTAL ? 4 : 6);
        if (axisTableOffset == 0) {
            return Integer.MAX_VALUE;
        }
        int baseTagListOffset = this.data.getOffset(axisTableOffset, 0);
        if (baseTagListOffset == 0) {
            return Integer.MAX_VALUE;
        }
        int baselineIndex = -1;
        int baseTagCount = this.data.getuint16(baseTagListOffset);
        for (int b = 0; b < baseTagCount; ++b) {
            if (this.data.getuint32(baseTagListOffset + 2 + 4 * b) != (long)baselineTag) continue;
            baselineIndex = b;
            break;
        }
        if (baselineIndex == -1) {
            return Integer.MAX_VALUE;
        }
        int baseScriptListOffset = this.data.getOffset(axisTableOffset, 2);
        int baseScriptCount = this.data.getuint16(baseScriptListOffset);
        int baseScriptIndex = -1;
        for (int s = 0; s < baseScriptCount; ++s) {
            if (Tag.script_DFLT == scriptTag || this.data.getuint32(baseScriptListOffset + 2 + 6 * s) == (long)scriptTag) {
                baseScriptIndex = s;
                break;
            }
            if (baseScriptIndex != -1 || this.data.getuint32(baseScriptListOffset + 2 + 6 * s) != (long)Tag.script_DFLT) continue;
            baseScriptIndex = s;
            break;
        }
        if (baseScriptIndex == -1) {
            return Integer.MAX_VALUE;
        }
        int baseScriptOffset = this.data.getOffset(baseScriptListOffset, 2 + 6 * baseScriptIndex + 4);
        int baseValuesOffset = this.data.getOffset(baseScriptOffset, 0);
        if (baseValuesOffset == 0) {
            return Integer.MAX_VALUE;
        }
        int baseCoordOffset = this.data.getOffset(baseValuesOffset, 4 + 2 * baselineIndex);
        return this.data.getint16(baseCoordOffset + 2);
    }

    private boolean baseCoordNeedsRegenerated(int bcOffset) throws InvalidFontException {
        return bcOffset != 0 && this.data.getuint16(bcOffset) == 2;
    }

    private boolean minMaxNeedsRegenerated(int minMaxOffset) throws InvalidFontException {
        if (minMaxOffset == 0) {
            return false;
        }
        if (this.baseCoordNeedsRegenerated(this.data.getOffset(minMaxOffset, 0))) {
            return true;
        }
        if (this.baseCoordNeedsRegenerated(this.data.getOffset(minMaxOffset, 2))) {
            return true;
        }
        int featMinMaxCount = this.data.getuint16(minMaxOffset + 4);
        for (int i = 0; i < featMinMaxCount; ++i) {
            if (this.baseCoordNeedsRegenerated(this.data.getOffset(minMaxOffset, 6 + 8 * i + 4))) {
                return true;
            }
            if (!this.baseCoordNeedsRegenerated(this.data.getOffset(minMaxOffset, 6 + 8 * i + 6))) continue;
            return true;
        }
        return false;
    }

    private boolean axisNeedsRegenerated(int axisOffset) throws InvalidFontException {
        if (axisOffset == 0) {
            return false;
        }
        int baseScriptListOffset = this.data.getOffset(axisOffset, 2);
        int baseScriptCount = this.data.getuint16(baseScriptListOffset);
        for (int i = 0; i < baseScriptCount; ++i) {
            int defaultMinMaxOffset;
            int baseScriptOffset = this.data.getOffset(baseScriptListOffset, 2 + 6 * i + 4);
            int baseValuesOffset = this.data.getOffset(baseScriptOffset, 0);
            if (baseValuesOffset != 0) {
                int baseCoordCount = this.data.getuint16(baseValuesOffset + 2);
                for (int j = 0; j < baseCoordCount; ++j) {
                    int baseCoordOffset = this.data.getOffset(baseValuesOffset, 4 + 2 * j);
                    if (!this.baseCoordNeedsRegenerated(baseCoordOffset)) continue;
                    return true;
                }
            }
            if (this.minMaxNeedsRegenerated(defaultMinMaxOffset = this.data.getOffset(baseScriptOffset, 2))) {
                return true;
            }
            int baseLangSysCount = this.data.getuint16(baseScriptOffset + 4);
            for (int j = 0; j < baseLangSysCount; ++j) {
                int minMaxOffset = this.data.getOffset(baseScriptOffset, 6 + 6 * j + 4);
                if (!this.minMaxNeedsRegenerated(minMaxOffset)) continue;
                return true;
            }
        }
        return false;
    }

    boolean baseNeedsRegenerated() throws InvalidFontException {
        return this.axisNeedsRegenerated(this.data.getOffset(0, 4)) || this.axisNeedsRegenerated(this.data.getOffset(0, 6));
    }

    private int generateBaseCoord(OTByteArray.OTByteArrayBuilder newData, int origBCOffset, int newBCOffset) throws InvalidFontException {
        newData.ensureCapacity(newBCOffset + 4);
        newData.setuint16(newBCOffset, 1);
        newData.setint16(newBCOffset + 2, this.data.getint16(origBCOffset + 2));
        return 4;
    }

    private int generateMinMax(OTByteArray.OTByteArrayBuilder newData, int origMinMaxOffset, int newMinMaxOffset) throws InvalidFontException {
        int mmCount = this.data.getuint16(origMinMaxOffset + 4);
        int mmSize = 6 + 8 * mmCount;
        newData.ensureCapacity(newMinMaxOffset + mmSize);
        int minOffset = this.data.getOffset(origMinMaxOffset, 0);
        if (minOffset != 0) {
            newData.setuint16(newMinMaxOffset, mmSize);
            mmSize += this.generateBaseCoord(newData, minOffset, newMinMaxOffset + mmSize);
        } else {
            newData.setuint16(newMinMaxOffset, 0);
        }
        int maxOffset = this.data.getOffset(origMinMaxOffset, 2);
        if (maxOffset != 0) {
            newData.setuint16(newMinMaxOffset + 2, mmSize);
            mmSize += this.generateBaseCoord(newData, maxOffset, newMinMaxOffset + mmSize);
        } else {
            newData.setuint16(newMinMaxOffset + 2, 0);
        }
        for (int i = 0; i < mmCount; ++i) {
            for (int j = 0; j < 4; ++j) {
                newData.setuint8(newMinMaxOffset + 6 + 8 * i + j, this.data.getuint8(origMinMaxOffset + 6 + i * 8 + j));
            }
            minOffset = this.data.getOffset(origMinMaxOffset, 6 + 8 * i + 4);
            if (minOffset != 0) {
                newData.setuint16(newMinMaxOffset + 6 + 8 * i + 4, mmSize);
                mmSize += this.generateBaseCoord(newData, minOffset, newMinMaxOffset + mmSize);
            } else {
                newData.setuint16(newMinMaxOffset + 6 + 8 * i + 4, 0);
            }
            maxOffset = this.data.getOffset(origMinMaxOffset, 6 + 8 * i + 6);
            if (maxOffset != 0) {
                newData.setuint16(newMinMaxOffset + 6 + 8 * i + 6, mmSize);
                mmSize += this.generateBaseCoord(newData, maxOffset, newMinMaxOffset + mmSize);
                continue;
            }
            newData.setuint16(newMinMaxOffset + 6 + 8 * i + 6, 0);
        }
        return mmSize;
    }

    private int generateBaseValues(OTByteArray.OTByteArrayBuilder newData, int origBaseValuesOffset, int newBaseValuesOffset) throws InvalidFontException {
        int bcCount = this.data.getuint16(origBaseValuesOffset + 2);
        int bvSize = 4 + 2 * bcCount;
        newData.ensureCapacity(newBaseValuesOffset + bvSize);
        newData.setuint16(newBaseValuesOffset, this.data.getuint16(origBaseValuesOffset));
        newData.setuint16(newBaseValuesOffset + 2, bcCount);
        for (int i = 0; i < bcCount; ++i) {
            newData.setuint16(newBaseValuesOffset + 4 + 2 * i, bvSize);
            bvSize += this.generateBaseCoord(newData, this.data.getOffset(origBaseValuesOffset, 4 + 2 * i), newBaseValuesOffset + bvSize);
        }
        return bvSize;
    }

    private int generateBaseScript(OTByteArray.OTByteArrayBuilder newData, int newBaseScriptOffset, int origBaseScriptOffset) throws InvalidFontException {
        int baseLangSysCount = this.data.getuint16(origBaseScriptOffset + 4);
        int baseScriptSize = 6 + 6 * baseLangSysCount;
        newData.ensureCapacity(newBaseScriptOffset + baseScriptSize);
        int origBaseValuesOffset = this.data.getOffset(origBaseScriptOffset, 0);
        if (origBaseValuesOffset != 0) {
            newData.setuint16(newBaseScriptOffset, baseScriptSize);
            baseScriptSize += this.generateBaseValues(newData, origBaseValuesOffset, newBaseScriptOffset + baseScriptSize);
        } else {
            newData.setuint16(newBaseScriptOffset, 0);
        }
        int origDefaultMinMaxOffset = this.data.getOffset(origBaseScriptOffset, 2);
        if (origDefaultMinMaxOffset != 0) {
            newData.setuint16(newBaseScriptOffset + 2, baseScriptSize);
            baseScriptSize += this.generateMinMax(newData, origDefaultMinMaxOffset, newBaseScriptOffset + baseScriptSize);
        } else {
            newData.setuint16(newBaseScriptOffset + 2, 0);
        }
        newData.setuint16(newBaseScriptOffset + 4, baseLangSysCount);
        for (int i = 0; i < baseLangSysCount; ++i) {
            for (int j = 0; j < 4; ++j) {
                newData.setuint8(newBaseScriptOffset + 6 + 6 * i + j, this.data.getuint8(origBaseScriptOffset + 6 + i * 6 + j));
            }
            newData.setuint16(newBaseScriptOffset + 6 + 6 * i + 4, baseScriptSize);
            baseScriptSize += this.generateMinMax(newData, this.data.getOffset(origBaseScriptOffset, 6 + 6 * i + 4), newBaseScriptOffset + baseScriptSize);
        }
        return baseScriptSize;
    }

    private int generateAxis(OTByteArray.OTByteArrayBuilder newData, int originalAxisOffset, int newAxisOffset) throws InvalidFontException {
        int origBaseTagListOffset = this.data.getOffset(originalAxisOffset, 0);
        int origBaseScriptListOffset = this.data.getOffset(originalAxisOffset, 2);
        int axisSize = 4;
        newData.ensureCapacity(newAxisOffset + axisSize);
        if (origBaseTagListOffset != 0) {
            newData.setuint16(newAxisOffset, 4);
            int baseTagCount = this.data.getuint16(origBaseTagListOffset);
            int baseTagListSize = 2 + baseTagCount * 4;
            newData.ensureCapacity(newAxisOffset + (axisSize += baseTagListSize));
            for (int i = 0; i < baseTagListSize; ++i) {
                newData.setuint8(newAxisOffset + 4 + i, this.data.getuint8(origBaseTagListOffset + i));
            }
        } else {
            newData.setuint16(newAxisOffset, 0);
        }
        if (origBaseScriptListOffset != 0) {
            int baseScriptCount = this.data.getuint16(origBaseScriptListOffset);
            int newBaseScriptListOffset = newAxisOffset + axisSize;
            int lastBaseScriptSize = 0;
            int lastBaseScriptOffset = 0;
            newData.ensureCapacity(newBaseScriptListOffset + baseScriptCount * 6 + 2);
            axisSize += baseScriptCount * 6 + 2;
            newData.setuint16(newAxisOffset + 2, newBaseScriptListOffset - newAxisOffset);
            newData.setuint16(newBaseScriptListOffset, baseScriptCount);
            for (int i = 0; i < baseScriptCount; ++i) {
                int prevOffset;
                int j;
                for (j = 0; j < 4; ++j) {
                    newData.setuint8(newBaseScriptListOffset + 2 + i * 6 + j, this.data.getuint8(origBaseScriptListOffset + 2 + i * 6 + j));
                }
                int currOffset = this.data.getOffset(origBaseScriptListOffset, 2 + i * 6 + 4);
                for (j = 0; j < i && (prevOffset = this.data.getOffset(origBaseScriptListOffset, 2 + j * 6 + 4)) != currOffset; ++j) {
                }
                if (j == i) {
                    newData.setuint16(newBaseScriptListOffset + 2 + i * 6 + 4, 2 + baseScriptCount * 6 + lastBaseScriptOffset + lastBaseScriptSize);
                    lastBaseScriptOffset += lastBaseScriptSize;
                    lastBaseScriptSize = this.generateBaseScript(newData, newAxisOffset + axisSize, this.data.getOffset(origBaseScriptListOffset, 2 + i * 6 + 4));
                    axisSize += lastBaseScriptSize;
                    continue;
                }
                newData.setuint16(newBaseScriptListOffset + 2 + i * 6 + 4, newData.getuint16(newBaseScriptListOffset + 2 + j * 6 + 4));
            }
        } else {
            newData.setuint16(newAxisOffset + 2, 0);
        }
        return axisSize;
    }

    OTByteArray.OTByteArrayBuilder regenerateBaseTable() throws InvalidFontException {
        int originalVerticalOffset;
        OTByteArray.OTByteArrayBuilder newData = OTByteArray.getOTByteArrayBuilderInstance();
        newData.ensureCapacity(8);
        newData.setuint32(0, 65536);
        int originalHorizontalOffset = this.data.getOffset(0, 4);
        int horizontalOffset = originalHorizontalOffset == 0 ? 0 : 8;
        newData.setuint16(4, horizontalOffset);
        int horizontalAxisSize = 0;
        if (horizontalOffset != 0) {
            horizontalAxisSize = this.generateAxis(newData, originalHorizontalOffset, horizontalOffset);
        }
        if ((originalVerticalOffset = this.data.getOffset(0, 6)) == 0) {
            newData.setuint16(6, 0);
        } else {
            newData.setuint16(6, horizontalAxisSize + 8);
            this.generateAxis(newData, originalVerticalOffset, horizontalAxisSize + 8);
        }
        return newData;
    }

    public void subsetAndStream(Subset subset, Map tables) throws InvalidFontException {
        OTByteArray.OTByteArrayBuilder newData = this.baseNeedsRegenerated() ? this.regenerateBaseTable() : this.getDataAsByteArray();
        tables.put(new Integer(1111577413), newData);
    }

    public void stream(Map tables) {
        OTByteArray.OTByteArrayBuilder newData = this.getDataAsByteArray();
        tables.put(new Integer(1111577413), newData);
    }
}

