/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font;

import com.adobe.fontengine.font.ROS;

public final class CoolTypeScript {
    private final String name;
    private final int scriptValue;
    public static final CoolTypeScript ROMAN = new CoolTypeScript("Roman", 0);
    public static final CoolTypeScript JAPANESE = new CoolTypeScript("Japanese", 1);
    public static final CoolTypeScript TRADITIONAL_CHINESE = new CoolTypeScript("TraditionalChinese", 2);
    public static final CoolTypeScript KOREAN = new CoolTypeScript("Korean", 3);
    public static final CoolTypeScript ARABIC = new CoolTypeScript("Arabic", 4);
    public static final CoolTypeScript HEBREW = new CoolTypeScript("Hebrew", 5);
    public static final CoolTypeScript GREEK = new CoolTypeScript("Greek", 6);
    public static final CoolTypeScript CYRILLIC = new CoolTypeScript("Cyrillic", 7);
    public static final CoolTypeScript RIGHTLEFT = new CoolTypeScript("RightLeft", 8);
    public static final CoolTypeScript DEVANAGARI = new CoolTypeScript("Devanagari", 9);
    public static final CoolTypeScript GURMUKHI = new CoolTypeScript("Gurmukhi", 10);
    public static final CoolTypeScript GUJARATI = new CoolTypeScript("Gujarati", 11);
    public static final CoolTypeScript ORIYA = new CoolTypeScript("Oriya", 12);
    public static final CoolTypeScript BENGALI = new CoolTypeScript("Bengali", 13);
    public static final CoolTypeScript TAMIL = new CoolTypeScript("Tamil", 14);
    public static final CoolTypeScript TELUGU = new CoolTypeScript("Telugu", 15);
    public static final CoolTypeScript KANNADA = new CoolTypeScript("Kannada", 16);
    public static final CoolTypeScript MALAYALAM = new CoolTypeScript("Malayalam", 17);
    public static final CoolTypeScript SINHALESE = new CoolTypeScript("Sinhalese", 18);
    public static final CoolTypeScript BURMESE = new CoolTypeScript("Burmese", 19);
    public static final CoolTypeScript KHMER = new CoolTypeScript("Khmer", 20);
    public static final CoolTypeScript THAI = new CoolTypeScript("Thai", 21);
    public static final CoolTypeScript LAOTIAN = new CoolTypeScript("Laotian", 22);
    public static final CoolTypeScript GEORGIAN = new CoolTypeScript("Georgian", 23);
    public static final CoolTypeScript ARMENIAN = new CoolTypeScript("Armenian", 24);
    public static final CoolTypeScript SIMPLIFIED_CHINESE = new CoolTypeScript("SimplifiedChinese", 25);
    public static final CoolTypeScript TIBETAN = new CoolTypeScript("Tibetan", 26);
    public static final CoolTypeScript MONGOLIAN = new CoolTypeScript("Mongolian", 27);
    public static final CoolTypeScript GEEZ = new CoolTypeScript("Geez", 28);
    public static final CoolTypeScript EAST_EUROPEAN_ROMAN = new CoolTypeScript("EastEuropeanRoman", 29);
    public static final CoolTypeScript VIETNAMESE = new CoolTypeScript("Vietnamese", 30);
    public static final CoolTypeScript EXTENDED_ARABIC = new CoolTypeScript("ExtendedArabic", 31);

    private CoolTypeScript(String name, int scriptValue) {
        this.name = name;
        this.scriptValue = scriptValue;
    }

    public String toString() {
        return this.name;
    }

    public int toInt() {
        return this.scriptValue;
    }

    public static CoolTypeScript fromWellKnownROS(ROS ros) {
        if (ros == null || !"Adobe".equals(ros.registry)) {
            return null;
        }
        if ("Japan1".equals(ros.ordering) || "Japan2".equals(ros.ordering)) {
            return JAPANESE;
        }
        if ("GB1".equals(ros.ordering)) {
            return SIMPLIFIED_CHINESE;
        }
        if ("Korea1".equals(ros.ordering)) {
            return KOREAN;
        }
        if ("CNS1".equals(ros.ordering)) {
            return TRADITIONAL_CHINESE;
        }
        return null;
    }

    public static CoolTypeScript fromAnyROS(ROS ros) {
        if (ros == null) {
            return null;
        }
        if (!"Adobe".equals(ros.registry)) {
            return JAPANESE;
        }
        if (!"Identity".equals(ros.ordering)) {
            return JAPANESE;
        }
        return null;
    }
}

