/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.eventgateway.im;

import coldfusion.eventgateway.CFEvent;
import coldfusion.eventgateway.Gateway;
import coldfusion.eventgateway.GatewayHelper;
import coldfusion.eventgateway.GatewayServices;
import coldfusion.eventgateway.Logger;
import coldfusion.eventgateway.impl.EventServiceImpl;
import coldfusion.runtime.ApplicationException;
import coldfusion.server.ServiceFactory;
import coldfusion.util.FastHashtable;
import coldfusion.util.RB;
import com.zion.jbuddy.IBuddy;
import com.zion.jbuddy.IBuddyList;
import com.zion.jbuddy.IClient;
import com.zion.jbuddy.IClientFactory;
import com.zion.jbuddy.IGateway;
import com.zion.jbuddy.IJabberClient;
import com.zion.jbuddy.IMessage;
import com.zion.jbuddy.IMessageFactory;
import com.zion.jbuddy.ISametimeClient;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.Properties;

public abstract class IMGateway
implements Gateway,
IGateway {
    public static final String ONINCOMINGMESSAGE = "onIncomingMessage";
    public static final String ONADDBUDDYREQUEST = "onAddBuddyRequest";
    public static final String ONADDBUDDYRESPONSE = "onAddBuddyResponse";
    public static final String ONBUDDYSTATUS = "onBuddyStatus";
    public static final String ONIMSERVERMESSAGE = "onIMServerMessage";
    public static final String BUDDYNAME = "buddyname";
    public static final String BUDDYNICKNAME = "buddynickname";
    public static final String BUDDYGROUP = "buddygroup";
    public static final String BUDDYSTATUS = "buddystatus";
    public static final String GENERALGROUP = "General";
    public static final String MESSAGE = "MESSAGE";
    public static final String SENDER = "SENDER";
    public static final String RECIPIENT = "RECIPIENT";
    public static final String BUDDYID = "buddyID";
    public static final String COMMAND = "command";
    public static final String SUBMIT = "submit";
    public static final String CFMESSAGE = "message";
    public static final String TIMESTAMP = "timestamp";
    public static final String ACCEPT = "accept";
    public static final String DECLINE = "decline";
    public static final String NOACT = "noact";
    public static final String REASON = "reason";
    public static final String OK = "OK";
    public static final String RESOURCENAME = "ColdFusion";
    public static final String XMPPGATEWAY = "XMPP";
    public static final String SAMETIMEGATEWAY = "SAMETIME";
    public static final String SERVERIP = "serverip";
    public static final String SERVERPORT = "serverport";
    public static final int XMPPDEFAULTPORT = 5222;
    public static final int SAMETIMEEFAULTPORT = 1533;
    protected Logger logger = null;
    protected IClient imclient = null;
    protected int status = 4;
    protected boolean bound = false;
    protected String gatewayType = null;
    protected String userid = null;
    protected String password = null;
    protected String gatewayID = null;
    protected String resourceName = "ColdFusion";
    protected Properties properties = new Properties();
    protected GatewayServices gatewayService = null;
    protected int MAX_RESTART = -1;
    protected long RETRY_INTERVAL = 5L;
    protected String propsFilePath = null;
    protected Collection cfcListeners = new ArrayList(10);
    protected String onIncomingMessageFunction = "onIncomingMessageFunction";
    protected String onAddBuddyRequestFunction = "onAddBuddyRequestFunction";
    protected String onAddBuddyResponseFunction = "onAddBuddyResponseFunction";
    protected String onBuddyStatusFunction = "onBuddyStatusFunction";
    protected String onIMServerMessageFunction = "onIMServerMessageFunction";
    protected String serverip = null;
    protected String serverport = null;
    private final int MAX_USERS = 3;
    private static FastHashtable DeveloperVersionUserList = new FastHashtable();

    public IMGateway(String id, String configPath, String gt) {
        this.gatewayID = id;
        this.propsFilePath = configPath;
        this.gatewayType = gt;
        this.gatewayService = GatewayServices.getGatewayServices();
        this.logger = this.gatewayService.getLogger();
        this.loadconfig();
    }

    private void loadconfig() {
        try {
            this.logger.info(RB.getString((Object)this, (String)"IMGateway.init", (Object)this.gatewayType, (Object)this.gatewayID, (Object)this.propsFilePath));
            FileInputStream propsFile = new FileInputStream(this.propsFilePath);
            this.properties.clear();
            this.properties.load(propsFile);
            propsFile.close();
            this.userid = this.properties.getProperty("userid");
            this.password = this.properties.getProperty("password");
            if (this.userid == null || this.password == null) {
                throw new IMGatewayMissingUsernamePasswordException(this.gatewayType + "Gateway", this.propsFilePath);
            }
            this.resourceName = this.properties.getProperty("resourceName", RESOURCENAME);
            this.onIncomingMessageFunction = this.properties.getProperty("onIncomingMessageFunction", ONINCOMINGMESSAGE);
            this.onAddBuddyRequestFunction = this.properties.getProperty("onAddBuddyRequestFunction", ONADDBUDDYREQUEST);
            this.onAddBuddyResponseFunction = this.properties.getProperty("onAddBuddyResponseFunction", ONADDBUDDYRESPONSE);
            this.onBuddyStatusFunction = this.properties.getProperty("onBuddyStatusFunction", ONBUDDYSTATUS);
            this.onIMServerMessageFunction = this.properties.getProperty("onIMServerMessageFunction", ONIMSERVERMESSAGE);
            this.serverip = this.properties.getProperty(SERVERIP);
            this.serverport = this.properties.getProperty(SERVERPORT);
            try {
                String value = this.properties.getProperty("retries");
                if (value != null) {
                    this.MAX_RESTART = Integer.parseInt(value);
                }
                if ((value = this.properties.getProperty("retryinterval")) != null) {
                    this.RETRY_INTERVAL = Long.parseLong(value);
                    if (this.RETRY_INTERVAL < 1L) {
                        this.RETRY_INTERVAL = 1L;
                    }
                }
            }
            catch (NumberFormatException e) {
                throw new IMGatewayInvalidRetriesRetryintervalValueException(this.gatewayType + "Gateway", this.propsFilePath);
            }
        }
        catch (Exception e) {
            throw new IMGatewayUnableInitializeGatewayException(this.gatewayType + "Gateway", e);
        }
    }

    public void incomingMessage(IClient client, IMessage msg) {
        int messageType = msg.getType();
        if (messageType == 0 && this.onIncomingMessageFunction.length() == 0) {
            return;
        }
        if (messageType == 7 && this.onAddBuddyRequestFunction.length() == 0) {
            return;
        }
        if ((messageType == 5 || messageType == 6) && this.onAddBuddyResponseFunction.length() == 0) {
            return;
        }
        if (messageType == 0 || messageType == 7 || messageType == 5 || messageType == 6) {
            String[] listeners = this.getCFCListeners();
            String sender = msg.getSender();
            String recipient = msg.getRecipient();
            Object message = msg.getMessage();
            Date timestamp = msg.getTimeStamp();
            if (timestamp == null) {
                timestamp = new Date();
            }
            if (this.checkDeveloperLimitation(recipient, sender)) {
                return;
            }
            for (int i = 0; i < listeners.length; ++i) {
                boolean sent;
                String path = listeners[i];
                CFEvent cfmsg = new CFEvent(this.gatewayID);
                cfmsg.setOriginatorID(sender);
                cfmsg.setGatewayType(this.gatewayType);
                if (messageType == 0) {
                    cfmsg.setCfcMethod(this.onIncomingMessageFunction);
                } else if (messageType == 7) {
                    cfmsg.setCfcMethod(this.onAddBuddyRequestFunction);
                    message = "Requesting authorization to add '" + recipient + "' to '" + sender + "'  buddy list and view '" + recipient + "' presence.";
                } else {
                    cfmsg.setCfcMethod(this.onAddBuddyResponseFunction);
                    message = messageType == 5 ? ACCEPT : DECLINE;
                }
                FastHashtable data = new FastHashtable();
                if (message != null) {
                    data.put((Object)MESSAGE, message);
                }
                if (sender != null) {
                    data.put((Object)SENDER, (Object)sender);
                }
                if (recipient != null) {
                    data.put((Object)RECIPIENT, (Object)recipient);
                }
                data.put((Object)TIMESTAMP, (Object)timestamp);
                cfmsg.setData((Map)data);
                if (path != null) {
                    cfmsg.setCfcPath(path);
                }
                if (sent = this.gatewayService.addEvent(cfmsg)) continue;
                this.logger.error(RB.getString((Object)this, (String)"IMGateway.cantAddToQueue", (Object)this.gatewayType, (Object)this.gatewayID, (Object)(path != null ? path : "default"), (Object)Integer.toString(this.gatewayService.getQueueSize()), (Object)Integer.toString(this.gatewayService.getMaxQueueSize())));
            }
        } else if (messageType == 99 || messageType == 98) {
            this.logger.error(RB.getString((Object)this, (String)"IMGateway.receiveErrorMessage", (Object)this.gatewayType, (Object)this.gatewayID, (Object)msg.getSender(), (Object)msg.getRecipient(), (Object)msg.getMessage()));
        }
    }

    private synchronized boolean checkDeveloperLimitation(String myname, String theirname) {
        boolean bIgnoreEvent = false;
        if (ServiceFactory.getLicenseService().isDeveloper()) {
            bIgnoreEvent = true;
            String[] mybuddies = (String[])DeveloperVersionUserList.get((Object)myname);
            if (mybuddies == null) {
                mybuddies = new String[3];
                mybuddies[0] = theirname;
                DeveloperVersionUserList.put((Object)myname, (Object)mybuddies);
                bIgnoreEvent = false;
            } else {
                for (int i = 0; i < mybuddies.length; ++i) {
                    String bud = mybuddies[i];
                    if (bud == null) {
                        mybuddies[i] = theirname;
                        bIgnoreEvent = false;
                        break;
                    }
                    if (!theirname.equals(bud)) continue;
                    bIgnoreEvent = false;
                    break;
                }
            }
            if (bIgnoreEvent) {
                StringBuffer nameList = new StringBuffer();
                for (int i = 0; i < mybuddies.length; ++i) {
                    nameList.append(mybuddies[i]);
                    if (i == mybuddies.length - 1) continue;
                    nameList.append(',');
                }
                this.logger.info(RB.getString((Object)this, (String)"IMGateway.DeveloperLicense", (Object)this.gatewayType, (Object)this.gatewayID, (Object)Integer.toString(3), (Object)nameList.toString(), (Object)theirname));
            }
        }
        return bIgnoreEvent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] getCFCListeners() {
        String[] listeners;
        int size = this.cfcListeners.size();
        if (size > 0) {
            Collection collection = this.cfcListeners;
            synchronized (collection) {
                listeners = new String[size];
                this.cfcListeners.toArray(listeners);
            }
        } else {
            listeners = new String[]{null};
        }
        return listeners;
    }

    public void adminMessage(IClient client, IMessage msg) {
        this.logger.debug(this.gatewayType + "Gateway (" + this.gatewayID + ") admin message: " + msg.getMessage());
        if (this.onIMServerMessageFunction.length() == 0) {
            return;
        }
        String[] listeners = this.getCFCListeners();
        for (int i = 0; i < listeners.length; ++i) {
            boolean sent;
            String path = listeners[i];
            String sender = msg.getSender();
            String recipient = msg.getRecipient();
            String message = msg.getMessage();
            Date timestamp = msg.getTimeStamp();
            if (timestamp == null) {
                timestamp = new Date();
            }
            CFEvent cfmsg = new CFEvent(this.gatewayID);
            cfmsg.setOriginatorID(sender);
            cfmsg.setGatewayType(this.gatewayType);
            cfmsg.setCfcMethod(this.onIMServerMessageFunction);
            FastHashtable data = new FastHashtable();
            if (message != null) {
                data.put((Object)MESSAGE, (Object)message);
            }
            if (sender != null) {
                data.put((Object)SENDER, (Object)sender);
            }
            if (recipient != null) {
                data.put((Object)RECIPIENT, (Object)recipient);
            }
            data.put((Object)TIMESTAMP, (Object)timestamp);
            cfmsg.setData((Map)data);
            if (path != null) {
                cfmsg.setCfcPath(path);
            }
            if (sent = this.gatewayService.addEvent(cfmsg)) continue;
            this.logger.error(RB.getString((Object)this, (String)"IMGateway.cantAddToQueue", (Object)this.gatewayType, (Object)this.gatewayID, (Object)(path != null ? path : "default"), (Object)Integer.toString(this.gatewayService.getQueueSize()), (Object)Integer.toString(this.gatewayService.getMaxQueueSize())));
        }
    }

    public void incomingBuddy(IClient client, IBuddy buddy) {
        this.logger.debug(this.gatewayType + "Gateway (" + this.gatewayID + ") Incoming Buddy " + buddy.getName() + ": " + buddy.getStatusAsString());
        if (this.onBuddyStatusFunction.length() == 0) {
            return;
        }
        String[] listeners = this.getCFCListeners();
        for (int i = 0; i < listeners.length; ++i) {
            boolean sent;
            String path = listeners[i];
            String buddyname = buddy.getName();
            String buddynick = buddy.getNickName();
            String buddygroup = buddy.getGroup();
            Date timestamp = buddy.getStatusTimeStamp();
            if (timestamp == null) {
                timestamp = new Date();
            }
            String status = buddy.getStatusAsString();
            String recipient = client.getName();
            CFEvent cfmsg = new CFEvent(this.gatewayID);
            cfmsg.setOriginatorID(buddyname);
            cfmsg.setGatewayType(this.gatewayType);
            cfmsg.setCfcMethod(this.onBuddyStatusFunction);
            FastHashtable data = new FastHashtable();
            if (buddyname == null) continue;
            data.put((Object)BUDDYNAME, (Object)buddyname);
            if (buddynick != null) {
                data.put((Object)BUDDYNICKNAME, (Object)buddynick);
            } else {
                data.put((Object)BUDDYNICKNAME, (Object)"");
            }
            if (buddygroup != null) {
                data.put((Object)BUDDYGROUP, (Object)buddygroup);
            } else {
                data.put((Object)BUDDYGROUP, (Object)"");
            }
            if (status != null) {
                data.put((Object)BUDDYSTATUS, (Object)status);
            } else {
                data.put((Object)BUDDYSTATUS, (Object)"");
            }
            if (recipient != null) {
                data.put((Object)RECIPIENT, (Object)recipient);
            } else {
                data.put((Object)RECIPIENT, (Object)"");
            }
            data.put((Object)TIMESTAMP, (Object)timestamp);
            cfmsg.setData((Map)data);
            if (path != null) {
                cfmsg.setCfcPath(path);
            }
            if (sent = this.gatewayService.addEvent(cfmsg)) continue;
            this.logger.error(RB.getString((Object)this, (String)"IMGateway.cantAddToQueue", (Object)this.gatewayType, (Object)this.gatewayID, (Object)(path != null ? path : "default"), (Object)Integer.toString(this.gatewayService.getQueueSize()), (Object)Integer.toString(this.gatewayService.getMaxQueueSize())));
        }
    }

    public void connectionLost(IClient client, String errorMessage) {
        try {
            this.logger.info(RB.getString((Object)this, (String)"IMGateway.connectionLost", (Object)this.gatewayType, (Object)this.gatewayID, (Object)errorMessage));
            client.disconnect();
            if (this.bound) {
                this.restart();
            }
        }
        catch (Exception e) {
            this.logger.error(RB.getString((Object)this, (String)"IMGateway.errorWhileReconnect", (Object)this.gatewayType, (Object)this.gatewayID, (Object)e.getMessage()), (Throwable)e);
        }
    }

    public String outgoingMessage(CFEvent m) {
        Map cfmsg;
        String buddyId;
        if (this.imclient == null || this.status == 4 || this.status == 5 || !this.bound) {
            this.logger.error(RB.getString((Object)this, (String)"IMGateway.attemptSendMsgWhileNotConnect", (Object)this.gatewayType, (Object)this.gatewayID));
        }
        if (!this.imclient.isOnline()) {
            this.logger.info(RB.getString((Object)this, (String)"IMGateway.restartConnection", (Object)this.gatewayType, (Object)this.gatewayID));
            try {
                this.restart();
            }
            catch (Exception e) {
                String msg = RB.getString((Object)this, (String)"IMGateway.restartFailed", (Object)this.gatewayType, (Object)this.gatewayID, (Object)e.getMessage());
                this.logger.error(msg, (Throwable)e);
                return msg;
            }
        }
        if ((buddyId = (String)(cfmsg = m.getData()).get(BUDDYID)) == null) {
            String msg = RB.getString((Object)this, (String)"IMGateway.missingBuddyID", (Object)this.gatewayType, (Object)this.gatewayID);
            this.logger.error(msg);
            return msg;
        }
        String command = (String)cfmsg.get(COMMAND);
        if (command == null || command.equalsIgnoreCase(SUBMIT)) {
            String message = (String)cfmsg.get(CFMESSAGE);
            if (message == null) {
                String msg = RB.getString((Object)this, (String)"IMGateway.missingMessage", (Object)this.gatewayType, (Object)this.gatewayID);
                this.logger.error(msg);
                return msg;
            }
            try {
                if (this.checkDeveloperLimitation(this.imclient.getName(), buddyId)) {
                    return OK;
                }
                this.imclient.sendIM(buddyId, message);
            }
            catch (IOException ioex) {
                String msg = RB.getString((Object)this, (String)"IMGateway.errorSendMessage", (Object)this.gatewayType, (Object)this.gatewayID, (Object)buddyId, (Object)ioex.getMessage());
                this.logger.error(msg);
                return msg;
            }
        } else if (command.equalsIgnoreCase(ACCEPT)) {
            String reason = (String)cfmsg.get(REASON);
            if (reason == null) {
                reason = ACCEPT;
            }
            try {
                if (this.checkDeveloperLimitation(this.imclient.getName(), buddyId)) {
                    return OK;
                }
                this.imclient.sendMessage(IMessageFactory.factory((int)5, (IClient)this.imclient, (String)buddyId, (String)reason));
            }
            catch (Exception ioex) {
                String msg = RB.getString((Object)this, (String)"IMGateway.errorSendAcceptMessage", (Object)this.gatewayType, (Object)this.gatewayID, (Object)buddyId, (Object)ioex.getMessage());
                this.logger.error(msg);
                return msg;
            }
        } else if (command.equalsIgnoreCase(DECLINE)) {
            String reason = (String)cfmsg.get(REASON);
            if (reason == null) {
                reason = DECLINE;
            }
            try {
                if (this.checkDeveloperLimitation(this.imclient.getName(), buddyId)) {
                    return OK;
                }
                this.imclient.sendMessage(IMessageFactory.factory((int)6, (IClient)this.imclient, (String)buddyId, (String)reason));
            }
            catch (Exception ioex) {
                String msg = RB.getString((Object)this, (String)" IMGateway.errorSendDeclineMessage", (Object)this.gatewayType, (Object)this.gatewayID, (Object)buddyId, (Object)ioex.getMessage());
                this.logger.error(msg);
                return msg;
            }
        } else if (command.equalsIgnoreCase(NOACT)) {
            this.logger.info(RB.getString((Object)this, (String)"IMGateway.sendNoactMessage", (Object)this.gatewayType, (Object)this.gatewayID, (Object)buddyId));
        }
        return OK;
    }

    public void setGatewayID(String id) {
        this.gatewayID = id;
    }

    public String getGatewayID() {
        return this.gatewayID;
    }

    public GatewayHelper getHelper() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCFCListeners(String[] listeners) {
        ArrayList<String> aListeners = new ArrayList<String>();
        for (int i = 0; i < listeners.length; ++i) {
            aListeners.add(listeners[i]);
        }
        Collection collection = this.cfcListeners;
        synchronized (collection) {
            this.cfcListeners = aListeners;
        }
    }

    public void start() {
        this.status = 1;
        EventServiceImpl eventService = (EventServiceImpl)ServiceFactory.getEventProcessorService();
        eventService.initializeJBuddyIMGateway();
        this.logger.info(RB.getString((Object)this, (String)"IMGateway.connecting", (Object)this.gatewayType, (Object)this.gatewayID, (Object)this.userid));
        this.bound = false;
        if (this.gatewayType.equals(XMPPGATEWAY)) {
            this.imclient = IClientFactory.factory((IGateway)this, (int)50, (String)this.userid, (String)this.password);
        } else if (this.gatewayType.equals(SAMETIMEGATEWAY)) {
            this.imclient = IClientFactory.factory((IGateway)this, (int)60, (String)this.userid, (String)this.password);
        }
        this.connect();
    }

    protected void connect() {
        if (this.imclient == null) {
            if (!IClientFactory.checkLicense()) {
                IClientFactory.showLicenseInfo();
                this.status = 5;
                throw new IMGatewayMissingLicenseException(this.gatewayType);
            }
            this.status = 5;
            throw new IMGatewayUnableCreateClientException(this.gatewayType, this.userid);
        }
        boolean conn = false;
        try {
            if (this.serverip != null && this.serverport != null) {
                conn = this.imclient.connect(this.serverip, Integer.valueOf(this.serverport).intValue());
            } else if (this.serverip != null) {
                this.logger.info(RB.getString((Object)this, (String)"IMGateway.missingServerPort", (Object)this.gatewayType, (Object)this.gatewayID));
                if (this.imclient instanceof IJabberClient) {
                    conn = this.imclient.connect(this.serverip, 5222);
                } else if (this.imclient instanceof ISametimeClient) {
                    conn = this.imclient.connect(this.serverip, 1533);
                }
            } else if (this.serverport != null) {
                this.logger.info(RB.getString((Object)this, (String)"IMGateway.missingServerIP", (Object)this.gatewayType, (Object)this.gatewayID));
                conn = this.imclient.connect();
            } else {
                conn = this.imclient.connect();
            }
            if (!conn) {
                throw new IMGatewayUnableConnectServerException(this.gatewayType, this.userid);
            }
        }
        catch (IOException e) {
            if (this.MAX_RESTART != 0) {
                this.logger.error(RB.getString((Object)this, (String)"IMGateway.connectError", (Object)this.gatewayType, (Object)this.gatewayID, (Object)this.serverip, (Object)e.getMessage()));
                try {
                    conn = this.connectWithRetry();
                }
                catch (IOException e1) {
                    this.status = 5;
                    throw new IMGatewayRetryConnectFailException(this.gatewayType, e1);
                }
            }
            this.status = 5;
            throw new IMGatewayUnableConnectServerException(this.gatewayType, e);
        }
        if (conn) {
            try {
                int i = 0;
                while (!this.imclient.isOnline() && i++ < 60) {
                    Thread.sleep(500L);
                }
                if (i < 60) {
                    this.bound = true;
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (!this.bound) {
            this.status = 5;
            throw new IMGatewayUnableConnectServerException(this.gatewayType, this.userid);
        }
        this.status = 2;
    }

    protected boolean connectWithRetry() throws IOException {
        boolean conn = false;
        int count = 0;
        long wait = 1000L * this.RETRY_INTERVAL;
        IOException saved_exception = null;
        Object msg = this.MAX_RESTART != -1 ? "(up to " + this.MAX_RESTART + " times)" : "until reconnected";
        this.logger.info(RB.getString((Object)this, (String)"IMGateway.connectWithRetry", (Object)this.gatewayType, (Object)this.gatewayID, (Object)msg));
        while (this.status != 4 && (count++ < this.MAX_RESTART || this.MAX_RESTART == -1)) {
            try {
                this.logger.debug("diconnecting old client");
                if (this.imclient != null) {
                    this.imclient.disconnect();
                }
                this.logger.debug("Getting new client");
                if (this.gatewayType.equals(XMPPGATEWAY)) {
                    this.imclient = IClientFactory.factory((IGateway)this, (int)50, (String)this.userid, (String)this.password);
                } else if (this.gatewayType.equals(SAMETIMEGATEWAY)) {
                    this.imclient = IClientFactory.factory((IGateway)this, (int)60, (String)this.userid, (String)this.password);
                }
                if (this.imclient == null) {
                    this.logger.debug("Did not get a client object back!");
                    break;
                }
                this.logger.debug("attmping to connect....");
                if (this.serverip != null && this.serverport != null) {
                    conn = this.imclient.connect(this.serverip, Integer.valueOf(this.serverport).intValue());
                } else if (this.serverip != null) {
                    if (this.imclient instanceof IJabberClient) {
                        conn = this.imclient.connect(this.serverip, 5222);
                    } else if (this.imclient instanceof ISametimeClient) {
                        conn = this.imclient.connect(this.serverip, 1533);
                    }
                } else {
                    conn = this.serverport != null ? this.imclient.connect() : this.imclient.connect();
                }
                this.logger.debug("back from connect status = " + conn);
                if (conn) {
                    this.logger.debug("connect is true, breaking out of loop");
                    break;
                }
            }
            catch (IOException e) {
                saved_exception = e;
                this.logger.info(RB.getString((Object)this, (String)"IMGateway.connectError", (Object)this.gatewayType, (Object)this.gatewayID, (Object)this.serverip, (Object)e.getMessage()));
            }
            this.logger.debug("Going to sleep for " + wait + " miliseconds");
            try {
                Thread.sleep(wait);
            }
            catch (InterruptedException x) {
                throw new IOException(x.toString());
            }
        }
        this.logger.debug("Out of loop, conn=" + conn + ", count = " + count);
        if (!conn && count >= this.MAX_RESTART && saved_exception != null) {
            this.logger.debug("Maximum retries exceeded, throwing last exception, '" + saved_exception.getMessage() + "'");
            throw saved_exception;
        }
        if (conn) {
            this.logger.info(RB.getString((Object)this, (String)"IMGateway.reconnectSucceed", (Object)this.gatewayType, (Object)this.gatewayID, (Object)String.valueOf(count)));
        }
        return conn;
    }

    public void stop() {
        this.status = 3;
        try {
            this.bound = false;
            if (this.imclient != null) {
                this.imclient.disconnect();
            }
        }
        catch (Exception e) {
            throw new IMGatewayUnableStoppingGatewayException(this.gatewayType, this.userid, e);
        }
        this.status = 4;
    }

    public void restart() {
        this.stop();
        this.loadconfig();
        this.start();
    }

    public int getStatus() {
        return this.status;
    }

    protected boolean addBuddy(String username, String nickname, String group) {
        boolean result = false;
        try {
            if (this.imclient != null) {
                result = group != null && group.length() > 0 ? this.imclient.addBuddy(username, nickname, group) : this.imclient.addBuddy(username, nickname, GENERALGROUP);
            }
        }
        catch (IOException ioex) {
            this.logger.error(RB.getString((Object)this, (String)"IMGateway.errorAddBuddyOperation", (Object)this.gatewayType, (Object)this.gatewayID, (Object)username, (Object)ioex.getMessage()));
        }
        return result;
    }

    protected boolean addDeny(String username, String nickname, String group) {
        boolean result = false;
        try {
            if (this.imclient != null) {
                result = group != null && group.length() > 0 ? this.imclient.addDeny(username, nickname, group) : this.imclient.addDeny(username, nickname, GENERALGROUP);
            }
        }
        catch (Exception ioex) {
            this.logger.error(RB.getString((Object)this, (String)"IMGateway.errorAddDenyOperation", (Object)this.gatewayType, (Object)this.gatewayID, (Object)username, (Object)ioex.getMessage()));
        }
        return result;
    }

    protected boolean addPermit(String username, String nickname, String group) {
        boolean result = false;
        try {
            if (this.imclient != null) {
                result = group != null && group.length() > 0 ? this.imclient.addPermit(username, nickname, group) : this.imclient.addPermit(username, nickname, GENERALGROUP);
            }
        }
        catch (Exception ioex) {
            this.logger.error(RB.getString((Object)this, (String)"IMGateway.errorAddPermitOperation", (Object)this.gatewayType, (Object)this.gatewayID, (Object)username, (Object)ioex.getMessage()));
        }
        return result;
    }

    protected IBuddyList getBuddyList() {
        IBuddyList result = null;
        try {
            if (this.imclient != null) {
                result = this.imclient.getBuddyList();
            }
        }
        catch (Exception ioex) {
            this.logger.error(RB.getString((Object)this, (String)"IMGateway.errorOperation", (Object)this.gatewayType, (Object)this.gatewayID, (Object)"getBuddyList", (Object)ioex.getMessage()));
        }
        return result;
    }

    protected String getCustomAwayMessage() {
        String result = null;
        try {
            if (this.imclient != null && (result = this.imclient.getCustomAwayMessage()) == null) {
                result = "";
            }
        }
        catch (Exception ioex) {
            this.logger.error(RB.getString((Object)this, (String)"IMGateway.errorOperation", (Object)this.gatewayType, (Object)this.gatewayID, (Object)"getCustomAwayMessage", (Object)ioex.getMessage()));
        }
        return result;
    }

    protected IBuddyList getDenyList() {
        IBuddyList result = null;
        try {
            if (this.imclient != null) {
                result = this.imclient.getDenyList();
            }
        }
        catch (Exception ioex) {
            this.logger.error(RB.getString((Object)this, (String)"IMGateway.errorOperation", (Object)this.gatewayType, (Object)this.gatewayID, (Object)"getDenyList", (Object)ioex.getMessage()));
        }
        return result;
    }

    protected IBuddyList getPermitList() {
        IBuddyList result = null;
        try {
            if (this.imclient != null) {
                result = this.imclient.getPermitList();
            }
        }
        catch (Exception ioex) {
            this.logger.error(RB.getString((Object)this, (String)"IMGateway.errorOperation", (Object)this.gatewayType, (Object)this.gatewayID, (Object)"getPermitList", (Object)ioex.getMessage()));
        }
        return result;
    }

    protected String getName() {
        String result = null;
        try {
            if (this.imclient != null && (result = this.imclient.getName()) == null) {
                result = "";
            }
        }
        catch (Exception ioex) {
            this.logger.error(RB.getString((Object)this, (String)"IMGateway.errorOperation", (Object)this.gatewayType, (Object)this.gatewayID, (Object)"getName", (Object)ioex.getMessage()));
        }
        return result;
    }

    protected String getNickName() {
        String result = null;
        try {
            if (this.imclient != null && (result = this.imclient.getNickName()) == null) {
                result = "";
            }
        }
        catch (Exception ioex) {
            this.logger.error(RB.getString((Object)this, (String)"IMGateway.errorOperation", (Object)this.gatewayType, (Object)this.gatewayID, (Object)"getNickName", (Object)ioex.getMessage()));
        }
        return result;
    }

    protected int getPermitMode() {
        int result = 0;
        try {
            if (this.imclient != null) {
                result = this.imclient.getPermitMode();
            }
        }
        catch (Exception ioex) {
            this.logger.error(RB.getString((Object)this, (String)"IMGateway.errorOperation", (Object)this.gatewayType, (Object)this.gatewayID, (Object)"getPermitMode", (Object)ioex.getMessage()));
        }
        return result;
    }

    protected int getPlainTextMode() {
        int result = 0;
        try {
            if (this.imclient != null) {
                result = this.imclient.getPlainTextMode();
            }
        }
        catch (Exception ioex) {
            this.logger.error(RB.getString((Object)this, (String)"IMGateway.errorOperation", (Object)this.gatewayType, (Object)this.gatewayID, (Object)"getPlainTextMode", (Object)ioex.getMessage()));
        }
        return result;
    }

    protected String getProtocolName() {
        String result = null;
        try {
            if (this.imclient != null && (result = this.imclient.getProtocolName()) == null) {
                result = "";
            }
        }
        catch (Exception ioex) {
            this.logger.error(RB.getString((Object)this, (String)"IMGateway.errorOperation", (Object)this.gatewayType, (Object)this.gatewayID, (Object)"getProtocolName", (Object)ioex.getMessage()));
        }
        return result;
    }

    protected Date getSignOnTimeStamp() {
        Date result = null;
        try {
            if (this.imclient != null && (result = this.imclient.getSignOnTimeStamp()) == null) {
                result = new Date(0L);
            }
        }
        catch (Exception ioex) {
            this.logger.error(RB.getString((Object)this, (String)"IMGateway.errorOperation", (Object)this.gatewayType, (Object)this.gatewayID, (Object)"getSignOnTimeStamp", (Object)ioex.getMessage()));
        }
        return result;
    }

    protected String getStatusAsString() {
        String result = null;
        try {
            if (this.imclient != null && (result = this.imclient.getStatusAsString()) == null) {
                result = "";
            }
        }
        catch (Exception ioex) {
            this.logger.error(RB.getString((Object)this, (String)"IMGateway.errorOperation", (Object)this.gatewayType, (Object)this.gatewayID, (Object)"getStatusAsString", (Object)ioex.getMessage()));
        }
        return result;
    }

    protected Date getStatusTimeStamp() {
        Date result = null;
        try {
            if (this.imclient != null && (result = this.imclient.getStatusTimeStamp()) == null) {
                result = new Date(0L);
            }
        }
        catch (Exception ioex) {
            this.logger.error(RB.getString((Object)this, (String)"IMGateway.errorOperation", (Object)this.gatewayType, (Object)this.gatewayID, (Object)"getStatusTimeStamp", (Object)ioex.getMessage()));
        }
        return result;
    }

    protected boolean isOnline() {
        boolean result = false;
        try {
            if (this.imclient != null) {
                result = this.imclient.isOnline();
            }
        }
        catch (Exception ioex) {
            this.logger.error(RB.getString((Object)this, (String)"IMGateway.errorOperation", (Object)this.gatewayType, (Object)this.gatewayID, (Object)"isOnline", (Object)ioex.getMessage()));
        }
        return result;
    }

    protected int numberOfMessagesReceived() {
        int result = 0;
        try {
            if (this.imclient != null) {
                result = this.imclient.numberOfMessagesReceived();
            }
        }
        catch (Exception ioex) {
            this.logger.error(RB.getString((Object)this, (String)"IMGateway.errorOperation", (Object)this.gatewayType, (Object)this.gatewayID, (Object)"numberOfMessagesReceived", (Object)ioex.getMessage()));
        }
        return result;
    }

    protected int numberOfMessagesSent() {
        int result = 0;
        try {
            if (this.imclient != null) {
                result = this.imclient.numberOfMessagesSent();
            }
        }
        catch (Exception ioex) {
            this.logger.error(RB.getString((Object)this, (String)"IMGateway.errorOperation", (Object)this.gatewayType, (Object)this.gatewayID, (Object)"numberOfMessagesSent", (Object)ioex.getMessage()));
        }
        return result;
    }

    protected boolean removeBuddy(String name, String group) {
        boolean result = false;
        try {
            if (this.imclient != null) {
                result = group != null && group.length() > 0 ? this.imclient.removeBuddy(name, group) : this.imclient.removeBuddy(name, GENERALGROUP);
            }
        }
        catch (Exception ioex) {
            this.logger.error(RB.getString((Object)this, (String)"IMGateway.errorRemoveBuddyOperation", (Object)this.gatewayType, (Object)this.gatewayID, (Object)name, (Object)ioex.getMessage()));
        }
        return result;
    }

    protected boolean removeDeny(String name, String group) {
        boolean result = false;
        try {
            if (this.imclient != null) {
                result = group != null && group.length() > 0 ? this.imclient.removeDeny(name, group) : this.imclient.removeDeny(name, GENERALGROUP);
            }
        }
        catch (Exception ioex) {
            this.logger.error(RB.getString((Object)this, (String)"IMGateway.errorRemoveDenyOperation", (Object)this.gatewayType, (Object)this.gatewayID, (Object)name, (Object)ioex.getMessage()));
        }
        return result;
    }

    protected boolean removePermit(String name, String group) {
        boolean result = false;
        try {
            if (this.imclient != null) {
                result = group != null && group.length() > 0 ? this.imclient.removePermit(name, group) : this.imclient.removePermit(name, GENERALGROUP);
            }
        }
        catch (Exception ioex) {
            this.logger.error(RB.getString((Object)this, (String)"IMGateway.errorRemovePermitOperation", (Object)this.gatewayType, (Object)this.gatewayID, (Object)name, (Object)ioex.getMessage()));
        }
        return result;
    }

    protected boolean setNickName(String nickName) {
        boolean result = false;
        try {
            if (this.imclient != null) {
                result = this.imclient.setNickName(nickName);
            }
        }
        catch (Exception ioex) {
            this.logger.error(RB.getString((Object)this, (String)"IMGateway.errorOperation", (Object)this.gatewayType, (Object)this.gatewayID, (Object)"setNickName", (Object)ioex.getMessage()));
        }
        return result;
    }

    protected boolean setPermitMode(int permitLevel) {
        boolean result = false;
        try {
            if (this.imclient != null) {
                result = this.imclient.setPermitMode(permitLevel);
            }
        }
        catch (Exception ioex) {
            this.logger.error(RB.getString((Object)this, (String)"IMGateway.errorOperation", (Object)this.gatewayType, (Object)this.gatewayID, (Object)"setPermitMode", (Object)ioex.getMessage()));
        }
        return result;
    }

    protected int setPlainTextMode(int textLevel) {
        int result = 0;
        try {
            if (this.imclient != null) {
                result = this.imclient.setPlainTextMode(textLevel);
            }
        }
        catch (Exception ioex) {
            this.logger.error(RB.getString((Object)this, (String)"IMGateway.errorOperation", (Object)this.gatewayType, (Object)this.gatewayID, (Object)"setPlainTextMode", (Object)ioex.getMessage()));
        }
        return result;
    }

    protected boolean setStatus(int newStatus, String customAwayMessage) {
        boolean result = false;
        try {
            if (this.imclient != null) {
                result = this.imclient.setStatus(newStatus, customAwayMessage);
            }
        }
        catch (Exception ioex) {
            this.logger.error(RB.getString((Object)this, (String)"IMGateway.errorOperation", (Object)this.gatewayType, (Object)this.gatewayID, (Object)"setStatus", (Object)ioex.getMessage()));
        }
        return result;
    }

    public class IMGatewayMissingUsernamePasswordException
    extends ApplicationException {
        public String gatewaytype = null;
        public String propsFilePath = null;

        public IMGatewayMissingUsernamePasswordException(String gatewaytype, String propsFilePath) {
            this.gatewaytype = gatewaytype;
            this.propsFilePath = propsFilePath;
        }
    }

    public class IMGatewayInvalidRetriesRetryintervalValueException
    extends ApplicationException {
        public String gatewaytype = null;
        public String propsFilePath = null;

        public IMGatewayInvalidRetriesRetryintervalValueException(String gatewaytype, String propsFilePath) {
            this.gatewaytype = gatewaytype;
            this.propsFilePath = propsFilePath;
        }
    }

    public class IMGatewayUnableInitializeGatewayException
    extends ApplicationException {
        public String gatewaytype;

        public IMGatewayUnableInitializeGatewayException(String gatewaytype, Throwable e) {
            super(e);
            this.gatewaytype = null;
            this.gatewaytype = gatewaytype;
        }
    }

    public class IMGatewayMissingLicenseException
    extends ApplicationException {
        public String gatewaytype = null;

        public IMGatewayMissingLicenseException(String gatewaytype) {
            this.gatewaytype = gatewaytype;
        }
    }

    public class IMGatewayUnableCreateClientException
    extends ApplicationException {
        public String gatewaytype = null;
        public String userid = null;

        public IMGatewayUnableCreateClientException(String gatewaytype, String userid) {
            this.gatewaytype = gatewaytype;
            this.userid = userid;
        }
    }

    public class IMGatewayUnableConnectServerException
    extends ApplicationException {
        public String gatewaytype;
        public String userid;

        public IMGatewayUnableConnectServerException(String gatewaytype, String userid) {
            this.gatewaytype = null;
            this.userid = "";
            this.gatewaytype = gatewaytype;
            this.userid = userid;
        }

        public IMGatewayUnableConnectServerException(String gatewaytype, Throwable e) {
            super(e);
            this.gatewaytype = null;
            this.userid = "";
            this.gatewaytype = gatewaytype;
        }
    }

    public class IMGatewayRetryConnectFailException
    extends ApplicationException {
        public String gatewaytype;

        public IMGatewayRetryConnectFailException(String gatewaytype, Throwable e) {
            super(e);
            this.gatewaytype = null;
            this.gatewaytype = gatewaytype;
        }
    }

    public class IMGatewayUnableStoppingGatewayException
    extends ApplicationException {
        public String gatewaytype;
        public String userid;

        public IMGatewayUnableStoppingGatewayException(String gatewaytype, String userid, Throwable e) {
            super(e);
            this.gatewaytype = null;
            this.userid = null;
            this.gatewaytype = gatewaytype;
            this.userid = userid;
        }
    }
}

