/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.cache.jcs;

import coldfusion.filter.FusionContext;
import coldfusion.log.CFLogs;
import coldfusion.runtime.ApplicationScopeTracker;
import coldfusion.runtime.CFPage;
import coldfusion.runtime.Cast;
import coldfusion.runtime.OleDateTime;
import coldfusion.runtime.Struct;
import coldfusion.runtime.TemplateClassLoader;
import coldfusion.server.ServiceFactory;
import coldfusion.tagext.io.cache.CacheConfig;
import coldfusion.tagext.io.cache.CacheException;
import coldfusion.tagext.io.cache.CacheExceptions;
import coldfusion.tagext.io.cache.CacheTO;
import coldfusion.tagext.io.cache.CacheTagHelper;
import coldfusion.tagext.io.cache.GenericCache;
import coldfusion.util.CaseInsensitiveHashtable;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.apache.commons.jcs.JCS;
import org.apache.commons.jcs.access.CacheAccess;
import org.apache.commons.jcs.admin.CacheElementInfo;
import org.apache.commons.jcs.admin.CacheRegionInfo;
import org.apache.commons.jcs.admin.JCSAdminBean;
import org.apache.commons.jcs.auxiliary.AuxiliaryCache;
import org.apache.commons.jcs.auxiliary.disk.indexed.IndexedDiskCache;
import org.apache.commons.jcs.auxiliary.disk.indexed.IndexedDiskCacheAttributes;
import org.apache.commons.jcs.engine.behavior.ICacheElement;
import org.apache.commons.jcs.engine.behavior.ICompositeCacheAttributes;
import org.apache.commons.jcs.engine.behavior.IElementAttributes;
import org.apache.commons.jcs.engine.control.CompositeCache;
import org.apache.commons.jcs.engine.control.CompositeCacheManager;

public class GenericJCSCache
extends GenericCache {
    private String configFilePath;
    private String applicationName;
    private CompositeCacheManager cacheManager = null;
    private static final String JCS_STATS = "stats_";
    private static final String JCSSTATS_KEY_HITCOUNT = "stats_key_hitcount";
    private static final String JCSSTATS_METADATA = "stats_metadata";
    private static final String JCSSTATS_CACHE_MISSCOUNT = "stats_cache_misscount";
    private static final String JCSSTATS_CACHE_HITCOUNT = "stats_cache_hitcount";
    private static final String JCSSTATS_KEY_LASTACCESS = "stats_key_lastaccess";
    private static final String JCSSTATS_KEY_UPDATETIME = "stats_key_updatetime";
    private static final String JCSSTATS_KEY_CREATETIME = "stats_key_createtime";
    private static final String JCSSTATS_CACHE_MAXELEMENTS = "stats_cache_maxelements";
    public static final String STATS_REGION = "stats_region";
    private static final String PROP_MAXMEMORYIDLETIMESECONDS = "MAXMEMORYIDLETIMESECONDS";
    private static final String PROP_MAXKEYSIZE = "MAXKEYSIZE";
    private CacheConfig cacheConfig;
    public boolean isServerCache = false;
    private CacheAccess<Object, Object> statsIns = null;
    private static Map<String, CacheAccess<Object, Object>> insMap = new HashMap<String, CacheAccess<Object, Object>>();

    public GenericJCSCache() {
    }

    public GenericJCSCache(String configFilePath, String applicationName, Map config) {
        this.applicationName = applicationName;
        if (configFilePath != null) {
            this.configFilePath = configFilePath.trim();
            this.configFilePath = CacheTagHelper.resolveConfigFilePath((String)this.configFilePath);
            this.cacheConfig = new CacheConfig();
            CacheTagHelper.readApplicationLevelProperties((String)this.configFilePath, (CacheConfig)this.cacheConfig, (Map)config);
        }
    }

    public Object getMetadata() {
        return null;
    }

    private void setPropertyOnCache(CompositeCache<Object, Object> cache2, String cacheName, Map<String, Object> map) {
        ICompositeCacheAttributes cacheConfig;
        CompositeCache cache = cache2;
        if (cache == null && cacheName != null) {
            String mgrCalcKey = CacheTagHelper.calculateKeyHash((Object)cacheName);
            cache = JCS.getInstance((String)mgrCalcKey).getCacheControl();
        }
        if (cache != null && map != null) {
            map = new CaseInsensitiveHashtable(map);
            cacheConfig = cache.getCacheAttributes();
            IElementAttributes elementsConfig = cache.getElementAttributes();
            if (null != map.get("TIMETOLIVESECONDS")) {
                elementsConfig.setMaxLife(Cast._long(map.get("TIMETOLIVESECONDS")));
            }
            if (null != map.get("TIMETOIDLESECONDS")) {
                elementsConfig.setIdleTime(Cast._long(map.get("TIMETOIDLESECONDS")));
            }
            if (null != map.get("ETERNAL")) {
                elementsConfig.setIsEternal(Cast._boolean(map.get("ETERNAL")));
            }
            if (null != map.get("MAXELEMENTSINMEMORY")) {
                JCS.getInstance((String)STATS_REGION).put((Object)(JCSSTATS_CACHE_MAXELEMENTS + cacheName), (Object)("" + Cast._int(map.get("MAXELEMENTSINMEMORY"))));
                cacheConfig.setMaxObjects(Cast._int(map.get("MAXELEMENTSINMEMORY")));
            }
            if (null != map.get("METADATA")) {
                JCS.getInstance((String)STATS_REGION).put((Object)(JCSSTATS_METADATA + cacheName), (Object)("" + Cast._boolean(map.get("METADATA"))));
            }
            if (null != map.get("MAXENTRIESLOCALHEAP")) {
                JCS.getInstance((String)STATS_REGION).put((Object)(JCSSTATS_CACHE_MAXELEMENTS + cacheName), (Object)("" + Cast._int(map.get("MAXENTRIESLOCALHEAP"))));
                cacheConfig.setMaxObjects(Cast._int(map.get("MAXENTRIESLOCALHEAP")));
            }
            if (null != map.get("DISKSTORE") && null != map.get("DISKPERSISTENT")) {
                String diskStrore = (String)map.get("DISKSTORE");
                this.setAuxiliaryCache((CompositeCache<Object, Object>)cache, diskStrore, (Map<String, Object>)map);
            }
            cache.setElementAttributes(elementsConfig);
        }
        if (cache != null && (map == null || null == map.get("MAXELEMENTSINMEMORY")) && this.cacheConfig != null) {
            cacheConfig = cache.getCacheAttributes();
            JCS.getInstance((String)STATS_REGION).put((Object)(JCSSTATS_CACHE_MAXELEMENTS + cacheName), (Object)this.cacheConfig.getCacheMaxElements());
            cacheConfig.setMaxObjects(this.cacheConfig.getCacheMaxElements());
        }
    }

    private void setAuxiliaryCache(CompositeCache<Object, Object> cache, String diskStrore, Map<String, Object> map) {
        AuxiliaryCache[] auxs = cache.getAuxCaches();
        IndexedDiskCacheAttributes idca = new IndexedDiskCacheAttributes();
        idca.setCacheName(cache.getCacheName());
        idca.setDiskPath(diskStrore);
        if (null != map && null != map.get("MAXELEMENTSONDISK")) {
            idca.setMaxPurgatorySize(Cast._int((Object)map.get("MAXELEMENTSONDISK")));
        }
        if (null != map && null != map.get(PROP_MAXKEYSIZE)) {
            idca.setMaxKeySize(Cast._int((Object)map.get(PROP_MAXKEYSIZE)));
        }
        IndexedDiskCache aux = new IndexedDiskCache(idca);
        ArrayList<Object> auxList = new ArrayList<Object>();
        auxList.add(aux);
        for (AuxiliaryCache auxCache : auxs) {
            if (auxCache instanceof IndexedDiskCache) continue;
            auxList.add(auxCache);
        }
        cache.setAuxCaches(auxList.toArray(auxs));
    }

    public void setCacheProperties(Map map, String region) {
        if (map != null && map instanceof Struct) {
            String appName = FusionContext.getCurrent().getApplicationName();
            String objectType = this.toStringValue(map.get("OBJECTTYPE"), "ALL").trim();
            String cacheName = null;
            if (region == null && CacheTagHelper.isStandardCacheRegion((String)objectType)) {
                region = objectType;
            }
            if (region == null && "ALL".equalsIgnoreCase(objectType)) {
                CompositeCache<Object, Object> cache = null;
                cacheName = CacheTagHelper.getCacheKey2(null, (String)appName, (String)"OBJECT", (String)this.configFilePath);
                this.setPropertyOnCache(cache, cacheName, map);
                cacheName = CacheTagHelper.getCacheKey2(null, (String)appName, (String)"TEMPLATE", (String)this.configFilePath);
                this.setPropertyOnCache(cache, cacheName, map);
                cacheName = CacheTagHelper.getCacheKey2(null, (String)appName, (String)"QUERY", (String)this.configFilePath);
                this.setPropertyOnCache(cache, cacheName, map);
            } else {
                CompositeCache<Object, Object> cache = null;
                if (region != null && (region.equalsIgnoreCase("OBJECT") || region.equalsIgnoreCase("QUERY") || region.equalsIgnoreCase("TEMPLATE"))) {
                    region = region.toUpperCase();
                    cacheName = CacheTagHelper.getCacheKey2((String)region, (String)appName, (String)"OBJECT", (String)this.configFilePath);
                } else {
                    cacheName = CacheTagHelper.getCacheKey2((String)region, (String)appName, (String)"OBJECT", (String)this.configFilePath);
                    if (this.getCacheManager().getCacheNames().length == 0) {
                        throw new CacheExceptions.CacheNotFoundException(region);
                    }
                    if (!this.cacheExists(region)) {
                        throw new CacheExceptions.CacheNotFoundException(region);
                    }
                }
                this.setPropertyOnCache(cache, cacheName, map);
            }
        }
    }

    public Object createCache(String mgrKey, String objType, String diskStore, Map properties) {
        if (mgrKey != null && mgrKey.trim().length() == 0) {
            throw new CacheExceptions.InvalidCacheNameException();
        }
        String appName = null;
        FusionContext context = FusionContext.getCurrent();
        if (context != null && (appName = context.getApplicationName()) == null && context.cacheConfig != null) {
            appName = context.cacheConfig.applicationName;
        }
        mgrKey = CacheTagHelper.getCacheKey2((String)mgrKey, (String)appName, (String)objType, (String)this.configFilePath);
        String mgrCalcKey = CacheTagHelper.calculateKeyHash((Object)mgrKey);
        CacheAccess cache = JCS.getInstance((String)mgrCalcKey);
        if (properties == null) {
            HashMap<String, Object> prop = new HashMap<String, Object>();
            if (null != this.cacheConfig) {
                prop.put("TIMETOIDLESECONDS", "" + this.cacheConfig.getCacheIdleTime());
                prop.put("TIMETOLIVESECONDS", "" + this.cacheConfig.getCacheTimeSpan());
                prop.put("ETERNAL", "" + this.cacheConfig.isCacheEternal());
                prop.put("MAXELEMENTSINMEMORY", "" + this.cacheConfig.getCacheMaxElements());
            }
            properties = prop;
        }
        this.setPropertyOnCache((CompositeCache<Object, Object>)cache.getCacheControl(), mgrCalcKey, (Map<String, Object>)properties);
        if (diskStore != null && diskStore.length() > 0) {
            this.setAuxiliaryCache((CompositeCache<Object, Object>)cache.getCacheControl(), diskStore, properties);
        }
        return cache;
    }

    public boolean cacheExists(String region) {
        String[] regions = this.getAllCacheNames();
        FusionContext fContext = FusionContext.getCurrent();
        if (fContext != null) {
            region = CacheTagHelper.getCacheKey2((String)region, (String)fContext.getApplicationName(), (String)"OBJECT", (String)this.configFilePath);
        }
        return Arrays.asList(regions).contains(region);
    }

    public boolean cacheExists(String region, String type) {
        String[] regions = this.getAllCacheNames();
        FusionContext fContext = FusionContext.getCurrent();
        if (fContext != null) {
            region = CacheTagHelper.getCacheKey2((String)region, (String)fContext.getApplicationName(), (String)type, (String)this.configFilePath);
        }
        return Arrays.asList(regions).contains(region);
    }

    public Object get(CacheTO xObj, boolean throwError, Long within) {
        xObj.id = CacheTagHelper.objectToString((Object)((Serializable)xObj.id));
        ICacheElement element = this.getCache(xObj, throwError).getCacheElement(xObj.id);
        if (element != null) {
            this.updateStats(xObj, element.getVal());
            return ((Map)element.getVal()).get("value");
        }
        return null;
    }

    public Object get(CacheTO xObj, boolean throwError) {
        CacheAccess<Object, Object> cache = this.getCache(xObj, throwError);
        if (cache != null) {
            Object value = null;
            xObj.id = CacheTagHelper.objectToString((Object)((Serializable)xObj.id));
            value = cache.get(xObj.id);
            this.updateStats(xObj, value);
            if (value != null) {
                try {
                    long checkTime;
                    long lastModified;
                    if (!xObj.getQuiet && "TEMPLATE".equalsIgnoreCase(xObj.objecttype) && (lastModified = TemplateClassLoader.getLastModifiedTime((String)FusionContext.getCurrent().getPagePath())) > (checkTime = this.getUpdateTimeOfElement(xObj))) {
                        return null;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return ((Map)value).get("value");
            }
        }
        return null;
    }

    private void updateStats(CacheTO xObj, Object value) {
        if (!xObj.getQuiet) {
            String cacheKey = CacheTagHelper.getCacheKey2((String)xObj.region, (String)xObj.appname, (String)xObj.objecttype, (String)this.configFilePath);
            if (this.cacheConfig != null && !this.cacheConfig.isCacheMetadata()) {
                return;
            }
            CacheTO statsTo = new CacheTO();
            statsTo.setId((Object)JCSSTATS_KEY_LASTACCESS);
            statsTo.setKey(xObj.region);
            statsTo.setAppname(xObj.appname);
            statsTo.setObjecttype(xObj.objecttype);
            statsTo.setValue((Object)System.currentTimeMillis());
            statsTo.getQuiet = true;
            CacheAccess<Object, Object> cache = this.getCache(statsTo, false);
            if (null != value) {
                Map metadata = (Map)value;
                metadata.put(statsTo.id, statsTo.value);
                Object cStats = metadata.get(JCSSTATS_KEY_HITCOUNT);
                if (cStats == null) {
                    statsTo.setValue((Object)1L);
                } else {
                    statsTo.setValue((Object)new AtomicLong((Long)cStats).incrementAndGet());
                }
                metadata.put(JCSSTATS_KEY_HITCOUNT, statsTo.value);
                cache.put(xObj.id, (Object)metadata, cache.getElementAttributes(xObj.id));
                statsTo.setId((Object)(JCSSTATS_CACHE_HITCOUNT + cacheKey));
                cStats = this.getStatsInstance().get(statsTo.id);
                if (cStats == null) {
                    statsTo.setValue((Object)1L);
                } else {
                    statsTo.setValue((Object)new AtomicLong((Long)cStats).incrementAndGet());
                }
                this.getStatsInstance().put(statsTo.id, statsTo.value);
            } else {
                statsTo.setId((Object)(JCSSTATS_CACHE_MISSCOUNT + cacheKey));
                Object cStats = this.getStatsInstance().get(statsTo.id);
                if (cStats == null) {
                    statsTo.setValue((Object)1L);
                } else {
                    statsTo.setValue((Object)new AtomicLong((Long)cStats).incrementAndGet());
                }
                this.getStatsInstance().put(statsTo.id, statsTo.value);
            }
        }
    }

    CacheAccess<Object, Object> getStatsInstance() {
        if (null != this.statsIns) {
            return this.statsIns;
        }
        return JCS.getInstance((String)STATS_REGION);
    }

    public long getUpdateTimeOfElement(CacheTO xObj) {
        Object obj;
        Object metadata;
        CacheTO statsTo = this.cloneCacheTO(xObj);
        statsTo.setId(xObj.id);
        CacheAccess<Object, Object> cache = this.getCache(statsTo, false);
        if (null != cache && null != (metadata = cache.get(statsTo.id)) && null != (obj = ((Map)metadata).get(JCSSTATS_KEY_UPDATETIME))) {
            return (Long)obj;
        }
        return 0L;
    }

    public long getCreateTimeOfElement(ICacheElement<Object, Object> element) {
        Object obj = ((Map)element.getVal()).get(JCSSTATS_KEY_CREATETIME);
        if (null != obj) {
            return (Long)obj;
        }
        return 0L;
    }

    private long getLastAccessTimeOfElement(ICacheElement<Object, Object> element) {
        Object obj = ((Map)element.getVal()).get(JCSSTATS_KEY_LASTACCESS);
        long lastAccess = null != obj ? ((Long)obj).longValue() : ((Long)((Map)element.getVal()).get(JCSSTATS_KEY_CREATETIME)).longValue();
        return lastAccess;
    }

    public Map getMetadata(CacheTO xObj) {
        CaseInsensitiveHashtable result = new CaseInsensitiveHashtable();
        CacheAccess<Object, Object> cache = this.getCache(xObj, true);
        String key = CacheTagHelper.getCacheKey2((String)xObj.region, (String)xObj.appname, (String)xObj.objecttype, (String)this.configFilePath);
        xObj.id = CacheTagHelper.objectToString((Object)((Serializable)xObj.id));
        ICacheElement element = cache.getCacheElement(xObj.id);
        if (cache != null && element != null) {
            JCSAdminBean admin = new JCSAdminBean();
            try {
                CacheElementInfo[] infos;
                for (CacheElementInfo info : infos = admin.buildElementInfo(key)) {
                    if (!info.getKey().equals(xObj.id)) continue;
                    result.put("TIMESPAN", new Long(element.getElementAttributes().getMaxLife()));
                    result.put("IDLETIME", new Long(element.getElementAttributes().getIdleTime()));
                    result.put("SIZE", CacheTagHelper.getSerializedSize((Object)element));
                    result.put("CREATEDTIME", new OleDateTime(this.getCreateTimeOfElement((ICacheElement<Object, Object>)element)));
                    result.put("LASTHIT", new OleDateTime(this.getLastAccessTimeOfElement((ICacheElement<Object, Object>)element)));
                    result.put("LASTUPDATED", new OleDateTime(this.getUpdateTimeOfElement(xObj)));
                    Object cStats = element.getVal();
                    if (cStats == null) {
                        result.put("HITCOUNT", 0);
                        break;
                    }
                    result.put("HITCOUNT", ((Map)cStats).get(JCSSTATS_KEY_HITCOUNT));
                    break;
                }
                CacheTO statsTo = this.cloneCacheTO(xObj);
                statsTo.setId((Object)(JCSSTATS_CACHE_HITCOUNT + key));
                Object cStats = this.getStatsInstance().get(statsTo.id);
                result.put("CACHE_HITCOUNT", cStats);
                statsTo.setId((Object)(JCSSTATS_CACHE_MISSCOUNT + key));
                Object missStats = this.getStatsInstance().get(statsTo.id);
                if (missStats == null) {
                    result.put("CACHE_MISSCOUNT", 0);
                } else {
                    result.put("CACHE_MISSCOUNT", missStats);
                }
                result.put("NAME", CacheTagHelper.getTrimmedCacheName((String)key, (String)xObj.appname));
            }
            catch (Exception e) {
                CFLogs.APPLICATION_LOG.error((Throwable)e);
            }
        }
        return result;
    }

    public List getObjectCacheMetadata(String appName) {
        ArrayList<Object> result = new ArrayList<Object>();
        if (appName != null) {
            CacheAccess<Object, Object> cache = this.getCache(appName, "OBJECT", null);
            result.add(this.populatePerAppMetadata(cache, appName));
            return result;
        }
        String[] cacheNames = this.getCacheManager().getCacheNames();
        result = new ArrayList();
        for (int i = 0; i < cacheNames.length; ++i) {
            if (cacheNames[i].indexOf("OBJECT") <= -1) continue;
            appName = cacheNames[i].substring(0, cacheNames[i].indexOf("OBJECT"));
            CacheAccess<Object, Object> cache = this.getCache(appName, "OBJECT", null);
            result.add(this.populatePerAppMetadata(cache, appName));
        }
        return result;
    }

    private Object populatePerAppMetadata(CacheAccess<Object, Object> cache, String appName) {
        String key = CacheTagHelper.getCacheKey2(null, (String)appName, (String)"OBJECT", (String)this.configFilePath);
        Struct resultObj = new Struct();
        if (cache != null) {
            JCSAdminBean admin = new JCSAdminBean();
            ArrayList<Struct> objects = new ArrayList<Struct>();
            try {
                CacheElementInfo[] elementsInfo;
                CacheRegionInfo[] regionInfos = admin.buildCacheInfo();
                for (CacheElementInfo elementInfo : elementsInfo = admin.buildElementInfo(key)) {
                    Struct objMeta = new Struct();
                    objMeta.put((Object)"ID", (Object)elementInfo.getKey());
                    objMeta.put((Object)"SIZE", (Object)new Long(CacheTagHelper.getSerializedSize((Object)elementInfo)));
                    CacheTO statsTo = new CacheTO();
                    statsTo.setId((Object)(JCSSTATS_KEY_HITCOUNT + elementInfo.getKey()));
                    statsTo.setKey(null);
                    statsTo.setAppname(appName);
                    statsTo.setObjecttype("OBJECT");
                    statsTo.getQuiet = true;
                    Object cStats = this.get(statsTo, false);
                    objMeta.put((Object)"HITCOUNT", cStats);
                    objects.add(objMeta);
                }
                resultObj.put((Object)"OBJECTS", objects);
                long cummSize = 0L;
                CacheTO statsTo = new CacheTO();
                statsTo.setId((Object)(JCSSTATS_CACHE_HITCOUNT + key));
                statsTo.getQuiet = true;
                statsTo.setKey(null);
                statsTo.setObjecttype("TEMPLATE");
                statsTo.setAppname(appName);
                Object cStats = this.get(statsTo, false);
                resultObj.put((Object)"CACHE_HITCOUNT", cStats);
                for (CacheRegionInfo regionInfo : regionInfos) {
                    if (!regionInfo.getCacheName().equals(key)) continue;
                    long cacheHits = regionInfo.getHitCountRam();
                    long missCountNotFound = regionInfo.getMissCountNotFound();
                    if (cacheHits == 0L) {
                        resultObj.put((Object)"HITRATIO", (Object)new Double(0.0));
                    } else {
                        resultObj.put((Object)"HITRATIO", (Object)new Double((double)cacheHits / (double)(missCountNotFound + cacheHits)));
                    }
                    resultObj.put((Object)"CACHE_MISSCOUNT", (Object)new Long(missCountNotFound));
                    resultObj.put((Object)"NUMBER", (Object)new Long(regionInfo.getCacheSize()));
                    cummSize += regionInfo.getByteCount();
                }
                resultObj.put((Object)"CACHESIZE", (Object)new Long(cummSize));
                resultObj.put((Object)"APPLICATIONNAME", (Object)appName);
            }
            catch (Exception e) {
                return resultObj;
            }
        }
        return resultObj;
    }

    public List getTemplateCacheMetadata(String appName) {
        ArrayList<Struct> result = new ArrayList<Struct>();
        if (appName != null) {
            appName = appName.trim();
            CacheAccess<Object, Object> cache = this.getCache(appName, "TEMPLATE", null);
            result.add(this.populatePerAppTemplateMetadata(cache, appName));
            return result;
        }
        String[] cacheNames = this.getCacheManager().getCacheNames();
        result = new ArrayList();
        for (int i = 0; i < cacheNames.length; ++i) {
            if (cacheNames[i].indexOf("TEMPLATE") <= -1) continue;
            appName = cacheNames[i].substring(0, cacheNames[i].indexOf("TEMPLATE"));
            CacheAccess<Object, Object> cache = this.getCache(appName, "TEMPLATE", null);
            result.add(this.populatePerAppTemplateMetadata(cache, appName));
        }
        return result;
    }

    private Struct populatePerAppTemplateMetadata(CacheAccess<Object, Object> cache, String appName) {
        String key = CacheTagHelper.getCacheKey2(null, (String)appName, (String)"TEMPLATE", (String)this.configFilePath);
        Struct resultObj = new Struct();
        if (cache != null) {
            JCSAdminBean admin = new JCSAdminBean();
            try {
                CacheRegionInfo[] regionInfos = admin.buildCacheInfo();
                long cummSize = 0L;
                CacheTO statsTo = new CacheTO();
                statsTo.setId((Object)(JCSSTATS_CACHE_HITCOUNT + key));
                statsTo.getQuiet = true;
                statsTo.setKey(null);
                statsTo.setObjecttype("TEMPLATE");
                statsTo.setAppname(appName);
                Object cStats = this.get(statsTo, false);
                resultObj.put((Object)"CACHE_HITCOUNT", cStats);
                for (CacheRegionInfo regionInfo : regionInfos) {
                    if (!regionInfo.getCacheName().equals(key)) continue;
                    long cacheHits = regionInfo.getHitCountRam();
                    long missCountNotFound = regionInfo.getMissCountNotFound();
                    if (cacheHits == 0L) {
                        resultObj.put((Object)"HITRATIO", (Object)new Double(0.0));
                    } else {
                        resultObj.put((Object)"HITRATIO", (Object)new Double((double)cacheHits / (double)(missCountNotFound + cacheHits)));
                    }
                    resultObj.put((Object)"CACHE_MISSCOUNT", (Object)new Long(missCountNotFound));
                    resultObj.put((Object)"NUMBER", (Object)new Long(regionInfo.getCacheSize()));
                    cummSize += regionInfo.getByteCount();
                }
                resultObj.put((Object)"CACHESIZE", (Object)new Long(cummSize));
                resultObj.put((Object)"APPLICATIONNAME", (Object)appName);
            }
            catch (Exception e) {
                return resultObj;
            }
        }
        return resultObj;
    }

    public List<Object> getAllCacheIds(CacheTO xObj, boolean accurate) {
        CacheAccess<Object, Object> cache = this.getCache(xObj, true);
        if (cache != null) {
            Set keySet = cache.getCacheControl().getMemoryCache().getKeySet();
            List<Object> res = accurate ? keySet.stream().filter(item -> !this.isKeyExpired(item, cache) && !((String)item).toLowerCase().contains(JCS_STATS)).map(item -> CacheTagHelper.stringToObject((String)((String)item))).collect(Collectors.toList()) : keySet.stream().filter(item -> !((String)item).toLowerCase().contains(JCS_STATS)).map(item -> CacheTagHelper.stringToObject((String)((String)item))).collect(Collectors.toList());
            return res;
        }
        return Collections.emptyList();
    }

    private boolean isKeyExpired(Object item, CacheAccess<Object, Object> cache) {
        boolean r = false;
        try {
            r = cache.getCacheElement(item) != null ? cache.getCacheControl().isExpired(cache.getCacheElement(item)) : true;
        }
        catch (Exception e) {
            r = true;
        }
        return r;
    }

    public void setMaxElementsInMemory(String cacheKey, int count) {
    }

    public boolean remove(CacheTO xObj) {
        CacheAccess<Object, Object> cache = this.getCache(xObj, true);
        if (cache != null) {
            if (xObj.id != null) {
                String keyHash = CacheTagHelper.objectToString((Object)((Serializable)xObj.id));
                if (xObj.exact && cache.get((Object)keyHash) != null) {
                    this.removeItem(cache, keyHash);
                    return true;
                }
                if (!xObj.exact && keyHash instanceof String) {
                    boolean cacheDeleted = false;
                    Set keys = cache.getCacheControl().getKeySet();
                    if (keys != null) {
                        String matchCriteria = CacheTagHelper.createMatchCriteria((String)keyHash);
                        for (Object key : keys.toArray()) {
                            if (!(key instanceof String) || CFPage.REFindNoCase((String)matchCriteria, (String)CacheTagHelper.createMatchCriteria((String)((String)key))) <= 0) continue;
                            cache.remove((Object)((String)key));
                            cacheDeleted = true;
                        }
                        return cacheDeleted;
                    }
                }
            } else if (!xObj.exact) {
                cache.clear();
                return true;
            }
        }
        return false;
    }

    private void removeItem(CacheAccess<Object, Object> cache, Object keyHash) {
        cache.remove(keyHash);
        cache.remove((Object)(JCSSTATS_KEY_HITCOUNT + keyHash));
        cache.remove((Object)(JCSSTATS_KEY_LASTACCESS + keyHash));
        cache.remove((Object)(JCSSTATS_KEY_UPDATETIME + keyHash));
        cache.remove((Object)(JCSSTATS_KEY_CREATETIME + keyHash));
    }

    public void put(CacheTO xObj, boolean throwOnError) {
        xObj.id = CacheTagHelper.objectToString((Object)xObj.id);
        CacheAccess<Object, Object> cache = this.getCache(xObj, throwOnError);
        String cacheKey = CacheTagHelper.getCacheKey2((String)xObj.region, (String)xObj.appname, (String)xObj.objecttype, (String)this.configFilePath);
        Object max = null;
        max = this.getStatsInstance().get((Object)(JCSSTATS_CACHE_MAXELEMENTS + cacheKey));
        if (max == null) {
            if (this.cacheConfig != null) {
                max = this.cacheConfig.getCacheMaxElements();
            }
            if (max == null) {
                ICompositeCacheAttributes cacheProp = cache.getCacheAttributes();
                max = cacheProp.getMaxObjects();
            }
            max = "" + (Integer)max;
            this.getStatsInstance().put((Object)(JCSSTATS_CACHE_MAXELEMENTS + cacheKey), max);
        }
        IElementAttributes dConfig = JCS.getInstance((String)"dummy").getCacheControl().getElementAttributes();
        boolean setPropertiesCalled = false;
        IElementAttributes config = cache.getDefaultElementAttributes();
        IElementAttributes newconfig = cache.getCacheControl().getElementAttributes();
        if (dConfig.getIdleTime() != newconfig.getIdleTime() || dConfig.getIsEternal() != newconfig.getIsEternal()) {
            setPropertiesCalled = true;
        }
        if (xObj.timetoidle >= 0L) {
            config.setIdleTime((long)((int)xObj.timetoidle));
        } else if (setPropertiesCalled) {
            config.setIdleTime(newconfig.getIdleTime());
        } else if (this.cacheConfig != null) {
            config.setIdleTime(this.cacheConfig.getCacheIdleTime());
        }
        if (xObj.timetoLive >= 0L) {
            config.setMaxLife((long)((int)xObj.timetoLive));
        } else if (setPropertiesCalled) {
            config.setMaxLife(newconfig.getTimeToLiveSeconds());
        } else if (this.cacheConfig != null) {
            config.setMaxLife(this.cacheConfig.getCacheTimeSpan());
        }
        if (xObj.eternal) {
            config.setIsEternal(true);
        } else if (xObj.timetoidle == 0L || xObj.timetoLive == 0L) {
            config.setIsEternal(true);
        } else if (setPropertiesCalled) {
            config.setIsEternal(newconfig.getIsEternal());
        } else if (this.cacheConfig != null) {
            config.setIsEternal(this.cacheConfig.isCacheEternal());
        }
        HashMap<Object, Object> metadata = new HashMap<Object, Object>();
        long time = System.currentTimeMillis();
        CacheTO statsTo = this.cloneCacheTO(xObj);
        statsTo.setId((Object)JCSSTATS_KEY_UPDATETIME);
        statsTo.setValue((Object)time);
        metadata.put(statsTo.id, statsTo.value);
        statsTo = this.cloneCacheTO(xObj);
        statsTo.setId((Object)JCSSTATS_KEY_CREATETIME);
        statsTo.setValue((Object)time);
        metadata.put(statsTo.id, statsTo.value);
        statsTo.setId((Object)JCSSTATS_KEY_HITCOUNT);
        metadata.put(statsTo.id, 0L);
        metadata.put("value", xObj.value);
        cache.put(xObj.id, metadata, config);
        statsTo.setId((Object)(JCSSTATS_CACHE_HITCOUNT + cacheKey));
        if (this.getStatsInstance().get(statsTo.id) == null) {
            this.getStatsInstance().put(statsTo.id, (Object)0L);
        }
        statsTo.setId((Object)(JCSSTATS_CACHE_MISSCOUNT + cacheKey));
        if (this.getStatsInstance().get(statsTo.id) == null) {
            this.getStatsInstance().put(statsTo.id, (Object)0L);
        }
    }

    private CacheTO cloneCacheTO(CacheTO xObj) {
        CacheTO statsTo = new CacheTO();
        statsTo.setKey(xObj.region);
        statsTo.setAppname(xObj.appname);
        statsTo.setObjecttype(xObj.objecttype);
        statsTo.getQuiet = true;
        return statsTo;
    }

    public List getCacheProperties(String region) {
        ArrayList result = new ArrayList();
        String appName = FusionContext.getCurrent().getApplicationName();
        if (region == null) {
            this.populateCacheProperties(appName, null, "OBJECT", result);
            this.populateCacheProperties(appName, null, "TEMPLATE", result);
            this.populateCacheProperties(appName, null, "QUERY", result);
        } else {
            this.populateCacheProperties(appName, null, region, result);
        }
        return result;
    }

    private void populateCacheProperties(String appName, String objType, String region, ArrayList result) {
        AuxiliaryCache[] auxs;
        if (objType == null) {
            objType = "OBJECT";
        }
        String mgrKey = CacheTagHelper.getCacheKey2((String)region, (String)appName, (String)objType, (String)this.configFilePath);
        CompositeCacheManager cacheManager = this.getCacheManager();
        String mgrCalcKey = CacheTagHelper.calculateKeyHash((Object)mgrKey);
        CompositeCache cacheObj = null;
        boolean exists = this.cacheExists(region, objType);
        if (!exists) {
            if (!CacheTagHelper.isStandardCacheRegion((String)region)) {
                throw new CacheExceptions.CacheNotFoundException(region);
            }
            this.createCache(region, objType, null, null);
        }
        cacheObj = cacheManager.getCache(mgrCalcKey);
        objType = !CacheTagHelper.isStandardCacheRegion((String)region) ? "ANY" : region.toUpperCase();
        Struct objSettings = new Struct();
        objSettings.put((Object)"OBJECTTYPE", (Object)objType);
        String cacheName = CacheTagHelper.getTrimmedCacheName((String)cacheObj.getCacheName(), (String)appName);
        if (appName != null && cacheName.startsWith(appName)) {
            cacheName = cacheName.substring(cacheName.indexOf(appName) + appName.length());
        }
        objSettings.put((Object)"NAME", (Object)cacheName);
        ICompositeCacheAttributes config = cacheObj.getCacheAttributes();
        IElementAttributes elementsConfig = cacheObj.getElementAttributes();
        if (this.applicationName == null || this.cacheConfig == null || elementsConfig != null && exists) {
            max = this.getStatsInstance().get((Object)(JCSSTATS_CACHE_MAXELEMENTS + cacheObj.getCacheName()));
            if (null == max) {
                max = config.getMaxObjects();
            }
            objSettings.put((Object)"MAXELEMENTSINMEMORY", (Object)("" + max));
            objSettings.put((Object)"TIMETOIDLESECONDS", (Object)("" + elementsConfig.getIdleTime()));
            objSettings.put((Object)"TIMETOLIVESECONDS", (Object)("" + elementsConfig.getMaxLife()));
            objSettings.put((Object)"ETERNAL", (Object)("" + elementsConfig.getIsEternal()));
        } else {
            max = this.getStatsInstance().get((Object)(JCSSTATS_CACHE_MAXELEMENTS + cacheObj.getCacheName()));
            if (null == max) {
                max = config.getMaxObjects();
            }
            max = this.cacheConfig.getCacheMaxElements();
            objSettings.put((Object)"MAXELEMENTSINMEMORY", (Object)("" + max));
            objSettings.put((Object)"TIMETOLIVESECONDS", (Object)("" + this.cacheConfig.getCacheTimeSpan()));
            objSettings.put((Object)"TIMETOIDLESECONDS", (Object)("" + this.cacheConfig.getCacheIdleTime()));
            objSettings.put((Object)"ETERNAL", (Object)("" + this.cacheConfig.isCacheEternal()));
        }
        for (AuxiliaryCache aux : auxs = cacheObj.getAuxCaches()) {
            if (!(aux instanceof IndexedDiskCache)) continue;
            IndexedDiskCacheAttributes idca = (IndexedDiskCacheAttributes)((IndexedDiskCache)aux).getAuxiliaryCacheAttributes();
            objSettings.put((Object)"DISKPERSISTENT", (Object)(idca.getDiskPath() != null ? 1 : 0));
            objSettings.put((Object)"DISKSTORE", (Object)idca.getDiskPath().getAbsolutePath());
        }
        result.add(objSettings);
    }

    public CacheAccess<Object, Object> getCache(final String appname, final String objecttype, final String key) {
        if (System.getSecurityManager() == null) {
            return this._getCache(appname, objecttype, key);
        }
        try {
            return (CacheAccess)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    String appN = appname;
                    String objType = objecttype;
                    return GenericJCSCache.this._getCache(appN, objType, key);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (CacheException)e.getException();
        }
    }

    private CacheAccess<Object, Object> _getCache(String appname, String objecttype, String key) {
        String mgrKey = CacheTagHelper.getCacheKey2((String)key, (String)appname, (String)objecttype, (String)this.configFilePath);
        this.getCacheManager();
        CacheAccess cache = null;
        String calcKey = CacheTagHelper.calculateKeyHash((Object)mgrKey);
        cache = JCS.getInstance((String)calcKey);
        return cache;
    }

    public void clearCache(String region) {
        CompositeCacheManager mgr = this.getCacheManager();
        CompositeCache regionCache = mgr.getCache(region);
        List<CompositeCache<Object, Object>> allCaches = this.getApplicationRegionCaches(region, mgr);
        if (regionCache != null) {
            allCaches.add((CompositeCache<Object, Object>)regionCache);
        }
        for (CompositeCache<Object, Object> cache : allCaches) {
            if (cache == null) continue;
            try {
                cache.removeAll();
            }
            catch (IOException iOException) {}
        }
    }

    private List<CompositeCache<Object, Object>> getApplicationRegionCaches(String region, CompositeCacheManager mgr) {
        Enumeration appNames;
        ArrayList<CompositeCache<Object, Object>> caches = new ArrayList<CompositeCache<Object, Object>>();
        if (!this.isApplicationSpecificCache() && CacheTagHelper.isStandardCacheRegion((String)region) && (appNames = ApplicationScopeTracker.getApplicationKeys()) != null) {
            while (appNames.hasMoreElements()) {
                String cacheKey = CacheTagHelper.getCacheKey2((String)region, (String)((String)appNames.nextElement()), null, (String)this.configFilePath);
                CompositeCache cache = mgr.getCache(cacheKey);
                if (cache == null) continue;
                caches.add((CompositeCache<Object, Object>)cache);
            }
        }
        return caches;
    }

    public ArrayList getAllCacheMetadataForMonitoring(boolean server) {
        String[] regions = this.getAllCacheNames();
        ArrayList<Struct> appr = new ArrayList<Struct>();
        for (String region : regions) {
            Struct resultObj = new Struct();
            if (CacheTagHelper.skipRegionForMonitoring((String)region, (String)this.configFilePath, (String)this.applicationName, (boolean)server)) continue;
            resultObj = this.getAllCacheMetadataForMonitoring(region, server);
            appr.add(resultObj);
        }
        return appr;
    }

    private Struct getAllCacheMetadataForMonitoring(String region, boolean server) {
        Struct resultObj = new Struct();
        String metaname = CacheTagHelper.getRegionNameForMonitoring((String)region, (String)this.applicationName, (GenericCache)this, (boolean)server);
        resultObj.put((Object)"APPLICATIONNAME", (Object)metaname);
        resultObj.put((Object)"ENGINE", (Object)this.getEngine());
        CacheTO statsTo = new CacheTO();
        statsTo.setId((Object)(JCSSTATS_CACHE_HITCOUNT + region));
        statsTo.getQuiet = true;
        Object cStats = JCS.getInstance((String)STATS_REGION).get(statsTo.id);
        if (cStats == null) {
            resultObj.put((Object)"CACHE_HITCOUNT", (Object)0);
        } else {
            resultObj.put((Object)"CACHE_HITCOUNT", cStats);
        }
        statsTo.setId((Object)(JCSSTATS_CACHE_MISSCOUNT + region));
        Object missStats = JCS.getInstance((String)STATS_REGION).get(statsTo.id);
        if (missStats == null) {
            resultObj.put((Object)"CACHE_MISSCOUNT", (Object)0);
        } else {
            resultObj.put((Object)"CACHE_MISSCOUNT", missStats);
        }
        JCSAdminBean admin = new JCSAdminBean();
        if (this.cacheManager != null) {
            CompositeCache cache = this.cacheManager.getCache(region);
            CacheElementInfo[] infos = null;
            try {
                infos = admin.buildElementInfo(region);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            CacheRegionInfo[] regionInfos = null;
            try {
                regionInfos = admin.buildCacheInfo();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (regionInfos != null) {
                for (CacheRegionInfo regionInfo : regionInfos) {
                    if (regionInfo == null || !regionInfo.getCacheName().equals(region)) continue;
                    long missCountNotFound = regionInfo.getMissCountNotFound();
                    if (missStats != null) {
                        missCountNotFound = (Long)missStats;
                    }
                    if (cStats == null) {
                        resultObj.put((Object)"HITRATIO", (Object)new Double(0.0));
                    } else {
                        long cs = (Long)cStats;
                        if (cs == 0L) {
                            resultObj.put((Object)"HITRATIO", (Object)new Double(0.0));
                        } else {
                            resultObj.put((Object)"HITRATIO", (Object)new Double((double)cs / (double)(missCountNotFound + cs)));
                        }
                    }
                    int size = regionInfo.getCacheSize();
                    resultObj.put((Object)"NUMBER", (Object)new Long(size));
                    resultObj.put((Object)"CACHESIZE", (Object)new Long(regionInfo.getByteCount()));
                }
            } else {
                Set keys = cache.getKeySet();
                long cummSize = 0L;
                for (Object key : keys) {
                    ICacheElement value = cache.get(key);
                    cummSize = CacheTagHelper.getSerializedSize((Object)value);
                }
                if (cStats == null) {
                    resultObj.put((Object)"HITRATIO", (Object)new Double(0.0));
                } else {
                    long cs = (Long)cStats;
                    long missCountNotFound = (Long)resultObj.get((Object)"CACHE_MISSCOUNT");
                    resultObj.put((Object)"HITRATIO", (Object)new Double((double)cs / (double)(missCountNotFound + cs)));
                }
                resultObj.put((Object)"NUMBER", (Object)keys.size());
                resultObj.put((Object)"CACHESIZE", (Object)cummSize);
            }
        }
        return resultObj;
    }

    public void removeCache(String cacheName) {
        if (cacheName != null) {
            if (CacheTagHelper.isStandardCacheRegion((String)cacheName)) {
                throw new CacheExceptions.ImpicitCacheRegionDeletionException(cacheName);
            }
            CompositeCacheManager mgr = this.getCacheManager();
            String cacheKey = CacheTagHelper.getCacheKey2((String)cacheName, (String)FusionContext.getCurrent().getApplicationName(), (String)"OBJECT", (String)this.configFilePath);
            if (!this.cacheExists(cacheName)) {
                throw new CacheExceptions.CacheNotFoundException(cacheName);
            }
            CompositeCache cache = mgr.getCache(cacheKey);
            try {
                if (cache.get((Object)(JCSSTATS_CACHE_HITCOUNT + cacheName)) != null) {
                    cache.remove((Object)(JCSSTATS_CACHE_HITCOUNT + cacheName));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (cache.get((Object)(JCSSTATS_CACHE_MISSCOUNT + cacheName)) != null) {
                    cache.remove((Object)(JCSSTATS_CACHE_MISSCOUNT + cacheName));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                cache.removeAll();
                mgr.freeCache(cacheKey);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            insMap.remove(cacheKey);
        }
    }

    public String[] getAllCacheNames() {
        return this.getCacheManager().getCacheNames();
    }

    public boolean isApplicationSpecificCache() {
        return this.configFilePath != null;
    }

    private CacheAccess<Object, Object> getCache(final CacheTO xObj, final boolean throwError) {
        if (System.getSecurityManager() == null) {
            return this._getCache(xObj, throwError);
        }
        try {
            return (CacheAccess)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return GenericJCSCache.this._getCache(xObj, throwError);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (CacheException)e.getException();
        }
    }

    private CacheAccess<Object, Object> _getCache(final CacheTO xObj, boolean throwError) {
        String mgrKey = CacheTagHelper.getCacheKey2((String)xObj.region, (String)xObj.appname, (String)xObj.objecttype, (String)this.configFilePath);
        if (null != insMap.get(mgrKey)) {
            return insMap.get(mgrKey);
        }
        CompositeCacheManager cacheMgr = this.getCacheManager();
        final ICompositeCacheAttributes attrs = cacheMgr.getDefaultCacheAttributes();
        boolean exist = false;
        String[] regions = this.getAllCacheNames();
        exist = Arrays.asList(regions).contains(mgrKey);
        if (!(exist || !throwError || xObj.region == null || xObj.region.equalsIgnoreCase("OBJECT") || xObj.region.equalsIgnoreCase("QUERY") || xObj.region.equalsIgnoreCase("TEMPLATE"))) {
            throw new CacheExceptions.CacheNotFoundException(xObj.region);
        }
        if (!exist) {
            this.createCache(xObj.region, xObj.objecttype, null, null);
            String appName = null;
            FusionContext context = FusionContext.getCurrent();
            if (context != null && (appName = context.getApplicationName()) == null && context.cacheConfig != null) {
                appName = context.cacheConfig.applicationName;
            }
            mgrKey = CacheTagHelper.getCacheKey2((String)xObj.region, (String)appName, (String)xObj.objecttype, (String)this.configFilePath);
        }
        final String imgrKey = mgrKey;
        CacheAccess finalCache = null;
        try {
            finalCache = (CacheAccess)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    CacheAccess cache = JCS.getInstance((String)imgrKey, (ICompositeCacheAttributes)attrs);
                    insMap.put(imgrKey, (CacheAccess<Object, Object>)cache);
                    if (xObj.directory != null && xObj.directory.length() > 0) {
                        GenericJCSCache.this.setAuxiliaryCache((CompositeCache<Object, Object>)cache.getCacheControl(), xObj.directory, null);
                    }
                    return cache;
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (CacheException)e.getException();
        }
        return finalCache;
    }

    private CompositeCacheManager getCacheManager() {
        if (this.cacheManager == null) {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        String configFilename = ServiceFactory.getRuntimeService().getLibDir() + File.separator + "cache.ccf";
                        Properties props = new Properties();
                        if (configFilename != null) {
                            try (FileReader f = new FileReader(configFilename);){
                                props.load(f);
                                JCS.setConfigProperties((Properties)props);
                            }
                            catch (IOException e) {
                                CFLogs.APPLICATION_LOG.error((Throwable)e);
                            }
                        }
                        GenericJCSCache.this.cacheManager = CompositeCacheManager.getUnconfiguredInstance();
                        GenericJCSCache.this.cacheManager.configure(props);
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException e) {
                throw (CacheException)e.getException();
            }
            CacheTagHelper.createDefaultCache((GenericCache)this, (CacheConfig)this.cacheConfig);
        }
        return this.cacheManager;
    }

    public void reset() {
        this.cacheManager = null;
    }

    public String getEngine() {
        return "JCS";
    }
}

