/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.cache;

import coldfusion.cache.ObjectSizeCalculator;
import coldfusion.cache.custom.GenericCustomCache;
import coldfusion.cache.ehcache.GenericEhcache;
import coldfusion.cache.jcs.GenericJCSCache;
import coldfusion.cache.memcached.GenericMemcachedCache;
import coldfusion.cache.redis.GenericRedisCache;
import coldfusion.featurerouter.EFRConstants;
import coldfusion.featurerouter.FeatureRouter;
import coldfusion.log.CFLogs;
import coldfusion.osgi.services.CachingService;
import coldfusion.runtime.CachedBufferedOutputStream;
import coldfusion.tagext.io.cache.GenericCache;
import coldfusion.tagext.io.cache.GenericCacheFactory;
import coldfusion.tagext.io.cache.ehcache.EHcachePageInfo;
import coldfusion.tagext.io.cache.ehcache.GenericResponseWrapper;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Status;
import net.spy.memcached.AddrUtil;
import net.spy.memcached.MemcachedClient;
import net.spy.memcached.MemcachedNode;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisCluster;

public class CachingServiceImpl
implements CachingService {
    private static final int CACHETYPE_UNKNOWN = -1;
    public static final int EHCACHE_TYPE = 0;
    public static final int JCS_TYPE = 1;
    public static final int REDIS_TYPE = 2;
    public static final int MEMCACHED_TYPE = 3;
    private static Map<String, GenericCache> customCacheMap = new HashMap<String, GenericCache>();

    public void writeContent(HttpServletRequest request, HttpServletResponse response, EHcachePageInfo pageInfo) throws Exception {
        byte[] body = pageInfo.getUngzippedBody();
        boolean shouldBodyBeZero = this.shouldBodyBeZero(request, pageInfo.getStatusCode());
        if (shouldBodyBeZero) {
            body = new byte[]{};
        }
        response.setContentLength(body.length);
        if (response instanceof GenericResponseWrapper) {
            ((CachedBufferedOutputStream)response.getOutputStream()).writeThrough(body);
        } else {
            response.getOutputStream().write(body);
        }
    }

    public String verifyMemcachedConnection(String server) {
        MemcachedClient mcClient;
        ArrayList<String> servers = new ArrayList<String>();
        for (String ser : server.split(",")) {
            servers.add(ser);
        }
        try {
            mcClient = new MemcachedClient(AddrUtil.getAddresses(servers));
        }
        catch (Throwable e) {
            return "false";
        }
        for (MemcachedNode node : mcClient.getNodeLocator().getAll()) {
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (node.isActive()) continue;
            mcClient.shutdown();
            return node.getSocketAddress().toString();
        }
        return "";
    }

    public GenericCache getCachingEngineImpl(int type, String cacheConfigPath, String appName, Map configMap, String engine, boolean isCFLoginRedisSessionStorage) {
        GenericCache temp = null;
        switch (type) {
            case 3: {
                CachingServiceImpl.checkForEnterpriseAccess();
                temp = new GenericMemcachedCache(cacheConfigPath, appName, configMap);
                break;
            }
            case 1: {
                temp = new GenericJCSCache(cacheConfigPath, appName, configMap);
                break;
            }
            case 2: {
                CachingServiceImpl.checkForEnterpriseAccess();
                temp = new GenericRedisCache(cacheConfigPath, appName, configMap, isCFLoginRedisSessionStorage);
                break;
            }
            case 0: {
                temp = new GenericEhcache(cacheConfigPath, appName);
                break;
            }
            default: {
                temp = CachingServiceImpl.createCustomCache(engine);
            }
        }
        return temp;
    }

    public GenericCache getServerCachingEngineImpl(int type) {
        GenericCache currentCacheImpl = null;
        switch (type) {
            case 3: {
                currentCacheImpl = new GenericMemcachedCache();
                break;
            }
            case 1: {
                currentCacheImpl = new GenericJCSCache();
                break;
            }
            case 2: {
                currentCacheImpl = new GenericRedisCache();
                break;
            }
            case 0: {
                currentCacheImpl = new GenericEhcache();
                break;
            }
            default: {
                currentCacheImpl = new GenericEhcache();
            }
        }
        return currentCacheImpl;
    }

    public GenericCache getRedisForCFLogin() {
        return new GenericRedisCache(true);
    }

    private static GenericCache createCustomCache(String engine) {
        GenericCache customCache = customCacheMap.get(engine);
        if (customCache == null) {
            customCache = new GenericCustomCache(engine);
            customCacheMap.put(engine, customCache);
        }
        return customCache;
    }

    private static void checkForEnterpriseAccess() {
        if (!FeatureRouter.getInstance().isFeatureAllowed(EFRConstants.cache_new_engines.intValue())) {
            throw new GenericCacheFactory.CachingFeatureNotAvailableException(EFRConstants.cache_new_engines.intValue());
        }
    }

    public long getObjectSize(Object o) {
        return ObjectSizeCalculator.getObjectSize(o);
    }

    public void stopCacheManager(GenericCache cacheManager) {
        try {
            GenericEhcache mgr;
            CacheManager ehcacheManager;
            if (cacheManager instanceof GenericEhcache && (ehcacheManager = (mgr = (GenericEhcache)cacheManager).getCacheManager()) != null && !ehcacheManager.getName().equals("__DEFAULT__") && ehcacheManager.getStatus().equals(Status.STATUS_ALIVE)) {
                ehcacheManager.shutdown();
            }
        }
        catch (Exception e) {
            CFLogs.SERVER_LOG.error((Object)("Failed to shutdown cache manager for application  - " + e));
        }
    }

    public void resetCache(GenericCache cache, int cacheType) {
        if (cacheType == 0 && cache instanceof GenericEhcache) {
            cache.reset();
        }
        if (cacheType == 3 && cache instanceof GenericMemcachedCache) {
            cache.reset();
        }
        if (cacheType == 2 && cache instanceof GenericRedisCache) {
            cache.reset();
        }
        if (cacheType == 1 && cache instanceof GenericJCSCache) {
            cache.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testConnection(String host, int port, String password, boolean isCluster, boolean isSSL) {
        if (!isCluster) {
            try (Jedis connection = null;){
                connection = new Jedis(host, port, isSSL);
                if (password != null && !password.trim().equalsIgnoreCase("")) {
                    connection.auth(password);
                }
                connection.ping();
                connection.set("test", "test");
                connection.del("test");
            }
        }
        try (JedisCluster con = null;){
            HashSet<HostAndPort> jedisClusterNode = new HashSet<HostAndPort>();
            if (host.contains(",")) {
                for (String hst : host.split(",")) {
                    jedisClusterNode.add(new HostAndPort(hst, port));
                }
            } else {
                jedisClusterNode.add(new HostAndPort(host, port));
            }
            con = password != null && password.length() > 0 ? new JedisCluster(jedisClusterNode, 0, 0, 5, password, new GenericObjectPoolConfig()) : new JedisCluster(jedisClusterNode, new GenericObjectPoolConfig());
        }
    }

    private boolean shouldBodyBeZero(HttpServletRequest request, int responseStatus) {
        if (responseStatus == 204) {
            if (CFLogs.SERVER_LOG.isDebugEnabled()) {
                CFLogs.SERVER_LOG.debug((Object)(request.getRequestURL() + " resulted in a 204 response. Removing message body in accordance with RFC2616."));
            }
            return true;
        }
        if (responseStatus == 304) {
            if (CFLogs.SERVER_LOG.isDebugEnabled()) {
                CFLogs.SERVER_LOG.debug((Object)(request.getRequestURL() + " resulted in a 304 response. Removing message body in accordance with RFC2616."));
            }
            return true;
        }
        return false;
    }
}

