/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.cloud.aws.sns;

import coldfusion.cloud.util.ConsumerMap;
import coldfusion.cloud.util.ConsumerValidator;
import coldfusion.cloud.util.FieldTypecastUtil;
import coldfusion.cloud.validator.NotNullValidator;
import coldfusion.runtime.CFBoolean;
import coldfusion.runtime.Cast;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.services.sns.model.MessageAttributeValue;
import software.amazon.awssdk.services.sns.model.PublishRequest;

public class SNSPublishMetadata {
    static SNSPublishMetadata instance = null;
    ConsumerMap<PublishRequest.Builder> consumerMap = new ConsumerMap();
    private static final String STRING_ARRAY_DELIMITER = ",";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SNSPublishMetadata getInstance() {
        if (instance != null) return instance;
        Class<SNSPublishMetadata> clazz = SNSPublishMetadata.class;
        synchronized (SNSPublishMetadata.class) {
            instance = new SNSPublishMetadata();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private SNSPublishMetadata() {
        this.consumerMap.put((Object)"phoneNumber", new ConsumerValidator((filler, val) -> filler.phoneNumber(FieldTypecastUtil.INSTANCE.getStringProperty(val)), null));
        this.consumerMap.put((Object)"topicArn", new ConsumerValidator((filler, val) -> filler.topicArn(FieldTypecastUtil.INSTANCE.getStringProperty(val)), null));
        this.consumerMap.put((Object)"messageStructure", new ConsumerValidator((filler, val) -> filler.messageStructure(FieldTypecastUtil.INSTANCE.getStringProperty(val)), null));
        this.consumerMap.put((Object)"subject", new ConsumerValidator((filler, val) -> filler.subject(FieldTypecastUtil.INSTANCE.getStringProperty(val)), null));
        this.consumerMap.put((Object)"messageBody", new ConsumerValidator((filler, val) -> filler.message(FieldTypecastUtil.INSTANCE.getStringProperty(val)), Arrays.asList(NotNullValidator.INSTANCE)));
        this.consumerMap.put((Object)"messageAttributes", new ConsumerValidator((filler, val) -> filler.messageAttributes(this.constructMessageAttriutes(FieldTypecastUtil.INSTANCE.getStringObjectMapProperty(val))), null));
    }

    private Map<String, MessageAttributeValue> constructMessageAttriutes(Map<String, Object> stringObjectMapProperty) {
        HashMap<String, MessageAttributeValue> attributesConstructed = new HashMap<String, MessageAttributeValue>();
        Set<String> keys = stringObjectMapProperty.keySet();
        keys.forEach(key -> {
            Object val = stringObjectMapProperty.get(key);
            String strValue = SNSPublishMetadata.getStringValue(val);
            if (strValue != null) {
                String dataType = val instanceof Number ? "Number" : (val instanceof List ? "String.Array" : "String");
                attributesConstructed.put((String)key, (MessageAttributeValue)MessageAttributeValue.builder().stringValue(strValue).dataType(dataType).build());
            } else {
                attributesConstructed.put((String)key, (MessageAttributeValue)MessageAttributeValue.builder().binaryValue(SdkBytes.fromByteArray((byte[])Cast._Binary(val))).dataType("Binary").build());
            }
        });
        return attributesConstructed;
    }

    private static String getStringValue(Object val) {
        if (val instanceof String) {
            return (String)val;
        }
        if (val instanceof Number) {
            return Cast._String((Object)val);
        }
        if (val instanceof Boolean || val instanceof Date) {
            return val.toString();
        }
        if (val instanceof CFBoolean) {
            return String.valueOf(((CFBoolean)val).value);
        }
        if (val instanceof List) {
            StringBuilder builder = new StringBuilder("[");
            List values = (List)val;
            if (values != null && values.size() > 0) {
                values.forEach(value -> {
                    if (value == null) {
                        builder.append("null").append(STRING_ARRAY_DELIMITER);
                    } else if (value instanceof Number) {
                        builder.append(Cast._String((Object)value)).append(STRING_ARRAY_DELIMITER);
                    } else if (value instanceof Boolean) {
                        builder.append(value.toString()).append(STRING_ARRAY_DELIMITER);
                    } else if (value instanceof CFBoolean) {
                        builder.append(String.valueOf(((CFBoolean)value).value)).append(STRING_ARRAY_DELIMITER);
                    } else {
                        builder.append("\"").append(Cast._String((Object)value)).append("\"").append(STRING_ARRAY_DELIMITER);
                    }
                });
            }
            return builder.append("]").toString();
        }
        return null;
    }

    public ConsumerMap<PublishRequest.Builder> getConsumerMap() {
        return this.consumerMap;
    }

    public void setConsumerMap(ConsumerMap<PublishRequest.Builder> consumerMap) {
        this.consumerMap = consumerMap;
    }
}

