/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.debugger.rds;

import coldfusion.debugger.rds.RdsServlet;
import coldfusion.debugger.rds.handler.DebuggerRDSRequestManager;
import coldfusion.rds.RdsRequest;
import coldfusion.rds.RdsResponse;
import coldfusion.security.AuthorizedUser;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletException;
import java.io.IOException;

public class DebuggerServlet
extends RdsServlet {
    private DebuggerRDSRequestManager reqMgr = null;
    private ServletException initException = null;

    @Override
    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.initilizeDebugger(config);
    }

    private void initilizeDebugger(ServletConfig config) {
        String strPort = null;
        String strMaxSession = null;
        int port = -1;
        int maxDebugSessions = 5;
        String cfRootDir = null;
        String ctxRoot = null;
        String canonicalCtxRoot = null;
        boolean traceDebugger = false;
        String host = config.getInitParameter("DEBUG_HOST");
        if (host == null) {
            host = "localhost";
        }
        strPort = config.getInitParameter("DEBUG_PORT");
        strMaxSession = config.getInitParameter("MAX_DEBUG_SESSIONS");
        String tmpObj = config.getInitParameter("CTX_ROOT");
        if (tmpObj != null) {
            ctxRoot = tmpObj.toString();
            tmpObj = config.getInitParameter("CANONICAL_CTX_ROOT");
            if (tmpObj != null) {
                canonicalCtxRoot = tmpObj.toString();
            }
        }
        if (host == null || strPort == null) {
            this.initException = new ServletException("HOST and PORT parameters are required to start CF Debugger");
            return;
        }
        try {
            port = Integer.parseInt(strPort);
        }
        catch (NumberFormatException ne) {
            this.initException = new ServletException("Invalid PORT number parameter", (Throwable)ne);
            return;
        }
        try {
            if (strMaxSession != null) {
                maxDebugSessions = Integer.parseInt(strMaxSession);
            }
        }
        catch (NumberFormatException ne) {
            this.initException = new ServletException("Invalid MAX_DEBUG_SESSIONS", (Throwable)ne);
            return;
        }
        String traceStr = config.getInitParameter("DEBUGGER_TRACE");
        if (traceStr != null && traceStr.toLowerCase().equals("true")) {
            traceDebugger = true;
        }
        this.reqMgr = new DebuggerRDSRequestManager(host, ctxRoot, canonicalCtxRoot, port, cfRootDir, maxDebugSessions, traceDebugger);
    }

    public String getServletInfo() {
        return "CF Debugger Servlet";
    }

    @Override
    protected void processCmd(RdsRequest req, RdsResponse resp, AuthorizedUser user) throws ServletException, IOException {
        if (this.initException != null) {
            throw this.initException;
        }
        this.reqMgr.processRequest(req, resp);
    }

    public void stopDebugger(boolean cfShutdown) {
        if (this.reqMgr != null) {
            this.reqMgr.stopDebugger(cfShutdown);
        }
    }
}

