/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.debugger;

import coldfusion.debugger.CFDebuggerLogger;
import coldfusion.debugger.JVMDebugThread;
import coldfusion.debugger.ThreadRefComparator;
import com.sun.jdi.Location;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VirtualMachine;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;

public class JVMDebugThreadManager {
    private static Hashtable jvmThreadMap = new Hashtable();
    private static Hashtable threadSessionMap = new Hashtable();

    public static JVMDebugThread getThread(String name) {
        if (name == null) {
            return null;
        }
        Object obj = jvmThreadMap.get(name);
        return obj == null ? null : (JVMDebugThread)obj;
    }

    public static JVMDebugThread getThread(ThreadReference thr) {
        JVMDebugThread th = JVMDebugThreadManager.getThread(thr.name());
        if (th != null) {
            return th;
        }
        return JVMDebugThreadManager.setThread(thr);
    }

    public static JVMDebugThread setThread(ThreadReference th) {
        if (!jvmThreadMap.containsKey(th.name())) {
            JVMDebugThread thr = new JVMDebugThread(th);
            jvmThreadMap.put(th.name(), thr);
            return thr;
        }
        return (JVMDebugThread)jvmThreadMap.get(th.name());
    }

    public static Location getLastLocation(String threadName) {
        JVMDebugThread th = JVMDebugThreadManager.getThread(threadName);
        return th == null ? null : th.getLastLocation();
    }

    public static void setLastLocation(String threadName, Location loc) {
        JVMDebugThread th = JVMDebugThreadManager.getThread(threadName);
        if (th != null) {
            th.setLastLocation(loc);
        }
    }

    public static int getLastStepRequest(String threadName) {
        JVMDebugThread th = JVMDebugThreadManager.getThread(threadName);
        return th == null ? -1 : th.getLastStepRequest();
    }

    public static void setLastStepRequest(String threadName, int stepRequest) {
        JVMDebugThread th = JVMDebugThreadManager.getThread(threadName);
        if (th != null) {
            th.setLastStepRequest(stepRequest);
        }
    }

    public static ArrayList getThreads(String sessionId) throws Throwable {
        ArrayList<JVMDebugThread> threads = new ArrayList<JVMDebugThread>();
        for (JVMDebugThread thr : jvmThreadMap.values()) {
            if (!sessionId.equals(thr.getSessionId())) continue;
            threads.add(thr);
        }
        return threads;
    }

    public static String getThreadStatus(int status) {
        switch (status) {
            case -1: {
                return "Unknown";
            }
            case 0: {
                return "Zombie";
            }
            case 3: {
                return "Monitor";
            }
            case 2: {
                return "Sleeping";
            }
            case 1: {
                return "Running";
            }
            case 4: {
                return "Wait";
            }
            case 5: {
                return "Not Started";
            }
        }
        return "Not Sure";
    }

    public static void dumpThreadInfo(VirtualMachine vm) {
        try {
            List<ThreadReference> ths = vm.allThreads();
            System.out.println("\n\nDumping threads ...\n\n");
            for (ThreadReference thr : ths) {
                System.out.print("Thread name - " + thr.name() + " : Status - " + JVMDebugThreadManager.getThreadStatus(thr.status()));
                System.out.println("");
            }
        }
        catch (Throwable e) {
            CFDebuggerLogger.log(e);
        }
    }

    public static boolean resumeWaitingThreads(VirtualMachine vm) {
        boolean threadResumed = false;
        try {
            List<ThreadReference> ths = vm.allThreads();
            for (ThreadReference thr : ths) {
                if (!thr.isSuspended() && !thr.isAtBreakpoint()) continue;
                thr.resume();
                threadResumed = true;
            }
        }
        catch (Throwable e) {
            CFDebuggerLogger.log(e);
        }
        return threadResumed;
    }

    public static ArrayList getVMThreads(VirtualMachine vm) throws Throwable {
        if (vm == null) {
            return null;
        }
        List<ThreadReference> threads = vm.allThreads();
        Object[] threadsArray = threads.toArray();
        Arrays.sort(threadsArray, new ThreadRefComparator());
        ArrayList<Object[]> threadsVec = new ArrayList<Object[]>();
        for (int i = 0; i < threadsArray.length; ++i) {
            ThreadReference thr = (ThreadReference)threadsArray[i];
            String name = thr.name();
            String status = JVMDebugThreadManager.getThreadStatus(thr.status());
            Object[] threadInfo = new Object[]{name, status};
            threadsVec.add(threadInfo);
        }
        return threadsVec;
    }

    public static String getSessionIdForThread(String threadName) {
        Object tmpObj = threadSessionMap.get(threadName);
        if (tmpObj == null) {
            return null;
        }
        return (String)tmpObj;
    }

    public static void setSessionIdForThread(String threadName, String sessionId) {
        if (sessionId == null) {
            threadSessionMap.remove(threadName);
        } else {
            threadSessionMap.put(threadName, sessionId);
        }
    }
}

