/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.debugger;

import coldfusion.util.SoftCache;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import java.lang.invoke.CallSite;
import java.util.HashMap;
import java.util.List;

public class ClassMethodLineTableCache
extends SoftCache {
    private static ClassMethodLineTableCache cacheInstance = new ClassMethodLineTableCache();

    private ClassMethodLineTableCache() {
    }

    protected Object fetch(Object key) {
        return null;
    }

    public Object get(Object key) {
        throw new RuntimeException("Method not implemented");
    }

    public static int checkCodeIndex(Method method, long codeIndex) {
        return cacheInstance.checkCodeIndexHelper(method, codeIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeClass(String className) {
        ClassMethodLineTableCache classMethodLineTableCache = cacheInstance;
        synchronized (classMethodLineTableCache) {
            cacheInstance.remove(className);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int checkCodeIndexHelper(Method method, long codeIndex) {
        Object[] lineCodeArrays;
        Object lineNumMapObj;
        HashMap<CallSite, Object[]> mapObj = null;
        String className = method.declaringType().name();
        ClassMethodLineTableCache classMethodLineTableCache = this;
        synchronized (classMethodLineTableCache) {
            mapObj = super.get((Object)className);
        }
        HashMap<CallSite, Object[]> methodMap = null;
        String methodKey = method.name() + method.signature();
        if (mapObj == null) {
            try {
                Object[] lineCodeArrays2 = this.codeIndicesInLineTable(method);
                if (lineCodeArrays2 == null) {
                    return -1;
                }
                methodMap = new HashMap<CallSite, Object[]>();
                methodMap.put((CallSite)((Object)methodKey), lineCodeArrays2);
                mapObj = methodMap;
            }
            catch (Throwable e) {
                return -1;
            }
            if (mapObj == null) {
                return -1;
            }
            ClassMethodLineTableCache e = this;
            synchronized (e) {
                super.put((Object)className, mapObj);
            }
        }
        if ((lineNumMapObj = (methodMap = (HashMap<CallSite, Object[]>)mapObj).get(methodKey)) == null) {
            lineCodeArrays = this.codeIndicesInLineTable(method);
            if (lineCodeArrays == null) {
                return -1;
            }
            methodMap.put((CallSite)((Object)methodKey), lineCodeArrays);
            lineNumMapObj = lineCodeArrays;
        }
        lineCodeArrays = (Object[])lineNumMapObj;
        long[] codeIndexArray = (long[])lineCodeArrays[0];
        long[] lineNumArray = (long[])lineCodeArrays[1];
        for (int i = 0; i < codeIndexArray.length; ++i) {
            if (codeIndexArray[i] != codeIndex) continue;
            return (int)lineNumArray[i];
        }
        return 0;
    }

    private Object[] codeIndicesInLineTable(Method method) {
        List<Location> lineLocations = null;
        try {
            lineLocations = method.allLineLocations();
        }
        catch (Throwable e) {
            return null;
        }
        int lineTableSize = lineLocations.size();
        long[] codeIndexes = new long[lineTableSize];
        long[] lineNumbers = new long[lineTableSize];
        int i = 0;
        for (Location loc1 : lineLocations) {
            codeIndexes[i] = loc1.codeIndex();
            lineNumbers[i] = loc1.lineNumber();
            ++i;
        }
        return new Object[]{codeIndexes, lineNumbers};
    }
}

