/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.debugger;

import coldfusion.debugger.CFDebuggerLogger;
import coldfusion.debugger.JVMDebugThreadManager;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ArrayType;
import com.sun.jdi.BooleanValue;
import com.sun.jdi.ByteValue;
import com.sun.jdi.CharValue;
import com.sun.jdi.ClassType;
import com.sun.jdi.DoubleValue;
import com.sun.jdi.Field;
import com.sun.jdi.FloatValue;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.InterfaceType;
import com.sun.jdi.InvocationException;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.Location;
import com.sun.jdi.LongValue;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.PrimitiveValue;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ShortValue;
import com.sun.jdi.StackFrame;
import com.sun.jdi.StringReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Value;
import com.sun.jdi.VirtualMachine;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class CFDebuggerUtils {
    public static final String DEBUG_SESSION_ID_ATTRIB_NAME = "debugsessionid";
    public static Method getAttributeMethod = null;
    public static Method setAttributeMethod = null;
    public static Method setSessionIdMethod = null;
    public static Method getDebugSessionIdMethod = null;
    public static Method autoscalarizeMethod = null;
    public static Method map_keySetMethod = null;
    public static Method set_iteratorMethod = null;
    public static Method itetator_hasNextMethod = null;
    public static Method iterator_nextMethod = null;
    public static Method map_getMethod = null;
    public static Method obj_toStringMethod = null;
    public static ClassType lineDebuggerClass = null;
    public static Method lineDebugger_getVariableValueMethod = null;
    public static Method lineDebugger_getVariableValueAsByteArrayMethod = null;
    public static Method lineDebugger_setVariableValueMethod = null;
    public static Method lineDebugger_getFunctionLocalVariables = null;
    public static Method lineDebugger_getCFOutput = null;
    public static Method lineDebugger_getFunctionLocalVariablesAsByteArray = null;
    private static Method lineDebugger_getExceptionStackTrace = null;
    private static final char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static HashMap threadMutexMap = new HashMap();
    private static Hashtable methodMap = new Hashtable();

    private static int getCharAsChars(char c, char[] ca) {
        char tmp = c;
        int len = 0;
        while (tmp > '\u0000') {
            tmp = (char)(tmp >> 4);
            ++len;
        }
        for (int i = 0; i < len; ++i) {
            ca[i] = hexDigits[c >> (len - 1 - i) * 4 & 0xF];
        }
        return len;
    }

    public static String getClassName(File pageFile) {
        String fileName = pageFile.getName();
        StringBuffer buf = new StringBuffer(fileName.length() + 20);
        char[] rep = new char[4];
        buf.append("cf");
        for (int i = 0; i < fileName.length(); ++i) {
            char c = fileName.charAt(i);
            if (!Character.isJavaIdentifierPart(c)) {
                if (c == '/') {
                    buf.append('_');
                    buf.append('_');
                    continue;
                }
                int len = CFDebuggerUtils.getCharAsChars(c, rep);
                buf.append(rep, 0, len);
                continue;
            }
            buf.append(c);
        }
        int hc = pageFile.hashCode();
        if (hc < 0) {
            hc ^= 0xFFFFFFFF;
        }
        buf.append(hc);
        return buf.toString();
    }

    private static boolean isInUDF(StackFrame frame) throws Throwable {
        Location loc = frame.location();
        Method m1 = loc.method();
        if (m1 == null) {
            return false;
        }
        return m1.name().equals("runFunction");
    }

    public static ObjectReference getCFPageObjectReference(ThreadReference th) throws Throwable {
        return CFDebuggerUtils.getCFPageObjectReference(th, 0);
    }

    public static ObjectReference getCFPageObjectReference(ThreadReference th, int stackFrameIndex) throws Throwable {
        if (!th.isSuspended() && !th.isAtBreakpoint()) {
            return null;
        }
        if (th.frameCount() > 0) {
            ClassType typ;
            StackFrame frame = th.frame(stackFrameIndex);
            ObjectReference thisObj = frame.thisObject();
            if (thisObj == null) {
                return null;
            }
            if (CFDebuggerUtils.isInUDF(frame)) {
                LocalVariable lv = frame.visibleVariableByName("parentPage");
                if (lv == null) {
                    return null;
                }
                Value v1 = frame.getValue(lv);
                if (!(v1 instanceof ObjectReference)) {
                    return null;
                }
                thisObj = (ObjectReference)v1;
            }
            if (CFDebuggerUtils.isClassInstanceOf(typ = (ClassType)thisObj.referenceType(), "coldfusion.runtime.CFPage")) {
                return thisObj;
            }
            return null;
        }
        return null;
    }

    public static ObjectReference getPagecontextObjectReference(ThreadReference th) throws Throwable {
        return CFDebuggerUtils.getPagecontextObjectReference(th, 0);
    }

    private static ObjectReference getPagecontextObjectReference(ThreadReference th, int stackFrameIndex) throws Throwable {
        if (!th.isSuspended() && !th.isAtBreakpoint()) {
            return null;
        }
        if (th.frameCount() > 0) {
            ClassType typ;
            StackFrame frame = th.frame(stackFrameIndex);
            ObjectReference thisObj = frame.thisObject();
            if (thisObj == null) {
                return null;
            }
            if (CFDebuggerUtils.isInUDF(frame)) {
                LocalVariable lv = frame.visibleVariableByName("parentPage");
                if (lv == null) {
                    return null;
                }
                Value v1 = frame.getValue(lv);
                if (!(v1 instanceof ObjectReference)) {
                    return null;
                }
                thisObj = (ObjectReference)v1;
            }
            if (CFDebuggerUtils.isClassInstanceOf(typ = (ClassType)thisObj.referenceType(), "coldfusion.runtime.NeoPageContext")) {
                return thisObj;
            }
            Field pageCtxField = typ.fieldByName("pageContext");
            if (pageCtxField == null) {
                return null;
            }
            ObjectReference pageCtxObj = (ObjectReference)thisObj.getValue(pageCtxField);
            return pageCtxObj;
        }
        return null;
    }

    private static boolean setDebugSessionId(ObjectReference pageContext, ThreadReference th, String sessionId) throws Throwable {
        ClassType pageCtxClass = (ClassType)pageContext.referenceType();
        if (setSessionIdMethod == null) {
            setSessionIdMethod = pageCtxClass.concreteMethodByName("setDebugSessionId", "(Ljava/lang/String;)V");
        }
        if (setSessionIdMethod == null) {
            return false;
        }
        ArrayList<StringReference> args = new ArrayList<StringReference>();
        VirtualMachine vm = th.virtualMachine();
        StringReference v1 = vm.mirrorOf(sessionId);
        v1.disableCollection();
        args.add(v1);
        pageContext.invokeMethod(th, setSessionIdMethod, args, 3);
        v1.enableCollection();
        return true;
    }

    private static String getDebugSessionId(ObjectReference pageContext, ThreadReference th) throws Throwable {
        ClassType pageCtxClass = (ClassType)pageContext.referenceType();
        if (getDebugSessionIdMethod == null) {
            getDebugSessionIdMethod = pageCtxClass.concreteMethodByName("getDebugSessionId", "()Ljava/lang/String;");
        }
        if (getDebugSessionIdMethod == null) {
            return null;
        }
        ArrayList args = new ArrayList();
        StringReference retObj = null;
        try {
            retObj = (StringReference)pageContext.invokeMethod(th, getDebugSessionIdMethod, args, 3);
        }
        catch (Throwable e) {
            retObj = null;
        }
        if (retObj == null) {
            return null;
        }
        return retObj.value();
    }

    public static String ObjectReferenceToString(ObjectReference objRef, ThreadReference th) throws Throwable {
        if (objRef == null) {
            return null;
        }
        ClassType classType = (ClassType)objRef.referenceType();
        Method m1 = classType.concreteMethodByName("toString", "()Ljava/lang/String;");
        if (m1 == null) {
            return null;
        }
        ArrayList args = new ArrayList();
        StringReference retObj = (StringReference)objRef.invokeMethod(th, m1, args, 1);
        if (retObj == null) {
            return null;
        }
        return retObj.value();
    }

    public static String getSessionId(ThreadReference thr) throws Throwable {
        if (!thr.isAtBreakpoint() && !thr.isSuspended()) {
            return null;
        }
        String sessionId = null;
        try {
            ObjectReference pageCtxObjRef = CFDebuggerUtils.getPagecontextObjectReference(thr);
            if (pageCtxObjRef == null) {
                return null;
            }
            sessionId = CFDebuggerUtils.getDebugSessionId(pageCtxObjRef, thr);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (sessionId == null) {
            return JVMDebugThreadManager.getSessionIdForThread(thr.name());
        }
        return sessionId;
    }

    public static void setSessionId(ThreadReference th, String sessionId) throws Throwable {
        if (!th.isAtBreakpoint() && !th.isSuspended()) {
            return;
        }
        ObjectReference pageCtxObjRef = CFDebuggerUtils.getPagecontextObjectReference(th);
        if (pageCtxObjRef == null) {
            return;
        }
        CFDebuggerUtils.setDebugSessionId(pageCtxObjRef, th, sessionId);
    }

    private static synchronized String getThreadMutex(ThreadReference th) {
        Object obj = threadMutexMap.get(th.name());
        if (obj == null) {
            threadMutexMap.put(th.name(), th.name());
            return th.name();
        }
        return (String)obj;
    }

    public static boolean isClassInstanceOf(ClassType classType, String parentName) throws Throwable {
        if (classType.name().equalsIgnoreCase(parentName)) {
            return true;
        }
        ClassType superClass = classType.superclass();
        if (superClass != null) {
            if (superClass.name().equals(parentName)) {
                return true;
            }
            if (CFDebuggerUtils.isClassInstanceOf(superClass, parentName)) {
                return true;
            }
        }
        List<InterfaceType> interfaces = classType.allInterfaces();
        for (InterfaceType iType : interfaces) {
            if (!CFDebuggerUtils.isInterfaceTypeOf(iType, parentName)) continue;
            return true;
        }
        return false;
    }

    public static boolean isInterfaceTypeOf(InterfaceType iType, String parentName) throws Throwable {
        if (iType.name().equals(parentName)) {
            return true;
        }
        List<InterfaceType> superInterfaces = iType.superinterfaces();
        for (InterfaceType superType : superInterfaces) {
            if (superType.name().equals(parentName)) {
                return true;
            }
            if (!CFDebuggerUtils.isInterfaceTypeOf(superType, parentName)) continue;
            return true;
        }
        return false;
    }

    public static Map getScopeVariables(String scopeName, ThreadReference thread) throws Throwable {
        ObjectReference pageObj = CFDebuggerUtils.getCFPageObjectReference(thread);
        Map scope = null;
        try {
            scope = CFDebuggerUtils.getScopeVariables(pageObj, scopeName, thread);
        }
        catch (Throwable t) {
            return null;
        }
        return scope;
    }

    public static Object getVariableValue(String varName, ThreadReference thread) throws Throwable {
        return CFDebuggerUtils.getVariableValueUsingSerialization(varName, thread);
    }

    private static Object getVariableValueUsingSerialization(String varName, ThreadReference thread) throws Throwable {
        ObjectReference pageObj = CFDebuggerUtils.getCFPageObjectReference(thread);
        if (pageObj == null) {
            return null;
        }
        try {
            return CFDebuggerUtils.getVariableValueObject(pageObj, varName, thread);
        }
        catch (Throwable e) {
            return null;
        }
    }

    private static Object getVariableValueUsingJDI(String varName, ThreadReference thread) throws Throwable {
        ObjectReference pageObj = CFDebuggerUtils.getCFPageObjectReference(thread);
        if (pageObj == null) {
            return null;
        }
        ObjectReference objRef = null;
        try {
            objRef = CFDebuggerUtils.getVariableValueHelper(pageObj, varName, thread);
        }
        catch (Throwable e) {
            return null;
        }
        if (objRef == null) {
            return null;
        }
        return CFDebuggerUtils.resolveObjectReference(objRef, thread);
    }

    public static ClassType getLineDebuggerHelperClass(ThreadReference th) {
        if (lineDebuggerClass != null) {
            return lineDebuggerClass;
        }
        try {
            VirtualMachine vm = th.virtualMachine();
            List<ReferenceType> classes = vm.classesByName("coldfusion.debug.LineDebuggerHelper");
            if (classes == null || classes.size() == 0) {
                return null;
            }
            lineDebuggerClass = (ClassType)classes.get(0);
            return lineDebuggerClass;
        }
        catch (Throwable e) {
            return null;
        }
    }

    public static ObjectReference getVariableValueHelper(ObjectReference pageObj, String varName, ThreadReference thread) throws Throwable {
        try {
            ClassType classType = CFDebuggerUtils.getLineDebuggerHelperClass(thread);
            if (classType == null) {
                return null;
            }
            if (lineDebugger_getVariableValueMethod == null) {
                lineDebugger_getVariableValueMethod = classType.concreteMethodByName("getVariableValue", "(Lcoldfusion/runtime/CFPage;Ljava/lang/String;)Ljava/lang/Object;");
            }
            if (lineDebugger_getVariableValueMethod == null) {
                return null;
            }
            ArrayList<ObjectReference> args = new ArrayList<ObjectReference>();
            args.add(pageObj);
            args.add(thread.virtualMachine().mirrorOf(varName));
            ObjectReference objRef = (ObjectReference)classType.invokeMethod(thread, lineDebugger_getVariableValueMethod, args, 3);
            return objRef;
        }
        catch (InvocationException ie) {
            return null;
        }
    }

    public static Map getScopeVariables(ObjectReference pageObj, String scopeName, ThreadReference thread) throws Throwable {
        return CFDebuggerUtils.getSerializedScopeVariables(pageObj, scopeName, thread);
    }

    private static Map getScopeVariablesUsingJDI(ObjectReference pageObj, String scopeName, ThreadReference thread) throws Throwable {
        try {
            HashMap mapObj;
            ObjectReference objRef = CFDebuggerUtils.getVariableValueHelper(pageObj, scopeName, thread);
            if (objRef != null && (mapObj = CFDebuggerUtils.resolveMapReference(objRef, thread)) != null) {
                return mapObj;
            }
            return null;
        }
        catch (InvocationException ie) {
            CFDebuggerLogger.log(ie);
            return null;
        }
    }

    private static Map getSerializedScopeVariables(ObjectReference pageObj, String scopeName, ThreadReference thread) throws Throwable {
        try {
            Object objValue = CFDebuggerUtils.getVariableValueObject(pageObj, scopeName, thread);
            if (objValue != null) {
                return (Map)objValue;
            }
            return null;
        }
        catch (InvocationException ie) {
            CFDebuggerLogger.log(ie);
            return null;
        }
    }

    public static Map getFunctionLocalScopeVariables(ThreadReference thread) throws Throwable {
        if (!CFDebuggerUtils.isInUDF(thread.frame(0))) {
            return null;
        }
        try {
            ObjectReference pageObj = CFDebuggerUtils.getCFPageObjectReference(thread);
            ClassType classType = CFDebuggerUtils.getLineDebuggerHelperClass(thread);
            if (classType == null) {
                return null;
            }
            if (lineDebugger_getFunctionLocalVariablesAsByteArray == null) {
                lineDebugger_getFunctionLocalVariablesAsByteArray = classType.concreteMethodByName("getFunctionLocalVariablesAsByteArray", "(Lcoldfusion/runtime/CFPage;)[B");
            }
            if (lineDebugger_getFunctionLocalVariablesAsByteArray == null) {
                return null;
            }
            ArrayList<ObjectReference> args = new ArrayList<ObjectReference>();
            args.add(pageObj);
            ObjectReference objRef = (ObjectReference)classType.invokeMethod(thread, lineDebugger_getFunctionLocalVariablesAsByteArray, args, 3);
            if (objRef == null) {
                return null;
            }
            ArrayReference arrayRef = (ArrayReference)objRef;
            List<Value> byteList = arrayRef.getValues();
            byte[] objBytes = new byte[arrayRef.length()];
            int i = 0;
            Iterator<Value> it = byteList.iterator();
            while (it.hasNext()) {
                objBytes[i] = ((ByteValue)it.next()).byteValue();
                ++i;
            }
            ByteArrayInputStream byteInputStream = new ByteArrayInputStream(objBytes);
            ObjectInputStream objInStream = new ObjectInputStream(byteInputStream);
            Object objValue = objInStream.readObject();
            byteInputStream.close();
            return (Map)objValue;
        }
        catch (Throwable e) {
            return null;
        }
    }

    public static HashMap resolveMapReference(ObjectReference scope, ThreadReference th) throws Throwable {
        ArrayList emptyArray = new ArrayList();
        Method keySetMethod = CFDebuggerUtils.getMethod((ClassType)scope.referenceType(), "keySet", "()Ljava/util/Set;");
        ObjectReference setObj = CFDebuggerUtils.invokeMethodRetObj(scope, keySetMethod, emptyArray, th);
        if (setObj == null) {
            return null;
        }
        Method iteratorMethod = CFDebuggerUtils.getMethod((ClassType)setObj.referenceType(), "iterator", "()Ljava/util/Iterator;");
        ObjectReference itObj = CFDebuggerUtils.invokeMethodRetObj(setObj, iteratorMethod, emptyArray, th);
        if (itObj == null) {
            return null;
        }
        Method hasNextMethod = CFDebuggerUtils.getMethod((ClassType)itObj.referenceType(), "hasNext", "()Z");
        BooleanValue boolValue = (BooleanValue)CFDebuggerUtils.invokeMethod(itObj, hasNextMethod, emptyArray, th);
        if (boolValue == null) {
            return null;
        }
        HashMap<String, Object> retMap = new HashMap<String, Object>();
        Method nextMethod = CFDebuggerUtils.getMethod((ClassType)itObj.referenceType(), "next", "()Ljava/lang/Object;");
        Method getMethod = CFDebuggerUtils.getMethod((ClassType)scope.referenceType(), "get", "(Ljava/lang/Object;)Ljava/lang/Object;");
        while (boolValue != null && boolValue.booleanValue()) {
            ObjectReference nxtObj = (ObjectReference)itObj.invokeMethod(th, nextMethod, emptyArray, 1);
            if (obj_toStringMethod == null) {
                obj_toStringMethod = ((ClassType)nxtObj.referenceType()).concreteMethodByName("toString", "()Ljava/lang/String;");
            }
            StringReference strRef = (StringReference)nxtObj.invokeMethod(th, obj_toStringMethod, emptyArray, 1);
            String key = strRef.value();
            ArrayList<StringReference> args = new ArrayList<StringReference>();
            args.add(strRef);
            Value valueRef = scope.invokeMethod(th, getMethod, args, 1);
            Object valueObj = CFDebuggerUtils.resolveValue(valueRef, th);
            if (valueObj != null) {
                retMap.put(key, valueObj);
            }
            boolValue = (BooleanValue)CFDebuggerUtils.invokeMethod(itObj, hasNextMethod, emptyArray, th);
        }
        return retMap;
    }

    public static Object resolveValue(Value val, ThreadReference th) throws Throwable {
        if (val instanceof ObjectReference) {
            return CFDebuggerUtils.resolveObjectReference((ObjectReference)val, th);
        }
        if (val instanceof PrimitiveValue) {
            return CFDebuggerUtils.resolvePrimitiveValue((PrimitiveValue)val);
        }
        return null;
    }

    public static Object resolvePrimitiveValue(PrimitiveValue primValue) throws Throwable {
        if (primValue instanceof BooleanValue) {
            return new Boolean(((BooleanValue)primValue).booleanValue());
        }
        if (primValue instanceof ByteValue) {
            return new Byte(((ByteValue)primValue).byteValue());
        }
        if (primValue instanceof CharValue) {
            return new Character(((CharValue)primValue).value());
        }
        if (primValue instanceof DoubleValue) {
            return new Double(((DoubleValue)primValue).doubleValue());
        }
        if (primValue instanceof FloatValue) {
            return new Float(((FloatValue)primValue).floatValue());
        }
        if (primValue instanceof IntegerValue) {
            return new Integer(((IntegerValue)primValue).intValue());
        }
        if (primValue instanceof LongValue) {
            return new Long(((LongValue)primValue).longValue());
        }
        if (primValue instanceof ShortValue) {
            return new Short(((ShortValue)primValue).shortValue());
        }
        return null;
    }

    public static Object resolveObjectReference(ObjectReference objRef, ThreadReference th) throws Throwable {
        if (objRef instanceof StringReference) {
            return ((StringReference)objRef).value();
        }
        ClassType classType = (ClassType)objRef.referenceType();
        if (CFDebuggerUtils.isClassInstanceOf(classType, "java.util.Map")) {
            return CFDebuggerUtils.resolveMapReference(objRef, th);
        }
        if (CFDebuggerUtils.isClassInstanceOf(classType, "coldfusion.runtime.UDFMethod")) {
            return null;
        }
        if (CFDebuggerUtils.isClassInstanceOf(classType, "coldfusion.runtime.java.JavaProxy")) {
            return null;
        }
        return CFDebuggerUtils.ObjectReferenceToString(objRef, th);
    }

    public static ObjectReference invokeMethodRetObj(ObjectReference obj, String methodName, ArrayList args, ThreadReference th, String methodSig) throws Throwable {
        Value val = CFDebuggerUtils.invokeMethod(obj, methodName, args, th, methodSig);
        if (val instanceof ObjectReference) {
            return (ObjectReference)val;
        }
        return null;
    }

    public static ObjectReference invokeMethodRetObj(ObjectReference obj, Method method, ArrayList args, ThreadReference th) throws Throwable {
        if (method == null) {
            return null;
        }
        Value val = CFDebuggerUtils.invokeMethod(obj, method, args, th);
        if (val instanceof ObjectReference) {
            return (ObjectReference)val;
        }
        return null;
    }

    public static Value invokeMethod(ObjectReference obj, String methodName, ArrayList args, ThreadReference th, String methodSig) throws Throwable {
        ClassType type = (ClassType)obj.referenceType();
        Method m1 = type.concreteMethodByName(methodName, methodSig);
        return CFDebuggerUtils.invokeMethod(obj, m1, args, th);
    }

    public static Value invokeMethod(ObjectReference obj, Method method, ArrayList args, ThreadReference th) throws Throwable {
        if (method == null) {
            return null;
        }
        return obj.invokeMethod(th, method, args == null ? new ArrayList() : args, 1);
    }

    public static Method getMethod(ClassType classType, String methodName, String signature) {
        String key = classType.name() + ":" + methodName + ":" + signature;
        Object obj = methodMap.get(key);
        if (obj != null) {
            return (Method)obj;
        }
        Method m1 = classType.concreteMethodByName(methodName, signature);
        if (m1 == null) {
            return null;
        }
        methodMap.put(key, m1);
        return m1;
    }

    public static boolean variableExists(String name, ThreadReference th) throws Throwable {
        ObjectReference ctxObj = CFDebuggerUtils.getPagecontextObjectReference(th);
        if (ctxObj == null) {
            return false;
        }
        Method m1 = CFDebuggerUtils.getMethod((ClassType)ctxObj.referenceType(), "findAttribute", "(Ljava/lang/String;)Ljava/lang/Object;");
        if (m1 == null) {
            return false;
        }
        ArrayList<StringReference> args = new ArrayList<StringReference>();
        StringReference strRef = th.virtualMachine().mirrorOf(name);
        strRef.disableCollection();
        args.add(strRef);
        Value ret = ctxObj.invokeMethod(th, m1, args, 1);
        strRef.enableCollection();
        return ret != null;
    }

    public static void setCFVariableValue(ThreadReference thr, String varName, Object value) throws Throwable {
        ObjectReference pageObj = CFDebuggerUtils.getCFPageObjectReference(thr);
        ClassType classType = CFDebuggerUtils.getLineDebuggerHelperClass(thr);
        if (classType == null) {
            throw new Exception("Error setting variable value. Internal Error : Could not get debugger helper class");
        }
        if (lineDebugger_setVariableValueMethod == null) {
            lineDebugger_setVariableValueMethod = classType.concreteMethodByName("setVariableValue", "(Lcoldfusion/runtime/CFPage;Ljava/lang/String;Ljava/lang/String;)Z");
        }
        if (lineDebugger_setVariableValueMethod == null) {
            throw new Exception("Error setting variable value");
        }
        ArrayList<ObjectReference> args = new ArrayList<ObjectReference>();
        args.add(pageObj);
        args.add(thr.virtualMachine().mirrorOf(varName));
        args.add(thr.virtualMachine().mirrorOf(value.toString()));
        BooleanValue retVal = (BooleanValue)classType.invokeMethod(thr, lineDebugger_setVariableValueMethod, args, 3);
        if (!retVal.booleanValue()) {
            throw new Exception("Error setting variable value");
        }
    }

    private static boolean setArrayVariableValue(ThreadReference thr, ObjectReference pageObj, String varName, Object value) throws Throwable {
        if ((varName = varName.trim()).charAt(varName.length() - 1) != ']') {
            return false;
        }
        int index1 = varName.lastIndexOf(91);
        String indexStr = varName.substring(index1 + 1, varName.length() - 1);
        int arrayIndex = -1;
        try {
            arrayIndex = Integer.parseInt(indexStr);
        }
        catch (NumberFormatException ne) {
            return false;
        }
        if (arrayIndex == -1) {
            throw new Throwable("Invalid array index - " + indexStr);
        }
        String arrayVarName = varName.substring(0, index1);
        VirtualMachine vm = thr.virtualMachine();
        StringReference v1 = vm.mirrorOf(arrayVarName);
        StringReference v3 = thr.virtualMachine().mirrorOf(value.toString());
        List<ReferenceType> classes = vm.classesByName("java.lang.Object[]");
        ArrayType objArrayType = (ArrayType)classes.get(0);
        ArrayReference arrayRef = objArrayType.newInstance(1);
        classes = vm.classesByName("java.lang.Integer");
        ClassType intType = (ClassType)classes.get(0);
        Method intConst = intType.concreteMethodByName("<init>", "(I)V");
        ArrayList<IntegerValue> args1 = new ArrayList<IntegerValue>();
        args1.add(vm.mirrorOf(arrayIndex));
        ObjectReference intObj = intType.newInstance(thr, intConst, args1, 1);
        arrayRef.setValue(0, (Value)intObj);
        ArrayList<ObjectReference> args3 = new ArrayList<ObjectReference>();
        args3.add(v1);
        args3.add(arrayRef);
        args3.add(v3);
        try {
            CFDebuggerUtils.invokeMethod(pageObj, "_arraySetAt", args3, thr, "(Ljava/lang/String;[Ljava/lang/Object;Ljava/lang/Object;)V");
        }
        catch (Throwable e) {
            CFDebuggerLogger.log(e);
            throw e;
        }
        return true;
    }

    static String getCFOutput(ThreadReference thr, boolean getOnlyBody) throws Throwable {
        ObjectReference pageObjRef = CFDebuggerUtils.getCFPageObjectReference(thr);
        ClassType classType = CFDebuggerUtils.getLineDebuggerHelperClass(thr);
        if (classType == null) {
            return null;
        }
        if (lineDebugger_getCFOutput == null) {
            lineDebugger_getCFOutput = classType.concreteMethodByName("getCFOutput", "(Lcoldfusion/runtime/CFPage;Z)Ljava/lang/String;");
        }
        if (lineDebugger_getCFOutput == null) {
            return null;
        }
        ArrayList<Value> args = new ArrayList<Value>();
        args.add(pageObjRef);
        args.add(thr.virtualMachine().mirrorOf(getOnlyBody));
        ObjectReference objRef = (ObjectReference)classType.invokeMethod(thr, lineDebugger_getCFOutput, args, 3);
        if (objRef == null) {
            return null;
        }
        return ((StringReference)objRef).value();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getVariableValueObject(ObjectReference pageObj, String varName, ThreadReference thread) throws Throwable {
        try {
            ObjectReference objRef;
            ClassType classType = CFDebuggerUtils.getLineDebuggerHelperClass(thread);
            if (classType == null) {
                return null;
            }
            if (lineDebugger_getVariableValueAsByteArrayMethod == null) {
                lineDebugger_getVariableValueAsByteArrayMethod = classType.concreteMethodByName("getVariableValueAsByteArray", "(Lcoldfusion/runtime/CFPage;Ljava/lang/String;)[B");
            }
            if (lineDebugger_getVariableValueAsByteArrayMethod == null) {
                return null;
            }
            ArrayList<ObjectReference> args = new ArrayList<ObjectReference>();
            args.add(pageObj);
            args.add(thread.virtualMachine().mirrorOf(varName));
            ThreadReference threadReference = thread;
            synchronized (threadReference) {
                objRef = (ObjectReference)classType.invokeMethod(thread, lineDebugger_getVariableValueAsByteArrayMethod, args, 3);
            }
            if (objRef == null) {
                return null;
            }
            ArrayReference arrayRef = (ArrayReference)objRef;
            List<Value> byteList = arrayRef.getValues();
            byte[] objBytes = new byte[arrayRef.length()];
            int i = 0;
            Iterator<Value> it = byteList.iterator();
            while (it.hasNext()) {
                objBytes[i] = ((ByteValue)it.next()).byteValue();
                ++i;
            }
            ByteArrayInputStream byteInputStream = new ByteArrayInputStream(objBytes);
            ObjectInputStream objInStream = new ObjectInputStream(byteInputStream);
            Object objValue = objInStream.readObject();
            byteInputStream.close();
            return objValue;
        }
        catch (Throwable e) {
            CFDebuggerLogger.log(e);
            return null;
        }
    }

    public static Object[] getExceptionStackTrace(ObjectReference exceptionObj, ThreadReference thread) throws Throwable {
        try {
            ClassType classType = CFDebuggerUtils.getLineDebuggerHelperClass(thread);
            if (classType == null) {
                return null;
            }
            if (lineDebugger_getExceptionStackTrace == null) {
                lineDebugger_getExceptionStackTrace = classType.concreteMethodByName("getExceptionStackTrace", "(Ljava/lang/Throwable;)Ljava/lang/Object;");
            }
            if (lineDebugger_getExceptionStackTrace == null) {
                return null;
            }
            ArrayList<ObjectReference> args = new ArrayList<ObjectReference>();
            args.add(exceptionObj);
            ObjectReference objRef = (ObjectReference)classType.invokeMethod(thread, lineDebugger_getExceptionStackTrace, args, 3);
            if (objRef == null) {
                return null;
            }
            ArrayReference arrayRef = (ArrayReference)objRef;
            if (arrayRef.length() >= 2) {
                int i;
                Value javaTraceValue = arrayRef.getValue(0);
                Value cfTraceValue = arrayRef.getValue(1);
                ArrayList<String> javaTraceList = new ArrayList<String>();
                ArrayList<String> cfTraceList = new ArrayList<String>();
                if (javaTraceValue instanceof ArrayReference) {
                    ArrayReference javaTraceArrayRef = (ArrayReference)javaTraceValue;
                    for (i = 0; i < javaTraceArrayRef.length(); ++i) {
                        javaTraceList.add(((StringReference)javaTraceArrayRef.getValue(i)).value());
                    }
                }
                if (cfTraceValue instanceof ArrayReference) {
                    ArrayReference cfTraceArrayRef = (ArrayReference)cfTraceValue;
                    for (i = 0; i < cfTraceArrayRef.length(); ++i) {
                        cfTraceList.add(((StringReference)cfTraceArrayRef.getValue(i)).value());
                    }
                }
                return new Object[]{javaTraceList, cfTraceList};
            }
            return null;
        }
        catch (Throwable e) {
            CFDebuggerLogger.log(e);
            return null;
        }
    }
}

