/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.xml.rpc.module;

import coldfusion.runtime.ApplicationException;
import coldfusion.util.SoftPool;
import coldfusion.xml.rpc.Axis1ServiceProxy;
import coldfusion.xml.rpc.CFUserCredential;
import coldfusion.xml.rpc.ServiceInfo;
import coldfusion.xml.rpc.ServiceProxy;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.client.Stub;
import org.apache.axis.configuration.XMLStringProvider;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.protocol.HttpContext;

public class Axis1ServiceInfo
extends ServiceInfo {
    public Axis1ServiceInfo(String name, Map ports) {
        super(name, ports);
    }

    public Stub getStub(String port) {
        if (port == null) {
            port = this.default_port;
        }
        SoftPool pool = (SoftPool)this.stubs.get(port);
        try {
            Stub s = null;
            if (pool != null) {
                s = (Stub)pool.checkOut();
            }
            if (s == null) {
                final Class locator_clazz = (Class)this.portMap.get(port);
                if (locator_clazz == null) {
                    throw new ServiceInfo.BadPortException((ServiceInfo)this, port);
                }
                Object locator = AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        if (Axis1ServiceInfo.this.isNTLMAuth()) {
                            return locator_clazz.getConstructor(EngineConfiguration.class).newInstance(Axis1ServiceInfo.getEngineConfiguration());
                        }
                        return locator_clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    }
                });
                QName portName = new QName(port);
                Method getPort = locator_clazz.getMethod("getPort", QName.class, Class.class);
                s = (Stub)getPort.invoke(locator, portName, null);
            }
            return s;
        }
        catch (ServiceInfo.BadPortException badport) {
            throw badport;
        }
        catch (PrivilegedActionException pex) {
            throw new ServiceInfo.ServiceStubInstantiationException((Throwable)pex.getException());
        }
        catch (Exception ex) {
            throw new ServiceInfo.ServiceStubInstantiationException((Throwable)ex);
        }
    }

    public ServiceProxy getServiceProxy(String port, CFUserCredential cfUserCredential) {
        String username = cfUserCredential.getUsername();
        String password = cfUserCredential.getPassword();
        String authtype = cfUserCredential.getAuthtype();
        String workstation = cfUserCredential.getWorkstation();
        String domain = cfUserCredential.getDomain();
        this.setAuthtype(authtype);
        Stub stub = this.getStub(port);
        if (!this.isNTLMAuth() && username != null && username.length() > 0) {
            stub.setUsername(username);
            stub.setPassword(password);
        }
        if (this.isNTLMAuth()) {
            stub.setUsername(domain + "\\" + username);
            stub.setPassword(password);
            this.isNTLMAuthEnabled(stub, domain, username, password);
        }
        return new Axis1ServiceProxy((Object)stub, this.getParamInfo(port, stub), this.getPool(port));
    }

    private void isNTLMAuthEnabled(Stub stub, String domain, String username, String password) {
        String endpoint = "";
        try {
            endpoint = (String)stub._getProperty("javax.xml.rpc.service.endpoint.address");
            URL u = new URL(endpoint);
            HttpOptions options = new HttpOptions(u.toString());
            RequestConfig.Builder requestBuilder = RequestConfig.custom();
            requestBuilder.setCookieSpec("ignoreCookies");
            requestBuilder.setTargetPreferredAuthSchemes(Arrays.asList("NTLM"));
            HttpClientBuilder clientBuilder = HttpClientBuilder.create().setDefaultRequestConfig(requestBuilder.build()).useSystemProperties();
            CloseableHttpClient httpClient = clientBuilder.build();
            NTCredentials creds = new NTCredentials(username, password, "", domain);
            HttpClientContext context = HttpClientContext.create();
            BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
            credsProvider.setCredentials(AuthScope.ANY, (Credentials)creds);
            context.setCredentialsProvider((CredentialsProvider)credsProvider);
            HttpResponse response = httpClient.execute((HttpUriRequest)options, (HttpContext)context);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == 401) {
                throw new CantFindEndpointException(u.toString(), statusCode + " " + response.getStatusLine().getReasonPhrase());
            }
        }
        catch (IOException e) {
            throw new CantFindEndpointException(endpoint, "not found");
        }
    }

    public static EngineConfiguration getEngineConfiguration() {
        StringBuffer sb = new StringBuffer();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n");
        sb.append("<deployment name=\"defaultClientConfig\"\r\n");
        sb.append("xmlns=\"http://xml.apache.org/axis/wsdd/\"\r\n");
        sb.append("xmlns:java=\"http://xml.apache.org/axis/wsdd/providers/java\">\r\n");
        sb.append("<globalConfiguration>\r\n");
        sb.append("<parameter name=\"disablePrettyXML\" value=\"true\"/>\r\n");
        sb.append("<parameter name=\"enableNamespacePrefixOptimization\" value=\"true\"/>\r\n");
        sb.append("</globalConfiguration>\r\n");
        sb.append("<transport name=\"http\" pivot=\"java:org.apache.axis.transport.http.CommonsHTTPSender\"/>\r\n");
        sb.append("<transport name=\"local\" pivot=\"java:org.apache.axis.transport.local.LocalSender\"/>\r\n");
        sb.append("<transport name=\"java\" pivot=\"java:org.apache.axis.transport.java.JavaSender\"/>\r\n");
        sb.append("</deployment>\r\n");
        return new XMLStringProvider(sb.toString());
    }

    public class CantFindEndpointException
    extends ApplicationException {
        public String wsdl;
        public String err;

        CantFindEndpointException(String wsdl, String err) {
            this.wsdl = wsdl;
            this.err = err;
        }
    }
}

