/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.pdf;

import coldfusion.document.DocumentFileExistsException;
import coldfusion.document.DocumentInvalidEncryptionPermission;
import coldfusion.featurerouter.EFRConstants;
import coldfusion.featurerouter.FeatureNotAvailableException;
import coldfusion.featurerouter.FeatureRouter;
import coldfusion.image.Image;
import coldfusion.pdf.AttachmentObject;
import coldfusion.pdf.PDFDocHandler;
import coldfusion.pdf.PDFDocOperation;
import coldfusion.pdf.PDFDocWrapper;
import coldfusion.pdf.PDFFileNotFoundException;
import coldfusion.pdf.PDFParamInfo;
import coldfusion.pdf.core.PDFException;
import coldfusion.runtime.Struct;
import coldfusion.sql.QueryTable;
import coldfusion.tagext.GenericTag;
import coldfusion.tagext.GenericTagPermission;
import coldfusion.tagext.document.DocumentTag;
import coldfusion.tagext.io.FileUtils;
import coldfusion.util.Utils;
import coldfusion.vfs.VFSFileFactory;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFException;
import com.adobe.internal.pdftoolkit.core.permissionprovider.ObjectOperations;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import jakarta.servlet.jsp.JspException;
import jakarta.servlet.jsp.PageContext;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.List;

public class PDFTag
extends GenericTag {
    private PDFDocOperation pdfOperation;
    private String destination;
    private String action;
    private String name;
    private Object source;
    private String sourceVar = null;
    private boolean overwrite = false;
    private boolean CFDocumentParent = false;
    private DocumentTag parentDocumentTag;
    private PDFDocument pdfdoc;
    private String pages;
    private String password;
    private Struct info;
    private File directory;
    private String order = "NAME";
    private boolean ascending;
    private String encrypt;
    private String permissions;
    private String version;
    private String saveOption;
    private String copyfrom;
    private int[] position;
    private int opacity = -1;
    private int rotation = 0;
    private Object image;
    private boolean foreground;
    private boolean keepBookmark = true;
    private boolean flatten;
    private String newOwnerPassword;
    private String newUserPassword;
    private String ownerPassword;
    private String userPassword;
    private boolean showOnPrint;
    private boolean isBase64 = false;
    private Struct inputFiles;
    private Struct outputFiles;
    private String ddxFile;
    private boolean stopOnError = false;
    private List<AttachmentObject> param = new ArrayList<AttachmentObject>();
    private String format = null;
    private int scale = 25;
    private boolean transparent = false;
    private boolean hires = true;
    private String imagePrefix = null;
    private String richText = null;
    private double height = -1.0;
    private double width = -1.0;
    private String algo = null;
    private double vScale = 0.5;
    private double hScale = 0.5;
    private boolean encodeAll = false;
    private boolean noJS = false;
    private boolean noThumbnails = false;
    private boolean noBookmarks = false;
    private boolean noComments = false;
    private boolean noFonts = false;
    private boolean noMetadata = false;
    private boolean noAttachments = false;
    private boolean noLinks = false;
    private String type = "XML";
    private boolean addQuads = false;
    private boolean portfolio = false;
    private List pdfsPortfolio = null;
    private String align = "CENTER";
    private String numberFormat = "NUMERIC";
    private double leftMargin = 1.0;
    private double rightMargin = 1.0;
    private double topMargin = 0.5;
    private double bottomMargin = 0.5;
    private boolean hiRes = false;
    private int maxScale = 0;
    private int maxLength = 0;
    private int maxBreadth = 0;
    private boolean overridePage = false;
    private int jpgDpi = 0;
    private boolean compressTiffs = false;
    private boolean honourSpaces = true;
    private boolean useStructure = true;
    private String charset = "UTF-8";
    private String keystore = null;
    private String keyalias = null;
    private String keystorePassword = null;
    private String keyPassword = null;
    private boolean author = false;
    private String signatureFieldName = null;
    private boolean unsignall = false;
    private String exportTo;
    private String importFrom;
    private String extract;
    private String nameKeys;
    private String encoding;
    private String standard;
    private boolean noDes = false;
    private List<PDFParamInfo> paramtags = new ArrayList<PDFParamInfo>();
    private static final GenericTagPermission tp = new GenericTagPermission("cfpdf");

    public List<PDFParamInfo> getParamtagsInfo() {
        return this.paramtags;
    }

    public void addParamtagsInfo(PDFParamInfo paramtags) {
        this.paramtags.add(paramtags);
    }

    protected Permission getPermission() {
        return tp;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public void setUseStructure(boolean useStructure) {
        this.useStructure = useStructure;
    }

    public void setHonourSpaces(boolean honourSpaces) {
        this.honourSpaces = honourSpaces;
    }

    public void setCompressTiffs(boolean compressTiffs) {
        this.compressTiffs = compressTiffs;
    }

    public void setJpgDpi(int jpgDpi) {
        this.jpgDpi = jpgDpi;
    }

    public void setOverridePage(boolean overridePage) {
        this.overridePage = overridePage;
    }

    public void setMaxBreadth(int maxBreadth) {
        this.maxBreadth = maxBreadth;
    }

    public void setMaxLength(int maxLength) {
        this.maxLength = maxLength;
    }

    public void setMaxScale(int maxScale) {
        this.maxScale = maxScale;
    }

    public void setHiRes(boolean hiRes) {
        this.hiRes = hiRes;
    }

    public boolean isPortfolio() {
        return this.portfolio;
    }

    public void setBottomMargin(double bottomMargin) {
        this.bottomMargin = bottomMargin;
    }

    public void setTopMargin(double topMargin) {
        this.topMargin = topMargin;
    }

    public void setRightMargin(double rightMargin) {
        this.rightMargin = rightMargin;
    }

    public void setLeftMargin(double leftMargin) {
        this.leftMargin = leftMargin;
    }

    public void setNumberFormat(String numberFormat) {
        if ("".equals(numberFormat) || !"NUMERIC".equalsIgnoreCase(numberFormat) && !"LOWERCASEROMAN".equalsIgnoreCase(numberFormat) && !"UPPERCASEROMAN".equalsIgnoreCase(numberFormat)) {
            throw new PDFException.InvalidValueException("numberformat", numberFormat, new StringBuffer().append("NUMERIC").append(",").append("LOWERCASEROMAN").append(",").append("UPPERCASEROMAN").toString());
        }
        this.numberFormat = numberFormat;
    }

    public void setAlign(String align) {
        if ("".equals(align) || !"CENTER".equalsIgnoreCase(align) && !"LEFT".equalsIgnoreCase(align) && !"RIGHT".equalsIgnoreCase(align)) {
            throw new PDFException.InvalidValueException("align", align, new StringBuffer().append("CENTER").append(",").append("LEFT").append(",").append("RIGHT").toString());
        }
        this.align = align;
    }

    public void setPackage(boolean portfolio) {
        this.portfolio = portfolio;
    }

    public void addToPortfolio(PDFDocWrapper pdf) {
        if (this.pdfsPortfolio == null) {
            this.pdfsPortfolio = new ArrayList();
        }
        this.pdfsPortfolio.add(pdf);
    }

    public void setAddQuads(boolean addQuads) {
        this.addQuads = addQuads;
    }

    public void setType(String type) {
        if ("".equals(type) || !"STRING".equalsIgnoreCase(type) && !"XML".equalsIgnoreCase(type) && !"COMMENT".equalsIgnoreCase(type) && !"METADATA".equalsIgnoreCase(type)) {
            throw new PDFException.InvalidValueException("type", type, new StringBuffer().append("STRING").append(",").append("XML").toString());
        }
        this.type = type;
    }

    public void setExportTo(String exportTo) {
        if (exportTo == null || "".equals(exportTo.trim())) {
            throw new PDFException.EmptyAttributeException2("EXPORTTO");
        }
        this.exportTo = exportTo;
    }

    public void setImportFrom(String importFrom) {
        if (importFrom == null || importFrom.trim().length() == 0) {
            throw new PDFException.EmptyAttributeException2("IMPORTFROM");
        }
        this.importFrom = importFrom;
    }

    public void setExtract(String extract) {
        this.extract = extract;
    }

    public void setStandard(String standard) {
        this.standard = standard;
    }

    public void setNameKeys(String nameKeys) {
        this.nameKeys = nameKeys;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setNoLinks(boolean noLinks) {
        this.noLinks = noLinks;
    }

    public void setNoAttachments(boolean noAttachments) {
        this.noAttachments = noAttachments;
    }

    public void setNoMetadata(boolean noMetadata) {
        this.noMetadata = noMetadata;
    }

    public void setNoComments(boolean noComments) {
        this.noComments = noComments;
    }

    public void setNoFonts(boolean noFonts) {
        this.noFonts = noFonts;
    }

    public void setNoBookmarks(boolean noBookmarks) {
        this.noBookmarks = noBookmarks;
    }

    public void setNoThumbnails(boolean noThumbnails) {
        this.noThumbnails = noThumbnails;
    }

    public void setNoJavascripts(boolean noJS) {
        this.noJS = noJS;
    }

    public void setEncodeAll(boolean encodeAll) {
        this.encodeAll = encodeAll;
    }

    public void setHScale(double hScale) {
        this.hScale = hScale;
    }

    public void setVScale(double vScale) {
        this.vScale = vScale;
    }

    public void setAlgo(String algo) {
        if ("".equals(algo) || !"BICUBIC".equalsIgnoreCase(algo) && !"BILINEAR".equalsIgnoreCase(algo) && !"NEAREST_NEIGHBOUR".equalsIgnoreCase(algo)) {
            throw new PDFException.InvalidValueException("algo", algo, new StringBuffer().append("BICUBIC").append(",").append("BILINEAR").append(",").append("NEAREST_NEIGHBOUR").toString());
        }
        this.algo = algo;
    }

    public void setHeight(double height) {
        if (height < 0.0) {
            throw new PDFException.EmptyAttributeException2("height");
        }
        this.height = height;
    }

    public void setWidth(double width) {
        if (width < 0.0) {
            throw new PDFException.EmptyAttributeException2("width");
        }
        this.width = width;
    }

    public void setSignaturefieldname(String signaturefieldname) {
        if (signaturefieldname == null) {
            throw new PDFException.EmptyAttributeException2("signaturefieldname");
        }
        this.signatureFieldName = signaturefieldname;
    }

    public void setUnsignall(boolean unsignall) {
        this.unsignall = unsignall;
    }

    public void setAuthor(boolean author) {
        this.author = author;
    }

    public void setText(String richText) {
        if ("".equals(richText = richText.trim())) {
            throw new PDFException.EmptyAttributeException2("text");
        }
        this.richText = richText;
    }

    public void setInputFiles(Struct inputFiles) {
        if (inputFiles.entrySet().isEmpty()) {
            throw new PDFException.PDFEmptyStructException("inputfiles");
        }
        this.inputFiles = inputFiles;
    }

    public void setOutputFiles(Struct outputFiles) {
        if (outputFiles.entrySet().isEmpty()) {
            throw new PDFException.PDFEmptyStructException("outputfiles");
        }
        this.outputFiles = outputFiles;
    }

    public void setDdxFile(String ddxFile) {
        if ("".equals(ddxFile = ddxFile.trim())) {
            throw new PDFException.EmptyAttributeException2("ddxfile");
        }
        this.ddxFile = ddxFile;
    }

    public void setIsBase64(boolean base64) {
        this.isBase64 = base64;
    }

    public void setShowOnPrint(boolean showOnPrint) {
        this.showOnPrint = showOnPrint;
    }

    public File getDirectory() {
        return this.directory;
    }

    public Object getSource() {
        return this.source;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean isKeepBookmark() {
        return this.keepBookmark;
    }

    public String getDestination() {
        return this.destination;
    }

    public String getName() {
        return this.name;
    }

    public List getList() {
        return this.param;
    }

    public void setInfo(Struct info) {
        this.info = info;
    }

    public void setKeepBookmark(boolean keepBookmark) {
        this.keepBookmark = keepBookmark;
    }

    public void setStopOnError(boolean stopOnError) {
        this.stopOnError = stopOnError;
    }

    public PDFDocument getPdfdoc() {
        return this.pdfdoc;
    }

    public void setPdfdoc(PDFDocument pdfdoc) {
        this.pdfdoc = pdfdoc;
    }

    public void setFlatten(boolean flatten) {
        this.flatten = flatten;
    }

    public void setNewOwnerPassword(String newOwnerPassword) {
        if ("".equals(newOwnerPassword.trim())) {
            throw new PDFException.EmptyAttributeException2("newOwnerPassword");
        }
        this.newOwnerPassword = newOwnerPassword;
    }

    public void setNewUserPassword(String newUserPassword) {
        if ("".equals(newUserPassword.trim())) {
            throw new PDFException.EmptyAttributeException2("newUserPassword");
        }
        this.newUserPassword = newUserPassword;
    }

    public void setPages(String page) {
        if ("".equals(page = page.trim())) {
            throw new PDFException.EmptyAttributeException2("pages");
        }
        this.pages = page;
    }

    public void setPassword(String password) {
        this.password = password.trim();
    }

    public void setDirectory(String directory) {
        if ("".equals(directory = directory.trim())) {
            throw new PDFException.EmptyAttributeException2("directory");
        }
        directory = Utils.getFileFullPath((String)directory.trim(), (PageContext)this.pageContext, (boolean)true);
        File tempFile = VFSFileFactory.getFileObject((String)directory);
        if (!PDFTag.fileExists(directory) || tempFile.isFile()) {
            throw new PDFFileNotFoundException("directory", directory);
        }
        this.directory = tempFile;
    }

    public void setOrder(String order) {
        if ("".equals(order = order.trim()) || !"NAME".equalsIgnoreCase(order) && !"TIME".equalsIgnoreCase(order)) {
            throw new PDFException.InvalidValueException("order", order, "NAME,TIME");
        }
        this.order = order.toUpperCase();
    }

    public void setAscending(boolean ascending) {
        this.ascending = ascending;
    }

    public void setEncrypt(String encrypt) {
        if (!(!"".equals(encrypt = encrypt.trim()) && ("RC4_40".equalsIgnoreCase(encrypt) || "RC4_128".equalsIgnoreCase(encrypt) || "RC4_128M".equalsIgnoreCase(encrypt) || "AES_128".equalsIgnoreCase(encrypt) || "NONE".equalsIgnoreCase(encrypt) || "AES_256R5".equalsIgnoreCase(encrypt) || "AES_256R6".equalsIgnoreCase(encrypt)))) {
            throw new PDFException.InvalidValueException("ENCRYPT", encrypt, "RC4_40,RC4_128,RC4_128M,AES_128,AES_256R5,AES_256R6,NONE");
        }
        this.encrypt = encrypt;
    }

    public void setPermissions(String permissions) {
        if ("".equals(permissions = permissions.trim())) {
            throw new DocumentInvalidEncryptionPermission(permissions);
        }
        this.permissions = permissions;
    }

    public void setVersion(double version) {
        if (version != 1.3 && version != 1.4 && version != 1.5 && version != 1.6 && version != 1.7) {
            throw new PDFException.InvalidVersionException("version", version);
        }
        this.version = new Double(version).toString();
    }

    public void setSaveOption(String saveoptions) {
        if ("".equals(saveoptions = saveoptions.trim()) || !"FULL".equalsIgnoreCase(saveoptions) && !"LINEAR".equalsIgnoreCase(saveoptions) && !"INCREMENTAL".equalsIgnoreCase(saveoptions)) {
            throw new PDFException.InvalidValueException("saveoption", saveoptions, "FULL,LINEAR,INCREMENTAL");
        }
        this.saveOption = saveoptions;
    }

    public void setAction(String action) {
        this.action = action.toUpperCase().trim();
    }

    public void setCopyfrom(String copyfrom) {
        if ("".equals(copyfrom = copyfrom.trim())) {
            throw new PDFException.EmptyAttributeException2("copyfrom");
        }
        copyfrom = Utils.getFileFullPath((String)copyfrom.trim(), (PageContext)this.pageContext, (boolean)true);
        File tempFile = VFSFileFactory.getFileObject((String)copyfrom);
        if (!PDFTag.fileExists(copyfrom) || tempFile.isDirectory()) {
            throw new PDFFileNotFoundException("copyfrom", copyfrom);
        }
        this.copyfrom = copyfrom;
    }

    public void setPosition(String position) {
        if ("".equals(position = position.trim()) || position.indexOf(",") == -1) {
            throw new PDFException.EmptyAttributeException2("position");
        }
        String[] temp = position.split(",");
        int[] tempInt = new int[2];
        if (temp.length > 2) {
            throw new PDFException.EmptyAttributeException2("position");
        }
        try {
            for (int i = 0; i < temp.length; ++i) {
                tempInt[i] = Integer.parseInt(temp[i].trim());
            }
        }
        catch (NumberFormatException nfe) {
            throw new PDFException.EmptyAttributeException2("position");
        }
        this.position = tempInt;
    }

    public void setOpacity(int opacity) {
        if (opacity < 0 || 10 < opacity) {
            throw new PDFException.PDFInvalidOpacityException("" + opacity);
        }
        this.opacity = opacity;
    }

    public int getOpacity() {
        return this.opacity;
    }

    public void setRotation(int rotation) {
        this.rotation = rotation;
    }

    public int getRotation() {
        return this.rotation;
    }

    public void setImage(Object image) {
        if (!(image instanceof Image || image instanceof String && !"".equals(((String)image).trim()) || image.getClass().isArray() || image instanceof byte[])) {
            throw new PDFException.EmptyAttributeException2("IMAGE");
        }
        this.image = image;
    }

    private void convertImage(Object image) {
        block8: {
            if (image instanceof Image) {
                this.image = new Image((Image)image);
            } else {
                try {
                    if (image.getClass().isArray() || image instanceof byte[]) {
                        this.image = new Image((byte[])image);
                        break block8;
                    }
                    if (image instanceof String) {
                        if (this.isBase64) {
                            Image tempImg = new Image();
                            tempImg.readBase64((String)image);
                            this.image = tempImg;
                        } else {
                            this.image = new Image((String)image, this.pageContext);
                        }
                        break block8;
                    }
                    throw new PDFException.EmptyAttributeException2("IMAGE");
                }
                catch (ClassCastException cex) {
                    throw new PDFException.EmptyAttributeException2("IMAGE");
                }
            }
        }
    }

    public void setForeground(boolean foreground) {
        this.foreground = foreground;
    }

    public void setDestination(String destination) {
        if ("".equals(destination = destination.trim())) {
            throw new PDFException.EmptyAttributeException2("destination");
        }
        this.destination = destination = Utils.getFileFullPath((String)destination, (PageContext)this.pageContext, (boolean)true);
    }

    public void setFormat(String format) {
        if ((format = format.trim()).equalsIgnoreCase("jpeg") || format.equalsIgnoreCase("jpg")) {
            format = "jpg";
        } else if (format.equalsIgnoreCase("png")) {
            format = "png";
        } else if (format.equalsIgnoreCase("tiff") || format.equalsIgnoreCase("tif")) {
            format = "tif";
        } else {
            throw new PDFException.PDFInvalidFormatException(format);
        }
        this.format = format;
    }

    public void setResolution(String resolution) {
        if ((resolution = resolution.trim()).equalsIgnoreCase("high")) {
            this.hires = true;
        } else if (resolution.equalsIgnoreCase("low")) {
            this.hires = false;
        } else {
            throw new PDFException.InvalidResolutionException(resolution);
        }
    }

    public void setImageprefix(String imagePrefix) {
        this.imagePrefix = imagePrefix.trim();
        if ("".equals(imagePrefix)) {
            throw new PDFException.EmptyAttributeException2("imageprefix");
        }
        this.imagePrefix = imagePrefix;
    }

    public void setScale(int scale) {
        if (scale < 1 || scale > 100) {
            throw new PDFException.PDFInvalidScaleException("" + scale);
        }
        this.scale = scale;
    }

    public void setTransparent(boolean transparent) {
        this.transparent = transparent;
    }

    public void setName(String name) {
        if ("".equals(name = name.trim())) {
            throw new PDFException.EmptyAttributeException2("name");
        }
        this.name = name;
    }

    public void setSource(Object source) {
        if (source == null || "".equals(source.toString().trim()) || "true".equalsIgnoreCase(source.toString())) {
            throw new PDFException.EmptyAttributeException2("source");
        }
        this.source = source;
    }

    private Object validateSource(Object sourceObj, String password) {
        Object value = null;
        if (sourceObj instanceof byte[]) {
            value = sourceObj;
            return value;
        }
        String source = (String)sourceObj;
        if (null != this.pageContext) {
            try {
                value = this.pageContext.findAttribute(source);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (value != null) {
            this.sourceVar = source;
            if (value instanceof byte[]) {
                this.pdfOperation.getPdfDocHandler().removeBackground = true;
                if (this.name == null && this.destination == null) {
                    this.name = source;
                }
                return value;
            }
            if (!(value instanceof PDFDocWrapper)) {
                throw new PDFException.EmptyAttributeException2("source");
            }
            if (this.name != null && this.name.equalsIgnoreCase(source)) {
                return value;
            }
            if (this.name == null && this.destination == null) {
                if ("MERGE".equalsIgnoreCase(this.action) || "PROTECT".equalsIgnoreCase(this.action)) {
                    this.name = source;
                }
                return value;
            }
            return PDFDocWrapper.deepCopy((PDFDocWrapper)value, password);
        }
        if (source.indexOf(",") == -1) {
            source = Utils.getFileFullPath((String)source.trim(), (PageContext)this.pageContext, (boolean)true);
        }
        return source;
    }

    public String getKeystore() {
        return this.keystore;
    }

    public void setKeystore(String keystore) {
        if (!new File(keystore).exists()) {
            throw new PDFException.KeyStoreNotFoundException(keystore);
        }
        this.keystore = keystore;
    }

    public String getKeyalias() {
        return this.keyalias;
    }

    public void setKeyalias(String keyalias) {
        this.keyalias = keyalias;
    }

    public String getKeystorePassword() {
        return this.keystorePassword;
    }

    public void setKeystorePassword(String keystorePassword) {
        this.keystorePassword = keystorePassword;
    }

    public String getKeyPassword() {
        return this.keyPassword;
    }

    public void setKeyPassword(String keyPassword) {
        this.keyPassword = keyPassword;
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }

    public boolean isCFDocumentParent() {
        return this.CFDocumentParent;
    }

    public DocumentTag getParentDocumentTag() {
        return this.parentDocumentTag;
    }

    String getAction() {
        return this.action;
    }

    static boolean fileExists(final String filename) {
        if (System.getSecurityManager() == null) {
            return VFSFileFactory.getFileObject((String)filename).exists();
        }
        Boolean bExists = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return VFSFileFactory.getFileObject((String)filename).exists();
            }
        });
        return bExists;
    }

    public void release() {
        this.destination = null;
        this.action = null;
        this.name = null;
        this.source = null;
        this.sourceVar = null;
        this.pdfOperation = null;
        this.overwrite = false;
        this.CFDocumentParent = false;
        this.parentDocumentTag = null;
        this.pages = null;
        this.password = null;
        this.directory = null;
        this.order = "NAME";
        this.ascending = false;
        this.encrypt = null;
        this.permissions = null;
        this.version = null;
        this.saveOption = null;
        this.copyfrom = null;
        this.position = null;
        this.opacity = -1;
        this.rotation = 0;
        this.image = null;
        this.foreground = false;
        this.keepBookmark = true;
        this.newOwnerPassword = null;
        this.newUserPassword = null;
        this.info = null;
        this.isBase64 = false;
        this.format = null;
        this.scale = 25;
        this.transparent = false;
        this.hires = true;
        this.imagePrefix = null;
        this.stopOnError = false;
        this.richText = null;
        this.height = -1.0;
        this.width = -1.0;
        this.pdfdoc = null;
        this.algo = null;
        this.type = "XML";
        this.align = "CENTER";
        this.numberFormat = "NUMERIC";
        this.honourSpaces = true;
        this.useStructure = true;
        this.charset = "UTF-8";
        this.showOnPrint = false;
        this.overridePage = false;
        this.compressTiffs = false;
        this.maxScale = 0;
        this.maxBreadth = 0;
        this.maxLength = 0;
        this.jpgDpi = 0;
        this.addQuads = false;
        this.portfolio = false;
        this.encodeAll = false;
        this.hScale = 0.5;
        this.vScale = 0.5;
        this.noJS = false;
        this.noThumbnails = false;
        this.noBookmarks = false;
        this.noComments = false;
        this.noAttachments = false;
        this.noFonts = false;
        this.noMetadata = false;
        this.noLinks = false;
        this.ddxFile = null;
        this.leftMargin = 1.0;
        this.topMargin = 0.5;
        this.rightMargin = 1.0;
        this.bottomMargin = 0.5;
        this.inputFiles = null;
        this.outputFiles = null;
        this.author = false;
        this.unsignall = false;
        this.flatten = false;
        this.keyPassword = null;
        this.keystore = null;
        this.keyalias = null;
        this.keystorePassword = null;
        this.signatureFieldName = null;
        super.release();
    }

    public int doStartTag() throws JspException {
        this.onTagStart();
        if (this.destination != null && !this.overwrite && !"THUMBNAIL".equalsIgnoreCase(this.action) && !"EXTRACTIMAGE".equalsIgnoreCase(this.action) && PDFTag.fileExists(this.destination)) {
            throw new DocumentFileExistsException(this.destination);
        }
        if (!this.overwrite && "EXPORT".equalsIgnoreCase(this.action) && PDFTag.fileExists(this.exportTo)) {
            throw new DocumentFileExistsException(this.exportTo);
        }
        if (this.destination != null && this.name != null && !"GETATTACHMENTS".equalsIgnoreCase(this.action)) {
            throw new PDFException.PDFDestNameException();
        }
        if (this.opacity == -1) {
            this.opacity = "ADDWATERMARK".equalsIgnoreCase(this.action) ? 3 : 10;
        }
        if (this.image != null) {
            this.convertImage(this.image);
        }
        this.pdfOperation = new PDFDocOperation();
        if (this.source != null) {
            this.source = this.validateSource(this.source, this.password);
        }
        this.validateAttribute();
        if (!(this.source instanceof PDFDocWrapper) && !(this.source instanceof byte[]) && this.destination == null && this.name == null) {
            this.destination = (String)this.source;
        }
        if (this.source instanceof PDFDocWrapper && this.password == null) {
            this.password = ((PDFDocWrapper)this.source).getPassword();
        }
        if (!("OPTIMIZE".equalsIgnoreCase(this.action) || this.noThumbnails || this.noBookmarks || this.algo == null)) {
            throw new PDFException.IllegalPageException();
        }
        if ("OPTIMIZE".equalsIgnoreCase(this.action)) {
            if (this.vScale > 1.0 || this.vScale < 0.0) {
                throw new PDFException.PDFInvalidScaleException("" + this.vScale, "vScale");
            }
            if (this.hScale > 1.0 || this.hScale < 0.0) {
                throw new PDFException.PDFInvalidScaleException("" + this.hScale, "hScale");
            }
        }
        if ("TRANSFORM".equalsIgnoreCase(this.action) && this.rotation != 0 && this.rotation != 90 && this.rotation != 180 && this.rotation != 270) {
            throw new PDFException.InvalidValueException("rotation", "" + this.rotation, "0,90,180 and 270");
        }
        if (!("MERGE".equalsIgnoreCase(this.action) || "REDACT".equalsIgnoreCase(this.action) || "ADDSTAMP".equalsIgnoreCase(this.action) || "ADDATTACHMENTS".equalsIgnoreCase(this.action))) {
            return 0;
        }
        FeatureRouter.getInstance().allowFeature(EFRConstants.pdf_document_manipulation.intValue(), this.tagNameFromClass(), null);
        return 1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void validateAttribute() {
        String[] sourceFiles;
        if (!"MERGE".equalsIgnoreCase(this.action) && this.source != null && this.source instanceof String) {
            File tempFile = VFSFileFactory.getFileObject((String)((String)this.source));
            if (!PDFTag.fileExists((String)this.source)) throw new PDFFileNotFoundException("source", (String)this.source);
            if (tempFile.isDirectory()) {
                throw new PDFFileNotFoundException("source", (String)this.source);
            }
        }
        if ("PROTECT".equalsIgnoreCase(this.action)) {
            if (this.newOwnerPassword != null || this.newUserPassword != null) {
                if (this.newOwnerPassword == null) return;
                if (!this.newOwnerPassword.equals(this.newUserPassword)) return;
            }
            if ("NONE".equalsIgnoreCase(this.encrypt)) return;
            throw new PDFException.PDFActionValidateException("newownerpassword and newuserpassword", "PROTECT");
        }
        if ("MERGE".equalsIgnoreCase(this.action)) {
            if (this.source == null) return;
            if (!(this.source instanceof String)) return;
            sourceFiles = ((String)this.source).split(",");
        } else {
            File destFile;
            if ("THUMBNAIL".equalsIgnoreCase(this.action)) {
                if (this.destination == null) {
                    this.destination = Utils.getFileFullPath((String)"", (PageContext)this.pageContext, (boolean)true) + "thumbnails" + File.separator;
                }
                if (this.directory != null) {
                    this.source = this.directory.getAbsolutePath();
                }
                if ((destFile = VFSFileFactory.getFileObject((String)this.destination)).exists()) {
                    if (!this.overwrite) throw new PDFException.PDFDirExistsException("destination", this.destination);
                    if (!destFile.isDirectory()) {
                        throw new PDFException.PDFDirNotFoundException("destination", this.destination);
                    }
                } else if (!destFile.mkdirs()) {
                    throw new PDFException.PDFDirCreateException("destination", this.destination);
                }
                if (this.format == null) {
                    this.format = "jpg";
                }
                if (this.jpgDpi > 0 && !this.format.toLowerCase().startsWith("jp")) {
                    throw new PDFException.PDFFormatSpecificException("jpgdpi", "jpgjpeg");
                }
                if (this.compressTiffs && !this.format.toLowerCase().startsWith("tif")) {
                    throw new PDFException.PDFFormatSpecificException("compresstiffs", "tif,tiff");
                }
                if (this.imagePrefix != null) return;
                if (!(this.source instanceof String)) {
                    this.imagePrefix = "thumbnail";
                    return;
                }
                File srcFile = VFSFileFactory.getFileObject((String)((String)this.source));
                int dotIndex = srcFile.getName().lastIndexOf(46);
                this.imagePrefix = dotIndex > 0 ? srcFile.getName().substring(0, dotIndex) : srcFile.getName();
                return;
            }
            if ("SIGN".equalsIgnoreCase(this.action)) {
                try {
                    if (this.pages == null) return;
                    if (this.pages == "") return;
                    Integer.parseInt(this.pages);
                    return;
                }
                catch (Exception e) {
                    throw new PDFException.InvalidPageValueException();
                }
            }
            if (!"EXTRACTIMAGE".equalsIgnoreCase(this.action)) return;
            if (this.destination == null) {
                this.destination = Utils.getFileFullPath((String)"", (PageContext)this.pageContext, (boolean)true) + "images" + File.separator;
            }
            if ((destFile = VFSFileFactory.getFileObject((String)this.destination)).exists()) {
                if (!this.overwrite) throw new PDFException.PDFDirExistsException("destination", this.destination);
                if (!destFile.isDirectory()) {
                    throw new PDFException.PDFDirNotFoundException("destination", this.destination);
                }
            } else if (!destFile.mkdirs()) {
                throw new PDFException.PDFDirCreateException("destination", this.destination);
            }
            if (this.imagePrefix != null) return;
            this.imagePrefix = "cf";
            return;
        }
        for (int i = 0; i < sourceFiles.length; ++i) {
            if (sourceFiles[i] == null) throw new PDFException.InvalidActionAttributeException("source", "MERGE");
            if ("".equals(sourceFiles[i].trim())) throw new PDFException.InvalidActionAttributeException("source", "MERGE");
            sourceFiles[i] = Utils.getFileFullPath((String)sourceFiles[i].trim(), (PageContext)this.pageContext, (boolean)true);
            File tempFile = VFSFileFactory.getFileObject((String)sourceFiles[i]);
            if (!PDFTag.fileExists(sourceFiles[i])) throw new PDFFileNotFoundException("source", sourceFiles[i]);
            if (!tempFile.isDirectory()) continue;
            throw new PDFFileNotFoundException("source", sourceFiles[i]);
        }
        if (sourceFiles.length <= 1) {
            if (((String)this.source).indexOf(",") != -1) return;
            if (this.pages != null) return;
            throw new PDFException.NoPageException("MERGE");
        }
        if (this.pages != null) {
            throw new PDFException.InvalidSourceAttributeException("pages", "MERGE");
        }
        this.source = sourceFiles;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int doEndTag() throws JspException {
        boolean isAllowed;
        if ((this.action != null && ("SIGN".equals(this.action) || "UNSIGN".equals(this.action)) || "READSIGNATUREFIELDS".equals(this.action) || "VALIDATESIGNATURE".equals(this.action)) && !(isAllowed = FeatureRouter.getInstance().isFeatureAllowed(EFRConstants.pdf_digital_signatures.intValue()))) {
            throw new FeatureNotAvailableException(EFRConstants.pdf_digital_signatures.intValue());
        }
        if (this.action == null || "PROCESSDDX".equalsIgnoreCase(this.action)) {
            this.pageContext.setAttribute(this.name, (Object)this.pdfOperation.processDDX(this.ddxFile, this.inputFiles, this.outputFiles, this.pageContext));
        } else if ("READ".equalsIgnoreCase(this.action)) {
            PDFDocument result = this.pdfOperation.read(this.password, this.source);
            this.pageContext.setAttribute(this.name, (Object)new PDFDocWrapper(result, this.password, this.pdfOperation));
        } else if ("DELETEPAGES".equalsIgnoreCase(this.action)) {
            PDFDocument result = this.pdfOperation.deletePage(this.destination, this.source, this.pages, this.password);
            if (this.name != null) {
                this.pageContext.setAttribute(this.name, (Object)new PDFDocWrapper(result, this.password, this.pdfOperation));
            }
        } else if ("PROTECT".equalsIgnoreCase(this.action)) {
            PDFDocument result = this.pdfOperation.protect(this.destination, this.source, this.password, this.permissions, this.newOwnerPassword, this.newUserPassword, this.encrypt);
            if (this.name != null && result != null) {
                String newOpenPass = null;
                newOpenPass = this.newOwnerPassword != null ? this.newOwnerPassword : this.newUserPassword;
                this.pageContext.setAttribute(this.name, (Object)new PDFDocWrapper(result, newOpenPass, this.pdfOperation));
            }
        } else if ("MERGE".equalsIgnoreCase(this.action)) {
            PDFDocument result;
            if (!this.portfolio) {
                if (this.directory == null) {
                    if (this.pdfdoc == null && this.source == null) {
                        throw new PDFException.PDFMergeSourceDiretoryException();
                    }
                    result = this.pdfOperation.merge(this.destination, this.pdfdoc, this.source, this.password, this.pages, this.keepBookmark);
                } else {
                    result = this.pdfOperation.merge(this.destination, this.pdfdoc, this.directory, this.order, this.ascending, this.password, this.keepBookmark, this.stopOnError, this.pages);
                }
            } else {
                result = this.pdfOperation.merge(this.pdfsPortfolio, this.destination);
            }
            if (this.name != null) {
                this.pageContext.setAttribute(this.name, (Object)new PDFDocWrapper(result, this.password, this.pdfOperation));
            }
        } else if ("ADDSTAMP".equalsIgnoreCase(this.action)) {
            if (this.pdfdoc == null && this.source == null) {
                throw new PDFException.PDFAddStampSourceDirectoryException();
            }
            if (this.name != null) {
                try {
                    PDFDocument result = this.pdfOperation.readFile(this.destination, this.password);
                    this.pageContext.setAttribute(this.name, (Object)new PDFDocWrapper(result, this.password, this.pdfOperation));
                }
                catch (FileNotFoundException newOpenPass) {
                }
                catch (IOException newOpenPass) {
                }
                catch (PDFException newOpenPass) {}
            }
        } else if ("SANITIZE".equalsIgnoreCase(this.action)) {
            PDFDocument result = this.pdfOperation.sanitize(this.destination, this.source, this.password, true);
            if (this.name != null) {
                this.pageContext.setAttribute(this.name, (Object)new PDFDocWrapper(result, this.password, this.pdfOperation));
            }
        } else if ("EXPORT".equalsIgnoreCase(this.action)) {
            if ("COMMENT".equalsIgnoreCase(this.type)) {
                PDFDocument result = this.pdfOperation.exportComment(this.source, this.exportTo, this.password, true, this.pageContext);
            } else {
                if (!"METADATA".equalsIgnoreCase(this.type)) throw new PDFException.InvalidActionAttributeException("TYPE", this.action);
                PDFDocument result = this.pdfOperation.exportMetadata(this.source, this.exportTo, this.password, true, this.pageContext);
            }
        } else if ("GETATTACHMENTS".equalsIgnoreCase(this.action)) {
            Struct result = this.pdfOperation.getAttachments(this.source, this.destination, this.nameKeys, this.extract, this.encoding, this.pageContext);
            this.pageContext.setAttribute(this.name, (Object)result);
        } else if ("IMPORT".equalsIgnoreCase(this.action)) {
            if ("COMMENT".equalsIgnoreCase(this.type)) {
                PDFDocument result = this.pdfOperation.importComment(this.source, this.importFrom, this.destination, this.password, true, this.pageContext);
                if (this.name != null) {
                    this.pageContext.setAttribute(this.name, (Object)new PDFDocWrapper(result, this.password, this.pdfOperation));
                }
            } else {
                if (!"METADATA".equalsIgnoreCase(this.type)) throw new PDFException.InvalidActionAttributeException("TYPE", this.action);
                PDFDocument result = this.pdfOperation.importMetadata(this.source, this.importFrom, this.destination, this.password, true, this.pageContext);
                if (this.name != null) {
                    this.pageContext.setAttribute(this.name, (Object)new PDFDocWrapper(result, this.password, this.pdfOperation));
                }
            }
        } else if ("REDACT".equalsIgnoreCase(this.action)) {
            PDFDocument result = null;
            if (this.pdfdoc == null && this.source == null) {
                throw new PDFException.PDFRedactSourceDirectoryException();
            }
            if (this.pdfdoc == null) {
                PDFDocHandler handler = new PDFDocHandler();
                PDFDocument pdfDocument = null;
                try {
                    pdfDocument = handler.readInternal(this.password, this.source, false, false);
                    if (!handler.getPdfDocSecurityHandler().isActionAllowed(pdfDocument, ObjectOperations.DOC_OPEN)) {
                        throw new PDFException.PDFInvalidPassword();
                    }
                }
                catch (PDFException e) {
                    throw new PDFException.PDFInvalidPassword();
                }
                catch (IOException e) {
                    // empty catch block
                }
                List<PDFParamInfo> pdfparamInfos = this.getParamtagsInfo();
                PDFDocument document = this.pdfOperation.markForRedaction(this.destination, this.source, this.password, pdfparamInfos);
                result = this.pdfOperation.redactDoc(this.destination, document, this.password, true);
            } else {
                result = this.pdfOperation.redactDoc(this.destination, this.pdfdoc, this.password, true);
            }
            if (this.name != null && result != null) {
                this.pageContext.setAttribute(this.name, (Object)new PDFDocWrapper(result, this.password, this.pdfOperation));
            }
        } else if ("ADDATTACHMENTS".equalsIgnoreCase(this.action)) {
            PDFDocument result = this.pdfOperation.attachDoc(this.destination, this.source, this.password, this.param, this.pageContext, true);
            if (this.name != null) {
                this.pageContext.setAttribute(this.name, (Object)new PDFDocWrapper(result, this.password, this.pdfOperation));
            }
        } else if ("WRITE".equalsIgnoreCase(this.action)) {
            PDFDocument result = this.pdfOperation.write(this.destination, this.source, this.password, this.saveOption, this.version, this.flatten, this.encodeAll, true);
            if (result != null) {
                if (this.name != null) {
                    this.pageContext.setAttribute(this.name, (Object)new PDFDocWrapper(result, this.password, this.pdfOperation));
                } else if (this.sourceVar != null) {
                    this.pageContext.setAttribute(this.sourceVar, (Object)new PDFDocWrapper(result, this.password, this.pdfOperation));
                }
            }
        } else if ("GETINFO".equalsIgnoreCase(this.action)) {
            this.pageContext.setAttribute(this.name, (Object)this.pdfOperation.getInfo(this.source, this.password, false));
        } else if ("SETINFO".equalsIgnoreCase(this.action)) {
            PDFDocument result = this.pdfOperation.setInfo(this.destination, this.source, this.password, this.info);
            if (this.name != null && result != null) {
                this.pageContext.setAttribute(this.name, (Object)new PDFDocWrapper(result, this.password, this.pdfOperation));
            }
        } else if ("EXTRACTTEXT".equalsIgnoreCase(this.action)) {
            String result = this.pdfOperation.extractText(this.source, this.password, this.pages, this.type, this.addQuads, this.honourSpaces, this.useStructure, this.charset);
            if (this.destination != null) {
                FileUtils.writeFile((String)this.destination, (Object)result, (String)this.charset);
            } else {
                this.pageContext.setAttribute(this.name, (Object)result);
            }
        } else if ("ADDWATERMARK".equalsIgnoreCase(this.action)) {
            PDFDocument result = this.copyfrom != null ? this.pdfOperation.addWatermark(this.destination, this.source, this.password, this.pages, this.copyfrom, this.foreground, this.opacity, this.position, this.rotation, this.showOnPrint) : this.pdfOperation.addWatermark(this.destination, this.source, this.password, this.pages, (Image)this.image, this.foreground, this.opacity, this.position, this.rotation, this.showOnPrint, this.richText, this.height, this.width);
            if (this.name != null) {
                this.pageContext.setAttribute(this.name, (Object)new PDFDocWrapper(result, this.password, this.pdfOperation));
            }
        } else if ("ADDHEADER".equalsIgnoreCase(this.action)) {
            PDFDocument result = this.pdfOperation.addWHF(this.destination, this.source, this.password, this.pages, (Image)this.image, this.opacity, this.showOnPrint, this.richText, "ADDHEADER", this.align, this.numberFormat, this.leftMargin, this.rightMargin, this.topMargin);
            if (this.name != null) {
                this.pageContext.setAttribute(this.name, (Object)new PDFDocWrapper(result, this.password, this.pdfOperation));
            }
        } else if ("ADDFOOTER".equalsIgnoreCase(this.action)) {
            PDFDocument result = this.pdfOperation.addWHF(this.destination, this.source, this.password, this.pages, (Image)this.image, this.opacity, this.showOnPrint, this.richText, "ADDFOOTER", this.align, this.numberFormat, this.leftMargin, this.rightMargin, this.bottomMargin);
            if (this.name != null) {
                this.pageContext.setAttribute(this.name, (Object)new PDFDocWrapper(result, this.password, this.pdfOperation));
            }
        } else if ("REMOVEWATERMARK".equalsIgnoreCase(this.action)) {
            PDFDocument result = this.pdfOperation.removeHFW(this.destination, this.source, this.password, this.pages, this.stopOnError, "REMOVEWATERMARK");
            if (this.name != null) {
                this.pageContext.setAttribute(this.name, (Object)new PDFDocWrapper(result, this.password, this.pdfOperation));
            }
        } else if ("REMOVEHEADERFOOTER".equalsIgnoreCase(this.action)) {
            PDFDocument result = this.pdfOperation.removeHFW(this.destination, this.source, this.password, this.pages, this.stopOnError, "REMOVEHEADERFOOTER");
            if (this.name != null) {
                this.pageContext.setAttribute(this.name, (Object)new PDFDocWrapper(result, this.password, this.pdfOperation));
            }
        } else if ("THUMBNAIL".equalsIgnoreCase(this.action)) {
            this.pdfOperation.thumbnail(this.source, this.password, this.destination, this.imagePrefix, this.format, this.pages, this.scale, this.transparent, this.hires, this.pageContext, this.hiRes, this.maxScale, this.maxLength, this.maxBreadth, this.overridePage, this.jpgDpi, this.compressTiffs, this.stopOnError);
        } else if ("EXTRACTIMAGE".equalsIgnoreCase(this.action)) {
            this.pdfOperation.extractImage(this.source, this.password, this.destination, this.imagePrefix, this.format, this.pages);
        } else if ("OPTIMIZE".equalsIgnoreCase(this.action)) {
            PDFDocument result = null;
            result = this.algo != null ? this.pdfOperation.downsampleImage(this.source, this.password, this.destination, this.algo, this.vScale, this.hScale, this.pages) : this.pdfOperation.read(this.password, this.source);
            result = this.pdfOperation.reduceSize(result, this.destination, this.noJS, this.noThumbnails, this.noBookmarks, this.noComments, this.noMetadata, this.noAttachments, this.noLinks, this.pages, this.noFonts);
            if (this.name != null) {
                this.pageContext.setAttribute(this.name, (Object)new PDFDocWrapper(result, this.password, this.pdfOperation));
            }
        } else if ("TRANSFORM".equalsIgnoreCase(this.action)) {
            PDFDocument result = this.pdfOperation.transform(this.source, this.password, this.destination, this.rotation, this.position, this.hScale, this.vScale, this.pages);
            if (this.name != null) {
                this.pageContext.setAttribute(this.name, (Object)new PDFDocWrapper(result, this.password, this.pdfOperation));
            }
        } else if ("ARCHIVE".equalsIgnoreCase(this.action)) {
            if (this.standard == null) {
                this.standard = "1b";
            }
            PDFDocument pdfdoc = this.pdfOperation.generateArchive(this.source, this.destination, this.password, this.overwrite, this.standard);
            if (this.name != null) {
                this.pageContext.setAttribute(this.name, (Object)new PDFDocWrapper(pdfdoc, this.password, this.pdfOperation));
            }
        } else if ("SIGN".equalsIgnoreCase(this.action)) {
            PDFDocument pdfdoc = this.pdfOperation.signDocument(this.source, this.destination, this.password, this.keystore, this.keyalias, this.keyPassword, this.keystorePassword, this.pages, this.position, this.width, this.height, this.author, this.signatureFieldName, this.flatten);
            if (this.name != null) {
                this.pageContext.setAttribute(this.name, (Object)new PDFDocWrapper(pdfdoc, this.password, this.pdfOperation));
            }
        } else if ("CREATESIGNATUREFIELD".equalsIgnoreCase(this.action)) {
            PDFDocument pdfdoc = this.pdfOperation.createSignatureField(this.source, this.destination, this.password, this.signatureFieldName, this.position, this.width, this.height, this.pages);
            if (this.name != null) {
                this.pageContext.setAttribute(this.name, (Object)new PDFDocWrapper(pdfdoc, this.password, this.pdfOperation));
            }
        } else if ("UNSIGN".equalsIgnoreCase(this.action)) {
            PDFDocument pdfdoc = this.pdfOperation.unsignDocument(this.source, this.destination, this.password, this.unsignall, this.signatureFieldName);
            if (this.name != null) {
                this.pageContext.setAttribute(this.name, (Object)new PDFDocWrapper(pdfdoc, this.password, this.pdfOperation));
            }
        } else if ("VALIDATESIGNATURE".equalsIgnoreCase(this.action)) {
            Struct str = this.pdfOperation.validateSignatures(this.source, this.password);
            this.pageContext.setAttribute(this.name, (Object)str);
        } else if ("READSIGNATUREFIELDS".equalsIgnoreCase(this.action)) {
            QueryTable qtb = this.pdfOperation.readSignatures(this.source, this.password);
            this.pageContext.setAttribute(this.name, (Object)qtb);
        }
        this.release();
        this.onTagEnd();
        return 6;
    }
}

