/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.pdf;

import coldfusion.featurerouter.EFRConstants;
import coldfusion.featurerouter.FeatureRouter;
import coldfusion.image.Image;
import coldfusion.log.CFLogs;
import coldfusion.log.Logger;
import coldfusion.pdf.AttachmentObject;
import coldfusion.pdf.DDXHelper;
import coldfusion.pdf.PDFA2BasicConversionHandler;
import coldfusion.pdf.PDFABasicConversionHandler;
import coldfusion.pdf.PDFArchiveOptions;
import coldfusion.pdf.PDFDocHandler;
import coldfusion.pdf.PDFDocUtil;
import coldfusion.pdf.PDFDocWrapper;
import coldfusion.pdf.PDFFileNotFoundException;
import coldfusion.pdf.PDFForm;
import coldfusion.pdf.PDFParamInfo;
import coldfusion.pdf.SamplePDFA2ValidationHandler;
import coldfusion.pdf.XFADataXMLGenerator;
import coldfusion.pdf.XFAXMLtoCFStruct;
import coldfusion.pdf.core.PDFDocException;
import coldfusion.pdf.core.PDFException;
import coldfusion.runtime.Struct;
import coldfusion.server.ServiceFactory;
import coldfusion.sql.QueryTable;
import coldfusion.util.Utils;
import coldfusion.vfs.VFSFileFactory;
import coldfusion.xml.XmlIOException;
import coldfusion.xml.XmlProcessor;
import com.adobe.internal.ddxm.Executive;
import com.adobe.internal.ddxm.ValidationException;
import com.adobe.internal.io.ByteReader;
import com.adobe.internal.io.ByteWriter;
import com.adobe.internal.io.InputStreamByteReader;
import com.adobe.internal.pdfm.Document;
import com.adobe.internal.pdfm.io.BytesStore;
import com.adobe.internal.pdfm.io.FileStore;
import com.adobe.internal.pdfm.io.Store;
import com.adobe.internal.pdftoolkit.core.cos.PDFCore;
import com.adobe.internal.pdftoolkit.core.credentials.Credentials;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFConfigurationException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFFontException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityAuthorizationException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFUnableToCompleteOperationException;
import com.adobe.internal.pdftoolkit.core.fontset.PDFFontSet;
import com.adobe.internal.pdftoolkit.core.permissionprovider.ObjectOperations;
import com.adobe.internal.pdftoolkit.core.permissionprovider.PermissionProvider;
import com.adobe.internal.pdftoolkit.core.securityframework.SecurityLock;
import com.adobe.internal.pdftoolkit.core.types.ASDate;
import com.adobe.internal.pdftoolkit.core.types.ASQuad;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCatalog;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocumentInfo;
import com.adobe.internal.pdftoolkit.pdf.document.PDFEncryptionType;
import com.adobe.internal.pdftoolkit.pdf.document.PDFNameDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFOpenOptions;
import com.adobe.internal.pdftoolkit.pdf.document.PDFSaveFullOptions;
import com.adobe.internal.pdftoolkit.pdf.document.PDFSaveIncrementalOptions;
import com.adobe.internal.pdftoolkit.pdf.document.PDFSaveLinearOptions;
import com.adobe.internal.pdftoolkit.pdf.document.PDFSaveOptions;
import com.adobe.internal.pdftoolkit.pdf.document.PDFVersion;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFRectangle;
import com.adobe.internal.pdftoolkit.pdf.interactive.PDFViewerPreferences;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotation;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationRedaction;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationStamp;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFInteractiveForm;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPage;
import com.adobe.internal.pdftoolkit.services.ap.AppearanceService;
import com.adobe.internal.pdftoolkit.services.ap.TextFormatterImpl;
import com.adobe.internal.pdftoolkit.services.ap.annot.StampAnnotApGenerator;
import com.adobe.internal.pdftoolkit.services.ap.spi.APContext;
import com.adobe.internal.pdftoolkit.services.ap.spi.APResources;
import com.adobe.internal.pdftoolkit.services.ap.spi.TextFormatter;
import com.adobe.internal.pdftoolkit.services.digsig.SignatureFieldInterface;
import com.adobe.internal.pdftoolkit.services.digsig.SignatureManager;
import com.adobe.internal.pdftoolkit.services.formflattener.FormFlattener;
import com.adobe.internal.pdftoolkit.services.manipulations.PMMOptions;
import com.adobe.internal.pdftoolkit.services.manipulations.PMMService;
import com.adobe.internal.pdftoolkit.services.pdfa.PDFAConformanceLevel;
import com.adobe.internal.pdftoolkit.services.pdfa.PDFAConversionHandler;
import com.adobe.internal.pdftoolkit.services.pdfa.PDFAConversionOptions;
import com.adobe.internal.pdftoolkit.services.pdfa.PDFAService;
import com.adobe.internal.pdftoolkit.services.pdfa2.PDFA2ConformanceLevel;
import com.adobe.internal.pdftoolkit.services.pdfa2.PDFA2ConversionHandler;
import com.adobe.internal.pdftoolkit.services.pdfa2.PDFA2ConversionOptions;
import com.adobe.internal.pdftoolkit.services.pdfa2.PDFA2Service;
import com.adobe.internal.pdftoolkit.services.pdfa2.PDFA2ValidationHandler;
import com.adobe.internal.pdftoolkit.services.pdfa2.PDFA2ValidationOptions;
import com.adobe.internal.pdftoolkit.services.pdfa3.PDFA3Service;
import com.adobe.internal.pdftoolkit.services.permissions.PermissionsManager;
import com.adobe.internal.pdftoolkit.services.redaction.RedactionOptions;
import com.adobe.internal.pdftoolkit.services.redaction.impl.RedactionProcessor;
import com.adobe.internal.pdftoolkit.services.sanitization.SanitizationOptions;
import com.adobe.internal.pdftoolkit.services.sanitization.SanitizationService;
import com.adobe.internal.pdftoolkit.services.security.SecurityKeyPassword;
import com.adobe.internal.pdftoolkit.services.security.StandardEncryptionPermissions;
import com.adobe.internal.pdftoolkit.services.textextraction.TextExtractionOptions;
import com.adobe.internal.pdftoolkit.services.textextraction.TextExtractor;
import com.adobe.internal.pdftoolkit.services.xmp.DocumentMetadata;
import com.adobe.internal.pdftoolkit.services.xmp.XMPService;
import com.adobe.service.ddxm.client.Environment;
import com.adobe.service.ddxm.client.Output;
import jakarta.servlet.jsp.PageContext;
import jakarta.xml.bind.JAXBException;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jpedal.exception.PdfException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class PDFDocOperation {
    private PDFDocHandler pdfDoc;
    private static long ddxHash = 2780866939L;
    private static long ddxstandardhash = 3445250269L;
    private Logger logger = CFLogs.APPLICATION_LOG;
    private static String INPUTFILE = "In1";
    private static String OUTPUTFILE = "Out1";
    private static String EXTRAFILE = "In2";
    private static final boolean enableExternalEntity = Boolean.getBoolean("coldfusion.pdf.ddx.allowExternalEntities");

    public PDFDocHandler getPdfDocHandler() {
        if (this.pdfDoc == null) {
            this.pdfDoc = new PDFDocHandler();
        }
        return this.pdfDoc;
    }

    public PDFDocument read(String password, Object source) {
        try {
            return this.getPdfDocHandler().readInternal(password, source, false, false);
        }
        catch (PDFInvalidDocumentException e) {
            if (source instanceof String) {
                throw new PDFException.PDFInvallidDocumentNameException("READ", (Throwable)e, (String)source);
            }
            throw new PDFException.PDFInvallidDocumentException("READ", (Throwable)e);
        }
        catch (PDFSecurityAuthorizationException pdfSex) {
            throw new PDFException.PDFIncorrectPasswordException("READ", (Throwable)pdfSex);
        }
        catch (PDFException pdfEx) {
            throw new PDFException.PDFOperationException("READ", (Throwable)pdfEx);
        }
        catch (IOException pdfEx) {
            throw new PDFException.PDFOperationException("READ", (Throwable)pdfEx);
        }
    }

    public PDFDocument deletePage(String outputPDFFileName, Object source, String page, String password) {
        PDFDocument pdfDocument = null;
        try {
            boolean useRaf = false;
            if (source instanceof String && ((String)source).equalsIgnoreCase(outputPDFFileName)) {
                useRaf = true;
            }
            pdfDocument = this.getPdfDocHandler().readInternal(password, source, false, useRaf);
            if (!this.getPdfDocHandler().getPdfDocSecurityHandler().isActionAllowed(pdfDocument, ObjectOperations.PAGE_DELETE)) {
                throw new PDFException.PDFUnAuthorisedOperationException("DELETEPAGES", (Object)pdfDocument);
            }
            this.getPdfDocHandler().deletePagesInternal(pdfDocument, page);
            if (outputPDFFileName != null) {
                this.getPdfDocHandler().writeDocument(outputPDFFileName, pdfDocument, (PDFSaveOptions)PDFSaveFullOptions.newInstance());
            }
            return pdfDocument;
        }
        catch (PDFInvalidDocumentException e) {
            if (source instanceof String) {
                throw new PDFException.PDFInvallidDocumentNameException("DELETEPAGES", (Throwable)e, (String)source, (Object)pdfDocument);
            }
            throw new PDFException.PDFInvallidDocumentException("DELETEPAGES", (Throwable)e, pdfDocument);
        }
        catch (PDFSecurityException pdfSex) {
            throw new PDFException.PDFUnAuthorisedOperationException("DELETEPAGES", (Throwable)pdfSex, pdfDocument);
        }
        catch (PDFException pdfEx) {
            throw new PDFException.PDFOperationException("DELETEPAGES", (Throwable)pdfEx, pdfDocument);
        }
        catch (IOException pdfEx) {
            throw new PDFException.PDFOperationException("DELETEPAGES", (Throwable)pdfEx, pdfDocument);
        }
    }

    public PDFDocument protect(String outputPDFFileName, Object source, String password, String permission, String newOwnerPWDStr, String newUserPWDStr, String encryptionMethod) {
        PDFDocument pdfDocument = null;
        try {
            SecurityLock securityLock;
            PDFSaveFullOptions saveFullOptions;
            SignatureManager sigMgr;
            boolean ignorePerm = false;
            boolean useRaf = false;
            if (source instanceof String && ((String)source).equalsIgnoreCase(outputPDFFileName)) {
                useRaf = true;
            }
            if ((sigMgr = SignatureManager.newInstance((PDFDocument)(pdfDocument = this.getPdfDocHandler().readInternal(password, source, false, useRaf)))).hasUsageRights()) {
                sigMgr.removeUsageRights();
            }
            if (!this.getPdfDocHandler().getPdfDocSecurityHandler().isActionAllowed(pdfDocument, ObjectOperations.DOC_SECURE)) {
                throw new PDFException.PDFUnAuthorisedOperationException("PROTECT", (Object)pdfDocument);
            }
            if (newOwnerPWDStr == null) {
                try {
                    ignorePerm = true;
                    newOwnerPWDStr = new String(SecurityKeyPassword.newInstance((PDFDocument)pdfDocument).getOwnerPassword());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (newUserPWDStr == null) {
                try {
                    newUserPWDStr = new String(SecurityKeyPassword.newInstance((PDFDocument)pdfDocument).getUserPassword());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            PDFSaveFullOptions pDFSaveFullOptions = saveFullOptions = (securityLock = this.getPdfDocHandler().getPdfDocSecurityHandler().encrypt(pdfDocument, newOwnerPWDStr, newUserPWDStr, encryptionMethod, permission, ignorePerm)) != null ? PDFSaveFullOptions.newInstance((SecurityLock)securityLock) : PDFSaveFullOptions.newInstance();
            if (outputPDFFileName == null) {
                byte[] savedBytes = this.getPdfDocHandler().writeDocument(pdfDocument, (PDFSaveOptions)saveFullOptions);
                String newOpenPass = null;
                newOpenPass = newOwnerPWDStr != null ? newOwnerPWDStr : newUserPWDStr;
                pdfDocument = this.getPdfDocHandler().readInternal(newOpenPass, (Object)savedBytes, false, false);
                return pdfDocument;
            }
            this.getPdfDocHandler().writeDocument(outputPDFFileName, pdfDocument, (PDFSaveOptions)saveFullOptions);
            return null;
        }
        catch (PDFInvalidDocumentException e) {
            if (source instanceof String) {
                throw new PDFException.PDFInvallidDocumentNameException("PROTECT", (Throwable)e, (String)source, pdfDocument);
            }
            throw new PDFException.PDFInvallidDocumentException("PROTECT", (Throwable)e, pdfDocument);
        }
        catch (PDFSecurityException pdfSex) {
            throw new PDFException.PDFUnAuthorisedOperationException("PROTECT", (Throwable)pdfSex, pdfDocument);
        }
        catch (PDFException pdfEx) {
            throw new PDFException.PDFOperationException("PROTECT", (Throwable)pdfEx, pdfDocument);
        }
        catch (IOException pdfEx) {
            throw new PDFException.PDFOperationException("PROTECT", (Throwable)pdfEx, pdfDocument);
        }
    }

    public PDFDocument write(String outputPDFFileName, Object source, String password, String saveOption, String version, boolean flatten, boolean encodeAll, boolean execJS) {
        try {
            boolean useRaf = true;
            if (source instanceof String && outputPDFFileName == null) {
                useRaf = false;
            }
            PDFDocument pdfDocument = this.getPdfDocHandler().readInternal(password, source, false, useRaf);
            SignatureManager sigMgr = SignatureManager.newInstance((PDFDocument)pdfDocument);
            if (flatten) {
                PDFInteractiveForm pdfinteractiveform;
                if (sigMgr.hasUsageRights()) {
                    sigMgr.removeUsageRights();
                }
                if ((pdfinteractiveform = pdfDocument.getInteractiveForm()) == null) {
                    pdfDocument.close();
                    throw new PDFException.PDFWriteFlattenException("flatten", "WRITE");
                }
                int formType = PDFForm.determineFormType(pdfDocument);
                if (formType == 2) {
                    pdfinteractiveform.setNeedAppearances(true);
                    XFADataXMLGenerator pdfDataObject = new XFADataXMLGenerator(pdfDocument);
                    Map dataStruct = XFAXMLtoCFStruct.parseXMLtoCF(pdfDataObject.getOldDataXML());
                    pdfDataObject.buildFormParamsListFromDataFileStruct(dataStruct, new Vector());
                    pdfDataObject.storeInFormParamsMap();
                    pdfDataObject.setAllPDFFieldAppearance();
                } else if (execJS) {
                    try {
                        this.getPdfDocHandler().getJavascriptEventForFormField(pdfDocument);
                    }
                    catch (Exception e) {
                        try {
                            if (pdfDocument != null) {
                                pdfDocument.close();
                            }
                        }
                        catch (Exception dataStruct) {
                            // empty catch block
                        }
                        return this.write(outputPDFFileName, source, password, saveOption, version, flatten, encodeAll, false);
                    }
                }
                APResources apResources = new APResources((PDFFontSet)ServiceFactory.getDocumentService().getAssemblerFontSet(), Locale.ROOT, null);
                APContext apContext = new APContext(apResources, true, null);
                TextFormatterImpl textFormatter = new TextFormatterImpl(pdfDocument);
                AppearanceService.generateAppearances((PDFDocument)pdfDocument, (APContext)apContext, (TextFormatter)textFormatter);
                FormFlattener.flattenDocument((APContext)apContext, (PDFDocument)pdfDocument, null);
            }
            if (version != null) {
                pdfDocument.setToSaveVersion(PDFVersion.getSupportedInstance((String)version));
            }
            Object options = null;
            if (saveOption == null) {
                options = sigMgr.hasUsageRights() || sigMgr.hasSignedSignatureFields() ? PDFSaveLinearOptions.newInstance() : PDFSaveFullOptions.newInstance();
            } else if ("FULL".equalsIgnoreCase(saveOption)) {
                options = PDFSaveFullOptions.newInstance();
            } else if ("LINEAR".equalsIgnoreCase(saveOption)) {
                options = PDFSaveLinearOptions.newInstance();
            } else if ("INCREMENTAL".equalsIgnoreCase(saveOption)) {
                options = PDFSaveIncrementalOptions.newInstance();
            }
            if (outputPDFFileName == null) {
                options.setForceCompress(encodeAll);
                byte[] srcPdfBytes = this.getPdfDocHandler().writeDocument(pdfDocument, (PDFSaveOptions)options);
                return this.readPDFfromByteArray(srcPdfBytes);
            }
            this.getPdfDocHandler().writeDocument(outputPDFFileName, pdfDocument, (PDFSaveOptions)options, encodeAll);
        }
        catch (PDFInvalidDocumentException e) {
            if (source instanceof String) {
                throw new PDFException.PDFInvallidDocumentNameException("WRITE", (Throwable)e, (String)source);
            }
            throw new PDFException.PDFInvallidDocumentException("WRITE", (Throwable)e);
        }
        catch (PDFSecurityException pdfSex) {
            throw new PDFException.PDFUnAuthorisedOperationException("WRITE", (Throwable)pdfSex);
        }
        catch (PDFException pdfEx) {
            throw new PDFException.PDFOperationException("WRITE", (Throwable)pdfEx);
        }
        catch (IOException pdfEx) {
            throw new PDFException.PDFOperationException("WRITE", (Throwable)pdfEx);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PDFDocument readPDFfromByteArray(byte[] srcPdfBytes) throws PDFInvalidDocumentException, PDFSecurityException, PDFIOException, IOException {
        ByteArrayInputStream byteArrayInputStream = null;
        InputStreamByteReader byteReader = null;
        try {
            byteArrayInputStream = new ByteArrayInputStream(srcPdfBytes);
            byteReader = new InputStreamByteReader((InputStream)byteArrayInputStream);
            PDFDocument pDFDocument = PDFDocument.newInstance((ByteReader)byteReader, (PDFOpenOptions)PDFOpenOptions.newInstance());
            return pDFDocument;
        }
        finally {
            try {
                byteArrayInputStream.close();
                byteReader.close();
            }
            catch (Exception exception) {}
        }
    }

    public PDFDocument merge(PDFDocument mainPDF, Object source, String password, String page, boolean keepBookmark, boolean stopOnError) {
        if (source == null) {
            return mainPDF;
        }
        PDFDocument pdfDocument = null;
        PMMOptions pmmOptions = keepBookmark ? PMMOptions.newInstanceAll() : PMMOptions.newInstanceNone();
        try {
            if (mainPDF != null) {
                pdfDocument = this.getPdfDocHandler().readInternal(password, source, false, false);
                if (pdfDocument.getInteractiveForm() != null && page == null) {
                    PMMService pmmServiceMain = new PMMService(pdfDocument);
                    pmmServiceMain.insertPages(mainPDF, null, null, pmmOptions);
                    mainPDF = pdfDocument;
                } else {
                    PMMService pmmServiceMain = new PMMService(mainPDF);
                    if (page == null) {
                        pmmServiceMain.appendPages(pdfDocument, null, pmmOptions);
                    } else {
                        PDFPage[] pageList = this.getPdfDocHandler().getPagesInternal(pdfDocument, page);
                        PMMService pmmService = new PMMService(pdfDocument);
                        pmmServiceMain.appendPages(pmmService.extractPages(pageList, pmmOptions, PDFOpenOptions.newInstance()), null, pmmOptions);
                    }
                }
            } else {
                pdfDocument = this.getPdfDocHandler().readInternal(password, source, false, false);
                if (page != null) {
                    PDFPage[] pageList = this.getPdfDocHandler().getPagesInternal(pdfDocument, page);
                    PMMService pmmService = new PMMService(pdfDocument);
                    mainPDF = pmmService.extractPages(pageList, pmmOptions, PDFOpenOptions.newInstance());
                } else {
                    mainPDF = pdfDocument;
                }
            }
        }
        catch (PDFInvalidDocumentException e) {
            if (stopOnError) {
                if (source instanceof String) {
                    throw new PDFException.PDFInvallidDocumentNameException("MERGE", (Throwable)e, (String)source, (Object)pdfDocument);
                }
                throw new PDFException.PDFInvallidDocumentException("MERGE", (Throwable)e, (Object)pdfDocument);
            }
        }
        catch (PDFSecurityException pdfSex) {
            throw new PDFException.PDFUnAuthorisedOperationException("MERGE", (Throwable)pdfSex, pdfDocument);
        }
        catch (PDFException pdfEx) {
            throw new PDFException.PDFOperationException("MERGE", (Throwable)pdfEx, pdfDocument);
        }
        catch (IOException pdfEx) {
            throw new PDFException.PDFOperationException("MERGE", (Throwable)pdfEx, pdfDocument);
        }
        return mainPDF;
    }

    public void addStamp(String destination, Object source, String password, String pages, int[][] coordinate, String iconName, String content, int coordinateLength, int rotation, int opacity) {
        PDFDocument pdfDocument = null;
        ByteWriter writer = null;
        try {
            pdfDocument = this.getPdfDocHandler().readInternal(password, source, false, false);
            PDFPage[] pageList = this.getPdfDocHandler().getPagesInternal(pdfDocument, pages);
            for (int i = 0; i < pageList.length; ++i) {
                PDFPage page = pageList[i];
                for (int j = 0; j < coordinateLength; ++j) {
                    StampAnnotApGenerator apgenerator = new StampAnnotApGenerator();
                    PDFAnnotationStamp stampAnnot = PDFAnnotationStamp.newInstance((PDFDocument)pdfDocument);
                    stampAnnot.setContents(content);
                    stampAnnot.setIconName(iconName);
                    stampAnnot.setOpacity((Number)((double)opacity / 10.0));
                    stampAnnot.setRotation(rotation);
                    stampAnnot.setRect((double)coordinate[j][0], (double)coordinate[j][1], (double)coordinate[j][2], (double)coordinate[j][3]);
                    stampAnnot.setViewable(true);
                    apgenerator.genAppearancePredefinedStampIcon(stampAnnot);
                    page.addAnnotation((PDFAnnotation)stampAnnot);
                }
            }
            writer = PDFDocUtil.getRAFByteWriter(destination);
            pdfDocument.save(writer, (PDFSaveOptions)PDFSaveIncrementalOptions.newInstance());
        }
        catch (PDFException e) {
            throw new PDFException.PDFOperationException("ADDSTAMP", (Throwable)e, (Object)pdfDocument);
        }
        catch (IOException e) {
            throw new PDFException.PDFOperationException("ADDSTAMP", (Throwable)e, (Object)pdfDocument);
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public PDFDocument markForRedaction(String destination, Object source, String password, List<PDFParamInfo> paramInfos) {
        PDFDocument pdfDocument = null;
        double[] quadPoints = new double[4];
        try {
            PDFOpenOptions openOptions = PDFOpenOptions.newInstance();
            openOptions.setFontSet((PDFFontSet)ServiceFactory.getDocumentService().getAssemblerFontSet());
            pdfDocument = this.getPdfDocHandler().readInternal(password, source, false, false);
            for (PDFParamInfo paramInfo : paramInfos) {
                int[][] coordinate = paramInfo.getCoordinate();
                List words = paramInfo.getWordstoredact();
                PDFPage[] pageList = this.getPdfDocHandler().getPagesInternal(pdfDocument, paramInfo.getPages(), "REDACT");
                for (int i = 0; i < pageList.length; ++i) {
                    PDFPage pageRef = pageList[i];
                    for (int j = 0; j < paramInfo.getPosCoordinate(); ++j) {
                        for (int k = 0; k < 4; ++k) {
                            quadPoints[k] = coordinate[j][k];
                        }
                        PDFAnnotationRedaction pdfRedact = PDFAnnotationRedaction.newInstance((PDFDocument)pdfDocument);
                        pdfRedact.setQuadPoints(new double[]{quadPoints[0], quadPoints[1], quadPoints[2], quadPoints[1], quadPoints[0], quadPoints[3], quadPoints[2], quadPoints[3]});
                        pdfRedact.setInteriorColor(0.0, 0.0, 0.0);
                        pdfRedact.setRect(0.0, 0.0, 0.0, 0.0);
                        pageRef.addAnnotation((PDFAnnotation)pdfRedact);
                    }
                    if (words == null || words.isEmpty()) continue;
                    this.addRedactAnnotation(pageRef, pdfDocument, words, paramInfo);
                }
            }
        }
        catch (PDFException pdfEx) {
            throw new PDFException.PDFOperationException("REDACT", (Throwable)pdfEx, pdfDocument);
        }
        catch (IOException pdfEx) {
            throw new PDFException.PDFOperationException("REDACT", (Throwable)pdfEx, pdfDocument);
        }
        return pdfDocument;
    }

    private void addRedactAnnotation(PDFPage pageRef, PDFDocument pdfDocument, List<String> wordsToRemove, PDFParamInfo paramInfo) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFFontException {
        PDFFontSet fontSet = (PDFFontSet)ServiceFactory.getDocumentService().getAssemblerFontSet();
        TextExtractionOptions txtExtOptns = TextExtractionOptions.newInstance();
        txtExtOptns.setHonourSpecialCharacter(true);
        TextExtractor textExtractor = TextExtractor.newInstance((PDFDocument)pdfDocument, (PDFFontSet)fontSet, (TextExtractionOptions)txtExtOptns);
        PDFPage currPage = pageRef;
        RedactionOptions options = new RedactionOptions(null);
        options.setWordMatch(paramInfo.getMatchingCriteria());
        HashSet<String> wordsSet = new HashSet<String>(wordsToRemove);
        double[] quadsOfWordsToBeRemovedArray = RedactionProcessor.adjustBoundingBox((PDFPage)currPage, (TextExtractor)textExtractor, wordsSet, (RedactionOptions)options, (boolean)paramInfo.isIgnorecase());
        this.addRedactionAnnotationsForWords(currPage, quadsOfWordsToBeRemovedArray);
    }

    private void addRedactionAnnotationsForWords(PDFPage page, double[] quadsOfWordsToBeRemovedArray) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFAnnotationRedaction redactAnnot = PDFAnnotationRedaction.newInstance((PDFDocument)page.getPDFDocument());
        redactAnnot.setInteriorColor(0.0, 0.0, 0.0);
        redactAnnot.setQuadPoints(quadsOfWordsToBeRemovedArray);
        redactAnnot.setRect(0.0, 0.0, 0.0, 0.0);
        page.addAnnotation((PDFAnnotation)redactAnnot);
    }

    public static double[] getQuadArray(List<ASQuad> quadList) {
        double[] quadArray = new double[quadList.size() * 8];
        double valy = 0.0;
        for (int i = 0; i < quadList.size(); ++i) {
            ASQuad currQuad = quadList.get(i);
            int index = i * 8;
            valy = currQuad.p4().y() - currQuad.p1().y();
            quadArray[index] = currQuad.p1().x();
            quadArray[index + 1] = currQuad.p1().y() + valy * 0.3;
            quadArray[index + 2] = currQuad.p2().x();
            quadArray[index + 3] = currQuad.p2().y() + valy * 0.3;
            quadArray[index + 4] = currQuad.p4().x();
            quadArray[index + 5] = currQuad.p4().y() - valy * 0.3;
            quadArray[index + 6] = currQuad.p3().x();
            quadArray[index + 7] = currQuad.p3().y() - valy * 0.3;
        }
        return quadArray;
    }

    public PDFDocument merge(String outputPDFFileName, PDFDocument mainPDF, Object source, String password, String page, boolean keepBookmark) {
        if (source instanceof String[]) {
            String[] sourceArray = (String[])source;
            for (int i = 0; i < sourceArray.length; ++i) {
                mainPDF = this.merge(mainPDF, sourceArray[i], password, page, keepBookmark, true);
            }
        } else {
            mainPDF = this.merge(mainPDF, source, password, page, keepBookmark, true);
        }
        try {
            PDFDocumentInfo documentInfo = mainPDF.getDocumentInfo();
            if (documentInfo == null) {
                documentInfo = PDFDocumentInfo.newInstance((PDFDocument)mainPDF);
                documentInfo.setCreationDate(new ASDate());
                documentInfo.setModificationDate(new ASDate());
                mainPDF.setDocumentInfo(documentInfo);
            }
            if (outputPDFFileName != null) {
                this.getPdfDocHandler().writeDocument(outputPDFFileName, mainPDF, (PDFSaveOptions)PDFSaveFullOptions.newInstance());
            }
        }
        catch (PDFInvalidDocumentException e) {
            if (source instanceof String) {
                throw new PDFException.PDFInvallidDocumentNameException("MERGE", (Throwable)e, (String)source, (Object)mainPDF);
            }
            throw new PDFException.PDFInvallidDocumentException("MERGE", (Throwable)e, (Object)mainPDF);
        }
        catch (PDFSecurityException pdfSex) {
            throw new PDFException.PDFUnAuthorisedOperationException("MERGE", (Throwable)pdfSex, (Object)mainPDF);
        }
        catch (PDFException pdfEx) {
            throw new PDFException.PDFOperationException("MERGE", (Throwable)pdfEx, (Object)mainPDF);
        }
        catch (IOException pdfEx) {
            throw new PDFException.PDFOperationException("MERGE", (Throwable)pdfEx, (Object)mainPDF);
        }
        return mainPDF;
    }

    public PDFDocument redactDoc(String outputPDFFileName, PDFDocument mainPDF, String password, boolean b) {
        RedactionOptions redactionOptions = new RedactionOptions(null);
        redactionOptions.setConsiderSpecialCharacter(true);
        try {
            RedactionProcessor redactionImpl = new RedactionProcessor(mainPDF, redactionOptions);
            redactionImpl.redactDocument();
            if (outputPDFFileName == null) {
                byte[] savedBytes = this.getPdfDocHandler().writeDocument(mainPDF, (PDFSaveOptions)PDFSaveFullOptions.newInstance());
                return this.getPdfDocHandler().readInternal(password, (Object)savedBytes, false, false);
            }
            this.getPdfDocHandler().writeDocument(outputPDFFileName, mainPDF, (PDFSaveOptions)PDFSaveFullOptions.newInstance());
        }
        catch (IOException pdfEx) {
            throw new PDFException.PDFOperationException("REDACT", (Throwable)pdfEx, (Object)mainPDF);
        }
        catch (PDFException pdfEx) {
            throw new PDFException.PDFOperationException("REDACT", (Throwable)pdfEx, (Object)mainPDF);
        }
        return mainPDF;
    }

    public PDFDocument attachDoc(String outputPDFFileName, Object source, String password, List<AttachmentObject> params, PageContext pageContext, boolean b) {
        File outtempFile = null;
        try {
            String value;
            String sourcename;
            boolean noDes = false;
            if (outputPDFFileName == null) {
                File tempFile = File.createTempFile("tmp", ".pdf");
                outputPDFFileName = tempFile.getAbsolutePath();
                noDes = true;
            }
            if (source instanceof PDFDocWrapper) {
                outtempFile = File.createTempFile("outtmp", ".pdf");
                sourcename = outtempFile.getAbsolutePath();
                PDFDocWrapper deepCopypdfdoc = PDFDocWrapper.deepCopy((PDFDocWrapper)source, password);
                this.getPdfDocHandler().writeDocument(sourcename, deepCopypdfdoc.getDoc(), null);
            } else {
                sourcename = source.toString();
            }
            int counter = 0;
            Struct InputFilesPath = new Struct();
            InputFilesPath.put((Object)INPUTFILE, (Object)sourcename);
            String ddx = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<DDX xmlns=\"http://ns.adobe.com/DDX/1.0/\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://ns.adobe.com/DDX/1.0/ coldfusion_ddx.xsd\">\r\n";
            StringBuilder ddxString = new StringBuilder(ddx);
            ddxString.append("<PDF result=\"");
            ddxString.append(OUTPUTFILE);
            ddxString.append("\">\r\n");
            for (AttachmentObject object : params) {
                String filename;
                String attachfile = "attach" + counter;
                ddxString.append("<FileAttachments source=\"");
                ddxString.append(attachfile);
                ddxString.append("\" >\r\n<File filename=\"");
                if (object.getFilename() == null) {
                    File f = new File(object.getSource());
                    filename = f.getName();
                } else {
                    filename = object.getFilename();
                }
                ddxString.append(filename);
                ddxString.append("\" mimetype=\"");
                ddxString.append(object.getMimetype());
                ddxString.append("\"/>\r\n<FilenameEncoding encoding=\"");
                ddxString.append(object.getEncoding());
                ddxString.append("\"/>\r\n<Description>");
                ddxString.append(object.getDescription());
                ddxString.append("</Description>\r\n</FileAttachments>\r\n");
                InputFilesPath.put((Object)attachfile, (Object)object.getSource());
                ++counter;
            }
            ddxString.append("<PDF source=\"");
            ddxString.append(INPUTFILE);
            ddxString.append("\" access=\"deptA\"/>\r\n</PDF>\r\n<PasswordAccessProfile name=\"deptA\">\r\n<Password>");
            ddxString.append(password);
            ddxString.append("</Password>\r\n</PasswordAccessProfile>\r\n</DDX>");
            Struct OutputFiles = new Struct();
            OutputFiles.put((Object)OUTPUTFILE, (Object)outputPDFFileName);
            Struct result = this.processDDX(ddxString.toString(), InputFilesPath, OutputFiles, pageContext);
            if (result.containsKey((Object)OUTPUTFILE) && (value = result.get((Object)OUTPUTFILE).toString()).contains("PDFM_S00011")) {
                throw new PDFException.PDFIncorrectPasswordException("ADDATTACHMENTS", null);
            }
            PDFDocument mainPDF = this.getPdfDocHandler().readInternal(password, (Object)outputPDFFileName, false, false);
            if (noDes) {
                PDFDocument pDFDocument = this.readFile(outputPDFFileName, password);
                return pDFDocument;
            }
        }
        catch (IOException pdfEx) {
            throw new PDFException.PDFOperationException("ADDATTACHMENTS", (Throwable)pdfEx);
        }
        catch (PDFException pdfEx) {
            throw new PDFException.PDFOperationException("ADDATTACHMENTS", (Throwable)pdfEx);
        }
        finally {
            if (outtempFile != null) {
                outtempFile.delete();
            }
        }
        return null;
    }

    public static boolean validateArchive(String fileName, String standard) {
        try {
            ByteReader reader = PDFDocUtil.getRAFByteReader(fileName);
            PDFDocument doc = PDFDocument.newInstance((ByteReader)reader, (PDFOpenOptions)PDFOpenOptions.newInstance());
            if ("2b".equalsIgnoreCase(standard)) {
                SamplePDFA2ValidationHandler validationHandler = new SamplePDFA2ValidationHandler();
                PDFA2Service.validate((PDFDocument)doc, (PDFA2ConformanceLevel)PDFA2ConformanceLevel.Level_2b, (PDFA2ValidationOptions)new PDFA2ValidationOptions(), (PDFA2ValidationHandler)validationHandler);
                if (!validationHandler.errorsFound()) {
                    return true;
                }
            } else if ("3b".equalsIgnoreCase(standard)) {
                SamplePDFA2ValidationHandler handler = new SamplePDFA2ValidationHandler();
                PDFA3Service.validate((PDFDocument)doc, (PDFA2ConformanceLevel)PDFA2ConformanceLevel.Level_3b, (PDFA2ValidationOptions)new PDFA2ValidationOptions(), (PDFA2ValidationHandler)handler);
                if (!handler.errorsFound()) {
                    return true;
                }
            }
        }
        catch (PDFInvalidDocumentException pDFInvalidDocumentException) {
        }
        catch (PDFException pDFException) {
            // empty catch block
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PDFDocument importComment(Object source, String importFrom, String outputPDFFileName, String password, boolean stopOnError, PageContext pageContext) {
        File outtempFile = null;
        try {
            String value;
            String sourcename;
            boolean noDest = false;
            if (outputPDFFileName == null) {
                File tempFile = File.createTempFile("tmp", ".pdf");
                outputPDFFileName = tempFile.getAbsolutePath();
                noDest = true;
            }
            if (source instanceof PDFDocWrapper) {
                outtempFile = File.createTempFile("outtmp", ".pdf");
                sourcename = outtempFile.getAbsolutePath();
                PDFDocWrapper deepCopypdfdoc = PDFDocWrapper.deepCopy((PDFDocWrapper)source, password);
                this.getPdfDocHandler().writeDocument(sourcename, deepCopypdfdoc.getDoc(), null);
            } else {
                sourcename = source.toString();
            }
            String ddx = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<DDX xmlns=\"http://ns.adobe.com/DDX/1.0/\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://ns.adobe.com/DDX/1.0/ coldfusion_ddx.xsd\">\r\n";
            StringBuilder ddxString = new StringBuilder(ddx);
            ddxString.append("<PDF result=\"");
            ddxString.append(OUTPUTFILE);
            ddxString.append("\">\r\n<PDF source=\"");
            ddxString.append(INPUTFILE);
            ddxString.append("\" access=\"deptA\"/>\r\n<Comments source=\"");
            ddxString.append(EXTRAFILE);
            ddxString.append("\"/>\r\n</PDF>\r\n<PasswordAccessProfile name=\"deptA\">\r\n<Password>");
            ddxString.append(password);
            ddxString.append("</Password>\r\n</PasswordAccessProfile>\r\n<PasswordEncryptionProfile name=\"userprotect\">\r\n<OpenPassword>");
            ddxString.append(password);
            ddxString.append("</OpenPassword>\r\n</PasswordEncryptionProfile>\r\n</DDX>");
            Struct InputFilesPath = new Struct();
            InputFilesPath.put((Object)INPUTFILE, (Object)sourcename);
            InputFilesPath.put((Object)EXTRAFILE, (Object)importFrom);
            Struct OutputFiles = new Struct();
            OutputFiles.put((Object)OUTPUTFILE, (Object)outputPDFFileName);
            Struct result = this.processDDX(ddxString.toString(), InputFilesPath, OutputFiles, pageContext);
            if (result.containsKey((Object)OUTPUTFILE) && (value = result.get((Object)OUTPUTFILE).toString()).contains("PDFM_S00011")) {
                throw new PDFException.PDFIncorrectPasswordException("IMPORT", null);
            }
            if (noDest) {
                PDFDocument pDFDocument = this.readFile(outputPDFFileName, password);
                return pDFDocument;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
        }
        catch (PDFException pDFException) {
        }
        finally {
            if (outtempFile != null) {
                outtempFile.delete();
            }
        }
        return null;
    }

    public PDFDocument readFile(String outputPDFFileName, String password) throws FileNotFoundException, IOException, PDFException {
        File del = new File(outputPDFFileName);
        byte[] savedBytes = new byte[(int)del.length()];
        FileInputStream stream = new FileInputStream(del);
        stream.read(savedBytes);
        stream.close();
        del.delete();
        return this.getPdfDocHandler().readInternal(password, (Object)savedBytes, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PDFDocument importMetadata(Object source, String importFrom, String outputPDFFileName, String password, boolean stopOnError, PageContext pageContext) {
        File outtempFile = null;
        try {
            String value;
            String sourcename;
            boolean noDest = false;
            if (outputPDFFileName == null) {
                File tempFile = File.createTempFile("tmp", ".pdf");
                outputPDFFileName = tempFile.getAbsolutePath();
                noDest = true;
            }
            if (source instanceof PDFDocWrapper) {
                outtempFile = File.createTempFile("outtmp", ".pdf");
                sourcename = outtempFile.getAbsolutePath();
                PDFDocWrapper deepCopypdfdoc = PDFDocWrapper.deepCopy((PDFDocWrapper)source, password);
                this.getPdfDocHandler().writeDocument(sourcename, deepCopypdfdoc.getDoc(), null);
            } else {
                sourcename = source.toString();
            }
            String ddx = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<DDX xmlns=\"http://ns.adobe.com/DDX/1.0/\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://ns.adobe.com/DDX/1.0/ coldfusion_ddx.xsd\">\r\n";
            StringBuilder ddxString = new StringBuilder(ddx);
            ddxString.append("<PDF result=\"");
            ddxString.append(OUTPUTFILE);
            ddxString.append("\">\r\n<Metadata source=\"");
            ddxString.append(INPUTFILE);
            ddxString.append("\"/>\r\n<PDF source=\"");
            ddxString.append(EXTRAFILE);
            ddxString.append("\" access=\"deptA\"/>\r\n</PDF>\r\n<PasswordAccessProfile name=\"deptA\">\r\n<Password>");
            ddxString.append(password);
            ddxString.append("</Password>\r\n</PasswordAccessProfile>\r\n</DDX>");
            Struct InputFilesPath = new Struct();
            InputFilesPath.put((Object)INPUTFILE, (Object)importFrom);
            InputFilesPath.put((Object)EXTRAFILE, (Object)sourcename);
            Struct OutputFiles = new Struct();
            OutputFiles.put((Object)OUTPUTFILE, (Object)outputPDFFileName);
            Struct result = this.processDDX(ddxString.toString(), InputFilesPath, OutputFiles, pageContext);
            if (result.containsKey((Object)OUTPUTFILE) && (value = result.get((Object)OUTPUTFILE).toString()).contains("PDFM_S00011")) {
                throw new PDFException.PDFIncorrectPasswordException("IMPORT", null);
            }
            if (noDest) {
                PDFDocument pDFDocument = this.readFile(outputPDFFileName, password);
                return pDFDocument;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
        }
        catch (PDFException pDFException) {
        }
        finally {
            if (outtempFile != null) {
                outtempFile.delete();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PDFDocument exportComment(Object source, String exportTo, String password, boolean stopOnError, PageContext pageContext) {
        File outtempFile = null;
        try {
            String value;
            String sourcename;
            if (source instanceof PDFDocWrapper) {
                outtempFile = File.createTempFile("outtmp", ".pdf");
                sourcename = outtempFile.getAbsolutePath();
                PDFDocWrapper deepCopypdfdoc = PDFDocWrapper.deepCopy((PDFDocWrapper)source, password);
                this.getPdfDocHandler().writeDocument(sourcename, deepCopypdfdoc.getDoc(), null);
            } else {
                sourcename = source.toString();
            }
            String ddx = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<DDX xmlns=\"http://ns.adobe.com/DDX/1.0/\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://ns.adobe.com/DDX/1.0/ coldfusion_ddx.xsd\">\r\n";
            StringBuilder ddxString = new StringBuilder(ddx);
            ddxString.append("<Comments result=\"");
            ddxString.append(OUTPUTFILE);
            ddxString.append("\" format=\"XFDF\">\r\n<PDF source=\"");
            ddxString.append(INPUTFILE);
            ddxString.append("\" access=\"deptA\"/>\r\n</Comments>\r\n<PasswordAccessProfile name=\"deptA\">\r\n<Password>");
            ddxString.append(password);
            ddxString.append("</Password>\r\n</PasswordAccessProfile>\r\n</DDX>");
            Struct InputFilesPath = new Struct();
            InputFilesPath.put((Object)INPUTFILE, (Object)sourcename);
            Struct OutputFiles = new Struct();
            OutputFiles.put((Object)OUTPUTFILE, (Object)exportTo);
            Struct result = this.processDDX(ddxString.toString(), InputFilesPath, OutputFiles, pageContext);
            if (result.containsKey((Object)OUTPUTFILE) && (value = result.get((Object)OUTPUTFILE).toString()).contains("PDFM_S00011")) {
                throw new PDFException.PDFIncorrectPasswordException("EXPORT", null);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
        }
        catch (PDFException pDFException) {
        }
        finally {
            if (outtempFile != null) {
                outtempFile.delete();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PDFDocument exportMetadata(Object source, String exportTo, String password, boolean stopOnError, PageContext pageContext) {
        File outtempFile = null;
        try {
            String value;
            String sourcename;
            if (source instanceof PDFDocWrapper) {
                outtempFile = File.createTempFile("outtmp", ".pdf");
                sourcename = outtempFile.getAbsolutePath();
                PDFDocWrapper deepCopypdfdoc = PDFDocWrapper.deepCopy((PDFDocWrapper)source, password);
                this.getPdfDocHandler().writeDocument(sourcename, deepCopypdfdoc.getDoc(), null);
            } else {
                sourcename = source.toString();
            }
            String ddx = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<DDX xmlns=\"http://ns.adobe.com/DDX/1.0/\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://ns.adobe.com/DDX/1.0/ coldfusion_ddx.xsd\">\r\n<Metadata result=\"";
            StringBuilder ddxString = new StringBuilder(ddx);
            ddxString.append(OUTPUTFILE);
            ddxString.append("\">\r\n<PDF source=\"");
            ddxString.append(INPUTFILE);
            ddxString.append("\" access=\"deptA\"/>\r\n</Metadata>\r\n<PasswordAccessProfile name=\"deptA\">\r\n<Password>");
            ddxString.append(password);
            ddxString.append("</Password>\r\n</PasswordAccessProfile>\r\n</DDX>");
            Struct InputFilesPath = new Struct();
            InputFilesPath.put((Object)INPUTFILE, (Object)sourcename);
            Struct OutputFiles = new Struct();
            OutputFiles.put((Object)OUTPUTFILE, (Object)exportTo);
            Struct result = this.processDDX(ddxString.toString(), InputFilesPath, OutputFiles, pageContext);
            if (result.containsKey((Object)OUTPUTFILE) && (value = result.get((Object)OUTPUTFILE).toString()).contains("PDFM_S00011")) {
                throw new PDFException.PDFIncorrectPasswordException("EXPORT", null);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
        }
        catch (PDFException pDFException) {
        }
        finally {
            if (outtempFile != null) {
                outtempFile.delete();
            }
        }
        return null;
    }

    public Struct getAttachments(Object source, String destination, String nameKeys, String extract, String encoding, PageContext pageContext) {
        Struct fileNameList = new Struct();
        try {
            String ddx = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<DDX xmlns=\"http://ns.adobe.com/DDX/1.0/\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://ns.adobe.com/DDX/1.0/ coldfusion_ddx.xsd\">\r\n<FileAttachments result=\"Out1\" nameKeys=\"" + nameKeys + "\" extract=\"" + extract + "\">\r\n<PDF source=\"In1\"/>\r\n<FilenameEncoding encoding=\"" + encoding + "\"/>\r\n</FileAttachments>\r\n</DDX>";
            Struct InputFilesPath = new Struct();
            InputFilesPath.put((Object)"In1", (Object)source.toString());
            Struct OutputFiles = new Struct();
            OutputFiles.put((Object)"Out1", (Object)destination);
            this.processDDX(ddx, InputFilesPath, OutputFiles, pageContext);
            Path path = Paths.get(destination, new String[0]);
            Charset charset = StandardCharsets.UTF_8;
            String content = new String(Files.readAllBytes(path), charset);
            content = content.replaceAll("UTF-16", "UTF-8");
            Files.write(path, content.getBytes(charset), new OpenOption[0]);
            File res = new File(destination);
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            org.w3c.dom.Document document = builder.parse(res);
            document.getDocumentElement().normalize();
            NodeList nList = document.getElementsByTagName("Attachment");
            NodeList fileList = document.getElementsByTagName("File");
            for (int temp = 0; temp < nList.getLength(); ++temp) {
                Node node = nList.item(temp);
                Node nodeFile = fileList.item(temp);
                if (node.getNodeType() != 1 || nodeFile.getNodeType() != 1) continue;
                Element eElement = (Element)node;
                Element eFile = (Element)nodeFile;
                fileNameList.put((Object)("filename" + temp), (Object)eFile.getElementsByTagName("Filename").item(0).getTextContent());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return fileNameList;
    }

    public PDFDocument sanitize(String outputPDFFileName, Object source, String password, boolean stopOnError) {
        PDFDocument pdfDocument = null;
        ByteWriter writer = null;
        try {
            boolean noDes = false;
            if (outputPDFFileName == null) {
                File tempFile = File.createTempFile("tmp", ".pdf");
                outputPDFFileName = tempFile.getAbsolutePath();
                noDes = true;
            }
            pdfDocument = this.getPdfDocHandler().readInternal(password, source, false, false);
            if (!this.getPdfDocHandler().getPdfDocSecurityHandler().isActionAllowed(pdfDocument, ObjectOperations.DOC_OPEN)) {
                throw new PDFException.PDFUnAuthorisedOperationException("SANITIZE", (Object)pdfDocument);
            }
            if (pdfDocument.requireCatalog().getCollection() != null) {
                throw new PDFException.PDFSanitizeException("collections");
            }
            this.checkDigitalSignature(pdfDocument);
            writer = PDFDocUtil.getRAFByteWriter(outputPDFFileName);
            this.checkXFAContent(pdfDocument);
            PDFSaveLinearOptions saveOptions = PDFSaveLinearOptions.newInstance();
            saveOptions.setForceCompress(true);
            SanitizationOptions options = this.setOptions((PDFSaveOptions)saveOptions);
            SanitizationService.sanitizeDocument((PDFDocument)pdfDocument, (SanitizationOptions)options, (ByteWriter)writer);
            if (noDes) {
                PDFDocument pDFDocument = this.readFile(outputPDFFileName, password);
                return pDFDocument;
            }
        }
        catch (PDFException pdfEx) {
            throw new PDFException.PDFOperationException("SANITIZE", (Throwable)pdfEx, pdfDocument);
        }
        catch (IOException pdfEx) {
            throw new PDFException.PDFOperationException("SANITIZE", (Throwable)pdfEx, pdfDocument);
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
                if (pdfDocument != null) {
                    pdfDocument.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (PDFInvalidDocumentException e) {
                e.printStackTrace();
            }
            catch (PDFIOException e) {
                e.printStackTrace();
            }
            catch (PDFSecurityException e) {
                e.printStackTrace();
            }
            catch (PDFUnableToCompleteOperationException e) {
                e.printStackTrace();
            }
        }
        return pdfDocument;
    }

    private SanitizationOptions setOptions(PDFSaveOptions saveOptions) throws PDFFontException {
        SanitizationOptions options = new SanitizationOptions();
        options.setPDFFontSet((PDFFontSet)ServiceFactory.getDocumentService().getAssemblerFontSet());
        options.setSaveOptions(saveOptions);
        return options;
    }

    private void checkXFAContent(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFFontException, PDFConfigurationException, PDFInvalidParameterException {
        PDFInteractiveForm acroform = pdfDocument.requireCatalog().getInteractiveForm();
        if (acroform != null) {
            if (acroform.hasXFA()) {
                throw new PDFException.PDFSanitizeException("XFA");
            }
            if (acroform.getNeedAppearances()) {
                AppearanceService.generateAppearances((PDFDocument)pdfDocument, null, null);
            }
        }
    }

    private void checkDigitalSignature(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        SignatureManager sigMgr = SignatureManager.newInstance((PDFDocument)pdfDocument);
        if (sigMgr.hasSignedSignatureFields() || sigMgr.hasUsageRights()) {
            throw new PDFException.PDFSanitizeException("digital");
        }
    }

    public PDFDocument merge(String outputPDFFileName, PDFDocument mainPDF, File directory, String order, boolean ascending, String password, boolean keepBookmark, boolean stopOnError, String page) {
        block10: {
            File[] fileList = directory.listFiles();
            if (fileList.length == 0) {
                throw new PDFException.PDFEmptyDirectoryException(directory.getAbsolutePath());
            }
            this.sortFile(order, fileList, ascending);
            for (int i = 0; i < fileList.length; ++i) {
                if (!fileList[i].isFile()) continue;
                mainPDF = this.merge(mainPDF, fileList[i].getPath(), password, page, keepBookmark, stopOnError);
            }
            try {
                if (mainPDF != null) {
                    PDFDocumentInfo documentInfo = mainPDF.getDocumentInfo();
                    if (documentInfo == null) {
                        documentInfo = PDFDocumentInfo.newInstance((PDFDocument)mainPDF);
                        documentInfo.setCreationDate(new ASDate());
                        documentInfo.setModificationDate(new ASDate());
                        mainPDF.setDocumentInfo(documentInfo);
                    }
                    if (outputPDFFileName != null) {
                        this.getPdfDocHandler().writeDocument(outputPDFFileName, mainPDF, (PDFSaveOptions)PDFSaveFullOptions.newInstance());
                    }
                    break block10;
                }
                throw new PDFException.PDFInvallidDocumentException("MERGE", (Object)mainPDF);
            }
            catch (PDFInvalidDocumentException e) {
                throw new PDFException.PDFInvallidDocumentException("MERGE", (Throwable)e, (Object)mainPDF);
            }
            catch (PDFSecurityException pdfSex) {
                throw new PDFException.PDFUnAuthorisedOperationException("MERGE", (Throwable)pdfSex, (Object)mainPDF);
            }
            catch (PDFException pdfEx) {
                throw new PDFException.PDFOperationException("MERGE", (Throwable)pdfEx, (Object)mainPDF);
            }
            catch (IOException pdfEx) {
                throw new PDFException.PDFOperationException("MERGE", (Throwable)pdfEx, (Object)mainPDF);
            }
        }
        return mainPDF;
    }

    public PDFDocument merge(List pdfs, String outputPDFFileName) {
        PDFDocument collection = null;
        try {
            if (pdfs == null) {
                throw new PDFException.PDFNoSourceException("MERGE");
            }
            collection = this.getPdfDocHandler().createPortfolio(pdfs, outputPDFFileName);
            if (outputPDFFileName != null) {
                this.getPdfDocHandler().writeDocument(outputPDFFileName, collection, (PDFSaveOptions)PDFSaveFullOptions.newInstance());
            }
        }
        catch (PDFInvalidDocumentException e) {
            throw new PDFException.PDFInvallidDocumentException("MERGE", (Throwable)e, (Object)collection);
        }
        catch (PDFSecurityException pdfSex) {
            throw new PDFException.PDFUnAuthorisedOperationException("MERGE", (Throwable)pdfSex, (Object)collection);
        }
        catch (PDFException pdfEx) {
            throw new PDFException.PDFOperationException("MERGE", (Throwable)pdfEx, (Object)collection);
        }
        catch (IOException pdfEx) {
            throw new PDFException.PDFOperationException("MERGE", (Throwable)pdfEx, (Object)collection);
        }
        return collection;
    }

    private void sortFile(String order, File[] fileList, boolean ascending) {
        if ("TIME".equalsIgnoreCase(order)) {
            for (int i = 0; i < fileList.length; ++i) {
                for (int j = i + 1; j < fileList.length; ++j) {
                    File tempFile;
                    if (ascending) {
                        if (fileList[j].lastModified() >= fileList[i].lastModified()) continue;
                        tempFile = fileList[j];
                        fileList[j] = fileList[i];
                        fileList[i] = tempFile;
                        continue;
                    }
                    if (fileList[j].lastModified() <= fileList[i].lastModified()) continue;
                    tempFile = fileList[j];
                    fileList[j] = fileList[i];
                    fileList[i] = tempFile;
                }
            }
        } else {
            Arrays.sort(fileList);
            if (!ascending) {
                Collections.reverse(Arrays.asList(fileList));
            }
        }
    }

    public Struct getInfo(Object source, String password, boolean fromWrapper) {
        PDFDocument pdfDocument = null;
        try {
            StandardEncryptionPermissions encryptPerms;
            pdfDocument = this.getPdfDocHandler().readInternal(password, source, false, true);
            Struct result = new Struct();
            PDFDocumentInfo documentInfo = pdfDocument.getDocumentInfo();
            PDFCatalog catalog = pdfDocument.requireCatalog();
            PDFViewerPreferences pref = pdfDocument.getViewerPreferences();
            StandardEncryptionPermissions standardEncryptionPermissions = encryptPerms = pdfDocument.isEncrypted() ? StandardEncryptionPermissions.newInstance((PermissionProvider)PermissionsManager.newInstance((PDFDocument)pdfDocument).getPermissionProvider("Security")) : StandardEncryptionPermissions.newInstanceAll();
            if (source instanceof String) {
                result.put((Object)"FilePath", source);
            } else {
                result.put((Object)"FilePath", (Object)"");
            }
            boolean nullDocInfo = false;
            if (documentInfo == null) {
                nullDocInfo = true;
            }
            result.put((Object)"Title", (Object)(nullDocInfo || documentInfo.getTitle() == null ? "" : documentInfo.getTitle()));
            result.put((Object)"Author", (Object)(nullDocInfo || documentInfo.getAuthor() == null ? "" : documentInfo.getAuthor()));
            result.put((Object)"Subject", (Object)(nullDocInfo || documentInfo.getSubject() == null ? "" : documentInfo.getSubject()));
            result.put((Object)"Keywords", (Object)(nullDocInfo || documentInfo.getKeywords() == null ? "" : documentInfo.getKeywords()));
            result.put((Object)"Created", (Object)(nullDocInfo || documentInfo.getCreationDate() == null ? "" : documentInfo.getCreationDate().toString()));
            result.put((Object)"Modified", (Object)(nullDocInfo || documentInfo.getModificationDate() == null ? "" : documentInfo.getModificationDate().toString()));
            result.put((Object)"Application", (Object)(nullDocInfo || documentInfo.getCreator() == null ? "" : documentInfo.getCreator()));
            result.put((Object)"Producer", (Object)(nullDocInfo || documentInfo.getProducer() == null ? "" : documentInfo.getProducer()));
            result.put((Object)"Properties", (Object)(nullDocInfo || documentInfo.getCustomProperties() == null ? "" : this.getPdfProperties(documentInfo)));
            result.put((Object)"Trapped", (Object)(nullDocInfo || documentInfo.getTrapped() == null ? "" : documentInfo.getTrapped()));
            result.put((Object)"Version", (Object)(pdfDocument.getOriginalVersion() == null ? "" : pdfDocument.getOriginalVersion().toString()));
            if (pref != null) {
                result.put((Object)"ShowDocumentsOption", (Object)pref.getPageMode().toString());
                result.put((Object)"FitToWindow", (Object)(pref.getFitWindow() ? "yes" : "no"));
                result.put((Object)"HideMenubar", (Object)(pref.getHideMenubar() ? "yes" : "no"));
                result.put((Object)"HideToolbar", (Object)(pref.getHideToolbar() ? "yes" : "no"));
                result.put((Object)"HideWindowUI", (Object)(pref.getHideWindowUI() ? "yes" : "no"));
                result.put((Object)"ShowWindowsOption", (Object)(pref.getDisplayDocTitle() ? "Docuent Title" : "File Name"));
                result.put((Object)"CenterWindowOnScreen", (Object)(pref.getCenterWindow() ? "yes" : "no"));
            } else {
                result.put((Object)"ShowDocumentsOption", (Object)"");
                result.put((Object)"FitToWindow", (Object)"");
                result.put((Object)"HideMenubar", (Object)"");
                result.put((Object)"HideToolbar", (Object)"");
                result.put((Object)"HideWindowUI", (Object)"");
                result.put((Object)"ShowWindowsOption", (Object)"");
                result.put((Object)"CenterWindowOnScreen", (Object)"");
            }
            result.put((Object)"TotalPages", (Object)new Integer(pdfDocument.requirePages().getNumPages()));
            PDFEncryptionType encryption = pdfDocument.getEncryptionType();
            String strEncryptType = "No Security";
            if (encryption == PDFEncryptionType.Password) {
                strEncryptType = "Password Security";
            } else if (encryption == PDFEncryptionType.PKI) {
                strEncryptType = "Certificate Security";
            } else if (encryption == PDFEncryptionType.Other) {
                strEncryptType = "Adobe Policy Server";
            }
            result.put((Object)"Encryption", (Object)strEncryptType);
            result.put((Object)"Printing", (Object)(encryptPerms.mayPrintLow() ? "Allowed" : "Not Allowed"));
            result.put((Object)"ChangingDocument", (Object)(encryptPerms.mayModify() ? "Allowed" : "Not Allowed"));
            result.put((Object)"DocumentAssembly", (Object)(encryptPerms.mayAssemble() ? "Allowed" : "Not Allowed"));
            result.put((Object)"CopyContent", (Object)(encryptPerms.mayCopy() ? "Allowed" : "Not Allowed"));
            result.put((Object)"ContentExtraction", (Object)(encryptPerms.mayExtract() ? "Allowed" : "Not Allowed"));
            result.put((Object)"Commenting", (Object)(encryptPerms.mayAdd() ? "Allowed" : "Not Allowed"));
            result.put((Object)"FillingForm", (Object)(encryptPerms.mayFill() ? "Allowed" : "Not Allowed"));
            result.put((Object)"Secure", (Object)(encryptPerms.maySecure() ? "Allowed" : "Not Allowed"));
            result.put((Object)"Signing", (Object)(this.getPdfDocHandler().getPdfDocSecurityHandler().isActionAllowed(pdfDocument, ObjectOperations.SIGNATURE_FILLIN) ? "Allowed" : "Not Allowed"));
            result.put((Object)"Language", (Object)(catalog.getLang() == null ? "" : catalog.getLang()));
            result.put((Object)"PageLayout", (Object)(catalog.getPageLayout() == null ? "" : catalog.getPageLayout().getName().asString()));
            ArrayList<Struct> pagesizeList = new ArrayList<Struct>();
            ArrayList<Integer> rotationList = new ArrayList<Integer>();
            for (PDFPage sourcePage : pdfDocument.requirePages()) {
                PDFRectangle cropbox = sourcePage.getCropBox();
                Struct pageSize = new Struct();
                pageSize.put((Object)"height", (Object)Math.abs(cropbox.getValues()[3] - cropbox.getValues()[1]));
                pageSize.put((Object)"width", (Object)Math.abs(cropbox.getValues()[2] - cropbox.getValues()[0]));
                pagesizeList.add(pageSize);
                rotationList.add(sourcePage.getRotation().getValue());
            }
            result.put((Object)"PageSizes", pagesizeList);
            result.put((Object)"PageRotations", rotationList);
            Struct struct = result;
            return struct;
        }
        catch (PDFParseException pdfEx) {
            throw new PDFException.PDFOperationException("GETINFO", (Throwable)pdfEx);
        }
        catch (PDFInvalidDocumentException e) {
            if (source instanceof String) {
                throw new PDFException.PDFInvallidDocumentNameException("GETINFO", (Throwable)e, (String)source);
            }
            throw new PDFException.PDFInvallidDocumentException("GETINFO", (Throwable)e);
        }
        catch (PDFSecurityException pdfSex) {
            throw new PDFException.PDFUnAuthorisedOperationException("GETINFO", (Throwable)pdfSex);
        }
        catch (PDFException pdfEx) {
            throw new PDFException.PDFOperationException("GETINFO", (Throwable)pdfEx);
        }
        catch (IOException pdfEx) {
            throw new PDFException.PDFOperationException("GETINFO", (Throwable)pdfEx);
        }
        finally {
            if (source instanceof String && pdfDocument != null && !fromWrapper) {
                try {
                    pdfDocument.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private Struct getPdfProperties(PDFDocumentInfo documentInfo) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        Struct struct = new Struct();
        List customProperties = documentInfo.getCustomProperties();
        if (customProperties != null) {
            for (String[] customproperty : customProperties) {
                struct.put((Object)customproperty[0], (Object)customproperty[1]);
            }
        }
        return struct;
    }

    public PDFDocument setInfo(String outputPDFFileName, Object source, String password, Struct infoStruct) {
        PDFDocument pdfDocument = null;
        try {
            Struct customProperties;
            boolean useRaf = false;
            if (source instanceof String && ((String)source).equalsIgnoreCase(outputPDFFileName)) {
                useRaf = true;
            }
            pdfDocument = this.getPdfDocHandler().readInternal(password, source, false, useRaf);
            if (!this.getPdfDocHandler().getPdfDocSecurityHandler().isActionAllowed(pdfDocument, ObjectOperations.DOC_MODIFY)) {
                throw new PDFException.PDFUnAuthorisedOperationException("SETINFO", (Object)pdfDocument);
            }
            PDFDocumentInfo documentInfo = pdfDocument.getDocumentInfo();
            if (documentInfo == null) {
                documentInfo = PDFDocumentInfo.newInstance((PDFDocument)pdfDocument);
            }
            String title = (String)infoStruct.get((Object)"Title");
            String author = (String)infoStruct.get((Object)"Author");
            String subject = (String)infoStruct.get((Object)"Subject");
            String keywords = (String)infoStruct.get((Object)"Keywords");
            String created = (String)infoStruct.get((Object)"Created");
            String modified = (String)infoStruct.get((Object)"Modified");
            String trapped = (String)infoStruct.get((Object)"Trapped");
            DocumentMetadata md = XMPService.getDocumentMetadata((PDFDocument)pdfDocument);
            if (title != null && !"".equals(title)) {
                md.setTitle(title);
            }
            if (author != null && !"".equals(author)) {
                md.setAuthor(author);
            }
            if (subject != null && !"".equals(subject)) {
                md.setSubject(subject);
            }
            if (keywords != null && !"".equals(keywords)) {
                md.setKeywords(keywords);
            }
            if (created != null && !"".equals(created)) {
                md.setCreationDate(new ASDate(created));
            }
            if (modified != null && !"".equals(modified)) {
                md.setModificationDate(new ASDate(modified));
            }
            if (trapped != null && !"".equals(trapped)) {
                md.setTrapped(trapped);
            }
            if ((customProperties = (Struct)infoStruct.get((Object)"CustomProperties")) != null) {
                Set keySet = customProperties.keySet();
                for (String key : keySet) {
                    md.addCustomProperty(key, (String)customProperties.get((Object)key));
                }
            }
            md.commit();
            if (outputPDFFileName == null) {
                byte[] savedBytes = this.getPdfDocHandler().writeDocument(pdfDocument, (PDFSaveOptions)PDFSaveFullOptions.newInstance());
                return this.getPdfDocHandler().readInternal(password, (Object)savedBytes, false, false);
            }
            this.getPdfDocHandler().writeDocument(outputPDFFileName, pdfDocument, (PDFSaveOptions)PDFSaveFullOptions.newInstance());
        }
        catch (PDFParseException cpe) {
            throw new PDFException.PDFSetInfoInvalidModException("SETINFO", (Throwable)cpe, pdfDocument);
        }
        catch (PDFInvalidDocumentException e) {
            if (source instanceof String) {
                throw new PDFException.PDFInvallidDocumentNameException("SETINFO", (Throwable)e, (String)source, (Object)pdfDocument);
            }
            throw new PDFException.PDFInvallidDocumentException("SETINFO", (Throwable)e, pdfDocument);
        }
        catch (PDFSecurityException pdfSex) {
            throw new PDFException.PDFUnAuthorisedOperationException("SETINFO", (Throwable)pdfSex, pdfDocument);
        }
        catch (PDFException pdfEx) {
            throw new PDFException.PDFOperationException("SETINFO", (Throwable)pdfEx, pdfDocument);
        }
        catch (IOException pdfEx) {
            throw new PDFException.PDFOperationException("SETINFO", (Throwable)pdfEx, pdfDocument);
        }
        return null;
    }

    public String extractText(Object source, String password, String page, String type, boolean addQuads, boolean honourSpaces, boolean useStructure, String charset) {
        PDFDocument pdfDocument = null;
        try {
            pdfDocument = this.getPdfDocHandler().readInternal(password, source, false, false);
            if (!this.getPdfDocHandler().getPdfDocSecurityHandler().isActionAllowed(pdfDocument, ObjectOperations.DOC_EXPORT)) {
                throw new PDFException.PDFUnAuthorisedOperationException("EXTRACTTEXT", (Object)pdfDocument);
            }
            return this.getPdfDocHandler().extractText(pdfDocument, page, type, addQuads, honourSpaces, useStructure, charset);
        }
        catch (PDFInvalidDocumentException e) {
            if (source instanceof String) {
                throw new PDFException.PDFInvallidDocumentNameException("EXTRACTTEXT", (Throwable)e, (String)source, (Object)pdfDocument);
            }
            throw new PDFException.PDFInvallidDocumentException("EXTRACTTEXT", (Throwable)e, (Object)pdfDocument);
        }
        catch (PDFSecurityException pdfSex) {
            throw new PDFException.PDFUnAuthorisedOperationException("EXTRACTTEXT", (Throwable)pdfSex, (Object)pdfDocument);
        }
        catch (PDFException pdfEx) {
            throw new PDFException.PDFOperationException("EXTRACTTEXT", (Throwable)pdfEx, (Object)pdfDocument);
        }
        catch (IOException pdfEx) {
            throw new PDFException.PDFOperationException("EXTRACTTEXT", (Throwable)pdfEx, (Object)pdfDocument);
        }
    }

    public PDFDocument removeHFW(String outputPDFFileName, Object source, String password, String page, boolean stopOnError, String type) {
        PDFDocument pdfDocument = null;
        try {
            boolean useRaf = false;
            if (source instanceof String && ((String)source).equalsIgnoreCase(outputPDFFileName)) {
                useRaf = true;
            }
            pdfDocument = this.getPdfDocHandler().readInternal(password, source, false, useRaf);
            if (!this.getPdfDocHandler().getPdfDocSecurityHandler().isActionAllowed(pdfDocument, ObjectOperations.PAGE_MODIFY)) {
                throw new PDFException.PDFUnAuthorisedOperationException(type, (Object)pdfDocument);
            }
            this.getPdfDocHandler().removeHFW(pdfDocument, page, stopOnError, type);
            if (outputPDFFileName != null) {
                this.getPdfDocHandler().writeDocument(outputPDFFileName, pdfDocument, (PDFSaveOptions)PDFSaveFullOptions.newInstance());
            }
            return pdfDocument;
        }
        catch (PDFInvalidDocumentException e) {
            if (source instanceof String) {
                throw new PDFException.PDFInvallidDocumentNameException(type, (Throwable)e, (String)source, (Object)pdfDocument);
            }
            throw new PDFException.PDFInvallidDocumentException(type, (Throwable)e, pdfDocument);
        }
        catch (PDFSecurityException pdfSex) {
            throw new PDFException.PDFUnAuthorisedOperationException(type, (Throwable)pdfSex, pdfDocument);
        }
        catch (PDFException pdfEx) {
            throw new PDFException.PDFOperationException(type, (Throwable)pdfEx, pdfDocument);
        }
        catch (IOException pdfEx) {
            throw new PDFException.PDFOperationException(type, (Throwable)pdfEx, pdfDocument);
        }
    }

    public static String validateDDX(String ddxFile, PageContext pageContext) {
        String errorMsg;
        ddxFile = PDFDocOperation.getDDXFile(ddxFile, pageContext);
        boolean isEnterpriseDDX = FeatureRouter.getInstance().isFeatureAllowed(EFRConstants.restricted_ddx.intValue());
        if (!isEnterpriseDDX) {
            URL resource = PDFDocOperation.class.getClassLoader().getResource("coldfusion/pdf/coldfusion_standard_ddx.xsd");
            byte[] tempFile = null;
            try {
                tempFile = new byte[resource.openConnection().getContentLength()];
                InputStream is = resource.openStream();
                int numRead = 0;
                for (int offset = 0; offset < tempFile.length && (numRead = is.read(tempFile, offset, tempFile.length - offset)) >= 0; offset += numRead) {
                }
                is.close();
            }
            catch (IOException is) {
                // empty catch block
            }
            long hashcode = -1L;
            if (tempFile != null) {
                hashcode = Utils.getByteArrayCheckSum((byte[])tempFile);
            }
            if (ddxstandardhash != hashcode) {
                throw new PDFException.PDFInvalidXSDException();
            }
        }
        if ((errorMsg = PDFDocOperation.validate(ddxFile)) != null) {
            throw new PDFException.PDFInvalidDDXException(errorMsg);
        }
        return ddxFile;
    }

    private static String validate(String ddx) {
        DDXHelper helper = new DDXHelper();
        InputSource input = XmlProcessor.getInputSource((String)ddx);
        try {
            XMLReader parser = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
            parser.setEntityResolver(helper);
            parser.setErrorHandler(helper);
            parser.setFeature("http://xml.org/sax/features/validation", true);
            parser.setFeature("http://apache.org/xml/features/validation/schema", true);
            parser.setFeature("http://apache.org/xml/features/validation/schema-full-checking", true);
            if (enableExternalEntity) {
                parser.setFeature("http://xml.org/sax/features/external-general-entities", true);
                parser.setFeature("http://xml.org/sax/features/external-parameter-entities", true);
                parser.setFeature("http://apache.org/xml/features/disallow-doctype-decl", false);
                parser.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", true);
            } else {
                parser.setFeature("http://xml.org/sax/features/external-general-entities", false);
                parser.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
                parser.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
                parser.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            }
            parser.parse(input);
        }
        catch (SAXException parser) {
        }
        catch (IOException ie) {
            throw new XmlIOException((Exception)ie);
        }
        return helper.errorMesssage;
    }

    private File[] getFiles(Struct filePath, PageContext pageContext) {
        int size = filePath.size();
        File[] files = new File[size];
        Iterator itr = filePath.entrySet().iterator();
        int count = 0;
        while (itr.hasNext()) {
            Map.Entry entry = (Map.Entry)itr.next();
            files[count++] = VFSFileFactory.getFileObject((String)Utils.getFileFullPath((String)((String)entry.getValue()), (PageContext)pageContext, (boolean)true));
        }
        return files;
    }

    private String[] getKeys(Struct filePath) {
        int size = filePath.size();
        String[] keys = new String[size];
        Iterator itr = filePath.entrySet().iterator();
        int count = 0;
        while (itr.hasNext()) {
            Map.Entry entry = (Map.Entry)itr.next();
            keys[count++] = (String)entry.getKey();
        }
        return keys;
    }

    private Struct initResult(Struct filePath) {
        Struct result = new Struct();
        for (Map.Entry entry : filePath.entrySet()) {
            result.put(entry.getKey(), (Object)"failed");
        }
        return result;
    }

    private Map getDDXMap(String[] keys, File[] files) {
        HashMap<String, Document> map = new HashMap<String, Document>();
        for (int i = 0; i < keys.length; ++i) {
            map.put(keys[i], new Document(keys[i], files[i]));
        }
        return map;
    }

    private Map getOutputMap(String[] keys, File[] files) {
        HashMap<String, File> map = new HashMap<String, File>();
        for (int i = 0; i < keys.length; ++i) {
            map.put(keys[i], files[i]);
        }
        return map;
    }

    private InputSource getInputSource(Reader ddxStream, String[] inputKeys, String[] outputKeys) {
        try {
            String strLine;
            BufferedReader brDDX = new BufferedReader(ddxStream);
            StringBuffer tempApp = new StringBuffer();
            while ((strLine = brDDX.readLine()) != null) {
                int i;
                for (i = 0; i < inputKeys.length; ++i) {
                    strLine = strLine.replaceAll("(?i)" + inputKeys[i], inputKeys[i]);
                }
                for (i = 0; i < outputKeys.length; ++i) {
                    strLine = strLine.replaceAll("(?i)" + outputKeys[i], outputKeys[i]);
                }
                tempApp.append(strLine);
            }
            StringReader inStr = new StringReader(tempApp.toString());
            return new InputSource(inStr);
        }
        catch (IOException ioe) {
            throw new PDFException.PDFOperationException("PROCESSDDX", (Throwable)ioe);
        }
    }

    private void populateResult(Struct result, final Output output, Map outputKeyMap) {
        OutputStream os = null;
        Map outputMap = output.getDocuments();
        Iterator i = outputMap.entrySet().iterator();
        try {
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                Object obj = entry.getValue();
                if (obj instanceof Document) {
                    String strName = ((Document)obj).getDisplayName();
                    File tempStore = (File)outputKeyMap.get(strName);
                    if (tempStore == null) {
                        tempStore = (File)outputKeyMap.get(strName.toUpperCase());
                    }
                    if (tempStore == null && (tempStore = (File)outputKeyMap.get(strName = (String)entry.getKey())) == null) {
                        tempStore = (File)outputKeyMap.get(strName.toUpperCase());
                    }
                    if (tempStore != null) {
                        os = VFSFileFactory.getOutputStream((String)tempStore.getAbsolutePath());
                        Document out = (Document)outputMap.get(strName);
                        result.put((Object)strName, (Object)"successful");
                        if (out.getStore() instanceof BytesStore) {
                            os.write(((BytesStore)out.getStore()).getBytes());
                        } else {
                            try (InputStream is = VFSFileFactory.getInputStream((String)((FileStore)out.getStore()).getFile().getAbsolutePath());){
                                byte[] buffer = new byte[1000];
                                int count = is.read(buffer);
                                while (count != -1) {
                                    os.write(buffer, 0, count);
                                    count = is.read(buffer);
                                }
                            }
                        }
                        os.close();
                    }
                }
                ((Document)obj).delete();
            }
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    Store store = output.getJobLog().getStore();
                    if (store != null && store instanceof FileStore) {
                        ((FileStore)store).getFile().delete();
                    }
                    return null;
                }
            });
            if (output.getThrowables().size() != 0) {
                for (Map.Entry entry : output.getThrowables().entrySet()) {
                    result.put(entry.getKey(), (Object)("failed: " + ((Throwable)entry.getValue()).getLocalizedMessage()));
                }
            }
        }
        catch (IOException ioe) {
            throw new PDFException.PDFOperationException("PROCESSDDX", (Throwable)ioe);
        }
    }

    public static String getDDXFile(String ddxFile, PageContext pageContext) {
        String tempStr;
        if (!ddxFile.startsWith("<?xml ") && new File(tempStr = Utils.getFileFullPath((String)ddxFile, (PageContext)pageContext, (boolean)true)).exists()) {
            File tempFile = new File(tempStr);
            if (tempFile.isDirectory()) {
                throw new PDFFileNotFoundException("ddxfile", ddxFile);
            }
            return tempStr;
        }
        if (ddxFile.indexOf("\"http://ns.adobe.com/DDX/1.0/\"") == -1) {
            throw new PDFFileNotFoundException("ddxfile", ddxFile);
        }
        return ddxFile;
    }

    public Struct processDDX(String ddxFile, Struct inputFilesPath, Struct outputFilesPath, PageContext pageContext) {
        ddxFile = PDFDocOperation.validateDDX(ddxFile, pageContext);
        Reader ddxStream = null;
        Struct result = null;
        try {
            InputSource is;
            File[] inputFiles = this.getFiles(inputFilesPath, pageContext);
            File[] outputFiles = this.getFiles(outputFilesPath, pageContext);
            String[] inputKeys = this.getKeys(inputFilesPath);
            String[] outputKeys = this.getKeys(outputFilesPath);
            Map inputMap = this.getDDXMap(inputKeys, inputFiles);
            Map outputKeyMap = this.getOutputMap(outputKeys, outputFiles);
            result = this.initResult(outputFilesPath);
            if (ddxFile.indexOf("\"http://ns.adobe.com/DDX/1.0/\"") == -1) {
                ddxStream = new FileReader(new File(ddxFile));
                is = this.getInputSource(ddxStream, inputKeys, outputKeys);
            } else {
                ddxStream = new StringReader(ddxFile);
                is = this.getInputSource(ddxStream, inputKeys, outputKeys);
            }
            this.executeDDXOperation(is, inputMap, outputKeyMap, result);
        }
        catch (FileNotFoundException fnf) {
            throw new PDFException.PDFStructFNFException((Exception)fnf);
        }
        catch (JAXBException fnf) {
            throw new PDFException.PDFInvalidDDXException(ddxFile);
        }
        catch (ValidationException fnf) {
            throw new PDFException.PDFInvalidDDXException(ddxFile);
        }
        catch (IOException fnf) {
            throw new PDFException.PDFOperationException("PROCESSDDX", (Throwable)fnf);
        }
        catch (Exception ex) {
            throw new PDFException.PDFInvalidDDXException(ddxFile, (Throwable)ex);
        }
        finally {
            try {
                ddxStream.close();
            }
            catch (Exception exception) {}
        }
        return result;
    }

    private Output executeDDXOperation(final InputSource is, final Map inputMap, final Map outputKeyMap, final Struct result) throws Exception {
        if (System.getSecurityManager() == null) {
            return this._executeDDXOperation(is, inputMap, outputKeyMap, result);
        }
        try {
            return (Output)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return PDFDocOperation.this._executeDDXOperation(is, inputMap, outputKeyMap, result);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw e.getException();
        }
    }

    private Output _executeDDXOperation(InputSource is, Map inputMap, Map outputKeyMap, Struct result) throws ValidationException, JAXBException {
        Environment env = new Environment();
        env.setFailOnError(false);
        if (this.logger.isDebugEnabled()) {
            env.setLogLevel(Level.FINER);
        } else {
            env.setLogLevel(Level.SEVERE);
        }
        Executive exec = new Executive();
        Output output = exec.execute(is, inputMap, env);
        this.populateResult(result, output, outputKeyMap);
        return output;
    }

    public PDFDocument addWatermark(String outputPDFFileName, Object source, String password, String page, String copyFrom, boolean foreground, int opacity, int[] position, int rotation, boolean showOnPrint) {
        PDFDocument pdfDocument = null;
        PDFDocument stampDocument = null;
        try {
            try {
                boolean useRaf = false;
                if (source instanceof String && ((String)source).equalsIgnoreCase(outputPDFFileName)) {
                    useRaf = true;
                }
                pdfDocument = this.getPdfDocHandler().readInternal(password, source, false, useRaf);
                if (!this.getPdfDocHandler().getPdfDocSecurityHandler().isActionAllowed(pdfDocument, ObjectOperations.PAGE_MODIFY)) {
                    throw new PDFException.PDFUnAuthorisedOperationException("ADDWATERMARK", (Object)pdfDocument);
                }
            }
            catch (PDFInvalidDocumentException e) {
                if (source instanceof String) {
                    throw new PDFException.PDFInvallidDocumentNameException("ADDWATERMARK", (Throwable)e, (String)source, (Object)pdfDocument);
                }
                throw new PDFException.PDFInvallidDocumentException("ADDWATERMARK", (Throwable)e, pdfDocument);
            }
            stampDocument = this.getPdfDocHandler().readInternal(password, (Object)copyFrom, false, true);
            if (stampDocument.requirePages().getNumPages() < 1) {
                stampDocument.close();
                pdfDocument.close();
                throw new PDFException.PDFCopyFromNoPageException("ADDWATERMARK", "copyfrom", copyFrom);
            }
            this.getPdfDocHandler().addWatermark(pdfDocument, page, stampDocument.requirePages().getPage(0), foreground, opacity, position, rotation, showOnPrint);
            if (outputPDFFileName != null) {
                this.getPdfDocHandler().writeDocument(outputPDFFileName, pdfDocument, (PDFSaveOptions)PDFSaveFullOptions.newInstance());
            }
            PDFDocument e = pdfDocument;
            return e;
        }
        catch (PDFInvalidDocumentException e) {
            throw new PDFException.PDFInvallidDocumentNameException("ADDWATERMARK", (Throwable)e, copyFrom, pdfDocument);
        }
        catch (PDFSecurityException pdfSex) {
            throw new PDFException.PDFUnAuthorisedOperationException("ADDWATERMARK", (Throwable)pdfSex, pdfDocument);
        }
        catch (PDFException pdfEx) {
            throw new PDFException.PDFOperationException("ADDWATERMARK", (Throwable)pdfEx, pdfDocument);
        }
        catch (IOException pdfEx) {
            throw new PDFException.PDFOperationException("ADDWATERMARK", (Throwable)pdfEx, pdfDocument);
        }
        finally {
            try {
                if (stampDocument != null) {
                    stampDocument.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public QueryTable readSignatures(Object source, String Password) {
        PDFDocument pdfdoc = null;
        QueryTable res = null;
        try {
            boolean useRaf = false;
            pdfdoc = this.getPdfDocHandler().readInternal(Password, source, false, useRaf);
            res = this.getPdfDocHandler().readSignatureFields(pdfdoc);
        }
        catch (PDFException e) {
            throw new PDFException.PDFOperationException("READSIGNATUREFIELDS", (Throwable)e, pdfdoc);
        }
        catch (IOException e) {
            throw new PDFException.PDFOperationException("READSIGNATUREFIELDS", (Throwable)e, pdfdoc);
        }
        return res;
    }

    public PDFDocument unsignDocument(Object source, String destination, String password, boolean unsignall, String fieldname) {
        PDFDocument pdfdoc = null;
        try {
            boolean useRaf = false;
            if (source instanceof String && ((String)source).equalsIgnoreCase(destination)) {
                useRaf = true;
            }
            pdfdoc = this.getPdfDocHandler().readInternal(password, source, false, useRaf);
            if (!this.getPdfDocHandler().getPdfDocSecurityHandler().isActionAllowed(pdfdoc, ObjectOperations.SIGNATURE_FILLIN)) {
                throw new PDFException.PDFSignatureFieldUnsignNotAllowedException((Object)pdfdoc);
            }
            if (unsignall) {
                this.getPdfDocHandler().unsignAllSignatures(pdfdoc);
            } else {
                this.getPdfDocHandler().unsignSignature(pdfdoc, fieldname);
            }
            if (destination != null) {
                this.getPdfDocHandler().writeDocument(destination, pdfdoc, (PDFSaveOptions)PDFSaveIncrementalOptions.newInstance());
            }
        }
        catch (PDFException e) {
            throw new PDFException.PDFOperationException("UNSIGN", (Throwable)e, pdfdoc);
        }
        catch (IOException e) {
            throw new PDFException.PDFOperationException("UNSIGN", (Throwable)e, pdfdoc);
        }
        return pdfdoc;
    }

    public Struct validateSignatures(Object source, String Password) {
        Struct result = new Struct();
        PDFDocument pdfdoc = null;
        try {
            pdfdoc = this.getPdfDocHandler().readInternal(Password, source, false, false);
            this.getPdfDocHandler().validateSignatures(pdfdoc, result);
        }
        catch (PDFException e) {
            throw new PDFException.PDFOperationException("VALIDATESIGNATURE", (Throwable)e, (Object)pdfdoc);
        }
        catch (IOException e) {
            throw new PDFException.PDFOperationException("VALIDATESIGNATURE", (Throwable)e, (Object)pdfdoc);
        }
        return result;
    }

    public PDFDocument createSignatureField(Object source, String destination, String Password, String fieldName, int[] position, double width, double height, String pagenos) {
        PDFDocument pdfdoc = null;
        try {
            PDFSaveFullOptions pdfsfo;
            boolean useRaf = false;
            if (source instanceof String && ((String)source).equalsIgnoreCase(destination)) {
                useRaf = true;
            }
            if ((pdfdoc = this.getPdfDocHandler().readInternal(Password, source, false, useRaf)).isEncrypted()) {
                SecurityLock seclock = this.getPdfDocHandler().getPdfDocSecurityHandler().encrypt(pdfdoc, null, null, "none", null, true);
                pdfsfo = PDFSaveFullOptions.newInstance((SecurityLock)seclock);
            } else {
                pdfsfo = PDFSaveFullOptions.newInstance();
            }
            SignatureFieldInterface sigField = null;
            this.getPdfDocHandler().checkAndCreateXFADomService(pdfdoc);
            if (!this.getPdfDocHandler().getPdfDocSecurityHandler().isActionAllowed(pdfdoc, ObjectOperations.SIGNATURE_CREATE)) {
                throw new PDFException.PDFSignatureFieldCreationNotPermittedExcception((Object)pdfdoc);
            }
            sigField = this.getPdfDocHandler().getSignatureField(pagenos, position, width, height, pdfdoc, fieldName);
            if (destination != null) {
                pdfsfo.setObjectCompressionMode(1);
                this.getPdfDocHandler().writeDocument(destination, pdfdoc, (PDFSaveOptions)pdfsfo);
            }
        }
        catch (PDFException e) {
            throw new PDFException.PDFOperationException("ADDSIGNATUREFIELD", (Throwable)e, pdfdoc);
        }
        catch (IOException e) {
            throw new PDFException.PDFOperationException("ADDSIGNATUREFIELD", (Throwable)e, pdfdoc);
        }
        return pdfdoc;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public PDFDocument signDocument(Object source, String destination, String Password, String keystoreFile, String keyalias, String keyPassword, String keystorePassword, String pageNos, int[] position, double width, double height, boolean author, String field, boolean flatten) {
        PDFDocument pdfdoc = null;
        try {
            boolean useRaf = false;
            if (source instanceof String && ((String)source).equalsIgnoreCase(destination)) {
                useRaf = true;
            }
            Credentials cred = this.getPdfDocHandler().getCredentials(keystoreFile, keyPassword, keyalias, keystorePassword);
            pdfdoc = this.getPdfDocHandler().readInternal(Password, source, false, useRaf);
            SignatureFieldInterface sigField = null;
            this.getPdfDocHandler().checkAndCreateXFADomService(pdfdoc);
            if (field != null) {
                if (!this.getPdfDocHandler().getPdfDocSecurityHandler().isActionAllowed(pdfdoc, ObjectOperations.SIGNATURE_FILLIN)) throw new PDFException.PDFSignatureFieldFillingOperationNotPermittedExcception(field, (Object)pdfdoc);
                sigField = this.getPdfDocHandler().getSignatureField(pdfdoc, field);
            } else {
                if (!this.getPdfDocHandler().getPdfDocSecurityHandler().isActionAllowed(pdfdoc, ObjectOperations.SIGNATURE_CREATE)) throw new PDFException.PDFSignatureFieldCreationNotPermittedExcception((Object)pdfdoc);
                sigField = this.getPdfDocHandler().getSignatureField(pageNos, position, width, height, pdfdoc, null);
            }
            this.getPdfDocHandler().signAndWriteDocument(destination, pdfdoc, cred, sigField, author, flatten);
            return pdfdoc;
        }
        catch (PDFException e) {
            throw new PDFException.PDFOperationException("SIGN", (Throwable)e, pdfdoc);
        }
        catch (IOException e) {
            throw new PDFException.PDFOperationException("SIGN", (Throwable)e, pdfdoc);
        }
    }

    public PDFDocument generateArchive(Object source, String destination, String password, Boolean overwrite, String standard) {
        PDFDocument pdfdoc = null;
        if (!("2b".equalsIgnoreCase(standard) || "1b".equalsIgnoreCase(standard) || "3b".equalsIgnoreCase(standard))) {
            throw new PDFException.PDFStandardException();
        }
        try {
            PDFSaveFullOptions pdfsfo;
            boolean useRaf = false;
            if (source instanceof String && ((String)source).equalsIgnoreCase(destination)) {
                useRaf = true;
            }
            if ((pdfdoc = this.getPdfDocHandler().readInternal(password, source, false, useRaf, true)).isEncrypted()) {
                SecurityLock seclock = this.getPdfDocHandler().getPdfDocSecurityHandler().encrypt(pdfdoc, null, null, "none", null, true);
                pdfsfo = PDFSaveFullOptions.newInstance((SecurityLock)seclock);
            } else {
                pdfsfo = PDFSaveFullOptions.newInstance();
            }
            SignatureManager smgr = SignatureManager.newInstance((PDFDocument)pdfdoc);
            smgr.removeAllSignatureFields();
            if ("2b".equalsIgnoreCase(standard)) {
                PDFA2ConversionOptions options = PDFArchiveOptions.createPDFConversionOption2(pdfdoc);
                PDFA2BasicConversionHandler handler = new PDFA2BasicConversionHandler();
                boolean converted = PDFA2Service.convert((PDFDocument)pdfdoc, (PDFA2ConformanceLevel)PDFA2ConformanceLevel.Level_2b, (PDFA2ConversionOptions)options, (PDFA2ConversionHandler)handler);
                Logger pdflog = CFLogs.PDFA2_ARCHIVE_LOG;
                Map<String, ArrayList<String>> map = handler.getArchiveErrorReport();
                this.writeArchiveLog(source, destination, pdfdoc, pdfsfo, pdflog, map, handler.hasErrors(), handler.getArchiveErrorReport());
            } else if ("3b".equalsIgnoreCase(standard)) {
                PDFA2ConversionOptions options = PDFArchiveOptions.createPDFConversionOption2(pdfdoc);
                PDFA2BasicConversionHandler handler = new PDFA2BasicConversionHandler();
                boolean converted = PDFA3Service.convert((PDFDocument)pdfdoc, (PDFA2ConformanceLevel)PDFA2ConformanceLevel.Level_3b, (PDFA2ConversionOptions)options, (PDFA2ConversionHandler)handler);
                Logger pdflog = CFLogs.PDFA2_ARCHIVE_LOG;
                Map<String, ArrayList<String>> map = handler.getArchiveErrorReport();
                this.writeArchiveLog(source, destination, pdfdoc, pdfsfo, pdflog, map, handler.hasErrors(), handler.getArchiveErrorReport());
            } else {
                PDFAConversionOptions options = PDFArchiveOptions.createPDFConversionOption(pdfdoc);
                PDFABasicConversionHandler handler = new PDFABasicConversionHandler();
                boolean converted = PDFAService.convert((PDFDocument)pdfdoc, (PDFAConformanceLevel)PDFAConformanceLevel.Level_1b, (PDFAConversionOptions)options, (PDFAConversionHandler)handler);
                Logger pdflog = CFLogs.PDFA2_ARCHIVE_LOG;
                Map<String, ArrayList<String>> map = handler.getArchiveErrorReport();
                this.writeArchiveLog(source, destination, pdfdoc, pdfsfo, pdflog, map, handler.hasErrors(), handler.getArchiveErrorReport());
            }
        }
        catch (IOException e) {
            throw new PDFException.PDFOperationException("ARCHIVE", (Throwable)e, pdfdoc);
        }
        catch (PDFException e) {
            throw new PDFException.PDFOperationException("ARCHIVE", (Throwable)e, pdfdoc);
        }
        return pdfdoc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeArchiveLog(Object source, String destination, PDFDocument pdfdoc, PDFSaveFullOptions pdfsfo, Logger pdflog, Map<String, ArrayList<String>> map, boolean errors, Map<String, ArrayList<String>> archiveErrorReport) {
        try {
            Logger logger = pdflog;
            synchronized (logger) {
                pdflog.info((Object)("********PDFA Archive Conversion details for " + source + ". *********"));
                if (!errors) {
                    pdflog.info((Object)("Archive successful for " + source));
                }
                for (String s : map.keySet()) {
                    pdflog.error((Object)s);
                }
            }
            if (errors) {
                ArrayList<Map<String, ArrayList<String>>> res = new ArrayList<Map<String, ArrayList<String>>>();
                if (System.getProperty("coldfusion.logpdfarchive") != null) {
                    res.add(archiveErrorReport);
                }
                pdfdoc.close();
                throw new PDFException.PDFArchiveUnsuccessfulException(res);
            }
            if (destination != null) {
                pdfsfo.setObjectCompressionMode(1);
                this.getPdfDocHandler().writeDocument(destination, pdfdoc, (PDFSaveOptions)pdfsfo);
            }
        }
        catch (PDFInvalidDocumentException pDFInvalidDocumentException) {
        }
        catch (PDFIOException pDFIOException) {
        }
        catch (PDFSecurityException pDFSecurityException) {
        }
        catch (PDFUnableToCompleteOperationException pDFUnableToCompleteOperationException) {
        }
        catch (PDFInvalidParameterException pDFInvalidParameterException) {
        }
        catch (IOException iOException) {
        }
        catch (PDFException pDFException) {
            // empty catch block
        }
    }

    public PDFDocument addWatermark(String outputPDFFileName, Object source, String password, String page, Image image, boolean foreground, int opacity, int[] position, int rotation, boolean showOnPrint, String richText, double height, double width) {
        PDFDocument pdfDocument = null;
        try {
            boolean useRaf = false;
            if (source instanceof String && ((String)source).equalsIgnoreCase(outputPDFFileName)) {
                useRaf = true;
            }
            pdfDocument = this.getPdfDocHandler().readInternal(password, source, false, useRaf);
            if (!this.getPdfDocHandler().getPdfDocSecurityHandler().isActionAllowed(pdfDocument, ObjectOperations.PAGE_MODIFY)) {
                throw new PDFException.PDFUnAuthorisedOperationException("ADDWATERMARK", (Object)pdfDocument);
            }
            if (richText == null) {
                this.getPdfDocHandler().addWatermark(pdfDocument, page, image, foreground, opacity, position, rotation, showOnPrint);
            } else {
                this.getPdfDocHandler().addWatermark(pdfDocument, page, richText, foreground, opacity, position, rotation, showOnPrint, height, width);
            }
            if (outputPDFFileName != null) {
                this.getPdfDocHandler().writeDocument(outputPDFFileName, pdfDocument, (PDFSaveOptions)PDFSaveFullOptions.newInstance());
            }
            return pdfDocument;
        }
        catch (PDFInvalidDocumentException e) {
            if (source instanceof String) {
                throw new PDFException.PDFInvallidDocumentNameException("ADDWATERMARK", (Throwable)e, (String)source, (Object)pdfDocument);
            }
            throw new PDFException.PDFInvallidDocumentException("ADDWATERMARK", (Throwable)e, pdfDocument);
        }
        catch (PDFSecurityException pdfSex) {
            throw new PDFException.PDFUnAuthorisedOperationException("ADDWATERMARK", (Throwable)pdfSex, pdfDocument);
        }
        catch (PDFException pdfEx) {
            throw new PDFException.PDFOperationException("ADDWATERMARK", (Throwable)pdfEx, pdfDocument);
        }
        catch (IOException pdfEx) {
            throw new PDFException.PDFOperationException("ADDWATERMARK", (Throwable)pdfEx, pdfDocument);
        }
    }

    public PDFDocument addWHF(String outputPDFFileName, Object source, String password, String page, Image image, int opacity, boolean showOnPrint, String richText, String type, String align, String numberFormat, double leftMargin, double rightMargin, double horMargin) {
        PDFDocument pdfDocument = null;
        try {
            boolean useRaf = false;
            if (source instanceof String && ((String)source).equalsIgnoreCase(outputPDFFileName)) {
                useRaf = true;
            }
            pdfDocument = this.getPdfDocHandler().readInternal(password, source, false, useRaf);
            if (!this.getPdfDocHandler().getPdfDocSecurityHandler().isActionAllowed(pdfDocument, ObjectOperations.PAGE_MODIFY)) {
                throw new PDFException.PDFUnAuthorisedOperationException(type, (Object)pdfDocument);
            }
            if (image == null) {
                this.getPdfDocHandler().addHF(pdfDocument, page, opacity, showOnPrint, richText, type, align, numberFormat, leftMargin, rightMargin, horMargin);
            } else {
                this.getPdfDocHandler().addHF(pdfDocument, page, opacity, showOnPrint, type, align, leftMargin, rightMargin, horMargin, image);
            }
            if (outputPDFFileName != null) {
                this.getPdfDocHandler().writeDocument(outputPDFFileName, pdfDocument, (PDFSaveOptions)PDFSaveFullOptions.newInstance());
            }
            return pdfDocument;
        }
        catch (PDFInvalidDocumentException e) {
            if (source instanceof String) {
                throw new PDFException.PDFInvallidDocumentNameException(type, (Throwable)e, (String)source, (Object)pdfDocument);
            }
            throw new PDFException.PDFInvallidDocumentException(type, (Throwable)e, pdfDocument);
        }
        catch (PDFSecurityException pdfSex) {
            throw new PDFException.PDFUnAuthorisedOperationException(type, (Throwable)pdfSex, pdfDocument);
        }
        catch (PDFException pdfEx) {
            throw new PDFException.PDFOperationException(type, (Throwable)pdfEx, pdfDocument);
        }
        catch (IOException pdfEx) {
            throw new PDFException.PDFOperationException(type, (Throwable)pdfEx, pdfDocument);
        }
    }

    public PDFDocument downsampleImage(Object source, String password, String destination, String algo, double vScale, double hScale, String pages) throws PDFDocException {
        PDFDocument pdfDocument = null;
        try {
            try {
                boolean useRaf = false;
                if (source instanceof String && ((String)source).equalsIgnoreCase(destination)) {
                    useRaf = true;
                }
                pdfDocument = this.getPdfDocHandler().readInternal(password, source, false, useRaf);
                if (!this.getPdfDocHandler().getPdfDocSecurityHandler().isActionAllowed(pdfDocument, ObjectOperations.PAGE_MODIFY)) {
                    throw new PDFException.PDFUnAuthorisedOperationException("OPTIMIZE", (Object)pdfDocument);
                }
            }
            catch (PDFInvalidDocumentException e) {
                if (source instanceof String) {
                    throw new PDFException.PDFInvallidDocumentNameException("OPTIMIZE", (Throwable)e, (String)source, (Object)pdfDocument);
                }
                throw new PDFException.PDFInvallidDocumentException("OPTIMIZE", (Throwable)e, pdfDocument);
            }
            this.getPdfDocHandler().downsampleImage(pdfDocument, password, algo, vScale, hScale, pages);
            return pdfDocument;
        }
        catch (PDFSecurityException pdfSex) {
            throw new PDFException.PDFUnAuthorisedOperationException("OPTIMIZE", (Throwable)pdfSex, pdfDocument);
        }
        catch (PDFException pdfEx) {
            throw new PDFException.PDFOperationException("OPTIMIZE", (Throwable)pdfEx, pdfDocument);
        }
        catch (IOException pdfEx) {
            throw new PDFException.PDFOperationException("OPTIMIZE", (Throwable)pdfEx, pdfDocument);
        }
    }

    public PDFDocument reduceSize(PDFDocument source, String destination, boolean noJS, boolean noThumbnails, boolean noBookmarks, boolean noComments, boolean noMetadata, boolean noAttachments, boolean noLinks, String pages, boolean noFonts) throws PDFDocException {
        try {
            PDFNameDictionary nameDictionary2;
            if (noJS) {
                nameDictionary2 = source.requireCatalog().getNameDictionary();
                if (nameDictionary2 != null) {
                    nameDictionary2.removeNamedJavaScripts();
                }
                source.requireCatalog().setOpenAction(null);
                this.getPdfDocHandler().removeJavaScriptsFromField(source);
            }
            if (noMetadata) {
                source.setDocumentInfo(null);
                try {
                    source.requireCatalog().setMetadata(null);
                }
                catch (PDFException nameDictionary2) {
                    // empty catch block
                }
            }
            if (noAttachments && (nameDictionary2 = source.requireCatalog().getNameDictionary()) != null) {
                nameDictionary2.removeNamedEmbeddedFiles();
            }
            if (noBookmarks) {
                this.getPdfDocHandler().noBookmarks(source, pages);
            }
            if (noThumbnails) {
                this.getPdfDocHandler().noThumbnails(source, pages);
            }
            if (noComments) {
                this.getPdfDocHandler().noComments(source, pages);
            }
            if (noLinks) {
                this.getPdfDocHandler().noLinks(source, pages);
            }
            if (noFonts) {
                try {
                    this.getPdfDocHandler().removeFonts(source);
                }
                catch (Exception nameDictionary3) {
                    // empty catch block
                }
            }
            if (destination != null) {
                this.getPdfDocHandler().writeDocument(destination, source, (PDFSaveOptions)PDFSaveFullOptions.newInstance());
            }
            return source;
        }
        catch (PDFSecurityException pdfSex) {
            throw new PDFException.PDFUnAuthorisedOperationException("OPTIMIZE", (Throwable)pdfSex, (Object)source);
        }
        catch (PDFException pdfEx) {
            throw new PDFException.PDFOperationException("OPTIMIZE", (Throwable)pdfEx, (Object)source);
        }
        catch (IOException pdfEx) {
            throw new PDFException.PDFOperationException("OPTIMIZE", (Throwable)pdfEx, (Object)source);
        }
    }

    public PDFDocument transform(Object source, String password, String destination, int rotation, int[] position, double hScale, double vScale, String pages) throws PDFDocException {
        PDFDocument pdfDocument = null;
        try {
            try {
                boolean useRaf = false;
                if (source instanceof String && ((String)source).equalsIgnoreCase(destination)) {
                    useRaf = true;
                }
                pdfDocument = this.getPdfDocHandler().readInternal(password, source, false, useRaf);
                if (!this.getPdfDocHandler().getPdfDocSecurityHandler().isActionAllowed(pdfDocument, ObjectOperations.PAGE_MODIFY)) {
                    throw new PDFException.PDFUnAuthorisedOperationException("TRANSFORM", (Object)pdfDocument);
                }
            }
            catch (PDFInvalidDocumentException e) {
                if (source instanceof String) {
                    throw new PDFException.PDFInvallidDocumentNameException("TRANSFORM", (Throwable)e, (String)source, (Object)pdfDocument);
                }
                throw new PDFException.PDFInvallidDocumentException("TRANSFORM", (Throwable)e, pdfDocument);
            }
            pdfDocument = this.getPdfDocHandler().transform(pdfDocument, password, destination, rotation, position, hScale, vScale, pages);
            if (destination != null) {
                this.getPdfDocHandler().writeDocument(destination, pdfDocument, (PDFSaveOptions)PDFSaveFullOptions.newInstance());
            }
            return pdfDocument;
        }
        catch (PDFSecurityException pdfSex) {
            throw new PDFException.PDFUnAuthorisedOperationException("TRANSFORM", (Throwable)pdfSex, pdfDocument);
        }
        catch (PDFException pdfEx) {
            throw new PDFException.PDFOperationException("TRANSFORM", (Throwable)pdfEx, pdfDocument);
        }
        catch (IOException pdfEx) {
            throw new PDFException.PDFOperationException("TRANSFORM", (Throwable)pdfEx, pdfDocument);
        }
    }

    public void extractImage(Object source, String password, String destination, String imagePrefix, String format, String pages) throws PDFDocException {
        PDFDocument pdfDocument = null;
        try {
            try {
                boolean useRaf = false;
                if (source instanceof String && ((String)source).equalsIgnoreCase(destination)) {
                    useRaf = true;
                }
                pdfDocument = this.getPdfDocHandler().readInternal(password, source, false, useRaf);
                if (!this.getPdfDocHandler().getPdfDocSecurityHandler().isActionAllowed(pdfDocument, ObjectOperations.PAGE_EXPORT)) {
                    throw new PDFException.PDFUnAuthorisedOperationException("EXTRACTIMAGE", (Object)pdfDocument);
                }
            }
            catch (PDFInvalidDocumentException e) {
                if (source instanceof String) {
                    throw new PDFException.PDFInvallidDocumentNameException("EXTRACTIMAGE", (Throwable)e, (String)source, (Object)pdfDocument);
                }
                throw new PDFException.PDFInvallidDocumentException("EXTRACTIMAGE", (Throwable)e, pdfDocument);
            }
            this.getPdfDocHandler().extractImage(pdfDocument, destination, imagePrefix, format, pages);
        }
        catch (PDFSecurityException pdfSex) {
            throw new PDFException.PDFUnAuthorisedOperationException("EXTRACTIMAGE", (Throwable)pdfSex, pdfDocument);
        }
        catch (PDFException pdfEx) {
            throw new PDFException.PDFOperationException("EXTRACTIMAGE", (Throwable)pdfEx, pdfDocument);
        }
        catch (IOException pdfEx) {
            throw new PDFException.PDFOperationException("EXTRACTIMAGE", (Throwable)pdfEx, pdfDocument);
        }
    }

    public void thumbnail(Object source, String password, String destination, String imagePrefix, String format, String pages, int scaling, boolean transparent, boolean isHighResolution, PageContext pageContext, boolean hiRes, int hScale, int hLength, int hBreadth, boolean overridePage, int jpgFlag, boolean compressTiffs, boolean stopOnError) throws PDFDocException {
        try {
            source = this.getSourceAsByte(source, password);
            this.getPdfDocHandler().extractImages(source, password, destination, imagePrefix, format, pages, scaling, transparent, isHighResolution, hiRes, hScale, hLength, hBreadth, overridePage, jpgFlag, compressTiffs, stopOnError);
        }
        catch (PDFException.PDFUnAuthorisedOperationException e) {
            throw e;
        }
        catch (PDFDocException e) {
            if (e.getCause() instanceof PdfException) {
                throw new PDFException.PDFInvallidDocumentException("THUMBNAIL", (Throwable)e);
            }
            throw e;
        }
        catch (Exception e) {
            throw new PDFException.PDFOperationException("THUMBNAIL", (Throwable)e);
        }
    }

    public Object getSourceAsByte(Object source, String password) throws PDFException, IOException {
        if (source instanceof PDFDocWrapper || source instanceof PDFCore || source instanceof String) {
            PDFDocument pdfDocument = this.getPdfDocHandler().readInternal(password, source, false, true);
            source = this.getPdfDocHandler().writeDocument(pdfDocument, null);
        }
        return source;
    }

    static {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                String logDir = ServiceFactory.getRuntimeService().getTempCacheDirectory() + File.separatorChar + "tmpPdf";
                File file = new File(logDir);
                if (!file.exists()) {
                    file.mkdirs();
                }
                System.setProperty("com.adobe.service.pdfm.tmpdir", logDir);
                return null;
            }
        });
    }
}

