/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.pdf;

import coldfusion.server.ServiceFactory;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.filters.PDFFilter;
import com.adobe.internal.pdftoolkit.pdf.filters.PDFFilterFlate;
import com.adobe.internal.pdftoolkit.pdf.filters.PDFFilterList;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFColorSpace;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFColorSpaceICCBased;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFICCProfile;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFRenderingIntent;
import com.adobe.internal.pdftoolkit.pdf.interchange.prepress.PDFOutputIntent;
import com.adobe.internal.pdftoolkit.services.pdfa.PDFAConversionOptions;
import com.adobe.internal.pdftoolkit.services.pdfa.PDFAOCConversionMode;
import com.adobe.internal.pdftoolkit.services.pdfa2.PDFA2ConversionOptions;
import java.awt.color.ICC_Profile;
import java.io.File;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

public class PDFArchiveOptions {
    private static String rootDir;

    private static void setrootDir() {
        rootDir = ServiceFactory.getRuntimeService().getRootDir();
    }

    public static PDFAConversionOptions createPDFConversionOption(PDFDocument doc) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, IOException {
        PDFAConversionOptions options = new PDFAConversionOptions();
        PDFArchiveOptions.setrootDir();
        PDFArchiveOptions.setPDFAOutputIntent(doc, options);
        PDFArchiveOptions.setDefaultColorSpaces(doc, options);
        options.setUpdatePDFAMetadataOnPartialConversion(false);
        options.setOCConversionMode(PDFAOCConversionMode.ConvertOCUsingDefaultConfigIncludingUsageApp, ASName.k_View);
        options.setRemoveIllegalAnnotations(true);
        options.setRemoveInvisibleNonStandardAnnots(true);
        options.setRemoveHiddenAnnots(true);
        options.setRemoveNoViewAnnots(true);
        options.setOverrideAnnotationFlags(true);
        options.setRemoveNonNormalAnnotAppearances(true);
        options.setRemoveIllegalActions(true);
        options.setRemoveIllegalAdditionalActions(true);
        options.setRemoveJavaScriptNameTree(true);
        options.setOverrideRenderingIntent(PDFRenderingIntent.RELATIVE_COLORIMETRIC);
        options.setRemoveFormXObjectPSData(true);
        options.setRemoveIllegalInterpolation(true);
        options.setRemoveImageAlternates(true);
        options.setRemoveTransferFunctions(true);
        options.setRemoveXFA(true);
        options.setRemoveXObjectOPI(true);
        options.setRemoveEmbeddedFilesNameTree(true);
        options.setShouldEmbedFonts(true);
        options.setRemoveInvalidXMPProperties(true);
        options.setRemovePostScriptXObjects(true);
        options.setRemoveReferenceXObjects(true);
        PDFFilterList list = PDFFilterList.newInstance((PDFDocument)doc);
        list.add((PDFFilter)PDFFilterFlate.newInstance((PDFDocument)doc, null));
        options.setLZWReplacementFilterList(list);
        return options;
    }

    public static PDFA2ConversionOptions createPDFConversionOption2(PDFDocument doc) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, IOException {
        PDFA2ConversionOptions options = new PDFA2ConversionOptions();
        PDFArchiveOptions.setrootDir();
        PDFArchiveOptions.setPDFA2OutputIntent(doc, options);
        PDFArchiveOptions.setDefaultColorSpaces2(doc, options);
        options.setUpdatePDFAMetadataOnPartialConversion(false);
        options.setRemoveIllegalAnnotations(true);
        options.setRemoveInvisibleAnnots(true);
        options.setRemoveHiddenAnnots(true);
        options.setRemoveNoViewAnnots(true);
        options.setOverrideAnnotationFlags(true);
        options.setRemoveNonNormalAnnotAppearances(true);
        options.setRemoveIllegalActions(true);
        options.setRemoveIllegalAdditionalActions(true);
        options.setRemoveJavaScriptNameTree(true);
        options.setRemoveJavaScriptNameTree(true);
        options.setOverrideRenderingIntent(PDFRenderingIntent.RELATIVE_COLORIMETRIC);
        options.setRemoveFormXObjectPSData(true);
        options.setRemoveIllegalInterpolation(true);
        options.setRemoveImageAlternates(true);
        options.setRemoveTransferFunctions(true);
        options.setRemoveXFA(true);
        options.setRemoveXObjectOPI(true);
        options.setRemoveEmbeddedFileFromNameTree(true);
        options.setShouldEmbedFonts(true);
        options.setRemoveInvalidXMPProperties(true);
        options.setRemoveOrderKeyFromOptionalContentConfig(true);
        options.setRemovePostScriptXObjects(true);
        options.setRemoveReferenceXObjects(true);
        options.setRemoveASKeyFromOCConfigDict(true);
        PDFFilterList list = PDFFilterList.newInstance((PDFDocument)doc);
        list.add((PDFFilter)PDFFilterFlate.newInstance((PDFDocument)doc, null));
        options.setLZWReplacementFilterList(list);
        return options;
    }

    private static void setPDFAOutputIntent(PDFDocument doc, PDFAConversionOptions options) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, IOException {
        PDFOutputIntent outputIntent = PDFOutputIntent.newInstance((PDFDocument)doc, (String)"GTS_PDFA1", (String)"CGATS TR 001");
        outputIntent.setOutputCondition("U.S. Web Coated(SWOP)v2");
        outputIntent.setRegistryName("http://www.color.org");
        ICC_Profile profile = ICC_Profile.getInstance(rootDir + File.separator + "color_profiles" + File.separator + "sRGB Color Space Profile.icm");
        PDFICCProfile destProfile = PDFICCProfile.newInstance((PDFDocument)doc, (ICC_Profile)profile);
        outputIntent.setDestOutputProfile(destProfile);
        outputIntent.setOutputConditionIdentifier("CGATS TR 001");
        options.setPDFAOutputIntent(outputIntent, false);
    }

    private static void setDefaultColorSpaces(PDFDocument doc, PDFAConversionOptions options) throws IOException, PDFIOException, PDFSecurityException, PDFInvalidDocumentException {
        ICC_Profile iccRGBProfile = ICC_Profile.getInstance(rootDir + File.separator + "color_profiles" + File.separator + "sRGB Color Space Profile.icm");
        ICC_Profile iccCMYKProfile = ICC_Profile.getInstance(rootDir + File.separator + "color_profiles" + File.separator + "USWebCoatedSWOP.icc");
        ICC_Profile iccGrayProfile = ICC_Profile.getInstance(rootDir + File.separator + "color_profiles" + File.separator + "BlackWhite.icc");
        PDFColorSpaceICCBased defaultRGBProfile = PDFColorSpaceICCBased.newInstance((PDFDocument)doc, (ICC_Profile)iccRGBProfile);
        PDFColorSpaceICCBased defaultCMYKProfile = PDFColorSpaceICCBased.newInstance((PDFDocument)doc, (ICC_Profile)iccCMYKProfile);
        PDFColorSpaceICCBased defaultGrayProfile = PDFColorSpaceICCBased.newInstance((PDFDocument)doc, (ICC_Profile)iccGrayProfile);
        options.setDefaultColorSpaces((PDFColorSpace)defaultRGBProfile, (PDFColorSpace)defaultCMYKProfile, (PDFColorSpace)defaultGrayProfile);
    }

    private static ICC_Profile getICCProfile(final String path) throws IOException {
        if (System.getSecurityManager() == null) {
            return ICC_Profile.getInstance(path);
        }
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<ICC_Profile>(){

                @Override
                public ICC_Profile run() throws Exception {
                    return ICC_Profile.getInstance(path);
                }
            });
        }
        catch (PrivilegedActionException e) {
            if (e.getException() instanceof IOException) {
                throw (IOException)e.getException();
            }
            throw new RuntimeException(e.getException());
        }
    }

    private static void setPDFA2OutputIntent(PDFDocument doc, PDFA2ConversionOptions options) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, IOException {
        PDFOutputIntent outputIntent = PDFOutputIntent.newInstance((PDFDocument)doc, (String)"GTS_PDFA1", (String)"CGATS TR 001");
        outputIntent.setOutputCondition("U.S. Web Coated(SWOP)v2");
        outputIntent.setRegistryName("http://www.color.org");
        ICC_Profile profile = PDFArchiveOptions.getICCProfile(rootDir + File.separator + "color_profiles" + File.separator + "sRGB Color Space Profile.icm");
        PDFICCProfile destProfile = PDFICCProfile.newInstance((PDFDocument)doc, (ICC_Profile)profile);
        outputIntent.setDestOutputProfile(destProfile);
        outputIntent.setOutputConditionIdentifier("CGATS TR 001");
        options.setPDFAOutputIntent(outputIntent, false);
    }

    private static void setDefaultColorSpaces2(PDFDocument doc, PDFA2ConversionOptions options) throws IOException, PDFIOException, PDFSecurityException, PDFInvalidDocumentException {
        ICC_Profile iccRGBProfile = PDFArchiveOptions.getICCProfile(rootDir + File.separator + "color_profiles" + File.separator + "sRGB Color Space Profile.icm");
        ICC_Profile iccCMYKProfile = PDFArchiveOptions.getICCProfile(rootDir + File.separator + "color_profiles" + File.separator + "USWebCoatedSWOP.icc");
        ICC_Profile iccGrayProfile = PDFArchiveOptions.getICCProfile(rootDir + File.separator + "color_profiles" + File.separator + "BlackWhite.icc");
        PDFColorSpaceICCBased defaultRGBProfile = PDFColorSpaceICCBased.newInstance((PDFDocument)doc, (ICC_Profile)iccRGBProfile);
        PDFColorSpaceICCBased defaultCMYKProfile = PDFColorSpaceICCBased.newInstance((PDFDocument)doc, (ICC_Profile)iccCMYKProfile);
        PDFColorSpaceICCBased defaultGrayProfile = PDFColorSpaceICCBased.newInstance((PDFDocument)doc, (ICC_Profile)iccGrayProfile);
        options.setDefaultColorSpaces((PDFColorSpace)defaultRGBProfile, (PDFColorSpace)defaultCMYKProfile, (PDFColorSpace)defaultGrayProfile);
    }
}

