/*
 * Decompiled with CFR 0.152.
 */
package macromedia.pool;

import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;
import macromedia.pool.ConnectionPool;

class PooledConnectionHolder
implements ConnectionEventListener {
    ConnectionPool pool;
    PooledConnection pc;
    long timeSync;
    boolean connected;
    boolean freed;
    private static String footprint = "$Revision: #1 $";

    PooledConnectionHolder(ConnectionPool connectionPool, PooledConnection pooledConnection) {
        this.pool = connectionPool;
        this.pc = pooledConnection;
    }

    PooledConnection getPooledConnection() {
        return this.pc;
    }

    void reset() {
        this.connected = true;
        this.freed = false;
        this.timeSync = System.currentTimeMillis();
    }

    void free() {
        this.freed = true;
        this.connected = false;
        this.timeSync = System.currentTimeMillis();
    }

    @Override
    public synchronized void connectionClosed(ConnectionEvent connectionEvent) {
        this.pool.connectionClosed(this);
    }

    @Override
    public synchronized void connectionErrorOccurred(ConnectionEvent connectionEvent) {
        this.pool.connectionErrorOccurred(this);
    }

    long timeConnected(long l) {
        if (!this.connected) {
            return 0L;
        }
        return l - this.timeSync;
    }

    long timeIdle(long l) {
        if (!this.freed) {
            return 0L;
        }
        return l - this.timeSync;
    }
}

