/*
 * Decompiled with CFR 0.152.
 */
package com.github.pjfanning.xlsx.impl;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.poi.util.TempFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TempFileUtil {
    private static final Logger log = LoggerFactory.getLogger(TempFileUtil.class);

    private TempFileUtil() {
    }

    public static File writeInputStreamToFile(InputStream is, int bufferSize) throws IOException {
        if (is == null) {
            throw new NullPointerException("InputStream is null");
        }
        File f = TempFile.createTempFile((String)"tmp-", (String)".xlsx");
        try {
            File file;
            FileOutputStream fos = new FileOutputStream(f);
            try {
                int read;
                byte[] bytes = new byte[bufferSize];
                while ((read = is.read(bytes)) != -1) {
                    fos.write(bytes, 0, read);
                }
                file = f;
            }
            catch (Throwable read) {
                try {
                    try {
                        fos.close();
                    }
                    catch (Throwable throwable) {
                        read.addSuppressed(throwable);
                    }
                    throw read;
                }
                catch (IOException | Error | RuntimeException e) {
                    try {
                        if (!f.delete()) {
                            log.debug("failed to delete temp file");
                        }
                    }
                    catch (Exception fileException) {
                        log.warn("Failed to delete temp file {}: {}", (Object)f.getAbsolutePath(), (Object)fileException.toString());
                    }
                    throw e;
                }
            }
            fos.close();
            return file;
        }
        finally {
            is.close();
        }
    }
}

