/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.microsoft.graph;

import coldfusion.cloud.util.ValidatorFiller;
import coldfusion.image.Image;
import coldfusion.log.Logger;
import coldfusion.microsoft.graph.GraphServiceConstants;
import coldfusion.microsoft.graph.GraphServiceException;
import coldfusion.microsoft.graph.GraphServiceUtils;
import coldfusion.microsoft.graph.RequestConfigurator;
import coldfusion.microsoft.graph.mapper.PasswordChangeDetailsConsumer;
import coldfusion.microsoft.graph.mapper.StructMapper;
import coldfusion.microsoft.graph.mapper.UserCollectionRequestConfiguratorConsumer;
import coldfusion.microsoft.graph.mapper.UserConsumer;
import coldfusion.microsoft.graph.mapper.UserRequestConfiguratorConsumer;
import coldfusion.microsoft.graph.mapper.UsersDeltaRequestConfiguratorConsumer;
import coldfusion.osgi.services.MSGraphService;
import coldfusion.runtime.GenerateCFInvoke;
import coldfusion.runtime.GenerateCFNamedInvoke;
import coldfusion.runtime.Struct;
import coldfusion.util.RB;
import com.microsoft.graph.core.tasks.PageIterator;
import com.microsoft.graph.models.User;
import com.microsoft.graph.models.UserCollectionResponse;
import com.microsoft.graph.users.UsersRequestBuilder;
import com.microsoft.graph.users.delta.DeltaGetResponse;
import com.microsoft.graph.users.delta.DeltaRequestBuilder;
import com.microsoft.graph.users.item.changepassword.ChangePasswordPostRequestBody;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.SerializationWriter;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;

@GenerateCFInvoke
@GenerateCFNamedInvoke
public class GraphServiceClient
implements MSGraphService {
    private final com.microsoft.graph.serviceclient.GraphServiceClient graphServiceClient;
    private final Logger logger;

    public GraphServiceClient(com.microsoft.graph.serviceclient.GraphServiceClient serviceClient, Logger logger) {
        this.graphServiceClient = serviceClient;
        this.logger = logger;
    }

    public Struct listUsers() {
        try {
            UserCollectionResponse userCollectionResponse = this.graphServiceClient.users().get(configurator -> {
                configurator.queryParameters.count = true;
                configurator.headers.add("consistencyLevel", "eventual");
            });
            StructMapper responseMapper = new StructMapper();
            userCollectionResponse.serialize((SerializationWriter)responseMapper);
            return responseMapper.getObject();
        }
        catch (RuntimeException ex) {
            String message = RB.getString(GraphServiceClient.class, (String)"ERROR_LISTING_USERS");
            this.logger.error((Object)message);
            throw new GraphServiceException(message, ex);
        }
    }

    public Struct listUsers(Struct requestConfigurator) {
        try {
            UserCollectionResponse userCollectionResponse;
            RequestConfigurator requestConfiguration = new RequestConfigurator();
            ValidatorFiller.INSTANCE.fillObject((Object)requestConfiguration, (Map)requestConfigurator, UserCollectionRequestConfiguratorConsumer.INSTANCE.getConsumerMap());
            Integer top = requestConfiguration.getTop();
            if (!GraphServiceUtils.isNullOrEmpty(requestConfiguration.getSkipToken())) {
                userCollectionResponse = this.graphServiceClient.users().withUrl(GraphServiceUtils.buildRawUrl(requestConfiguration)).get(configurator -> configurator.headers.add("consistencyLevel", "eventual"));
            } else if (!GraphServiceUtils.needsAutoPagination(top)) {
                userCollectionResponse = this.graphServiceClient.users().get(this.getUsersListRequestConfiguration(requestConfiguration));
            } else {
                ArrayList users = new ArrayList();
                requestConfiguration.setTop(GraphServiceConstants.MAX_PAGE_SIZE);
                UserCollectionResponse collectionResponse = this.graphServiceClient.users().get(this.getUsersListRequestConfiguration(requestConfiguration));
                Function<User, Boolean> processPageItemCallback = top == -1 ? user -> {
                    users.add(user);
                    return true;
                } : user -> {
                    users.add(user);
                    return users.size() < top;
                };
                PageIterator<User, UserCollectionResponse> pageIterator = GraphServiceUtils.getPageIterator(this.graphServiceClient, requestInfo -> requestInfo, collectionResponse, UserCollectionResponse::createFromDiscriminatorValue, processPageItemCallback);
                if (Objects.nonNull(pageIterator)) {
                    pageIterator.iterate();
                }
                userCollectionResponse = new UserCollectionResponse();
                userCollectionResponse.setOdataCount(collectionResponse.getOdataCount());
                userCollectionResponse.setAdditionalData(collectionResponse.getAdditionalData());
                userCollectionResponse.setValue(users);
            }
            StructMapper responseMapper = new StructMapper();
            userCollectionResponse.serialize((SerializationWriter)responseMapper);
            return responseMapper.getObject();
        }
        catch (ReflectiveOperationException ex) {
            String message = RB.getString(GraphServiceClient.class, (String)"ERROR_RETRIEVING_MULTIPLE_USERS");
            this.logger.error((Object)message);
            throw new GraphServiceException(message, ex);
        }
        catch (RuntimeException ex) {
            String message = RB.getString(GraphServiceClient.class, (String)"ERROR_LISTING_USERS");
            this.logger.error((Object)message);
            throw new GraphServiceException(message, ex);
        }
    }

    public Struct getUser() {
        try {
            User user = this.graphServiceClient.me().get();
            StructMapper responseMapper = new StructMapper();
            user.serialize((SerializationWriter)responseMapper);
            return responseMapper.getObject();
        }
        catch (RuntimeException ex) {
            String message = RB.getString(GraphServiceClient.class, (String)"ERROR_RETRIEVING_SIGNED_IN_USER");
            this.logger.error((Object)message);
            throw new GraphServiceException(message, ex);
        }
    }

    public Struct getUser(Object arguments) {
        User user;
        if (arguments instanceof String) {
            String userId = (String)arguments;
            if (GraphServiceUtils.isNullOrEmpty(userId)) {
                throw new GraphServiceException(RB.getString(GraphServiceClient.class, (String)"NON_NULL_USER_ID", (Object)"getUser"));
            }
            try {
                user = this.graphServiceClient.users().byUserId(userId).get();
            }
            catch (RuntimeException ex) {
                String message = RB.getString(GraphServiceClient.class, (String)"ERROR_RETRIEVING_USER");
                this.logger.error((Object)message);
                throw new GraphServiceException(message, ex);
            }
        } else if (arguments instanceof Map) {
            Map requestConfigurator = (Map)arguments;
            try {
                RequestConfigurator requestConfiguration = new RequestConfigurator();
                ValidatorFiller.INSTANCE.fillObject((Object)requestConfiguration, requestConfigurator, UserRequestConfiguratorConsumer.INSTANCE.getConsumerMap());
                user = this.graphServiceClient.me().get(configurator -> {
                    configurator.queryParameters.select = requestConfiguration.getSelect();
                });
            }
            catch (RuntimeException ex) {
                String message = RB.getString(GraphServiceClient.class, (String)"ERROR_RETRIEVING_SIGNED_IN_USER");
                this.logger.error((Object)message);
                throw new GraphServiceException(message, ex);
            }
        } else {
            throw new IllegalArgumentException(RB.getString(GraphServiceClient.class, (String)"ERROR_RETRIEVING_USER"));
        }
        StructMapper responseMapper = new StructMapper();
        user.serialize((SerializationWriter)responseMapper);
        return responseMapper.getObject();
    }

    public Struct getUser(String userId, Struct requestConfigurator) {
        if (GraphServiceUtils.isNullOrEmpty(userId)) {
            throw new GraphServiceException(RB.getString(GraphServiceClient.class, (String)"NON_NULL_USER_ID", (Object)"getUser"));
        }
        try {
            RequestConfigurator requestConfiguration = new RequestConfigurator();
            ValidatorFiller.INSTANCE.fillObject((Object)requestConfiguration, (Map)requestConfigurator, UserRequestConfiguratorConsumer.INSTANCE.getConsumerMap());
            User user = this.graphServiceClient.users().byUserId(userId).get(configurator -> {
                configurator.queryParameters.select = requestConfiguration.getSelect();
            });
            StructMapper responseMapper = new StructMapper();
            user.serialize((SerializationWriter)responseMapper);
            return responseMapper.getObject();
        }
        catch (RuntimeException ex) {
            String message = RB.getString(GraphServiceClient.class, (String)"ERROR_RETRIEVING_USER");
            this.logger.error((Object)message);
            throw new GraphServiceException(message, ex);
        }
    }

    public String createUser(Struct user) {
        Optional.ofNullable(user).orElseThrow(() -> new GraphServiceException(RB.getString(GraphServiceClient.class, (String)"NON_NULL_USER_VALUE", (Object)"createUser")));
        try {
            User newUser = new User();
            ValidatorFiller.INSTANCE.fillObject((Object)newUser, (Map)user, UserConsumer.INSTANCE.getConsumerMap());
            User postedUser = this.graphServiceClient.users().post(newUser);
            return postedUser.getId();
        }
        catch (RuntimeException ex) {
            String message = RB.getString(GraphServiceClient.class, (String)"ERROR_CREATING_USER");
            this.logger.error((Object)message);
            throw new GraphServiceException(message, ex);
        }
    }

    public void updateUser(Struct user) {
        Optional.ofNullable(user).orElseThrow(() -> new GraphServiceException(RB.getString(GraphServiceClient.class, (String)"NON_NULL_USER_VALUE", (Object)"updateUser")));
        try {
            User newUser = new User();
            ValidatorFiller.INSTANCE.fillObject((Object)newUser, (Map)user, UserConsumer.INSTANCE.getConsumerMap());
            this.graphServiceClient.me().patch(newUser);
        }
        catch (RuntimeException ex) {
            String message = RB.getString(GraphServiceClient.class, (String)"ERROR_UPDATING_SIGNED_IN_USER");
            this.logger.error((Object)message);
            throw new GraphServiceException(message, ex);
        }
    }

    public void updateUser(String userId, Struct user) {
        if (GraphServiceUtils.isNullOrEmpty(userId)) {
            throw new GraphServiceException(RB.getString(GraphServiceClient.class, (String)"NON_NULL_USER_ID", (Object)"updateUser"));
        }
        Optional.ofNullable(user).orElseThrow(() -> new GraphServiceException(RB.getString(GraphServiceClient.class, (String)"NON_NULL_USER_VALUE", (Object)"updateUser")));
        try {
            User newUser = new User();
            ValidatorFiller.INSTANCE.fillObject((Object)newUser, (Map)user, UserConsumer.INSTANCE.getConsumerMap());
            this.graphServiceClient.users().byUserId(userId).patch(newUser);
        }
        catch (RuntimeException ex) {
            String message = RB.getString(GraphServiceClient.class, (String)"ERROR_UPDATING_USER");
            this.logger.error((Object)message);
            throw new GraphServiceException(message, ex);
        }
    }

    public void deleteUser(String userId) {
        if (GraphServiceUtils.isNullOrEmpty(userId)) {
            throw new GraphServiceException(RB.getString(GraphServiceClient.class, (String)"NON_NULL_USER_ID", (Object)"deleteUser"));
        }
        try {
            this.graphServiceClient.users().byUserId(userId).delete();
        }
        catch (RuntimeException ex) {
            String message = RB.getString(GraphServiceClient.class, (String)"ERROR_DELETING_USER");
            this.logger.error((Object)message);
            throw new GraphServiceException(message, ex);
        }
    }

    public Struct getUsersDelta() {
        try {
            DeltaGetResponse deltaGetResponse = this.graphServiceClient.users().delta().get();
            StructMapper responseMapper = new StructMapper();
            deltaGetResponse.serialize((SerializationWriter)responseMapper);
            return responseMapper.getObject();
        }
        catch (RuntimeException ex) {
            String message = RB.getString(GraphServiceClient.class, (String)"ERROR_USERS_DELTA");
            this.logger.error((Object)message);
            throw new GraphServiceException(message, ex);
        }
    }

    public Struct getUsersDelta(Struct requestConfigurator) {
        try {
            DeltaGetResponse deltaGetResponse;
            RequestConfigurator requestConfiguration = new RequestConfigurator();
            ValidatorFiller.INSTANCE.fillObject((Object)requestConfiguration, (Map)requestConfigurator, UsersDeltaRequestConfiguratorConsumer.INSTANCE.getConsumerMap());
            Integer top = requestConfiguration.getTop();
            if (!GraphServiceUtils.isNullOrEmpty(requestConfiguration.getSkipToken()) | !GraphServiceUtils.isNullOrEmpty(requestConfiguration.getDeltaToken())) {
                deltaGetResponse = this.graphServiceClient.users().delta().withUrl(GraphServiceUtils.buildRawUrl(requestConfiguration, true)).get(configurator -> configurator.headers.add("Prefer", "return=minimal"));
            } else if (Objects.isNull(top)) {
                deltaGetResponse = this.graphServiceClient.users().delta().get(this.getUsersDeltaRequestConfiguration(requestConfiguration));
            } else {
                ArrayList users = new ArrayList();
                DeltaGetResponse deltaResponse = this.graphServiceClient.users().delta().get(this.getUsersDeltaRequestConfiguration(requestConfiguration));
                PageIterator<Parsable, DeltaGetResponse> pageIterator = GraphServiceUtils.getPageIterator(this.graphServiceClient, requestInfo -> requestInfo, deltaResponse, DeltaGetResponse::createFromDiscriminatorValue, user -> {
                    users.add((User)user);
                    return true;
                });
                if (Objects.nonNull(pageIterator)) {
                    pageIterator.iterate();
                }
                deltaGetResponse = new DeltaGetResponse();
                deltaGetResponse.setValue(users);
                Optional.ofNullable(pageIterator.getDeltaLink()).ifPresent(arg_0 -> ((DeltaGetResponse)deltaGetResponse).setOdataDeltaLink(arg_0));
            }
            StructMapper responseMapper = new StructMapper();
            deltaGetResponse.serialize((SerializationWriter)responseMapper);
            return responseMapper.getObject();
        }
        catch (ReflectiveOperationException ex) {
            String message = RB.getString(GraphServiceClient.class, (String)"ERROR_RETRIEVING_MULTIPLE_USERS");
            this.logger.error((Object)message);
            throw new GraphServiceException(message, ex);
        }
        catch (RuntimeException ex) {
            String message = RB.getString(GraphServiceClient.class, (String)"ERROR_USERS_DELTA");
            this.logger.error((Object)message);
            throw new GraphServiceException(message, ex);
        }
    }

    public void changePassword(Struct details) {
        Optional.ofNullable(details).orElseThrow(() -> new GraphServiceException(RB.getString(GraphServiceClient.class, (String)"NON_NULL_PASSWORD_DETAILS")));
        try {
            ChangePasswordPostRequestBody changePasswordPostRequestBody = new ChangePasswordPostRequestBody();
            ValidatorFiller.INSTANCE.fillObject((Object)changePasswordPostRequestBody, (Map)details, PasswordChangeDetailsConsumer.INSTANCE.getConsumerMap());
            this.graphServiceClient.me().changePassword().post(changePasswordPostRequestBody);
        }
        catch (RuntimeException ex) {
            String message = RB.getString(GraphServiceClient.class, (String)"ERROR_CHANGE_PASSWORD");
            this.logger.error((Object)message);
            throw new GraphServiceException(message, ex);
        }
    }

    public void revokeSignInSessions() {
        try {
            this.graphServiceClient.me().revokeSignInSessions().post();
        }
        catch (RuntimeException ex) {
            String message = RB.getString(GraphServiceClient.class, (String)"ERROR_REVOKE_SIGNED_IN_USER_SESSIONS");
            this.logger.error((Object)message);
            throw new GraphServiceException(message, ex);
        }
    }

    public void revokeSignInSessions(String userId) {
        if (GraphServiceUtils.isNullOrEmpty(userId)) {
            throw new GraphServiceException(RB.getString(GraphServiceClient.class, (String)"NON_NULL_USER_ID", (Object)"revokeSignInSessions"));
        }
        try {
            this.graphServiceClient.users().byUserId(userId).revokeSignInSessions().post();
        }
        catch (RuntimeException ex) {
            String message = RB.getString(GraphServiceClient.class, (String)"ERROR_REVOKE_SIGN_IN_SESSIONS");
            this.logger.error((Object)message);
            throw new GraphServiceException(message, ex);
        }
    }

    public Object getProfilePhoto() {
        try {
            byte[] imageBytes = this.graphServiceClient.me().photo().content().get().readAllBytes();
            return new Image(imageBytes);
        }
        catch (IOException | RuntimeException ex) {
            String message = RB.getString(GraphServiceClient.class, (String)"ERROR_RETRIEVE_PROFILE_PHOTO_SIGNED_IN_USER");
            this.logger.error((Object)message);
            throw new GraphServiceException(message, ex);
        }
    }

    public Object getProfilePhoto(String userId) {
        if (GraphServiceUtils.isNullOrEmpty(userId)) {
            throw new GraphServiceException(RB.getString(GraphServiceClient.class, (String)"NON_NULL_USER_ID", (Object)"getProfilePhoto"));
        }
        try {
            byte[] imageBytes = this.graphServiceClient.users().byUserId(userId).photo().content().get().readAllBytes();
            return new Image(imageBytes);
        }
        catch (IOException | RuntimeException ex) {
            String message = RB.getString(GraphServiceClient.class, (String)"ERROR_RETRIEVE_PROFILE_PHOTO");
            this.logger.error((Object)message);
            throw new GraphServiceException(message, ex);
        }
    }

    public void updateProfilePhoto(Object image) {
        block9: {
            if (image instanceof Image) {
                try (ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(((Image)image).getImageBytes(null));){
                    this.graphServiceClient.me().photo().content().put((InputStream)byteArrayInputStream);
                    break block9;
                }
                catch (IOException ex) {
                    String message = RB.getString(GraphServiceClient.class, (String)"ILLEGAL_IMAGE");
                    this.logger.error((Object)message);
                    throw new GraphServiceException(message, ex);
                }
                catch (RuntimeException ex) {
                    String message = RB.getString(GraphServiceClient.class, (String)"ERROR_UPLOAD_SIGNED_IN_USER_PHOTO");
                    this.logger.error((Object)message);
                    throw new GraphServiceException(message, ex);
                }
            }
            String message = RB.getString(GraphServiceClient.class, (String)"INVALID_ARGUMENT_FOR_IMAGE");
            this.logger.error((Object)message);
            throw new IllegalArgumentException(message);
        }
    }

    public void updateProfilePhoto(String userId, Object image) {
        block10: {
            if (GraphServiceUtils.isNullOrEmpty(userId)) {
                throw new GraphServiceException(RB.getString(GraphServiceClient.class, (String)"NON_NULL_USER_ID", (Object)"updateProfilePhoto"));
            }
            if (image instanceof Image) {
                try (ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(((Image)image).getImageBytes(null));){
                    this.graphServiceClient.users().byUserId(userId).photo().content().put((InputStream)byteArrayInputStream);
                    break block10;
                }
                catch (IOException ex) {
                    String message = RB.getString(GraphServiceClient.class, (String)"ILLEGAL_IMAGE");
                    this.logger.error((Object)message);
                    throw new GraphServiceException(message, ex);
                }
                catch (RuntimeException ex) {
                    String message = RB.getString(GraphServiceClient.class, (String)"ERROR_UPLOAD_PHOTO");
                    this.logger.error((Object)message);
                    throw new GraphServiceException(message, ex);
                }
            }
            String message = RB.getString(GraphServiceClient.class, (String)"INVALID_ARGUMENT_FOR_IMAGE");
            this.logger.error((Object)message);
            throw new IllegalArgumentException(message);
        }
    }

    public void deleteProfilePhoto() {
        try {
            this.graphServiceClient.me().photo().delete();
        }
        catch (RuntimeException ex) {
            String message = RB.getString(GraphServiceClient.class, (String)"ERROR_DELETE_PROFILE_PHOTO_SIGNED_IN_USER");
            this.logger.error((Object)message);
            throw new GraphServiceException(message, ex);
        }
    }

    public void deleteProfilePhoto(String userId) {
        if (GraphServiceUtils.isNullOrEmpty(userId)) {
            throw new IllegalArgumentException(RB.getString(GraphServiceClient.class, (String)"NON_NULL_USER_ID", (Object)"deleteProfilePhoto"));
        }
        try {
            this.graphServiceClient.users().byUserId(userId).photo().delete();
        }
        catch (RuntimeException ex) {
            String message = RB.getString(GraphServiceClient.class, (String)"ERROR_DELETE_PROFILE_PHOTO");
            this.logger.error((Object)message);
            throw new GraphServiceException(message, ex);
        }
    }

    private Consumer<UsersRequestBuilder.GetRequestConfiguration> getUsersListRequestConfiguration(RequestConfigurator requestConfigurator) {
        return configurator -> {
            Optional.ofNullable(requestConfigurator.getFilter()).ifPresent(value -> {
                configurator.queryParameters.filter = value;
            });
            Optional.ofNullable(requestConfigurator.getOrderBy()).ifPresent(value -> {
                configurator.queryParameters.orderby = value;
            });
            Optional.ofNullable(requestConfigurator.getSearch()).ifPresent(value -> {
                configurator.queryParameters.search = "\"" + value + "\"";
            });
            Optional.ofNullable(requestConfigurator.getSelect()).ifPresent(value -> {
                configurator.queryParameters.select = value;
            });
            Optional.ofNullable(requestConfigurator.getTop()).ifPresent(value -> {
                configurator.queryParameters.top = value;
            });
            configurator.queryParameters.count = true;
            configurator.headers.add("consistencyLevel", "eventual");
        };
    }

    private Consumer<DeltaRequestBuilder.GetRequestConfiguration> getUsersDeltaRequestConfiguration(RequestConfigurator requestConfigurator) {
        return configurator -> {
            Optional.ofNullable(requestConfigurator.getFilter()).ifPresent(value -> {
                configurator.queryParameters.filter = value;
            });
            Optional.ofNullable(requestConfigurator.getSelect()).ifPresent(value -> {
                configurator.queryParameters.select = value;
            });
        };
    }
}

