/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cms;

import java.io.IOException;
import java.io.InputStream;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.CertStore;
import java.security.cert.CertStoreException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.BERSet;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.x509.CertificateList;
import org.bouncycastle.asn1.x509.X509CertificateStructure;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.util.io.Streams;

class CMSUtils {
    private static final Runtime RUNTIME = Runtime.getRuntime();

    CMSUtils() {
    }

    static int getMaximumMemory() {
        long l = RUNTIME.maxMemory();
        if (l > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)l;
    }

    static ContentInfo readContentInfo(byte[] byArray) throws CMSException {
        return CMSUtils.readContentInfo(new ASN1InputStream(byArray));
    }

    static ContentInfo readContentInfo(InputStream inputStream) throws CMSException {
        return CMSUtils.readContentInfo(new ASN1InputStream(inputStream, CMSUtils.getMaximumMemory()));
    }

    static List getCertificatesFromStore(CertStore certStore) throws CertStoreException, CMSException {
        ArrayList<X509CertificateStructure> arrayList = new ArrayList<X509CertificateStructure>();
        try {
            Iterator<? extends Certificate> iterator = certStore.getCertificates(null).iterator();
            while (iterator.hasNext()) {
                X509Certificate x509Certificate = (X509Certificate)iterator.next();
                arrayList.add(X509CertificateStructure.getInstance(ASN1Object.fromByteArray(x509Certificate.getEncoded())));
            }
            return arrayList;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new CMSException("error processing certs", illegalArgumentException);
        }
        catch (IOException iOException) {
            throw new CMSException("error processing certs", iOException);
        }
        catch (CertificateEncodingException certificateEncodingException) {
            throw new CMSException("error encoding certs", certificateEncodingException);
        }
    }

    static List getCRLsFromStore(CertStore certStore) throws CertStoreException, CMSException {
        ArrayList<CertificateList> arrayList = new ArrayList<CertificateList>();
        try {
            Iterator<? extends CRL> iterator = certStore.getCRLs(null).iterator();
            while (iterator.hasNext()) {
                X509CRL x509CRL = (X509CRL)iterator.next();
                arrayList.add(CertificateList.getInstance(ASN1Object.fromByteArray(x509CRL.getEncoded())));
            }
            return arrayList;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new CMSException("error processing crls", illegalArgumentException);
        }
        catch (IOException iOException) {
            throw new CMSException("error processing crls", iOException);
        }
        catch (CRLException cRLException) {
            throw new CMSException("error encoding crls", cRLException);
        }
    }

    static ASN1Set createBerSetFromList(List list) {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            aSN1EncodableVector.add((DEREncodable)iterator.next());
        }
        return new BERSet(aSN1EncodableVector);
    }

    static ASN1Set createDerSetFromList(List list) {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            aSN1EncodableVector.add((DEREncodable)iterator.next());
        }
        return new DERSet(aSN1EncodableVector);
    }

    private static ContentInfo readContentInfo(ASN1InputStream aSN1InputStream) throws CMSException {
        try {
            return ContentInfo.getInstance(aSN1InputStream.readObject());
        }
        catch (IOException iOException) {
            throw new CMSException("IOException reading content.", iOException);
        }
        catch (ClassCastException classCastException) {
            throw new CMSException("Malformed content.", classCastException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new CMSException("Malformed content.", illegalArgumentException);
        }
    }

    public static byte[] streamToByteArray(InputStream inputStream) throws IOException {
        return Streams.readAll(inputStream);
    }
}

