/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.cloud.aws.sqs;

import coldfusion.cloud.aws.AWSCredential;
import coldfusion.cloud.aws.AWSUtils;
import coldfusion.cloud.aws.sqs.SQSServiceConfig;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsSessionCredentials;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.apache.ApacheHttpClient;
import software.amazon.awssdk.services.sqs.SqsClientBuilder;

public class SQSUtils
extends AWSUtils {
    public static void configureSQSClientBuilder(SqsClientBuilder sqsClientBuilder, SQSServiceConfig config) {
        if (config != null) {
            if (config.getHttpClientBuilder() != null) {
                sqsClientBuilder.httpClientBuilder((SdkHttpClient.Builder)config.getHttpClientBuilder());
            } else {
                sqsClientBuilder.httpClient(SQSUtils.getDefaultHTTPClient());
            }
            if (config.getClientOverrideConfiguration() != null) {
                sqsClientBuilder.overrideConfiguration(config.getClientOverrideConfiguration());
            }
        } else {
            sqsClientBuilder.httpClient(SQSUtils.getDefaultHTTPClient());
        }
    }

    private static SdkHttpClient getDefaultHTTPClient() {
        return ApacheHttpClient.builder().build();
    }

    public static AwsCredentialsProvider getAWSCredential(final AWSCredential awsCred) {
        return new AwsCredentialsProvider(){

            public AwsCredentials resolveCredentials() {
                if (awsCred.sessionToken() == null) {
                    return new AwsCredentials(){

                        public String secretAccessKey() {
                            return awsCred.secretAccessKey();
                        }

                        public String accessKeyId() {
                            return awsCred.accessKeyId();
                        }
                    };
                }
                return AwsSessionCredentials.create((String)awsCred.accessKeyId(), (String)awsCred.secretAccessKey(), (String)awsCred.sessionToken());
            }
        };
    }
}

