/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.cloud.aws.sqs;

import coldfusion.cloud.aws.sqs.SQSAPIException;
import coldfusion.cloud.aws.sqs.SQSClientImpl;
import coldfusion.cloud.util.ConsumerMap;
import coldfusion.cloud.util.ConsumerValidator;
import coldfusion.cloud.util.FieldTypecastUtil;
import coldfusion.cloud.validator.IntegerRangeValidator;
import coldfusion.cloud.validator.NotNullValidator;
import coldfusion.runtime.Cast;
import coldfusion.runtime.CfJspPage;
import coldfusion.runtime.JSONUtils;
import coldfusion.util.RB;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.services.sqs.model.MessageAttributeValue;
import software.amazon.awssdk.services.sqs.model.SendMessageRequest;

public class SQSSendMessageMetadata {
    static SQSSendMessageMetadata instance = null;
    ConsumerMap<SendMessageRequest.Builder> consumerMap = new ConsumerMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SQSSendMessageMetadata getInstance() {
        if (instance != null) return instance;
        Class<SQSSendMessageMetadata> clazz = SQSSendMessageMetadata.class;
        synchronized (SQSSendMessageMetadata.class) {
            instance = new SQSSendMessageMetadata();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private SQSSendMessageMetadata() {
        this.consumerMap.put((Object)"delaySeconds", new ConsumerValidator((filler, val) -> filler.delaySeconds(Integer.valueOf(FieldTypecastUtil.INSTANCE.getIntegerProperty(val))), Arrays.asList(new IntegerRangeValidator("delaySeconds", Integer.valueOf(0), Integer.valueOf(900)))));
        this.consumerMap.put((Object)"messageBody", new ConsumerValidator((filler, val) -> filler.messageBody(FieldTypecastUtil.INSTANCE.getStringProperty(val)), Arrays.asList(NotNullValidator.INSTANCE)));
        this.consumerMap.put((Object)"messageDeduplicationId", new ConsumerValidator((filler, val) -> filler.messageDeduplicationId(FieldTypecastUtil.INSTANCE.getStringProperty(val)), null));
        this.consumerMap.put((Object)"messageGroupId", new ConsumerValidator((filler, val) -> filler.messageGroupId(FieldTypecastUtil.INSTANCE.getStringProperty(val)), null));
        this.consumerMap.put((Object)"messageAttributes", new ConsumerValidator((filler, val) -> {
            Map attributes = FieldTypecastUtil.INSTANCE.getStringObjectMapProperty(val);
            filler.messageAttributes(this.constructSendMessageAttributes(attributes));
        }, null));
    }

    public Map<String, MessageAttributeValue> constructSendMessageAttributes(Map<String, Object> attributes) {
        HashMap<String, MessageAttributeValue> attributesConstructed = new HashMap<String, MessageAttributeValue>();
        Set<String> keys = attributes.keySet();
        keys.forEach(key -> {
            Object val = attributes.get(key);
            if (val instanceof List) {
                List valList = (List)val;
                if (valList.get(0) instanceof String) {
                    attributesConstructed.put((String)key, (MessageAttributeValue)MessageAttributeValue.builder().stringListValues((Collection)valList).dataType("String").build());
                    return;
                } else {
                    if (!this.isBinary(valList.get(0))) throw new SQSAPIException(RB.getString(SQSClientImpl.class, (String)"UnsupportedAttributeError", valList.get(0).getClass()));
                    ArrayList<SdkBytes> binaryList = new ArrayList<SdkBytes>();
                    for (int i = 0; i < valList.size(); ++i) {
                        binaryList.add(SdkBytes.fromByteArray((byte[])Cast._Binary(valList.get(i))));
                    }
                    attributesConstructed.put((String)key, (MessageAttributeValue)MessageAttributeValue.builder().binaryListValues(binaryList).dataType("Binary").build());
                }
                return;
            } else if (val instanceof String) {
                attributesConstructed.put((String)key, (MessageAttributeValue)MessageAttributeValue.builder().stringValue((String)val).dataType("String").build());
                return;
            } else if (this.isBinary(val)) {
                attributesConstructed.put((String)key, (MessageAttributeValue)MessageAttributeValue.builder().binaryValue(SdkBytes.fromByteArray((byte[])Cast._Binary(val))).dataType("Binary").build());
                return;
            } else {
                if (!this.isStruct(val)) throw new SQSAPIException(RB.getString(SQSClientImpl.class, (String)"UnsupportedAttributeError", val.getClass()));
                attributesConstructed.put((String)key, (MessageAttributeValue)MessageAttributeValue.builder().stringValue(JSONUtils.serializeJSON(val)).dataType("String").build());
            }
        });
        return attributesConstructed;
    }

    public ConsumerMap<SendMessageRequest.Builder> getConsumerMap() {
        return this.consumerMap;
    }

    public void setConsumerMap(ConsumerMap<SendMessageRequest.Builder> consumerMap) {
        this.consumerMap = consumerMap;
    }

    private boolean isBinary(Object obj) {
        try {
            Cast._Binary((Object)obj);
        }
        catch (CfJspPage.BinaryConversionException ex) {
            return false;
        }
        return true;
    }

    private boolean isStruct(Object obj) {
        try {
            Cast._Map((Object)obj);
        }
        catch (Throwable ex) {
            return false;
        }
        return true;
    }
}

